/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.client.render.entity.silverglider;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.client.render.entity.AbstractDragonRenderer;
import WolfShotz.Wyrmroost.client.render.entity.silverglider.SilverGliderModel;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.dragon.SilverGliderEntity;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;

public class SilverGliderRenderer
extends AbstractDragonRenderer<SilverGliderEntity, SilverGliderModel> {
    public static final ResourceLocation[] MALE_TEXTURES = new ResourceLocation[6];
    public static final ResourceLocation FEMALE = SilverGliderRenderer.resource("female.png");
    public static final ResourceLocation FEMALE_GLOW = SilverGliderRenderer.resource("female_glow.png");
    public static final ResourceLocation BODY_SPE = SilverGliderRenderer.resource("spe.png");
    public static final ResourceLocation BODY_SPE_GLOW = SilverGliderRenderer.resource("spe_glow.png");
    public static final ResourceLocation XMAS_LAYER = SilverGliderRenderer.resource("body_christmas.png");
    public static final ResourceLocation XMAS_GLOW = SilverGliderRenderer.resource("body_christmas_glow.png");
    public static final ResourceLocation SLEEP = SilverGliderRenderer.resource("sleep.png");

    public SilverGliderRenderer(EntityRendererManager manager) {
        super(manager, new SilverGliderModel(), 1.0f);
        this.func_177094_a(new AbstractDragonRenderer.GlowLayer(this::getGlowTexture));
        if (this.itsChristmasOMG) {
            this.func_177094_a(new AbstractDragonRenderer.ConditionalLayer(c -> true, d -> RenderType.func_228640_c_((ResourceLocation)XMAS_LAYER)));
            this.func_177094_a(new AbstractDragonRenderer.GlowLayer(sg -> XMAS_GLOW));
        }
        this.func_177094_a(new AbstractDragonRenderer.ConditionalLayer(AbstractDragonEntity::func_70608_bn, d -> RenderType.func_228640_c_((ResourceLocation)SLEEP)));
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/silver_glider/" + png);
    }

    @Nullable
    public ResourceLocation getEntityTexture(SilverGliderEntity sg) {
        if (sg.getVariant() == -1) {
            return BODY_SPE;
        }
        if (!sg.isMale()) {
            return FEMALE;
        }
        int index = sg.getVariant();
        if (MALE_TEXTURES[index] == null) {
            SilverGliderRenderer.MALE_TEXTURES[index] = SilverGliderRenderer.resource("male_" + index + ".png");
            return SilverGliderRenderer.MALE_TEXTURES[index];
        }
        return MALE_TEXTURES[index];
    }

    private ResourceLocation getGlowTexture(SilverGliderEntity sg) {
        if (sg.getVariant() == -1) {
            return BODY_SPE_GLOW;
        }
        if (!sg.isMale()) {
            return FEMALE_GLOW;
        }
        int index = sg.getVariant() + 3;
        if (MALE_TEXTURES[index] == null) {
            SilverGliderRenderer.MALE_TEXTURES[index] = SilverGliderRenderer.resource("male_" + sg.getVariant() + "_glow.png");
            return SilverGliderRenderer.MALE_TEXTURES[index];
        }
        return MALE_TEXTURES[index];
    }
}

