/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.containers.util;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SlotBuilder
extends SlotItemHandler {
    public static final int CENTER_X = 89;
    public static final int CENTER_Y = 60;
    private int limit = super.func_75219_a();
    private BooleanSupplier isEnabled = () -> true;
    private Predicate<ItemStack> isItemValid = x$0 -> super.func_75214_a(x$0);
    private Predicate<PlayerEntity> canTakeStack = x$0 -> super.func_82869_a(x$0);
    private Consumer<SlotBuilder> onSlotUpdate = s -> {};

    public SlotBuilder(IItemHandler handler, int index, int posX, int posY) {
        super(handler, index, posX, posY);
    }

    public SlotBuilder(IItemHandler handler, int index) {
        this(handler, index, 89, 60);
    }

    public SlotBuilder condition(BooleanSupplier isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public SlotBuilder onUpdate(Consumer<SlotBuilder> onUpdate) {
        this.onSlotUpdate = onUpdate;
        return this;
    }

    public SlotBuilder only(Predicate<ItemStack> isItemValid) {
        this.isItemValid = isItemValid;
        return this;
    }

    public SlotBuilder only(IItemProvider item) {
        return this.only((ItemStack s) -> s.func_77973_b() == item);
    }

    public SlotBuilder only(Class<? extends IItemProvider> clazz) {
        if (Block.class.isAssignableFrom(clazz)) {
            return this.only((ItemStack s) -> {
                Item item = s.func_77973_b();
                return item instanceof BlockItem && clazz.isInstance(((BlockItem)item).func_179223_d());
            });
        }
        return this.only((ItemStack s) -> clazz.isInstance(s.func_77973_b()));
    }

    public SlotBuilder canTake(Predicate<PlayerEntity> canTakeStack) {
        this.canTakeStack = canTakeStack;
        return this;
    }

    public SlotBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean func_111238_b() {
        return this.isEnabled.getAsBoolean();
    }

    public void func_75218_e() {
        this.onSlotUpdate.accept(this);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return this.func_111238_b() && this.isItemValid.test(stack);
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        return this.canTakeStack.test(playerIn);
    }

    public int func_75219_a() {
        return this.limit;
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return this.limit;
    }
}

