/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.data;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.registry.WRBlocks;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

class LootTableData
extends LootTableProvider {
    LootTableData(DataGenerator gen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new Entities(), (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    private static class Entities
    extends EntityLootTables {
        private static final ILootCondition.IBuilder UNTAMED_AND_ADULT = EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(new EntityFlagsPredicate(null, null, null, null, Boolean.valueOf(false))).func_209365_a(new NBTPredicate((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), c -> c.func_74778_a("OwnerUUID", "")))));
        private static final LootFunction.Builder<?> ON_FIRE_SMELT = Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(EntityFlagsPredicate.Builder.func_217967_a().func_217968_a(Boolean.valueOf(true)).func_217966_b())));
        private final Map<EntityType<?>, LootTable.Builder> lootTables = Maps.newHashMap();

        private Entities() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.addTables();
            for (EntityType<?> entity : this.getKnownEntities()) {
                if (!this.lootTables.containsKey(entity)) {
                    if (entity.func_220339_d() == EntityClassification.MISC) continue;
                    throw new IllegalArgumentException(String.format("Missing Loottable for entry: '%s'", entity.getRegistryName()));
                }
                consumer.accept(entity.func_220348_g(), this.lootTables.remove(entity));
            }
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModUtils.getRegistryEntries(WREntities.REGISTRY);
        }

        public void registerEmptyTables(EntityType<?> ... types) {
            for (EntityType<?> type : types) {
                Wyrmroost.LOG.warn("Registering EMPTY Loottable for: '{}'", (Object)type.getRegistryName());
                this.func_218582_a(type, LootTable.func_216119_b());
            }
        }

        protected void func_218582_a(EntityType<?> type, LootTable.Builder table) {
            this.lootTables.put(type, table);
        }

        protected void addTables() {
            this.func_218582_a((EntityType)WREntities.LESSER_DESERTWYRM.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a((LootEntry.Builder)Entities.item((IItemProvider)WRItems.LDWYRM.get(), 1).func_212841_b_(ON_FIRE_SMELT))));
            this.func_218582_a((EntityType)WREntities.OVERWORLD_DRAKE.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a((LootEntry.Builder)Entities.item((IItemProvider)Items.field_151116_aA, 5.0f, 10.0f).func_212841_b_((ILootFunction.IBuilder)Entities.looting(1.0f, 4.0f)))).func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_COMMON_MEAT.get(), 1, 7, 2, 3))).func_216040_a(Entities.singleRollPool().func_216045_a(Entities.item((IItemProvider)WRItems.DRAKE_BACKPLATE.get(), 1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(UNTAMED_AND_ADULT).func_212840_b_(RandomChance.func_216004_a((float)0.25f))));
            this.func_218582_a((EntityType)WREntities.ROOSTSTALKER.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_LOWTIER_MEAT.get(), 0, 3, 1, 3))).func_216040_a(Entities.singleRollPool().func_216045_a(Entities.item((IItemProvider)Items.field_151074_bl, 0.0f, 2.0f))));
            this.func_218582_a((EntityType)WREntities.DRAGON_FRUIT_DRAKE.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.item((IItemProvider)Items.field_151034_e, 0.0f, 6.0f))));
            this.func_218582_a((EntityType)WREntities.CANARI_WYVERN.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_COMMON_MEAT.get(), 0, 3, 1, 2))).func_216040_a(Entities.singleRollPool().func_216045_a((LootEntry.Builder)Entities.item((IItemProvider)Items.field_151008_G, 1.0f, 4.0f).func_212841_b_((ILootFunction.IBuilder)Entities.looting(2.0f, 6.0f)))));
            this.func_218582_a((EntityType)WREntities.SILVER_GLIDER.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_LOWTIER_MEAT.get(), 0, 5, 1, 3))));
            this.func_218582_a((EntityType)WREntities.BUTTERFLY_LEVIATHAN.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_APEX_MEAT.get(), 6, 9, 2, 4))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)).func_216045_a((LootEntry.Builder)Entities.item((IItemProvider)Items.field_221601_aC, 0.0f, 2.0f).func_212841_b_((ILootFunction.IBuilder)Entities.looting(1.0f, 2.0f))).func_216045_a(Entities.item((IItemProvider)Items.field_221600_aB, 4.0f, 14.0f)).func_216045_a(Entities.item((IItemProvider)Items.field_222066_kO, 16.0f, 24.0f))).func_216040_a(Entities.singleRollPool().func_216045_a(Entities.item((IItemProvider)Items.field_205158_fa, 1).func_212840_b_(RandomChance.func_216004_a((float)0.1f))).func_216045_a(Entities.item((IItemProvider)Items.field_205157_eZ, 1).func_212840_b_(RandomChance.func_216004_a((float)0.2f)))));
            this.func_218582_a((EntityType)WREntities.ROYAL_RED.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_APEX_MEAT.get(), 4, 8, 3, 5))));
            this.func_218582_a((EntityType)WREntities.COIN_DRAGON.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_LOWTIER_MEAT.get(), 1, 1, 0, 1)).func_216045_a(Entities.item((IItemProvider)Items.field_151074_bl, 4))));
            this.func_218582_a((EntityType)WREntities.ALPINE.get(), LootTable.func_216119_b().func_216040_a(Entities.singleRollPool().func_216045_a(Entities.meat((IItemProvider)WRItems.RAW_COMMON_MEAT.get(), 3, 7, 2, 6))).func_216040_a(Entities.singleRollPool().func_216045_a((LootEntry.Builder)Entities.item((IItemProvider)Items.field_151008_G, 3.0f, 10.0f).func_212841_b_((ILootFunction.IBuilder)Entities.looting(3.0f, 11.0f)))));
        }

        private static LootingEnchantBonus.Builder looting(float min, float max) {
            return LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)min, (float)max));
        }

        private static StandaloneLootEntry.Builder<?> item(IItemProvider itemIn, float minIn, float maxIn) {
            return ItemLootEntry.func_216168_a((IItemProvider)itemIn).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minIn, (float)maxIn)));
        }

        private static StandaloneLootEntry.Builder<?> item(IItemProvider itemIn, int amount) {
            return ItemLootEntry.func_216168_a((IItemProvider)itemIn).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)amount)));
        }

        private static LootPool.Builder singleRollPool() {
            return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1));
        }

        private static StandaloneLootEntry.Builder<?> meat(IItemProvider itemIn, int minAmount, int maxAmount, int lootingMin, int lootingMax) {
            return Entities.item(itemIn, minAmount, maxAmount).func_212841_b_(ON_FIRE_SMELT).func_212841_b_((ILootFunction.IBuilder)Entities.looting(lootingMin, lootingMax));
        }
    }

    private static class Blocks
    extends BlockLootTables {
        public final Map<Block, LootTable.Builder> field_218581_i = Maps.newHashMap();

        private Blocks() {
        }

        protected void addTables() {
            this.registerOre((Block)WRBlocks.BLUE_GEODE_ORE.get(), (Item)WRItems.BLUE_GEODE.get());
            this.registerOre((Block)WRBlocks.RED_GEODE_ORE.get(), (Item)WRItems.RED_GEODE.get());
            this.registerOre((Block)WRBlocks.PURPLE_GEODE_ORE.get(), (Item)WRItems.PURPLE_GEODE.get());
            for (Block block : this.getKnownBlocks()) {
                if (this.field_218581_i.containsKey(block) || block.func_220068_i() == LootTables.field_186419_a) continue;
                this.func_218492_c(block);
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModUtils.getRegistryEntries(WRBlocks.REGISTRY);
        }

        private void registerOre(Block ore, Item output) {
            this.func_218522_a(ore, block -> Blocks.func_218476_a((Block)block, (Item)output));
        }

        protected void func_218507_a(Block blockIn, LootTable.Builder table) {
            super.func_218507_a(blockIn, table);
            this.field_218581_i.put(blockIn, table);
        }
    }
}

