/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.dragon;

import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.FlyerWanderGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import WolfShotz.Wyrmroost.entities.projectile.WindGustEntity;
import WolfShotz.Wyrmroost.entities.util.EntityDataEntry;
import WolfShotz.Wyrmroost.entities.util.animation.Animation;
import WolfShotz.Wyrmroost.network.packets.AnimationPacket;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.TickFloat;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class AlpineEntity
extends AbstractDragonEntity {
    public static final Animation ROAR_ANIMATION = new Animation(84);
    public static final Animation WIND_GUST_ANIMATION = new Animation(25);
    public static final Animation BITE_ANIMATION = new Animation(10);
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat flightTimer = new TickFloat().setLimit(0.0f, 1.0f);

    public AlpineEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new DragonBreedGoal(this, 4));
        this.field_70714_bg.func_75776_a(8, (Goal)new FlyerWanderGoal(this, 1.0, 0.01f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, BeeEntity.class, true, bee -> ((BeeEntity)bee).func_226411_eD_()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.sitTimer.add(this.func_233684_eK_() || this.func_70608_bn() ? 0.1f : -0.1f);
        this.sleepTimer.add(this.func_70608_bn() ? 0.1f : -0.1f);
        this.flightTimer.add(this.isFlying() ? 0.1f : -0.05f);
        if (!this.field_70170_p.field_72995_K && this.noActiveAnimation() && !this.func_70608_bn() && !this.func_70631_g_() && this.func_70681_au().nextDouble() < 5.0E-4) {
            AnimationPacket.send(this, ROAR_ANIMATION);
        }
        Animation animation = this.getAnimation();
        int tick = this.getAnimationTick();
        if (animation == ROAR_ANIMATION) {
            if (tick == 0) {
                this.func_184185_a((SoundEvent)WRSounds.ENTITY_ALPINE_ROAR.get(), 3.0f, 1.0f);
            } else if (tick == 25) {
                for (LivingEntity entity : this.getEntitiesNearby(20.0, e -> e.func_200600_R() == WREntities.ALPINE.get())) {
                    AlpineEntity alpine = (AlpineEntity)entity;
                    if (!alpine.noActiveAnimation() || !alpine.isIdling()) continue;
                    alpine.setAnimation(ROAR_ANIMATION);
                }
            }
        } else if (animation == WIND_GUST_ANIMATION) {
            if (tick == 0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.35, 0.0));
            }
            if (tick == 4) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)new WindGustEntity(this));
                }
                this.func_213317_d(this.func_213322_ci().func_178787_e(this.func_70040_Z().func_216371_e().func_216372_d(1.5, 0.0, 1.5).func_72441_c(0.0, 1.0, 0.0)));
                this.playSound((SoundEvent)WRSounds.WING_FLAP.get(), 3.0f, 1.0f, true);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity enemy) {
        Entity holder;
        BeeEntity bee;
        boolean flag = super.func_70652_k(enemy);
        if (!this.func_70909_n() && flag && !enemy.func_70089_S() && enemy.func_200600_R() == EntityType.field_226289_e_ && (bee = (BeeEntity)enemy).func_226411_eD_() && bee.func_110167_bD() && (holder = bee.func_110166_bE()) instanceof PlayerEntity) {
            this.tame(true, (PlayerEntity)holder);
        }
        return flag;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
        return size.func_220312_a(1.0f, this.func_233684_eK_() || this.func_70608_bn() ? 0.7f : 1.0f);
    }

    @Override
    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
        if (key == 2 && pressed && this.noActiveAnimation() && this.isFlying()) {
            this.setAnimation(WIND_GUST_ANIMATION);
        }
    }

    @Override
    public void setMountCameraAngles(boolean backView, EntityViewRenderEvent.CameraSetup event) {
        if (backView) {
            event.getInfo().func_216782_a(-5.0, 0.75, 0.0);
        } else {
            event.getInfo().func_216782_a(-3.0, 0.3, 0.0);
        }
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_217376_c((Entity)new WindGustEntity(this, this.func_213303_ch().func_72441_c(0.0, 7.0, 0.0), this.func_174806_f(90.0f, this.field_70177_z)));
        }
    }

    @Override
    protected float func_175134_bD() {
        if (this.canFly()) {
            return this.func_213302_cg() * this.func_226269_ah_();
        }
        return super.func_175134_bD();
    }

    public void func_184609_a(Hand hand) {
        this.setAnimation(BITE_ANIMATION);
        this.playSound(SoundEvents.field_187537_bA, 1.0f, 1.0f, true);
        super.func_184609_a(hand);
    }

    @Override
    public int getVariantForSpawn() {
        return this.func_70681_au().nextInt(6);
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return entity instanceof LivingEntity && this.func_152114_e((LivingEntity)entity);
    }

    @Override
    public Collection<? extends IItemProvider> getFoodItems() {
        return ImmutableSet.of((Object)Items.field_226635_pU_, (Object)Items.field_226638_pX_);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * (this.isFlying() ? 0.8f : 1.25f);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_ALPINE_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_ALPINE_ROAR.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_ALPINE_DEATH.get();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ROAR_ANIMATION, WIND_GUST_ANIMATION, BITE_ANIMATION};
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.EXTREME_HILLS) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.ALPINE.get(), 2, 1, 4));
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233822_e_, 0.5).func_233815_a_((Attribute)WREntities.Attributes.PROJECTILE_DAMAGE.get(), 1.0);
    }
}

