/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.dragon;

import WolfShotz.Wyrmroost.WRConfig;
import WolfShotz.Wyrmroost.client.screen.StaffScreen;
import WolfShotz.Wyrmroost.containers.DragonInvContainer;
import WolfShotz.Wyrmroost.containers.util.SlotBuilder;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.dragon.helpers.DragonInvHandler;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.LessShitLookController;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.WRSitGoal;
import WolfShotz.Wyrmroost.entities.util.EntityDataEntry;
import WolfShotz.Wyrmroost.entities.util.animation.Animation;
import WolfShotz.Wyrmroost.items.staff.StaffAction;
import WolfShotz.Wyrmroost.network.packets.AnimationPacket;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.Mafs;
import WolfShotz.Wyrmroost.util.TickFloat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.pathfinding.WalkAndSwimNodeProcessor;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.items.IItemHandler;

public class ButterflyLeviathanEntity
extends AbstractDragonEntity {
    public static final DataParameter<Boolean> HAS_CONDUIT = EntityDataManager.func_187226_a(ButterflyLeviathanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation LIGHTNING_ANIMATION = new Animation(64);
    public static final Animation CONDUIT_ANIMATION = new Animation(59);
    public static final Animation BITE_ANIMATION = new Animation(17);
    public static final int CONDUIT_SLOT = 0;
    public final TickFloat beachedTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat swimTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public int lightningCooldown;
    public boolean beached = true;

    public ButterflyLeviathanEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.field_70158_ak = WRConfig.disableFrustumCheck;
        this.field_70765_h = new MoveController();
        this.field_70138_W = 2.0f;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.setImmune(DamageSource.field_180137_b);
        this.setImmune(DamageSource.field_76372_a);
        this.setImmune(DamageSource.field_76368_d);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new WRSitGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new DragonBreedGoal(this, 1));
        this.field_70714_bg.func_75776_a(5, (Goal)new JumpOutOfWaterGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 40));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 14.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, LivingEntity.class, false, e -> !(!this.beached && !e.func_70090_H() || e.func_200600_R() != EntityType.field_200749_ao && e.func_200600_R() != EntityType.field_200761_A && e.func_200600_R() != EntityType.field_200729_aH)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_CONDUIT, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        Vector3d conduitPos = this.getConduitPos();
        if (this.lightningCooldown > 0) {
            --this.lightningCooldown;
        }
        boolean prevBeached = this.beached;
        if (!this.beached && this.field_70122_E && !this.field_70171_ac) {
            this.beached = true;
        } else if (this.beached && this.field_70171_ac) {
            this.beached = false;
        }
        if (prevBeached != this.beached) {
            this.func_213323_x_();
        }
        this.beachedTimer.add(this.beached ? 0.1f : -0.05f);
        this.swimTimer.add(this.func_204231_K() ? -0.1f : 0.1f);
        this.sitTimer.add(this.func_233684_eK_() ? 0.1f : -0.1f);
        if (this.isJumpingOutOfWater()) {
            Vector3d motion = this.func_213322_ci();
            this.field_70125_A = (float)(Math.signum(-motion.field_72448_b) * Math.acos(Math.sqrt(Entity.func_213296_b((Vector3d)motion)) / motion.func_72433_c()) * 57.2957763671875) * 0.725f;
        }
        if (this.hasConduit()) {
            if (this.field_70170_p.field_72995_K && this.func_70026_G() && this.func_70681_au().nextDouble() <= 0.1) {
                for (int i = 0; i < 16; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_205167_W, conduitPos.field_72450_a, conduitPos.field_72448_b + 2.25, conduitPos.field_72449_c, Mafs.nextDouble(this.func_70681_au()) * 1.5, Mafs.nextDouble(this.func_70681_au()), Mafs.nextDouble(this.func_70681_au()) * 1.5);
                }
            }
            if (this.field_70173_aa % 80 == 0) {
                boolean attacked = false;
                for (LivingEntity entity : this.getEntitiesNearby(25.0, Entity::func_70026_G)) {
                    if (entity != this.func_70638_az() && (entity instanceof PlayerEntity || this.func_184191_r((Entity)entity))) {
                        entity.func_195064_c(new EffectInstance(Effects.field_205136_C, 220, 0, true, true));
                    }
                    if (attacked || !(entity instanceof IMob)) continue;
                    attacked = true;
                    entity.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    this.func_184185_a(SoundEvents.field_206936_aP, 1.0f, 1.0f);
                }
            }
            if (this.field_70170_p.field_72995_K && this.field_70173_aa % 100 == 0) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.playSound(SoundEvents.field_206934_aN, 1.0f, 1.0f, true);
                } else {
                    this.playSound(SoundEvents.field_206935_aO, 1.0f, 1.0f, true);
                }
            }
        }
        Animation animation = this.getAnimation();
        int animTick = this.getAnimationTick();
        if (animation == LIGHTNING_ANIMATION) {
            LivingEntity target;
            this.lightningCooldown += 6;
            if (animTick == 10) {
                this.playSound((SoundEvent)WRSounds.ENTITY_BFLY_ROAR.get(), 3.0f, 1.0f, true);
            }
            if (!this.field_70170_p.field_72995_K && this.func_70026_G() && animTick >= 10 && (target = this.func_70638_az()) != null) {
                if (this.hasConduit()) {
                    if (animTick % 10 == 0) {
                        Vector3d vec3d = target.func_213303_ch().func_72441_c(Mafs.nextDouble(this.func_70681_au()) * 2.333, 0.0, Mafs.nextDouble(this.func_70681_au()) * 2.333);
                        ButterflyLeviathanEntity.createLightning(this.field_70170_p, vec3d, false);
                    }
                } else if (animTick == 10) {
                    ButterflyLeviathanEntity.createLightning(this.field_70170_p, target.func_213303_ch(), false);
                }
            }
        } else if (animation == CONDUIT_ANIMATION) {
            ((LessShitLookController)this.func_70671_ap()).restore();
            if (animTick == 0) {
                this.playSound((SoundEvent)WRSounds.ENTITY_BFLY_ROAR.get(), 5.0f, 1.0f, true);
            } else if (animTick == 15) {
                this.func_184185_a(SoundEvents.field_206938_K, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    ButterflyLeviathanEntity.createLightning(this.field_70170_p, this.getConduitPos().func_72441_c(0.0, 1.0, 0.0), true);
                } else {
                    for (int i = 0; i < 26; ++i) {
                        double velX = Math.cos(i);
                        double velZ = Math.sin(i);
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, conduitPos.field_72450_a, conduitPos.field_72448_b + 0.8, conduitPos.field_72449_c, velX, 0.0, velZ);
                    }
                }
            }
        } else if (animation == BITE_ANIMATION) {
            if (animTick == 0) {
                this.playSound((SoundEvent)WRSounds.ENTITY_BFLY_HURT.get(), 1.0f, 1.0f, true);
            } else if (animTick == 6) {
                AxisAlignedBB aabb = this.func_174813_aQ().func_191194_a(Mafs.getYawVec(this.field_70177_z, 0.0, 5.5)).func_186662_g(0.85);
                this.attackInAABB(aabb, true, 40);
            }
        }
    }

    @Override
    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        if ((this.beached && this.lightningCooldown > 60 || player.func_184812_l_() || this.func_70631_g_()) && this.isFoodItem(stack)) {
            this.eat(stack);
            if (!this.field_70170_p.field_72995_K) {
                this.tame(this.func_70681_au().nextDouble() < 0.2, player);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.playerInteraction(player, hand, stack);
    }

    @Override
    public void func_213352_e(Vector3d vec3d) {
        if (this.func_70090_H()) {
            if (this.func_184186_bw()) {
                float speed = this.getTravelSpeed() * 0.225f;
                LivingEntity entity = (LivingEntity)this.func_184179_bs();
                double moveY = vec3d.field_72448_b;
                double moveX = vec3d.field_72450_a;
                double moveZ = entity.field_191988_bg;
                this.field_70759_as = entity.field_70759_as;
                if (!this.isJumpingOutOfWater()) {
                    this.field_70125_A = entity.field_70125_A * 0.5f;
                }
                double lookY = entity.func_70040_Z().field_72448_b;
                if (entity.field_191988_bg != 0.0f && (this.func_204231_K() || lookY < 0.0)) {
                    moveY = lookY;
                }
                this.func_70659_e(speed);
                vec3d = new Vector3d(moveX, moveY, moveZ);
            }
            if (this.func_213322_ci().field_72448_b > 0.25 && this.field_70170_p.func_180495_p(new BlockPos(this.func_174824_e(1.0f)).func_177984_a()).func_204520_s().func_206888_e()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.2, 1.5, 1.2));
            }
            this.func_213309_a(this.func_70689_ay(), vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            this.field_184618_aE = this.field_70721_aZ;
            double xDiff = this.func_226277_ct_() - this.field_70169_q;
            double yDiff = this.func_226278_cu_() - this.field_70167_r;
            double zDiff = this.func_226281_cx_() - this.field_70166_s;
            float amount = MathHelper.func_76133_a((double)(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff)) * 4.0f;
            if (amount > 1.0f) {
                amount = 1.0f;
            }
            this.field_70721_aZ += (amount - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            if (vec3d.field_72449_c == 0.0 && this.func_70638_az() == null && !this.func_233684_eK_()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.003, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public float getTravelSpeed() {
        return this.func_70090_H() ? (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e() : (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e() * 0.225f;
    }

    @Override
    public ItemStack func_213357_a(World world, ItemStack stack) {
        this.lightningCooldown = 0;
        return super.func_213357_a(world, stack);
    }

    @Override
    public void doSpecialEffects() {
        if (this.getVariant() == -1 && this.field_70173_aa % 25 == 0) {
            double x = this.func_226277_ct_() + (Mafs.nextDouble(this.func_70681_au()) * (double)this.func_213311_cf() + 1.0);
            double y = this.func_226278_cu_() + (this.func_70681_au().nextDouble() * (double)this.func_213302_cg() + 1.0);
            double z = this.func_226281_cx_() + (Mafs.nextDouble(this.func_70681_au()) * (double)this.func_213311_cf() + 1.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, 0.0, (double)0.05f, 0.0);
        }
    }

    @Override
    public void onInvContentsChanged(int slot, ItemStack stack, boolean onLoad) {
        if (slot == 0) {
            boolean flag = stack.func_77973_b() == Items.field_222048_ij;
            boolean hadConduit = this.hasConduit();
            this.field_70180_af.func_187227_b(HAS_CONDUIT, (Object)flag);
            if (!onLoad && flag && !hadConduit) {
                this.setAnimation(CONDUIT_ANIMATION);
            }
        }
    }

    @Override
    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
        if (pressed && this.noActiveAnimation()) {
            EntityRayTraceResult ertr;
            if (key == 1) {
                this.setAnimation(BITE_ANIMATION);
            } else if (key == 2 && !this.field_70170_p.field_72995_K && this.canZap() && (ertr = Mafs.rayTraceEntities((Entity)this.getControllingPlayer(), 40.0, e -> e instanceof LivingEntity && e != this)) != null && this.func_142018_a((LivingEntity)ertr.func_216348_a(), this.func_70902_q())) {
                this.func_70624_b((LivingEntity)ertr.func_216348_a());
                AnimationPacket.send(this, LIGHTNING_ANIMATION);
            }
        }
    }

    public Vector3d getConduitPos() {
        return this.func_174824_e(1.0f).func_72441_c(0.0, 0.4, 0.0).func_178787_e(this.func_174806_f(this.field_70125_A, this.field_70177_z).func_216372_d(-4.0, -4.0, -4.0));
    }

    @Override
    public void addScreenInfo(StaffScreen screen) {
        screen.addAction(StaffAction.INVENTORY);
        screen.addAction(StaffAction.TARGET);
        super.addScreenInfo(screen);
    }

    @Override
    public void addContainerInfo(DragonInvContainer container) {
        super.addContainerInfo(container);
        container.func_75146_a((Slot)new SlotBuilder((IItemHandler)this.getInvHandler(), 0).only((IItemProvider)Items.field_222048_ij).limit(1));
    }

    @Override
    public void setMountCameraAngles(boolean backView, EntityViewRenderEvent.CameraSetup event) {
        if (backView) {
            event.getInfo().func_216782_a(-10.0, 1.0, 0.0);
        } else {
            event.getInfo().func_216782_a(-5.0, -0.75, 0.0);
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_205019_a(IWorldReader world) {
        return world.func_226668_i_((Entity)this);
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return WRItems.WRTags.MEATS.func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_222066_kO;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_BFLY_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_BFLY_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_BFLY_DEATH.get();
    }

    protected PathNavigator func_175447_b(World world) {
        return new Navigator();
    }

    public boolean hasConduit() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CONDUIT);
    }

    @Override
    public DragonInvHandler createInv() {
        return new DragonInvHandler(this, 1);
    }

    @Override
    public boolean func_213336_c(LivingEntity target) {
        return !this.func_70631_g_() && super.func_213336_c(target);
    }

    public boolean isJumpingOutOfWater() {
        return !this.func_70090_H() && !this.beached;
    }

    public boolean canZap() {
        return this.func_70026_G() && this.lightningCooldown <= 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    @Override
    public boolean isImmuneToArrows() {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b * (this.beached ? 1.0f : 0.6f);
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
    }

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return this.func_70909_n() && !this.func_70631_g_();
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    @Override
    public Vector3d getPassengerPosOffset(Entity entity, int index) {
        return new Vector3d(0.0, this.func_70042_X(), index == 1 ? -2.0 : 0.0);
    }

    @Override
    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    @Override
    public int func_184649_cE() {
        return 6;
    }

    @Override
    public int getVariantForSpawn() {
        return this.func_70681_au().nextInt(2);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Override
    public Collection<? extends IItemProvider> getFoodItems() {
        return WRItems.WRTags.MEATS.func_230236_b_();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{LIGHTNING_ANIMATION, CONDUIT_ANIMATION, BITE_ANIMATION};
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    private static void createLightning(World world, Vector3d position, boolean effectOnly) {
        if (world.field_72995_K) {
            return;
        }
        LightningBoltEntity entity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
        entity.func_233576_c_(position);
        entity.func_233623_a_(effectOnly);
        world.func_217376_c((Entity)entity);
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.OCEAN) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.BUTTERFLY_LEVIATHAN.get(), 1, 1, 1));
        }
    }

    public static <F extends MobEntity> boolean getSpawnPlacement(EntityType<F> fEntityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (reason == SpawnReason.SPAWNER) {
            return true;
        }
        return world.func_204610_c(pos).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a) && world.func_204610_c(pos.func_177981_b(2)).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a) && random.nextDouble() < 0.1;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.08).func_233815_a_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233819_b_, 50.0);
    }

    private class JumpOutOfWaterGoal
    extends Goal {
        private BlockPos pos;

        public JumpOutOfWaterGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (ButterflyLeviathanEntity.this.func_233684_eK_()) {
                return false;
            }
            if (ButterflyLeviathanEntity.this.func_184186_bw()) {
                return false;
            }
            if (!ButterflyLeviathanEntity.this.func_204231_K()) {
                return false;
            }
            this.pos = ButterflyLeviathanEntity.this.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, ButterflyLeviathanEntity.this.func_233580_cy_()).func_177977_b();
            if (ButterflyLeviathanEntity.this.field_70170_p.func_204610_c(this.pos).func_206888_e()) {
                return false;
            }
            if (this.pos.func_177956_o() <= 0) {
                return false;
            }
            return ButterflyLeviathanEntity.this.func_70681_au().nextDouble() < 0.001;
        }

        public boolean func_75253_b() {
            return !ButterflyLeviathanEntity.this.func_184186_bw() && ButterflyLeviathanEntity.this.func_204231_K();
        }

        public void func_75249_e() {
            ButterflyLeviathanEntity.this.func_70661_as().func_75499_g();
            this.pos = this.pos.func_177967_a(ButterflyLeviathanEntity.this.func_174811_aO(), (int)(((double)this.pos.func_177956_o() - ButterflyLeviathanEntity.this.func_226278_cu_()) * 0.5));
        }

        public void func_75246_d() {
            ButterflyLeviathanEntity.this.func_70605_aq().func_75642_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 1.2);
        }

        public void func_75251_c() {
            this.pos = null;
            ButterflyLeviathanEntity.this.clearAI();
        }
    }

    private class AttackGoal
    extends Goal {
        public AttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return !ButterflyLeviathanEntity.this.func_184186_bw() && ButterflyLeviathanEntity.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            boolean isClose;
            LivingEntity target = ButterflyLeviathanEntity.this.func_70638_az();
            if (target == null) {
                return;
            }
            double distFromTarget = ButterflyLeviathanEntity.this.func_70068_e((Entity)target);
            ButterflyLeviathanEntity.this.func_70671_ap().func_75651_a((Entity)target, (float)ButterflyLeviathanEntity.this.func_184649_cE(), (float)ButterflyLeviathanEntity.this.func_70646_bf());
            boolean bl = isClose = distFromTarget < 40.0;
            if (ButterflyLeviathanEntity.this.func_70661_as().func_75500_f() || isClose || ButterflyLeviathanEntity.this.field_70173_aa % 10 == 0) {
                ButterflyLeviathanEntity.this.func_70661_as().func_75497_a((Entity)target, 1.2);
            }
            if (isClose) {
                ButterflyLeviathanEntity.this.field_70177_z = (float)Mafs.getAngle((Entity)ButterflyLeviathanEntity.this, (Entity)target) + 90.0f;
            }
            if (ButterflyLeviathanEntity.this.noActiveAnimation()) {
                if (distFromTarget > 225.0 && target.func_200600_R() == EntityType.field_200729_aH && ButterflyLeviathanEntity.this.canZap()) {
                    AnimationPacket.send(ButterflyLeviathanEntity.this, LIGHTNING_ANIMATION);
                } else if (isClose && MathHelper.func_203301_d((float)((float)Mafs.getAngle((Entity)ButterflyLeviathanEntity.this, (Entity)target) + 90.0f), (float)ButterflyLeviathanEntity.this.field_70177_z) < 30.0f) {
                    AnimationPacket.send(ButterflyLeviathanEntity.this, BITE_ANIMATION);
                }
            }
        }
    }

    private class MoveController
    extends MovementController {
        public MoveController() {
            super((MobEntity)ButterflyLeviathanEntity.this);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !ButterflyLeviathanEntity.this.func_184186_bw()) {
                double z;
                double y;
                this.field_188491_h = MovementController.Action.WAIT;
                double x = this.field_75646_b - ButterflyLeviathanEntity.this.func_226277_ct_();
                double distSq = x * x + (y = this.field_75647_c - ButterflyLeviathanEntity.this.func_226278_cu_()) * y + (z = this.field_75644_d - ButterflyLeviathanEntity.this.func_226281_cx_()) * z;
                if (distSq < 2.5000003E-7) {
                    ButterflyLeviathanEntity.this.func_191989_p(0.0f);
                } else {
                    float yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)z, (double)x)) - 90.0f;
                    float pitch = -((float)(MathHelper.func_181159_b((double)y, (double)MathHelper.func_76133_a((double)(x * x + z * z))) * 180.0 / Math.PI));
                    pitch = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)pitch), (float)-85.0f, (float)85.0f);
                    ButterflyLeviathanEntity.this.field_70759_as = yaw;
                    ButterflyLeviathanEntity.this.field_70761_aq = ButterflyLeviathanEntity.this.field_70177_z = this.func_75639_a(ButterflyLeviathanEntity.this.field_70177_z, ButterflyLeviathanEntity.this.field_70759_as, ButterflyLeviathanEntity.this.func_184649_cE());
                    ButterflyLeviathanEntity.this.field_70125_A = this.func_75639_a(ButterflyLeviathanEntity.this.field_70125_A, pitch, 90.0f);
                    ((LessShitLookController)ButterflyLeviathanEntity.this.func_70671_ap()).freeze();
                    float speed = (float)this.field_75645_e * ButterflyLeviathanEntity.this.getTravelSpeed();
                    ButterflyLeviathanEntity.this.func_70659_e(speed);
                    if (ButterflyLeviathanEntity.this.func_70090_H()) {
                        this.field_188489_f = MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180))) * speed;
                        ButterflyLeviathanEntity.this.field_70701_bs = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180))) * speed;
                    }
                }
            } else {
                ButterflyLeviathanEntity.this.func_70659_e(0.0f);
                ButterflyLeviathanEntity.this.func_184646_p(0.0f);
                ButterflyLeviathanEntity.this.func_70657_f(0.0f);
                ButterflyLeviathanEntity.this.func_191989_p(0.0f);
            }
        }
    }

    public class Navigator
    extends SwimmerPathNavigator {
        public Navigator() {
            super((MobEntity)ButterflyLeviathanEntity.this, ButterflyLeviathanEntity.this.field_70170_p);
        }

        protected PathFinder func_179679_a(int range) {
            this.field_179695_a = new WalkAndSwimNodeProcessor();
            return new PathFinder(this.field_179695_a, range);
        }

        public boolean func_188555_b(BlockPos pos) {
            return !this.field_75513_b.func_180495_p(pos.func_177977_b()).isAir((IBlockReader)this.field_75513_b, pos.func_177977_b());
        }

        protected boolean func_75485_k() {
            return true;
        }
    }
}

