/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.dragon;

import WolfShotz.Wyrmroost.entities.util.animation.Animation;
import WolfShotz.Wyrmroost.entities.util.animation.IAnimatedEntity;
import WolfShotz.Wyrmroost.items.LazySpawnEggItem;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRSounds;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;

public class LDWyrmEntity
extends AnimalEntity
implements IAnimatedEntity {
    public static final String DATA_BURROWED = "Burrowed";
    public static final Animation BITE_ANIMATION = new Animation(10);
    private static final DataParameter<Boolean> BURROWED = EntityDataManager.func_187226_a(LDWyrmEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<LivingEntity> AVOIDING = t -> EntityPredicates.field_188444_d.test(t) && !(t instanceof LDWyrmEntity);
    public Animation animation = NO_ANIMATION;
    public int animationTick;

    public LDWyrmEntity(EntityType<? extends LDWyrmEntity> minutus, World world) {
        super(minutus, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, LivingEntity.class, 6.0f, 0.8, 1.2, AVOIDING));
        this.field_70714_bg.func_75776_a(3, (Goal)new BurrowGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)LazySpawnEggItem.getEggFor(this.func_200600_R()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BURROWED, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(DATA_BURROWED, this.isBurrowed());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBurrowed(compound.func_74767_n(DATA_BURROWED));
    }

    public boolean isBurrowed() {
        return (Boolean)this.field_70180_af.func_187225_a(BURROWED);
    }

    public void setBurrowed(boolean burrow) {
        this.field_70180_af.func_187227_b(BURROWED, (Object)burrow);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isBurrowed()) {
            if (this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177979_c(1)).func_185904_a() != Material.field_151595_p) {
                this.setBurrowed(false);
            }
            this.attackAbove();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAnimation() != NO_ANIMATION) {
            ++this.animationTick;
            if (this.animationTick >= this.animation.getDuration()) {
                this.setAnimation(NO_ANIMATION);
            }
        }
    }

    private void attackAbove() {
        Predicate<Entity> predicateFilter = filter -> {
            if (filter instanceof LDWyrmEntity) {
                return false;
            }
            return filter instanceof FishingBobberEntity || filter instanceof LivingEntity && filter.func_213311_cf() < 0.9f && filter.func_213302_cg() < 0.9f;
        };
        AxisAlignedBB aabb = this.func_174813_aQ().func_72321_a(0.0, 2.0, 0.0).func_72314_b(0.5, 0.0, 0.5);
        List entities = this.field_70170_p.func_175674_a((Entity)this, aabb, predicateFilter);
        if (entities.isEmpty()) {
            return;
        }
        Optional<Entity> closest = entities.stream().min(Comparator.comparingDouble(entity -> entity.func_70032_d((Entity)this)));
        Entity entity2 = closest.get();
        if (entity2 instanceof FishingBobberEntity) {
            entity2.func_70106_y();
            this.func_213293_j(0.0, 0.8, 0.0);
            this.setBurrowed(false);
        } else {
            if (this.getAnimation() != BITE_ANIMATION) {
                this.setAnimation(BITE_ANIMATION);
            }
            this.func_70652_k(entity2);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)WRItems.LDWYRM.get());
                CompoundNBT tag = new CompoundNBT();
                CompoundNBT subTag = this.serializeNBT();
                tag.func_218657_a("DesertWyrm", (INBT)subTag);
                if (this.func_145818_k_()) {
                    stack.func_200302_a(this.func_200201_e());
                }
                stack.func_77982_d(tag);
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)stack);
                this.func_70106_y();
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151595_p) {
            return 10.0f;
        }
        return super.func_205022_a(pos, world);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.field_70170_p.func_72935_r();
    }

    public void func_70623_bb() {
        if (this.func_104002_bU()) {
            this.field_70708_bq = 0;
            return;
        }
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, -1.0);
        Event.Result result = ForgeEventFactory.canEntityDespawn((MobEntity)this);
        if (result == Event.Result.DENY) {
            this.field_70708_bq = 0;
            return;
        }
        if (result == Event.Result.ALLOW) {
            this.func_70106_y();
            return;
        }
        if (player != null) {
            double distanceSq = player.func_70068_e((Entity)this);
            if (distanceSq > 1024.0 && this.func_70681_au().nextInt(500) == 0 && this.func_213397_c(distanceSq)) {
                this.func_70106_y();
            } else if (distanceSq < 1024.0) {
                this.field_70708_bq = 0;
            }
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_76368_d;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_LDWYRM_IDLE.get();
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    public boolean func_70104_M() {
        return !this.isBurrowed();
    }

    public boolean func_70067_L() {
        return !this.isBurrowed();
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.isBurrowed()) {
            super.func_82167_n(entityIn);
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isBurrowed();
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, BITE_ANIMATION};
    }

    @Override
    public void setAnimation(Animation animation) {
        this.animation = animation;
        this.setAnimationTick(0);
    }

    public static <F extends MobEntity> boolean getSpawnPlacement(EntityType<F> fEntityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        if (reason == SpawnReason.SPAWNER) {
            return true;
        }
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block == Blocks.field_150354_m && world.func_226659_b_(pos, 0) > 8;
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.DESERT) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.LESSER_DESERTWYRM.get(), 10, 2, 4));
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    class BurrowGoal
    extends Goal {
        private int burrowTicks = 30;

        public BurrowGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return !LDWyrmEntity.this.isBurrowed() && this.belowIsSand();
        }

        public void func_75251_c() {
            this.burrowTicks = 30;
        }

        public void func_75246_d() {
            if (--this.burrowTicks <= 0) {
                LDWyrmEntity.this.setBurrowed(true);
                this.burrowTicks = 30;
            }
        }

        private boolean belowIsSand() {
            return LDWyrmEntity.this.field_70170_p.func_180495_p(LDWyrmEntity.this.func_233580_cy_().func_177979_c(1)).func_185904_a() == Material.field_151595_p;
        }
    }
}

