/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.dragon;

import WolfShotz.Wyrmroost.WRConfig;
import WolfShotz.Wyrmroost.client.screen.StaffScreen;
import WolfShotz.Wyrmroost.containers.DragonInvContainer;
import WolfShotz.Wyrmroost.containers.util.SlotBuilder;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.dragon.helpers.DragonInvHandler;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.ControlledAttackGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import WolfShotz.Wyrmroost.entities.util.EntityDataEntry;
import WolfShotz.Wyrmroost.entities.util.animation.Animation;
import WolfShotz.Wyrmroost.items.DragonArmorItem;
import WolfShotz.Wyrmroost.items.staff.StaffAction;
import WolfShotz.Wyrmroost.network.packets.AnimationPacket;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.Mafs;
import WolfShotz.Wyrmroost.util.TickFloat;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.items.IItemHandler;

public class OWDrakeEntity
extends AbstractDragonEntity {
    public static final int SADDLE_SLOT = 0;
    public static final int ARMOR_SLOT = 1;
    public static final int CHEST_SLOT = 2;
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(OWDrakeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation GRAZE_ANIMATION = new Animation(35);
    public static final Animation HORN_ATTACK_ANIMATION = new Animation(15);
    public static final Animation ROAR_ANIMATION = new Animation(86);
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public LivingEntity thrownPassenger;

    public OWDrakeEntity(EntityType<? extends OWDrakeEntity> drake, World world) {
        super(drake, world);
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
        this.registerDataEntry("Gender", EntityDataEntry.BOOLEAN, GENDER, true);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
        this.sitTimer.set(this.func_233684_eK_() ? 1.0f : 0.0f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new ControlledAttackGoal(this, 1.75, true, d -> AnimationPacket.send(d, HORN_ATTACK_ANIMATION)));
        this.field_70714_bg.func_75776_a(6, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new DragonBreedGoal(this, 2));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, true, EntityPredicates.field_188444_d::test));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(ARMOR, (Object)ItemStack.field_190927_a);
    }

    public boolean hasChest() {
        return this.getStackInSlot(2) != ItemStack.field_190927_a;
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    @Override
    public int getVariantForSpawn() {
        if (this.func_70681_au().nextInt(100) == 0) {
            return -1;
        }
        if (this.field_70170_p.func_226691_t_(this.func_233580_cy_()).func_201856_r() == Biome.Category.SAVANNA) {
            return 1;
        }
        return 0;
    }

    @Override
    public DragonInvHandler createInv() {
        return new DragonInvHandler(this, 24);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.sitTimer.add(this.func_233684_eK_() || this.func_70608_bn() ? 0.1f : -0.1f);
        this.sleepTimer.add(this.func_70608_bn() ? 0.04f : -0.1f);
        if (this.thrownPassenger != null) {
            this.thrownPassenger.func_213293_j(Mafs.nextDouble(this.func_70681_au()), 0.1 + this.func_70681_au().nextDouble(), Mafs.nextDouble(this.func_70681_au()));
            ((ServerChunkProvider)this.field_70170_p.func_72863_F()).func_217216_a((Entity)this.thrownPassenger, (IPacket)new SEntityVelocityPacket((Entity)this.thrownPassenger));
            this.thrownPassenger = null;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70638_az() != null || this.func_233684_eK_() || this.func_70608_bn() || this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c() != Blocks.field_196658_i)) {
            double d = this.func_70681_au().nextDouble();
            double d2 = this.func_70631_g_() ? 0.005 : 0.001;
            if (d < d2) {
                AnimationPacket.send(this, GRAZE_ANIMATION);
            }
        }
        Animation animation = this.getAnimation();
        int tick = this.getAnimationTick();
        if (animation == ROAR_ANIMATION) {
            if (tick == 0) {
                this.playSound((SoundEvent)WRSounds.ENTITY_OWDRAKE_ROAR.get(), 3.0f, 1.0f, true);
            } else if (tick == 15) {
                for (LivingEntity e2 : this.getEntitiesNearby(15.0, e -> !this.func_184191_r((Entity)e))) {
                    e2.func_195064_c(new EffectInstance(Effects.field_76421_d, 200));
                    if (!(this.func_70068_e((Entity)e2) <= 10.0)) continue;
                    double angle = Mafs.getAngle(this.func_226277_ct_(), this.func_226281_cx_(), e2.func_226277_ct_(), e2.func_226281_cx_()) * Math.PI / 180.0;
                    e2.func_70024_g(1.2 * -Math.cos(angle), 0.4, 1.2 * -Math.sin(angle));
                }
            }
        }
        if (animation == HORN_ATTACK_ANIMATION) {
            this.field_70761_aq = this.field_70177_z = this.field_70759_as;
            this.field_70126_B = this.field_70177_z;
            if (tick == 8) {
                this.playSound(SoundEvents.field_187596_cD, 1.0f, 0.5f, true);
                AxisAlignedBB size = this.func_174813_aQ().func_186664_h(0.15);
                AxisAlignedBB aabb = size.func_191194_a(Mafs.getYawVec(this.field_70761_aq, 0.0, size.func_216364_b() * 1.2));
                this.attackInAABB(aabb);
            }
        }
        if (animation == GRAZE_ANIMATION && tick == 13) {
            BlockPos pos = new BlockPos(Mafs.getYawVec(this.field_70761_aq, 0.0, this.func_213311_cf() / 2.0f + 1.0f).func_178787_e(this.func_213303_ch()));
            if (this.field_70170_p.func_180495_p(pos).func_177230_c().getBlock() == Blocks.field_150349_c && WRConfig.canGrief(this.field_70170_p)) {
                this.field_70170_p.func_175655_b(pos, false);
                this.func_70615_aA();
            } else if (this.field_70170_p.func_180495_p(pos = pos.func_177977_b()).func_177230_c().getBlock() == Blocks.field_196658_i) {
                this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                this.field_70170_p.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
                this.func_70615_aA();
            }
        }
    }

    @Override
    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151141_av && !this.isSaddled() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.getInvHandler().insertItem(0, stack.func_77946_l(), false);
                this.func_175505_a(player, stack);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.func_70909_n() && this.func_70631_g_() && this.isFoodItem(stack)) {
            this.tame(this.func_70681_au().nextInt(10) == 0, player);
            this.func_175505_a(player, stack);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.playerInteraction(player, hand, stack);
    }

    @Override
    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            if (this.func_70909_n()) {
                this.func_70031_b(passenger.func_70051_ag());
            } else if (!this.field_70170_p.field_72995_K && passenger instanceof PlayerEntity) {
                double rng = this.func_70681_au().nextDouble();
                if (rng < 0.01) {
                    this.tame(true, (PlayerEntity)passenger);
                } else if (rng <= 0.1) {
                    this.func_70624_b(passenger);
                    this.field_184245_j = 60;
                    this.func_184226_ay();
                    this.thrownPassenger = passenger;
                }
            }
        }
    }

    @Override
    public void onInvContentsChanged(int slot, ItemStack stack, boolean onLoad) {
        if (slot == 0) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)(!stack.func_190926_b() ? 1 : 0));
            if (!stack.func_190926_b() && !onLoad) {
                this.func_184185_a(SoundEvents.field_187726_cu, 1.0f, 1.0f);
            }
        }
        if (slot == 1) {
            this.setArmor(stack);
        }
    }

    @Override
    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
        if (key == 1 && pressed && this.noActiveAnimation()) {
            if ((mods & 2) != 0) {
                this.setAnimation(ROAR_ANIMATION);
            } else {
                this.setAnimation(HORN_ATTACK_ANIMATION);
            }
        }
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
        if (this.func_233684_eK_() || this.func_70608_bn()) {
            size = size.func_220312_a(1.0f, 0.75f);
        }
        return size;
    }

    @Override
    public void addScreenInfo(StaffScreen screen) {
        screen.addAction(StaffAction.INVENTORY);
        screen.addAction(StaffAction.TARGET);
        super.addScreenInfo(screen);
    }

    @Override
    public void addContainerInfo(DragonInvContainer container) {
        super.addContainerInfo(container);
        DragonInvHandler inv = container.inventory;
        container.func_75146_a((Slot)new SlotBuilder((IItemHandler)inv, 0, 17, 45).only((IItemProvider)Items.field_151141_av));
        container.func_75146_a((Slot)new SlotBuilder((IItemHandler)inv, 1, 17, 63).only(DragonArmorItem.class));
        container.func_75146_a((Slot)new SlotBuilder((IItemHandler)inv, 2, 17, 81).only(ChestBlock.class).limit(1).canTake(p -> inv.isEmptyAfter(2)));
        container.makeSlots(3, 51, 45, 7, 3, (i, x, z) -> new SlotBuilder((IItemHandler)inv, i, x, z).condition(this::hasChest));
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        LivingEntity prev = this.func_70638_az();
        super.func_70624_b(target);
        boolean flag = this.func_70638_az() != null;
        this.func_70031_b(flag);
        if (flag && prev != target && !this.func_70909_n() && this.noActiveAnimation()) {
            AnimationPacket.send(this, ROAR_ANIMATION);
        }
    }

    @Override
    public void setMountCameraAngles(boolean backView, EntityViewRenderEvent.CameraSetup event) {
        if (backView) {
            event.getInfo().func_216782_a(-0.5, 0.75, 0.0);
        } else {
            event.getInfo().func_216782_a(-3.0, 0.3, 0.0);
        }
    }

    public void func_70615_aA() {
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(4.0f);
        }
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return this.isSaddled() && !this.func_70631_g_() && (this.func_152114_e((LivingEntity)entity) || !this.func_70909_n() && this.field_184245_j <= 0);
    }

    @Override
    public float getTravelSpeed() {
        float speed = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        if (this.func_70051_ag()) {
            speed += 0.8f;
        }
        return speed;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.3f, 1.0f);
        super.func_180429_a(pos, blockIn);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_OWDRAKE_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_OWDRAKE_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_OWDRAKE_DEATH.get();
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Override
    public Collection<? extends IItemProvider> getFoodItems() {
        return Tags.Items.CROPS_WHEAT.func_230236_b_();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, GRAZE_ANIMATION, HORN_ATTACK_ANIMATION, ROAR_ANIMATION};
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.SAVANNA || category == Biome.Category.PLAINS) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.OVERWORLD_DRAKE.get(), 8, 1, 3));
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233821_d_, 0.21).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233824_g_, 3.2).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }
}

