/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.dragon;

import WolfShotz.Wyrmroost.client.screen.StaffScreen;
import WolfShotz.Wyrmroost.containers.DragonInvContainer;
import WolfShotz.Wyrmroost.containers.util.SlotBuilder;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.dragon.helpers.DragonInvHandler;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DefendHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import WolfShotz.Wyrmroost.entities.util.EntityDataEntry;
import WolfShotz.Wyrmroost.items.staff.StaffAction;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.Mafs;
import java.util.Collection;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.items.IItemHandler;

public class RoostStalkerEntity
extends AbstractDragonEntity {
    public static final int ITEM_SLOT = 0;
    private static final Predicate<LivingEntity> TARGETS = target -> target instanceof ChickenEntity || target instanceof RabbitEntity || target instanceof TurtleEntity;
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(RoostStalkerEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> SCAVENGING = EntityDataManager.func_187226_a(RoostStalkerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public RoostStalkerEntity(EntityType<? extends RoostStalkerEntity> stalker, World world) {
        super(stalker, world);
        this.field_70138_W = 0.0f;
        this.setImmune(DamageSource.field_76369_e);
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new ScavengeGoal(1.1));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 5.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal<PlayerEntity>((CreatureEntity)this, PlayerEntity.class, 7.0f, (double)1.15f, 1.0){

            public boolean func_75250_a() {
                return !RoostStalkerEntity.this.func_70909_n() && !RoostStalkerEntity.this.getItem().func_190926_b() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, LivingEntity.class, false, TARGETS));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(SCAVENGING, (Object)false);
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    private boolean hasItem() {
        return this.getItem() != ItemStack.field_190927_a;
    }

    public void setItem(ItemStack item) {
        this.field_70180_af.func_187227_b(ITEM, (Object)item);
        if (!item.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187719_p, 0.5f, 1.0f);
        }
    }

    public boolean isScavenging() {
        return (Boolean)this.field_70180_af.func_187225_a(SCAVENGING);
    }

    public void setScavenging(boolean b) {
        this.field_70180_af.func_187227_b(SCAVENGING, (Object)b);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.sleepTimer.add(this.func_70608_bn() ? 0.08f : -0.15f);
        if (!this.field_70170_p.field_72995_K) {
            ItemStack item = this.getStackInSlot(0);
            if (this.isFoodItem(item) && this.func_110143_aJ() < this.func_110138_aP() && this.func_70681_au().nextDouble() <= 0.0075) {
                this.eat(item);
            }
            if (this.func_70877_b(item) && this.func_213743_em() && this.func_70874_b() == 0 && this.func_70681_au().nextDouble() < 0.01) {
                RoostStalkerEntity.setInLove(this);
            }
        }
    }

    @Override
    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        ActionResultType COMMON_SUCCESS = ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        ItemStack heldItem = this.getItem();
        Item item = stack.func_77973_b();
        if (!this.func_70909_n() && Tags.Items.EGGS.func_230235_a_((Object)item)) {
            this.eat(stack);
            if (this.tame(this.field_70146_Z.nextInt(4) == 0, player)) {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            }
            return COMMON_SUCCESS;
        }
        if (this.func_152114_e((LivingEntity)player)) {
            if (player.func_225608_bj_()) {
                this.setSit(!this.func_233684_eK_());
                return COMMON_SUCCESS;
            }
            if (stack.func_190926_b() && heldItem.func_190926_b() && player.func_184188_bt().size() < 3) {
                this.setSit(false);
                this.func_184205_a((Entity)player, true);
                return COMMON_SUCCESS;
            }
            this.setStackInSlot(0, stack);
            player.func_184611_a(hand, heldItem);
            return COMMON_SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void doSpecialEffects() {
        if (this.getVariant() == -1 && this.field_70173_aa % 25 == 0) {
            double x = this.func_226277_ct_() + Mafs.nextDouble(this.func_70681_au()) * 0.7;
            double y = this.func_226278_cu_() + this.func_70681_au().nextDouble() * 0.5;
            double z = this.func_226281_cx_() + Mafs.nextDouble(this.func_70681_au()) * 0.7;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, 0.0, (double)0.05f, 0.0);
        }
    }

    @Override
    public void onInvContentsChanged(int slot, ItemStack stack, boolean onLoad) {
        if (slot == 0) {
            this.setItem(stack);
        }
    }

    public ItemStack func_184582_a(EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.getItem();
        }
        return super.func_184582_a(slot);
    }

    @Override
    public void addScreenInfo(StaffScreen screen) {
        screen.addAction(StaffAction.INVENTORY);
        screen.addAction(StaffAction.TARGET);
        super.addScreenInfo(screen);
    }

    @Override
    public void addContainerInfo(DragonInvContainer container) {
        super.addContainerInfo(container);
        container.func_75146_a((Slot)new SlotBuilder((IItemHandler)this.getInvHandler(), 0));
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151074_bl;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
    }

    @Override
    public int getVariantForSpawn() {
        return this.func_70681_au().nextInt(185) == 0 ? -1 : 0;
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyController((MobEntity)this);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_STALKER_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_STALKER_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_STALKER_DEATH.get();
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    @Override
    public Collection<? extends IItemProvider> getFoodItems() {
        return WRItems.WRTags.MEATS.func_230236_b_();
    }

    @Override
    public DragonInvHandler createInv() {
        return new DragonInvHandler(this, 1);
    }

    private static void setInLove(RoostStalkerEntity entity) {
        ItemStack item = entity.getStackInSlot(0);
        item.func_190918_g(1);
        entity.func_204700_e(600);
        entity.setStackInSlot(0, item.func_77946_l());
        entity.field_70170_p.func_72960_a((Entity)entity, (byte)18);
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category == Biome.Category.PLAINS || category == Biome.Category.FOREST || category == Biome.Category.EXTREME_HILLS) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.ROOSTSTALKER.get(), 7, 2, 9));
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.285).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    class BreedGoal
    extends DragonBreedGoal {
        public BreedGoal() {
            super(RoostStalkerEntity.this, 0);
        }

        public void func_75249_e() {
            RoostStalkerEntity.setInLove((RoostStalkerEntity)this.targetMate);
        }
    }

    class ScavengeGoal
    extends MoveToBlockGoal {
        private IInventory chest;
        private int searchDelay;

        public ScavengeGoal(double speed) {
            super((CreatureEntity)RoostStalkerEntity.this, speed, 16);
            this.searchDelay = 20 + new Random().nextInt(40) + 5;
        }

        public boolean func_75250_a() {
            boolean flag;
            boolean bl = flag = !RoostStalkerEntity.this.func_70909_n() && !RoostStalkerEntity.this.hasItem() && super.func_75250_a();
            if (flag) {
                this.chest = this.getInventoryAtPosition();
                return this.chest != null && !this.chest.func_191420_l();
            }
            return false;
        }

        public boolean func_75253_b() {
            return !RoostStalkerEntity.this.hasItem() && this.chest != null && super.func_75253_b();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.func_179487_f()) {
                int index;
                ItemStack stack;
                if (RoostStalkerEntity.this.hasItem()) {
                    return;
                }
                RoostStalkerEntity.this.setScavenging(true);
                if (this.chest == null) {
                    return;
                }
                if (this.chest instanceof ChestTileEntity && ((ChestTileEntity)this.chest).field_145987_o == 0) {
                    this.interactChest(this.chest, true);
                }
                if (!this.chest.func_191420_l() && --this.searchDelay <= 0 && !(stack = this.chest.func_70301_a(index = RoostStalkerEntity.this.func_70681_au().nextInt(this.chest.func_70302_i_()))).func_190926_b()) {
                    stack = this.chest.func_70304_b(index);
                    RoostStalkerEntity.this.getInvHandler().insertItem(0, stack, false);
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.interactChest(this.chest, false);
            this.searchDelay = 20 + new Random().nextInt(40) + 5;
            RoostStalkerEntity.this.setScavenging(false);
        }

        @Nullable
        public IInventory getInventoryAtPosition() {
            TileEntity tileentity;
            IInventory inv = null;
            BlockState blockstate = RoostStalkerEntity.this.field_70170_p.func_180495_p(this.field_179494_b);
            Block block = blockstate.func_177230_c();
            if (blockstate.hasTileEntity() && (tileentity = RoostStalkerEntity.this.field_70170_p.func_175625_s(this.field_179494_b)) instanceof IInventory && (inv = (IInventory)tileentity) instanceof ChestTileEntity && block instanceof ChestBlock) {
                inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (World)RoostStalkerEntity.this.field_70170_p, (BlockPos)this.field_179494_b, (boolean)true);
            }
            return inv;
        }

        protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
            return world.func_175625_s(pos) instanceof IInventory;
        }

        private void interactChest(IInventory intentory, boolean open) {
            if (!(intentory instanceof ChestTileEntity)) {
                return;
            }
            ChestTileEntity chest = (ChestTileEntity)intentory;
            chest.field_145987_o = open ? 1 : 0;
            chest.func_145831_w().func_175641_c(chest.func_174877_v(), chest.func_195044_w().func_177230_c(), 1, chest.field_145987_o);
        }
    }
}

