/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.dragon;

import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.FlyerWanderGoal;
import WolfShotz.Wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import WolfShotz.Wyrmroost.entities.util.CommonGoalWrappers;
import WolfShotz.Wyrmroost.entities.util.EntityDataEntry;
import WolfShotz.Wyrmroost.network.packets.SGGlidePacket;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.registry.WRSounds;
import WolfShotz.Wyrmroost.util.TickFloat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class SilverGliderEntity
extends AbstractDragonEntity {
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat flightTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public TemptGoal temptGoal;
    public boolean isGliding;

    public SilverGliderEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.registerDataEntry("Gender", EntityDataEntry.BOOLEAN, GENDER, this.func_70681_au().nextBoolean());
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.temptGoal = CommonGoalWrappers.nonTamedTemptGoal(this, 0.8, true, Ingredient.func_199804_a((IItemProvider[])this.getFoodItems().toArray(new IItemProvider[0])));
        this.field_70714_bg.func_75776_a(3, (Goal)this.temptGoal);
        this.field_70714_bg.func_75776_a(4, CommonGoalWrappers.nonTamedAvoidGoal(this, PlayerEntity.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new DragonBreedGoal(this, 0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new SwoopGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new FlyerWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 7.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isGliding && !this.isRiding()) {
            this.isGliding = false;
        }
        this.sitTimer.add(this.func_233684_eK_() || this.func_70608_bn() ? 0.2f : -0.2f);
        this.sleepTimer.add(this.func_70608_bn() ? 0.05f : -0.1f);
        this.flightTimer.add(this.isFlying() || this.isGliding() ? 0.1f : -0.1f);
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        if (!(this.func_184187_bx() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)this.func_184187_bx();
        boolean FLAG = this.shouldGlide(player);
        if (this.field_70170_p.field_72995_K && this.isGliding != FLAG) {
            SGGlidePacket.send(FLAG);
            this.isGliding = FLAG;
        }
        if (this.isGliding) {
            Vector3d vec3d = player.func_70040_Z().func_186678_a(0.3);
            player.func_213317_d(player.func_213322_ci().func_186678_a(0.6).func_72441_c(vec3d.field_72450_a, Math.min(vec3d.field_72448_b * 2.0, 0.0), vec3d.field_72449_c));
            if (!this.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.field_184344_B = false;
            }
            player.field_70143_R = 0.0f;
        }
    }

    @Override
    public void func_213352_e(Vector3d vec3d) {
        Vector3d look = this.func_70040_Z();
        if (this.isFlying() && look.field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, look.field_72448_b * 0.25, 0.0));
        }
        super.func_213352_e(vec3d);
    }

    @Override
    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        if (!this.func_70909_n() && this.func_70877_b(stack)) {
            if (!this.field_70170_p.field_72995_K && (this.temptGoal.func_75277_f() || player.func_184812_l_())) {
                this.tame(this.func_70681_au().nextDouble() < 0.333, player);
                this.eat(stack);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        if (this.func_152114_e((LivingEntity)player) && player.func_184188_bt().size() == 0 && !player.func_225608_bj_()) {
            this.func_184205_a((Entity)player, true);
            this.setSit(false);
            this.clearAI();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.playerInteraction(player, hand, stack);
    }

    public boolean shouldGlide(PlayerEntity player) {
        if (this.func_70631_g_()) {
            return false;
        }
        if (!player.field_70703_bu) {
            return false;
        }
        if (player.field_71075_bZ.field_75100_b) {
            return false;
        }
        if (player.func_184613_cA()) {
            return false;
        }
        if (player.func_70090_H()) {
            return false;
        }
        if (player.func_213322_ci().field_72448_b > 0.0) {
            return false;
        }
        if (this.isGliding() && !player.func_233570_aj_()) {
            return true;
        }
        return this.getAltitude() - 1.8 > 4.0;
    }

    @Override
    public void doSpecialEffects() {
        if (this.getVariant() == -1 && this.field_70173_aa % 5 == 0) {
            double x = this.func_226277_ct_() + this.func_70681_au().nextGaussian();
            double y = this.func_226278_cu_() + this.func_70681_au().nextDouble();
            double z = this.func_226281_cx_() + this.func_70681_au().nextGaussian();
            this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.8f, 0.0f, 1.0f), x, y, z, 0.0, (double)0.2f, 0.0);
        }
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
        if (this.func_233684_eK_() || this.func_70608_bn()) {
            size = size.func_220312_a(1.0f, 0.87f);
        }
        return size;
    }

    @Override
    public int getVariantForSpawn() {
        if (this.func_70681_au().nextDouble() < 0.002) {
            return -1;
        }
        return this.func_70681_au().nextInt(3);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_SILVERGLIDER_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_SILVERGLIDER_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_SILVERGLIDER_DEATH.get();
    }

    @Override
    public Vector3d getRidingPosOffset(int passengerIndex) {
        return new Vector3d(0.0, 1.81, 0.5);
    }

    @Override
    public boolean shouldFly() {
        return this.isRiding() ? this.isGliding() : super.shouldFly();
    }

    public int func_70646_bf() {
        return 30;
    }

    @Override
    public int func_184649_cE() {
        return this.isFlying() ? 5 : 75;
    }

    public boolean isGliding() {
        return this.isGliding;
    }

    @Override
    public Collection<? extends IItemProvider> getFoodItems() {
        return ItemTags.field_206964_G.func_230236_b_();
    }

    public static boolean getSpawnPlacement(EntityType<SilverGliderEntity> fEntityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (spawnReason == SpawnReason.SPAWNER) {
            return true;
        }
        Block block = world.func_180495_p(blockPos.func_177977_b()).func_177230_c();
        return block == Blocks.field_150350_a || block == Blocks.field_150354_m && world.func_226659_b_(blockPos, 0) > 8;
    }

    @Nullable
    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.OCEAN || event.getCategory() == Biome.Category.BEACH) {
            event.getSpawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)WREntities.SILVER_GLIDER.get(), 10, 1, 4));
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.23).func_233815_a_(Attributes.field_233822_e_, 0.24);
    }

    public class SwoopGoal
    extends Goal {
        private BlockPos pos;

        public SwoopGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (!SilverGliderEntity.this.isFlying()) {
                return false;
            }
            if (SilverGliderEntity.this.isRiding()) {
                return false;
            }
            if (SilverGliderEntity.this.func_70681_au().nextDouble() > 0.001) {
                return false;
            }
            this.pos = SilverGliderEntity.this.field_70170_p.func_205770_a(Heightmap.Type.WORLD_SURFACE, SilverGliderEntity.this.func_233580_cy_()).func_177977_b();
            if (SilverGliderEntity.this.field_70170_p.func_204610_c(this.pos).func_206888_e()) {
                return false;
            }
            return SilverGliderEntity.this.func_226278_cu_() - (double)this.pos.func_177956_o() > 8.0;
        }

        public boolean func_75253_b() {
            return SilverGliderEntity.this.func_233580_cy_().func_177951_i((Vector3i)this.pos) > 8.0;
        }

        public void func_75246_d() {
            if (SilverGliderEntity.this.func_70661_as().func_75500_f()) {
                SilverGliderEntity.this.func_70661_as().func_75492_a((double)this.pos.func_177958_n(), (double)(this.pos.func_177956_o() + 2), (double)this.pos.func_177952_p(), 1.0);
            }
            SilverGliderEntity.this.func_70671_ap().func_220679_a((double)this.pos.func_177958_n(), (double)(this.pos.func_177956_o() + 2), (double)this.pos.func_177952_p());
        }
    }
}

