/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.projectile.breath;

import WolfShotz.Wyrmroost.WRConfig;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.projectile.DragonProjectileEntity;
import WolfShotz.Wyrmroost.entities.projectile.breath.BreathWeaponEntity;
import WolfShotz.Wyrmroost.registry.WREntities;
import WolfShotz.Wyrmroost.util.Mafs;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FireBreathEntity
extends BreathWeaponEntity {
    public FireBreathEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public FireBreathEntity(AbstractDragonEntity shooter) {
        super((EntityType<? extends DragonProjectileEntity>)((EntityType)WREntities.FIRE_BREATH.get()), shooter);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            if (this.field_70146_Z.nextDouble() <= 0.25) {
                this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            }
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), Mafs.nextDouble(this.field_70146_Z) * (double)0.2f, this.field_70146_Z.nextDouble() * (double)0.08f, Mafs.nextDouble(this.field_70146_Z) * (double)0.2f);
            }
            this.func_70106_y();
            return;
        }
        Vector3d motion = this.func_213322_ci();
        double x = this.func_226277_ct_() + motion.field_72450_a + this.field_70146_Z.nextGaussian() * 0.2;
        double y = this.func_226278_cu_() + motion.field_72448_b + this.field_70146_Z.nextGaussian() * 0.2 + 0.5;
        double z = this.func_226281_cx_() + motion.field_72449_c + this.field_70146_Z.nextGaussian() * 0.2;
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public void onBlockImpact(BlockRayTraceResult result) {
        Direction face;
        BlockPos offset;
        super.onBlockImpact(result);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos pos = result.func_216350_a();
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (CampfireBlock.func_241470_h_((BlockState)state)) {
            this.field_70170_p.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            return;
        }
        double flammability = WRConfig.fireBreathFlammability;
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223598_a) && WRConfig.canGrief(this.field_70170_p) && flammability != 0.0 && this.field_70170_p.func_180495_p(offset = pos.func_177972_a(face = result.func_216354_b())).isAir((IBlockReader)this.field_70170_p, offset) && (flammability == 1.0 || this.field_70146_Z.nextDouble() <= flammability)) {
            this.field_70170_p.func_180501_a(offset, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)offset), 11);
        }
    }

    @Override
    public void onEntityImpact(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entity == this.shooter) {
            return;
        }
        if (entity.func_230279_az_()) {
            return;
        }
        if (entity instanceof LivingEntity && this.shooter.func_184191_r(entity)) {
            return;
        }
        float damage = (float)this.shooter.func_110148_a((Attribute)WREntities.Attributes.PROJECTILE_DAMAGE.get()).func_111126_e();
        if (this.field_70170_p.func_175727_C(entity.func_233580_cy_())) {
            damage *= 0.75f;
        }
        entity.func_70015_d(8);
        entity.func_70097_a(this.getDamageSource("fireBreath"), damage);
    }

    @Override
    public DamageSource getDamageSource(String name) {
        return super.getDamageSource(name).func_76361_j();
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70027_ad() {
        return true;
    }
}

