/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.entities.util;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.util.TriConsumer;

public class EntityDataEntry<T> {
    public static final SerializerType<Boolean> BOOLEAN = new SerializerType((key, nbt, value) -> nbt.func_74757_a(key, value.booleanValue()), (key, nbt) -> nbt.func_74767_n(key));
    public static final SerializerType<Integer> INTEGER = new SerializerType((key, nbt, value) -> nbt.func_74768_a(key, value.intValue()), (key, nbt) -> nbt.func_74762_e(key));
    public static final SerializerType<CompoundNBT> COMPOUND = new SerializerType((key, nbt, value) -> nbt.func_218657_a(key, (INBT)value), (key, nbt) -> nbt.func_74775_l(key));
    public static final SerializerType<BlockPos> BLOCK_POS = new SerializerType((key, nbt, value) -> nbt.func_74772_a(key, value.func_218275_a()), (key, nbt) -> BlockPos.func_218283_e((long)nbt.func_74763_f(key)));
    private final String key;
    private final SerializerType<T> serializer;
    private final Supplier<T> writer;
    private final Consumer<T> reader;

    public EntityDataEntry(String key, SerializerType<T> type, Supplier<T> write, Consumer<T> read) {
        this.key = key;
        this.serializer = type;
        this.writer = write;
        this.reader = read;
    }

    public void write(CompoundNBT nbt) {
        this.serializer.write.accept((Object)this.key, (Object)nbt, this.writer.get());
    }

    public void read(CompoundNBT nbt) {
        this.reader.accept(this.serializer.read.apply(this.key, nbt));
    }

    public static class SerializerType<T> {
        public final TriConsumer<String, CompoundNBT, T> write;
        public final BiFunction<String, CompoundNBT, T> read;

        private SerializerType(TriConsumer<String, CompoundNBT, T> write, BiFunction<String, CompoundNBT, T> read) {
            this.write = write;
            this.read = read;
        }

        public SerializerType<Optional<T>> optional() {
            return new SerializerType<Optional<T>>((key, nbt, value) -> value.ifPresent(j -> this.write.accept(key, nbt, j)), (key, nbt) -> nbt.func_74764_b(key) ? Optional.of(this.read.apply((String)key, (CompoundNBT)nbt)) : Optional.empty());
        }
    }
}

