/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.items;

import WolfShotz.Wyrmroost.registry.WRItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.registries.ForgeRegistries;

public class LazySpawnEggItem
extends Item {
    public static List<LazySpawnEggItem> EGG_TYPES = Lists.newArrayList();
    public final Supplier<EntityType<?>> type;
    private final int PRIMARY_COLOR;
    private final int SECONDARY_COLOR;

    public LazySpawnEggItem(Supplier<EntityType<? extends Entity>> type, int primaryColor, int secondaryColor) {
        super(WRItems.builder());
        this.type = type;
        this.PRIMARY_COLOR = primaryColor;
        this.SECONDARY_COLOR = secondaryColor;
        EGG_TYPES.add(this);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ResourceLocation regName = this.type.get().getRegistryName();
        return new TranslationTextComponent("entity." + regName.func_110624_b() + "." + regName.func_110623_a()).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("item.wyrmroost.spawn_egg"));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileentity;
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == Blocks.field_150474_ac && (tileentity = world.func_175625_s(blockpos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            abstractspawner.func_200876_a(this.type.get());
            tileentity.func_70296_d();
            world.func_184138_a(blockpos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        if (this.type.get().func_220331_a((ServerWorld)world, itemstack, context.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult raytraceresult = LazySpawnEggItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            if (this.type.get().func_220331_a((ServerWorld)worldIn, itemstack, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (!(target instanceof AgeableEntity)) {
            return ActionResultType.PASS;
        }
        if (!target.func_70089_S()) {
            return ActionResultType.PASS;
        }
        if (target.func_200600_R() != this.type.get()) {
            return ActionResultType.PASS;
        }
        if (!target.field_70170_p.field_72995_K) {
            ((AgeableEntity)target).func_241840_a((ServerWorld)target.field_70170_p, (AgeableEntity)target);
        }
        return ActionResultType.func_233537_a_((boolean)playerIn.field_70170_p.field_72995_K);
    }

    public int getColors(int index) {
        return index == 0 ? this.PRIMARY_COLOR : this.SECONDARY_COLOR;
    }

    @Nullable
    public static Item getEggFor(EntityType<?> type) {
        ResourceLocation loc = type.getRegistryName();
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + "_spawn_egg"));
    }
}

