/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.items;

import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.registry.WRItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SoulCrystalItem
extends Item {
    public static final String DATA_DRAGON = "DragonData";

    public SoulCrystalItem() {
        super(WRItems.builder().func_200917_a(1));
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        World world = player.field_70170_p;
        if (SoulCrystalItem.containsDragon(stack)) {
            return ActionResultType.PASS;
        }
        if (!SoulCrystalItem.isSuitableEntity(target)) {
            return ActionResultType.PASS;
        }
        TameableEntity dragon = (TameableEntity)target;
        if (dragon.func_70902_q() != player) {
            return ActionResultType.PASS;
        }
        if (!dragon.func_184188_bt().isEmpty()) {
            dragon.func_184226_ay();
        }
        if (!world.field_72995_K) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_218657_a(DATA_DRAGON, (INBT)dragon.serializeNBT());
            stack.func_77982_d(tag);
            dragon.func_70106_y();
            player.func_184611_a(hand, stack);
        } else {
            int i = 0;
            while ((float)i <= dragon.func_213311_cf() * 25.0f) {
                double calcX = (double)MathHelper.func_76134_b((float)((float)i + 41252.96f)) * ((double)dragon.func_213311_cf() * 1.5);
                double calcZ = (double)MathHelper.func_76126_a((float)((float)i + 41252.96f)) * ((double)dragon.func_213311_cf() * 1.5);
                double x = dragon.func_226277_ct_() + calcX;
                double y = dragon.func_226278_cu_() + (double)(dragon.func_213302_cg() * 1.8f);
                double z = dragon.func_226281_cx_() + calcZ;
                double xMot = -calcX / 5.0;
                double yMot = -(dragon.func_213302_cg() / 8.0f);
                double zMot = -calcZ / 5.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, xMot, yMot, zMot);
                ++i;
            }
        }
        world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.AMBIENT, 1.0f, 1.0f);
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        if (!SoulCrystalItem.containsDragon(stack)) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        TameableEntity dragon = SoulCrystalItem.getContained(stack, world);
        BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l());
        PlayerEntity player = context.func_195999_j();
        dragon.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        if (!world.func_226665_a__((Entity)dragon, dragon.func_174813_aQ())) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.wyrmroost.soul_crystal.fail").func_240699_a_(TextFormatting.RED), true);
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K) {
            stack.func_196083_e(DATA_DRAGON);
            world.func_217376_c((Entity)dragon);
        } else {
            EntitySize size = dragon.func_213305_a(dragon.func_213283_Z());
            double posX = (double)pos.func_177958_n() + 0.5;
            double posY = (float)pos.func_177956_o() + size.field_220316_b / 2.0f;
            double posZ = (double)pos.func_177952_p() + 0.5;
            int i = 0;
            while ((float)i < dragon.func_213311_cf() * 25.0f) {
                double x = (double)MathHelper.func_76134_b((float)((float)i + 41252.96f)) * ((double)dragon.func_213311_cf() * 1.5);
                double z = (double)MathHelper.func_76126_a((float)((float)i + 41252.96f)) * ((double)dragon.func_213311_cf() * 1.5);
                double xMot = x / 10.0;
                double yMot = dragon.func_213302_cg() / 18.0f;
                double zMot = z / 10.0;
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, posX, posY, posZ, xMot, yMot, zMot);
                world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, posX, posY + (double)i * 0.25, posZ, 0.0, 0.0, 0.0);
                ++i;
            }
        }
        world.func_184133_a(null, dragon.func_233580_cy_(), SoundEvents.field_191244_bn, SoundCategory.AMBIENT, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TameableEntity dragon = SoulCrystalItem.getContained(stack, world);
        if (dragon != null) {
            tooltip.add((ITextComponent)new StringTextComponent(dragon.func_200200_C_().func_150261_e()));
            tooltip.add((ITextComponent)new StringTextComponent(Character.toString('\u2764')).func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %s / %s", (int)(dragon.func_110143_aJ() / 2.0f), (int)dragon.func_110138_aP() / 2))));
            LivingEntity owner = dragon.func_70902_q();
            if (owner != null) {
                tooltip.add((ITextComponent)new StringTextComponent("Tamed by " + owner.func_200200_C_().func_150261_e()));
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        TranslationTextComponent name = (TranslationTextComponent)super.func_200295_i(stack);
        if (SoulCrystalItem.containsDragon(stack)) {
            name.func_240699_a_(TextFormatting.AQUA).func_240699_a_(TextFormatting.ITALIC);
        }
        return name;
    }

    public boolean func_77636_d(ItemStack stack) {
        return SoulCrystalItem.containsDragon(stack);
    }

    private static boolean containsDragon(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(DATA_DRAGON);
    }

    @Nullable
    private static TameableEntity getContained(ItemStack stack, World world) {
        if (!SoulCrystalItem.containsDragon(stack)) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p().func_74775_l(DATA_DRAGON);
        EntityType type = EntityType.func_220327_a((String)tag.func_74779_i("id")).orElse(null);
        if (type == null) {
            return null;
        }
        TameableEntity dragon = (TameableEntity)type.func_200721_a(world);
        dragon.deserializeNBT(tag);
        return dragon;
    }

    private static boolean isSuitableEntity(LivingEntity entity) {
        if (entity instanceof TameableEntity) {
            String modID;
            if (entity instanceof AbstractDragonEntity) {
                return true;
            }
            switch (modID = entity.func_200600_R().getRegistryName().func_110624_b()) {
                case "dragonmounts": 
                case "wings": {
                    return true;
                }
            }
        }
        return false;
    }
}

