/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.items.staff;

import WolfShotz.Wyrmroost.client.screen.StaffScreen;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.items.staff.StaffAction;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class DragonStaffItem
extends Item {
    public static final String DATA_DRAGON_ID = "BoundDragon";
    public static final String DATA_ACTION = "Action";

    public DragonStaffItem() {
        super(WRItems.builder().func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_() && stack.func_77942_o() && stack.func_77978_p().func_74764_b(DATA_DRAGON_ID)) {
            DragonStaffItem.reset(stack.func_77978_p());
            ModUtils.playLocalSound(world, player.func_233580_cy_(), SoundEvents.field_219685_jO, 1.0f, 1.0f);
            return ActionResult.func_226248_a_((Object)stack);
        }
        AbstractDragonEntity dragon = DragonStaffItem.getBoundDragon(world, stack);
        if (dragon != null && DragonStaffItem.getAction(stack).rightClick(dragon, player, stack)) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        AbstractDragonEntity dragon;
        if (entity instanceof AbstractDragonEntity && (dragon = (AbstractDragonEntity)entity).func_152114_e((LivingEntity)player)) {
            DragonStaffItem.bindDragon(dragon, stack);
            ModUtils.playLocalSound(player.field_70170_p, player.func_233580_cy_(), SoundEvents.field_190021_aL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        AbstractDragonEntity dragon;
        if (target instanceof AbstractDragonEntity && (dragon = (AbstractDragonEntity)target).func_152114_e((LivingEntity)playerIn)) {
            DragonStaffItem.bindDragon(dragon, stack);
            if (playerIn.field_70170_p.field_72995_K) {
                StaffScreen.open(dragon, stack);
            }
            return ActionResultType.func_233537_a_((boolean)playerIn.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j().func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        AbstractDragonEntity dragon = DragonStaffItem.getBoundDragon(context.func_195991_k(), stack);
        if (dragon != null && DragonStaffItem.getAction(stack).clickBlock(dragon, context)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        AbstractDragonEntity dragon;
        tooltip.add((ITextComponent)new TranslationTextComponent("item.wyrmroost.dragon_staff.desc").func_240699_a_(TextFormatting.GRAY));
        if (stack.func_77942_o() && (dragon = DragonStaffItem.getBoundDragon(worldIn, stack)) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.wyrmroost.dragon_staff.bound", new Object[]{new StringTextComponent(dragon.func_200200_C_().func_150261_e()).func_240699_a_(TextFormatting.AQUA)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.wyrmroost.dragon_staff.action", new Object[]{new TranslationTextComponent(DragonStaffItem.getAction(stack).getTranslateKey(dragon)).func_240699_a_(TextFormatting.AQUA).getString()}));
        }
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        DragonStaffItem.reset(nbt);
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return DragonStaffItem.getAction(stack) != StaffAction.DEFAULT;
    }

    public static void reset(@Nullable CompoundNBT tag) {
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b(DATA_DRAGON_ID)) {
            tag.func_82580_o(DATA_DRAGON_ID);
        }
        if (tag.func_74764_b(DATA_ACTION)) {
            tag.func_82580_o(DATA_ACTION);
        }
    }

    public static void setAction(StaffAction action, PlayerEntity player, ItemStack stack) {
        DragonStaffItem.assertStaff(stack);
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a(DATA_ACTION, action.ordinal());
        DragonStaffItem.getAction(stack).onSelected(DragonStaffItem.getBoundDragon(player.field_70170_p, stack), player, stack);
    }

    public static StaffAction getAction(ItemStack stack) {
        CompoundNBT tag;
        DragonStaffItem.assertStaff(stack);
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b(DATA_ACTION)) {
            return StaffAction.VALUES[tag.func_74762_e(DATA_ACTION)];
        }
        return StaffAction.DEFAULT;
    }

    public static void bindDragon(AbstractDragonEntity dragon, ItemStack stack) {
        DragonStaffItem.assertStaff(stack);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a(DATA_DRAGON_ID, dragon.func_145782_y());
    }

    @Nullable
    public static AbstractDragonEntity getBoundDragon(World world, ItemStack stack) {
        Entity entity;
        CompoundNBT tag;
        DragonStaffItem.assertStaff(stack);
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b(DATA_DRAGON_ID) && (entity = world.func_73045_a(tag.func_74762_e(DATA_DRAGON_ID))) instanceof AbstractDragonEntity) {
            return (AbstractDragonEntity)entity;
        }
        return null;
    }

    public static void assertStaff(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof DragonStaffItem)) {
            throw new AssertionError((Object)String.format("This isnt a staff wtf? [%s] Please contact the mod author", stack.func_77973_b().getRegistryName()));
        }
    }
}

