/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.network.packets;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.client.ClientEvents;
import WolfShotz.Wyrmroost.entities.util.animation.Animation;
import WolfShotz.Wyrmroost.entities.util.animation.IAnimatedEntity;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public class AnimationPacket {
    private final int entityID;
    private final int animationIndex;

    public AnimationPacket(int entityID, int index) {
        this.entityID = entityID;
        this.animationIndex = index;
    }

    public AnimationPacket(PacketBuffer buf) {
        this.entityID = buf.readInt();
        this.animationIndex = buf.readInt();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.animationIndex);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.handleAnimationPacket(this.entityID, this.animationIndex));
    }

    public static <T extends Entity> void send(T entity, Animation animation) {
        if (!entity.field_70170_p.field_72995_K) {
            ((IAnimatedEntity)entity).setAnimation(animation);
            Wyrmroost.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new AnimationPacket(entity.func_145782_y(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation)));
        }
    }
}

