/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.gui;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.client.gui.BookBlit;
import com.github.alexthe666.citadel.client.gui.BookPage;
import com.github.alexthe666.citadel.client.gui.BookPageButton;
import com.github.alexthe666.citadel.client.gui.data.EntityRenderData;
import com.github.alexthe666.citadel.client.gui.data.ImageData;
import com.github.alexthe666.citadel.client.gui.data.ItemRenderData;
import com.github.alexthe666.citadel.client.gui.data.LineData;
import com.github.alexthe666.citadel.client.gui.data.LinkData;
import com.github.alexthe666.citadel.client.gui.data.RecipeData;
import com.github.alexthe666.citadel.client.gui.data.TabulaRenderData;
import com.github.alexthe666.citadel.client.gui.data.Whitespace;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.TabulaModelHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IResource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiBasicBook
extends Screen {
    private static final ResourceLocation BOOK_PAGE_TEXTURE = new ResourceLocation("citadel:textures/gui/book/book_pages.png");
    private static final ResourceLocation BOOK_BINDING_TEXTURE = new ResourceLocation("citadel:textures/gui/book/book_binding.png");
    private static final ResourceLocation BOOK_WIDGET_TEXTURE = new ResourceLocation("citadel:textures/gui/book/widgets.png");
    protected ItemStack bookStack;
    protected int xSize = 390;
    protected int ySize = 320;
    protected int currentPageCounter = 0;
    protected int maxPagesFromPrinting = 0;
    protected int linesFromJSON = 0;
    protected int linesFromPrinting = 0;
    protected ResourceLocation prevPageJSON;
    protected ResourceLocation currentPageJSON;
    protected ResourceLocation currentPageText = null;
    private BookPageButton buttonNextPage;
    private BookPageButton buttonPreviousPage;
    private BookPage internalPage = null;
    private List<LineData> lines = new ArrayList<LineData>();
    private List<LinkData> links = new ArrayList<LinkData>();
    private List<ItemRenderData> itemRenders = new ArrayList<ItemRenderData>();
    private List<RecipeData> recipes = new ArrayList<RecipeData>();
    private List<TabulaRenderData> tabulaRenders = new ArrayList<TabulaRenderData>();
    private List<EntityRenderData> entityRenders = new ArrayList<EntityRenderData>();
    private List<ImageData> images = new ArrayList<ImageData>();
    private List<Whitespace> yIndexesToSkip = new ArrayList<Whitespace>();
    private Map<String, TabulaModel> renderedTabulaModels = new HashMap<String, TabulaModel>();
    private Map<String, Entity> renderedEntites = new HashMap<String, Entity>();
    private Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
    private String writtenTitle = "";

    public GuiBasicBook(ItemStack bookStack, ITextComponent title) {
        super(title);
        this.bookStack = bookStack;
        this.currentPageJSON = this.getRootPage();
    }

    public static void drawEntityOnScreen(int posX, int posY, float scale, boolean follow, double xRot, double yRot, double zRot, float mouseX, float mouseY, Entity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        entity.func_230245_c_(false);
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(20.0f);
        if (follow) {
            float yaw;
            entity.field_70177_z = yaw = f * 20.0f;
            entity.field_70125_A = -f1 * 20.0f;
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).field_70761_aq = yaw;
                ((LivingEntity)entity).field_70760_ar = yaw;
                ((LivingEntity)entity).field_70759_as = yaw;
                ((LivingEntity)entity).field_70758_at = yaw;
            }
            quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
            quaternion.func_195890_a(quaternion1);
        }
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(-xRot)));
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)yRot));
        matrixstack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)zRot));
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_(entity, 0.0, 0.0, 0.0, f, partialTicks, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70177_z = 0.0f;
        entity.field_70125_A = 0.0f;
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).field_70761_aq = 0.0f;
            ((LivingEntity)entity).field_70758_at = 0.0f;
            ((LivingEntity)entity).field_70759_as = 0.0f;
        }
        RenderSystem.popMatrix();
    }

    public static void drawTabulaModelOnScreen(TabulaModel model, ResourceLocation tex, int posX, int posY, float scale, boolean follow, double xRot, double yRot, double zRot, float mouseX, float mouseY) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(0.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        if (follow) {
            quaternion.func_195890_a(quaternion1);
        }
        matrixstack.func_227863_a_(quaternion);
        if (follow) {
            matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + f * 40.0f));
        }
        matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)xRot));
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)yRot));
        matrixstack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)zRot));
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> {
            IVertexBuilder ivertexbuilder = irendertypebuffer$impl.getBuffer(RenderType.func_228640_c_((ResourceLocation)tex));
            model.resetToDefaultPose();
            model.func_225598_a_(matrixstack, ivertexbuilder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        });
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.playBookOpeningSound();
        this.addNextPreviousButtons();
        this.addLinkButtons();
    }

    private void addNextPreviousButtons() {
        int k = (this.field_230708_k_ - this.xSize) / 2;
        int l = (this.field_230709_l_ - this.ySize + 128) / 2;
        this.buttonPreviousPage = (BookPageButton)this.func_230480_a_((Widget)new BookPageButton(this, k + 10, l + 180, false, p_214208_1_ -> this.onSwitchPage(false), true));
        this.buttonNextPage = (BookPageButton)this.func_230480_a_((Widget)new BookPageButton(this, k + 365, l + 180, true, p_214205_1_ -> this.onSwitchPage(true), true));
    }

    private void addLinkButtons() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.addNextPreviousButtons();
        int k = (this.field_230708_k_ - this.xSize) / 2;
        int l = (this.field_230709_l_ - this.ySize + 128) / 2;
        for (LinkData linkData : this.links) {
            if (linkData.getPage() != this.currentPageCounter) continue;
            int maxLength = Math.max(100, Minecraft.func_71410_x().field_71466_p.func_78256_a(linkData.getTitleText()) + 20);
            this.yIndexesToSkip.add(new Whitespace(linkData.getPage(), linkData.getX() - maxLength / 2, linkData.getY(), 100, 20));
            this.func_230480_a_((Widget)new Button(k + linkData.getX() - maxLength / 2, l + linkData.getY(), maxLength, 20, (ITextComponent)new StringTextComponent(linkData.getTitleText()), p_213021_1_ -> {
                this.prevPageJSON = this.currentPageJSON;
                this.currentPageJSON = new ResourceLocation(this.getTextFileDirectory() + linkData.getLinkedPage());
                this.currentPageCounter = 0;
                this.addNextPreviousButtons();
            }));
        }
    }

    private void onSwitchPage(boolean next) {
        if (next) {
            if (this.currentPageCounter < this.maxPagesFromPrinting) {
                ++this.currentPageCounter;
            }
        } else {
            if (this.currentPageCounter > 0) {
                --this.currentPageCounter;
            }
            if (this.internalPage != null && !this.internalPage.getParent().isEmpty()) {
                this.prevPageJSON = this.currentPageJSON;
                this.currentPageJSON = new ResourceLocation(this.getTextFileDirectory() + this.internalPage.getParent());
                this.currentPageCounter = 0;
            }
        }
        this.refreshSpacing();
        this.currentPageCounter = MathHelper.func_76125_a((int)this.currentPageCounter, (int)0, (int)this.maxPagesFromPrinting);
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        int color = this.getBindingColor();
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        this.func_230446_a_(matrixStack);
        int k = (this.field_230708_k_ - this.xSize) / 2;
        int l = (this.field_230709_l_ - this.ySize + 128) / 2;
        this.getMinecraft().func_110434_K().func_110577_a(this.getBookPageTexture());
        GuiBasicBook.func_238463_a_((MatrixStack)matrixStack, (int)k, (int)l, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)this.xSize, (int)this.ySize);
        this.getMinecraft().func_110434_K().func_110577_a(this.getBookBindingTexture());
        BookBlit.setRGB(r, g, b, 255);
        BookBlit.func_238463_a_(matrixStack, k, l, 0.0f, 0.0f, this.xSize, this.ySize, this.xSize, this.ySize);
        if (this.internalPage == null || this.currentPageJSON != this.prevPageJSON || this.prevPageJSON == null) {
            this.internalPage = this.generatePage(this.currentPageJSON);
            if (this.internalPage != null) {
                this.refreshSpacing();
            }
        }
        if (this.internalPage != null) {
            matrixStack.func_227860_a_();
            this.renderOtherWidgets(matrixStack, x, y, this.internalPage);
            matrixStack.func_227865_b_();
            this.writePageText(matrixStack, x, y);
        }
        this.prevPageJSON = this.currentPageJSON;
        super.func_230430_a_(matrixStack, x, y, partialTicks);
    }

    private void refreshSpacing() {
        if (this.internalPage != null) {
            this.currentPageText = new ResourceLocation(this.getTextFileDirectory() + this.internalPage.getTextFileToReadFrom());
            this.readInPageWidgets(this.internalPage);
            this.addWidgetSpacing();
            this.addLinkButtons();
            this.readInPageText(this.currentPageText);
        }
    }

    private Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    private IRecipe getRecipeByName(String registryName) {
        try {
            RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
            if (manager.func_215367_a(new ResourceLocation(registryName)).isPresent()) {
                return (IRecipe)manager.func_215367_a(new ResourceLocation(registryName)).get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addWidgetSpacing() {
        this.yIndexesToSkip.clear();
        for (ItemRenderData itemRenderData : this.itemRenders) {
            Item item = this.getItemByRegistryName(itemRenderData.getItem());
            if (item == null) continue;
            this.yIndexesToSkip.add(new Whitespace(itemRenderData.getPage(), itemRenderData.getX(), itemRenderData.getY(), (int)(itemRenderData.getScale() * 17.0), (int)(itemRenderData.getScale() * 15.0)));
        }
        for (RecipeData recipeData : this.recipes) {
            IRecipe recipe = this.getRecipeByName(recipeData.getRecipe());
            if (recipe == null) continue;
            this.yIndexesToSkip.add(new Whitespace(recipeData.getPage(), recipeData.getX(), recipeData.getY() - (int)(recipeData.getScale() * 15.0), (int)(recipeData.getScale() * 35.0), (int)(recipeData.getScale() * 60.0), true));
        }
        for (ImageData imageData : this.images) {
            if (imageData == null) continue;
            this.yIndexesToSkip.add(new Whitespace(imageData.getPage(), imageData.getX(), imageData.getY(), (int)(imageData.getScale() * (double)imageData.getWidth()), (int)(imageData.getScale() * (double)imageData.getHeight() * (double)0.8f)));
        }
        if (!this.writtenTitle.isEmpty()) {
            this.yIndexesToSkip.add(new Whitespace(0, 20, 5, 70, 15));
        }
    }

    private void renderOtherWidgets(MatrixStack matrixStack, int x, int y, BookPage page) {
        TabulaModel model;
        int k = (this.field_230708_k_ - this.xSize) / 2;
        int l = (this.field_230709_l_ - this.ySize + 128) / 2;
        for (ItemRenderData itemRenderData : this.itemRenders) {
            Item item;
            if (itemRenderData.getPage() != this.currentPageCounter || (item = this.getItemByRegistryName(itemRenderData.getItem())) == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)k, (float)l, (float)32.0f);
            float scale = (float)itemRenderData.getScale();
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            this.field_230707_j_.func_180450_b(new ItemStack((IItemProvider)item), itemRenderData.getX(), itemRenderData.getY());
            RenderSystem.popMatrix();
        }
        for (RecipeData recipeData : this.recipes) {
            if (recipeData.getPage() != this.currentPageCounter) continue;
            IRecipe recipe = this.getRecipeByName(recipeData.getRecipe());
            int playerTicks = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
            if (recipe == null) continue;
            float scale = (float)recipeData.getScale();
            this.getMinecraft().func_110434_K().func_110577_a(this.getBookWidgetTexture());
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(k + recipeData.getX()), (double)(l + recipeData.getY()), 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            this.func_238474_b_(matrixStack, 0, 0, 0, 88, 116, 53);
            matrixStack.func_227865_b_();
            for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
                Ingredient ing = (Ingredient)recipe.func_192400_c().get(i);
                ItemStack stack = ItemStack.field_190927_a;
                if (!ing.func_203189_d()) {
                    if (ing.func_193365_a().length > 1) {
                        int currentIndex = (int)((float)playerTicks / 20.0f % (float)ing.func_193365_a().length);
                        stack = ing.func_193365_a()[currentIndex];
                    } else {
                        stack = ing.func_193365_a()[0];
                    }
                }
                if (stack.func_190926_b()) continue;
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)k, (float)l, (float)32.0f);
                RenderSystem.translatef((float)((int)((float)recipeData.getX() + (float)(i % 3 * 20) * scale)), (float)((int)((float)recipeData.getY() + (float)(i / 3 * 20) * scale)), (float)0.0f);
                RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                this.field_230707_j_.func_180450_b(stack, 0, 0);
                RenderSystem.popMatrix();
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)k, (float)l, (float)32.0f);
            float finScale = scale * 1.5f;
            RenderSystem.translatef((float)((float)recipeData.getX() + 70.0f * finScale), (float)((float)recipeData.getY() + 10.0f * finScale), (float)0.0f);
            RenderSystem.scalef((float)finScale, (float)finScale, (float)finScale);
            this.field_230707_j_.func_180450_b(recipe.func_77571_b(), 0, 0);
            RenderSystem.popMatrix();
        }
        for (TabulaRenderData tabulaRenderData : this.tabulaRenders) {
            if (tabulaRenderData.getPage() != this.currentPageCounter) continue;
            model = null;
            ResourceLocation texture = this.textureMap.get(tabulaRenderData.getTexture()) != null ? this.textureMap.get(tabulaRenderData.getTexture()) : this.textureMap.put(tabulaRenderData.getTexture(), new ResourceLocation(tabulaRenderData.getTexture()));
            if (this.renderedTabulaModels.get(tabulaRenderData.getModel()) != null) {
                model = this.renderedTabulaModels.get(tabulaRenderData.getModel());
            } else {
                try {
                    model = new TabulaModel(TabulaModelHandler.INSTANCE.loadTabulaModel("/assets/" + tabulaRenderData.getModel().split(":")[0] + "/" + tabulaRenderData.getModel().split(":")[1]));
                }
                catch (Exception e) {
                    Citadel.LOGGER.warn("Could not load in tabula model for book at " + tabulaRenderData.getModel());
                }
                this.renderedTabulaModels.put(tabulaRenderData.getModel(), model);
            }
            if (model == null || texture == null) continue;
            float scale = (float)tabulaRenderData.getScale();
            GuiBasicBook.drawTabulaModelOnScreen(model, texture, k + tabulaRenderData.getX(), l + tabulaRenderData.getY(), 30.0f * scale, tabulaRenderData.isFollow_cursor(), tabulaRenderData.getRot_x(), tabulaRenderData.getRot_y(), tabulaRenderData.getRot_z(), k + tabulaRenderData.getX() - x, l + tabulaRenderData.getY() - y);
        }
        for (EntityRenderData entityRenderData : this.entityRenders) {
            if (entityRenderData.getPage() != this.currentPageCounter) continue;
            model = null;
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityRenderData.getEntity()));
            if (type != null) {
                model = this.renderedEntites.putIfAbsent(entityRenderData.getEntity(), type.func_200721_a((World)Minecraft.func_71410_x().field_71441_e));
            }
            if (model == null) continue;
            float scale = (float)entityRenderData.getScale();
            ((Entity)model).field_70173_aa = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
            int mouseX = k + entityRenderData.getX() - x;
            int mouseY = k + entityRenderData.getY() / 2 - y;
            GuiBasicBook.drawEntityOnScreen(k + entityRenderData.getX(), l + entityRenderData.getY(), 30.0f * scale, entityRenderData.isFollow_cursor(), entityRenderData.getRot_x(), entityRenderData.getRot_y(), entityRenderData.getRot_z(), mouseX, mouseY, (Entity)model);
        }
        for (ImageData imageData : this.images) {
            if (imageData.getPage() != this.currentPageCounter || imageData == null) continue;
            ResourceLocation tex = this.textureMap.get(imageData.getTexture());
            if (tex == null) {
                tex = new ResourceLocation(imageData.getTexture());
                this.textureMap.put(imageData.getTexture(), tex);
            }
            float scale = (float)imageData.getScale();
            this.getMinecraft().func_110434_K().func_110577_a(tex);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(k + imageData.getX()), (double)(l + imageData.getY()), 0.0);
            matrixStack.func_227862_a_(scale, scale, scale);
            this.func_238474_b_(matrixStack, 0, 0, imageData.getU(), imageData.getV(), imageData.getWidth(), imageData.getHeight());
            matrixStack.func_227865_b_();
        }
    }

    private void writePageText(MatrixStack matrixStack, int x, int y) {
        FontRenderer font = this.field_230712_o_;
        int k = (this.field_230708_k_ - this.xSize) / 2;
        int l = (this.field_230709_l_ - this.ySize + 128) / 2;
        if (this.currentPageCounter == 0 && !this.writtenTitle.isEmpty()) {
            String actualTitle = I18n.func_135052_a((String)this.writtenTitle, (Object[])new Object[0]);
            matrixStack.func_227860_a_();
            float scale = 2.0f;
            if (font.func_78256_a(actualTitle) > 80) {
                scale = 2.0f - MathHelper.func_76131_a((float)((float)(font.func_78256_a(actualTitle) - 80) * 0.011f), (float)0.0f, (float)1.95f);
            }
            matrixStack.func_227861_a_((double)(k + 10), (double)(l + 10), 0.0);
            matrixStack.func_227862_a_(scale, scale, 1.0f);
            font.func_238421_b_(matrixStack, actualTitle, 0.0f, 0.0f, this.getTitleColor());
            matrixStack.func_227865_b_();
        }
        this.buttonNextPage.field_230694_p_ = this.currentPageCounter < this.maxPagesFromPrinting;
        boolean rootPage = this.currentPageJSON == this.getRootPage();
        this.buttonPreviousPage.field_230694_p_ = this.currentPageCounter > 0 || !rootPage;
        for (LineData line : this.lines) {
            if (line.getPage() != this.currentPageCounter) continue;
            font.func_238421_b_(matrixStack, line.getText(), (float)(k + 10 + line.getxIndex()), (float)(l + 10 + line.getyIndex() * 12), this.getTextColor());
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean func_231177_au__() {
        return this.isPauseScreen();
    }

    protected void playBookOpeningSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219617_ah, (float)1.0f));
    }

    protected void playBookClosingSound() {
    }

    protected abstract int getBindingColor();

    protected int getWidgetColor() {
        return this.getBindingColor();
    }

    protected int getTextColor() {
        return 0x303030;
    }

    protected int getTitleColor() {
        return 12233880;
    }

    public abstract ResourceLocation getRootPage();

    public abstract String getTextFileDirectory();

    protected ResourceLocation getBookPageTexture() {
        return BOOK_PAGE_TEXTURE;
    }

    protected ResourceLocation getBookBindingTexture() {
        return BOOK_BINDING_TEXTURE;
    }

    protected ResourceLocation getBookWidgetTexture() {
        return BOOK_WIDGET_TEXTURE;
    }

    protected void playPageFlipSound() {
    }

    @Nullable
    protected BookPage generatePage(ResourceLocation res) {
        IResource resource = null;
        BookPage page = null;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(res);
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(res);
                InputStream inputstream = resource.func_199027_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                page = BookPage.deserialize(reader);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            return null;
        }
        return page;
    }

    protected void readInPageWidgets(BookPage page) {
        this.links.clear();
        this.itemRenders.clear();
        this.recipes.clear();
        this.tabulaRenders.clear();
        this.entityRenders.clear();
        this.images.clear();
        this.links.addAll(page.getLinkedButtons());
        this.itemRenders.addAll(page.getItemRenders());
        this.recipes.addAll(page.getRecipes());
        this.tabulaRenders.addAll(page.getTabulaRenders());
        this.entityRenders.addAll(page.getEntityRenders());
        this.images.addAll(page.getImages());
        this.writtenTitle = page.getTitle();
    }

    protected void readInPageText(ResourceLocation res) {
        IResource resource = null;
        int xIndex = 0;
        int actualTextX = 0;
        int yIndex = 0;
        try {
            resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(res);
            try {
                List readStrings = IOUtils.readLines((InputStream)resource.func_199027_b(), (Charset)StandardCharsets.UTF_8);
                this.linesFromJSON = readStrings.size();
                this.lines.clear();
                ArrayList<String> splitBySpaces = new ArrayList<String>();
                for (String line : readStrings) {
                    splitBySpaces.addAll(Arrays.asList(line.split(" ")));
                }
                String lineToPrint = "";
                this.linesFromPrinting = 0;
                int page = 0;
                for (int i = 0; i < splitBySpaces.size(); ++i) {
                    String word = (String)splitBySpaces.get(i);
                    int cutoffPoint = xIndex > 100 ? 30 : 35;
                    boolean newline = word.equals("<NEWLINE>");
                    for (Whitespace indexes : this.yIndexesToSkip) {
                        int indexPage = indexes.getPage();
                        if (indexPage != page) continue;
                        int buttonX = indexes.getX();
                        int buttonY = indexes.getY();
                        int width = indexes.getWidth();
                        int height = indexes.getHeight();
                        if (indexes.isDown()) {
                            if (!((float)yIndex >= (float)buttonY / 12.0f) || !((float)yIndex <= (float)(buttonY + height) / 12.0f) || (buttonX >= 90 || xIndex >= 90) && (buttonX < 90 || xIndex < 90)) continue;
                            yIndex += 2;
                            continue;
                        }
                        if (!((float)yIndex >= (float)(buttonY - height) / 12.0f) || !((float)yIndex <= (float)(buttonY + height) / 12.0f) || (buttonX >= 90 || xIndex >= 90) && (buttonX < 90 || xIndex < 90)) continue;
                        ++yIndex;
                    }
                    boolean last = i == splitBySpaces.size() - 1;
                    actualTextX += word.length() + 1;
                    if (lineToPrint.length() + word.length() + 1 >= cutoffPoint || newline) {
                        ++this.linesFromPrinting;
                        if (yIndex > 13) {
                            if (xIndex > 0) {
                                ++page;
                                xIndex = 0;
                                yIndex = 0;
                            } else {
                                xIndex = 200;
                                yIndex = 0;
                            }
                        }
                        if (last) {
                            lineToPrint = lineToPrint + " " + word;
                        }
                        this.lines.add(new LineData(xIndex, yIndex, lineToPrint, page));
                        ++yIndex;
                        actualTextX = 0;
                        if (newline) {
                            ++yIndex;
                        }
                        lineToPrint = "" + (word.equals("<NEWLINE>") ? "" : word);
                        continue;
                    }
                    lineToPrint = lineToPrint + " " + word;
                    if (!last) continue;
                    ++this.linesFromPrinting;
                    this.lines.add(new LineData(xIndex, yIndex, lineToPrint, page));
                    ++yIndex;
                    actualTextX = 0;
                    if (!newline) continue;
                    ++yIndex;
                }
                this.maxPagesFromPrinting = page;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            Citadel.LOGGER.warn("Could not load in page .txt from json from page, page: " + res.toString());
        }
    }
}

