/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.entity;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.EntityDataHandler;
import com.github.alexthe666.citadel.server.entity.IEntityData;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;

public class EntityDataCapabilityImplementation
implements IEntityData {
    private Entity entity;

    public static IEntityData getCapability(Entity entity) {
        return (IEntityData)entity.getCapability(Citadel.ENTITY_DATA_CAPABILITY, null).orElseGet(null);
    }

    public void init(Entity entity, World world) {
    }

    public void init(Entity entity, World world, boolean init) {
        this.entity = entity;
        if (init) {
            for (IEntityData<Entity> entityData : EntityDataHandler.INSTANCE.getEntityData(entity)) {
                entityData.init(entity, world);
            }
        }
    }

    @Override
    public void saveNBTData(CompoundNBT compound) {
        for (IEntityData<Entity> entityData : EntityDataHandler.INSTANCE.getEntityData(this.entity)) {
            CompoundNBT managerTag = new CompoundNBT();
            entityData.saveNBTData(managerTag);
            compound.func_218657_a(entityData.getID(), (INBT)managerTag);
        }
    }

    @Override
    public void loadNBTData(CompoundNBT compound) {
        for (IEntityData<Entity> entityData : EntityDataHandler.INSTANCE.getEntityData(this.entity)) {
            CompoundNBT managerTag = compound.func_74775_l(entityData.getID());
            entityData.loadNBTData(managerTag);
        }
    }

    @Override
    public String getID() {
        return "data_cap_citadel";
    }
}

