/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class BlockCharedPath
extends GrassPathBlock {
    public static final BooleanProperty REVERTS = BooleanProperty.func_177716_a((String)"revert");
    public Item itemBlock;
    public int dragonType;

    public BlockCharedPath(int dragonType) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(dragonType != 1 ? SoundType.field_185849_b : SoundType.field_185853_f).func_200943_b(0.6f).harvestTool(ToolType.SHOVEL).harvestLevel(0).func_200941_a(dragonType != 1 ? 0.6f : 0.98f).func_200944_c());
        this.dragonType = dragonType;
        this.setRegistryName("iceandfire", this.getNameFromType(dragonType));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)REVERTS, (Comparable)Boolean.valueOf(false)));
    }

    public String getNameFromType(int dragonType) {
        switch (dragonType) {
            case 0: {
                return "chared_grass_path";
            }
            case 1: {
                return "frozen_grass_path";
            }
            case 2: {
                return "crackled_grass_path";
            }
        }
        return "";
    }

    public BlockState getSmushedState(int dragonType) {
        switch (dragonType) {
            case 0: {
                return IafBlockRegistry.CHARRED_DIRT.func_176223_P();
            }
            case 1: {
                return IafBlockRegistry.FROZEN_DIRT.func_176223_P();
            }
            case 2: {
                return IafBlockRegistry.CRACKLED_DIRT.func_176223_P();
            }
        }
        return null;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.field_72995_K) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (((Boolean)state.func_177229_b((Property)REVERTS)).booleanValue() && rand.nextInt(3) == 0) {
                worldIn.func_175656_a(pos, Blocks.field_185774_da.func_176223_P());
            }
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, this.getSmushedState(this.dragonType));
        }
        this.updateBlockState((World)worldIn, pos);
    }

    private void updateBlockState(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            worldIn.func_175656_a(pos, this.getSmushedState(this.dragonType));
        }
    }

    public BlockState getStateFromMeta(int meta) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)REVERTS, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int getMetaFromState(BlockState state) {
        return (Boolean)state.func_177229_b((Property)REVERTS) != false ? 1 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{REVERTS});
    }
}

