/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.block.INoTab;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockDragonforgeCore
extends ContainerBlock
implements IDragonProof,
INoTab {
    private static boolean keepInventory;
    private int isFire;
    private boolean activated;

    public BlockDragonforgeCore(int isFire, boolean activated) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_208770_d().func_200948_a(40.0f, 500.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(p_235454_0_ -> activated ? 15 : 0));
        String disabled = activated ? "" : "_disabled";
        this.setRegistryName("iceandfire", "dragonforge_" + DragonType.getNameFromInt(isFire) + "_core" + disabled);
        this.isFire = isFire;
        this.activated = activated;
    }

    public static void setState(int dragonType, boolean active, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            if (dragonType == 0) {
                worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_FIRE_CORE.func_176223_P(), 3);
                worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_FIRE_CORE.func_176223_P(), 3);
            } else if (dragonType == 1) {
                worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_ICE_CORE.func_176223_P(), 3);
                worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_ICE_CORE.func_176223_P(), 3);
            } else if (dragonType == 2) {
                worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE.func_176223_P(), 3);
                worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE.func_176223_P(), 3);
            }
        } else if (dragonType == 0) {
            worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED.func_176223_P(), 3);
            worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED.func_176223_P(), 3);
        } else if (dragonType == 1) {
            worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_ICE_CORE_DISABLED.func_176223_P(), 3);
            worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_ICE_CORE_DISABLED.func_176223_P(), 3);
        } else if (dragonType == 2) {
            worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE_DISABLED.func_176223_P(), 3);
            worldIn.func_180501_a(pos, IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE_DISABLED.func_176223_P(), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                IceAndFire.PROXY.setRefrencedTE(worldIn.func_175625_s(pos));
            } else {
                INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, worldIn, pos);
                if (inamedcontainerprovider != null) {
                    player.func_213829_a(inamedcontainerprovider);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public ItemStack getItem(World worldIn, BlockPos pos, BlockState state) {
        if (this.isFire == 0) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED));
        }
        if (this.isFire == 1) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)IafBlockRegistry.DRAGONFORGE_ICE_CORE_DISABLED));
        }
        if (this.isFire == 2) {
            return new ItemStack((IItemProvider)Item.func_150898_a((Block)IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE_DISABLED));
        }
        return new ItemStack((IItemProvider)Item.func_150898_a((Block)IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void randomDisplayTick(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.activated) {
            // empty if block
        }
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityDragonforge(this.isFire);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityDragonforge) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityDragonforge)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Override
    public boolean shouldBeInTab() {
        return !this.activated;
    }
}

