/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IDreadBlock;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDreadPortal;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockDreadPortal
extends ContainerBlock
implements IDreadBlock,
ICustomRendered {
    public BlockDreadPortal() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_208770_d().func_200948_a(-1.0f, 100000.0f).harvestTool(ToolType.PICKAXE).func_235838_a_(p_235454_0_ -> 1).func_200944_c());
        this.setRegistryName("iceandfire", "dread_portal");
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void neighborChanged(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean canSurviveAt(World world, BlockPos pos) {
        return DragonUtils.isDreadBlock(world.func_180495_p(pos.func_177984_a())) && DragonUtils.isDreadBlock(world.func_180495_p(pos.func_177977_b()));
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityDreadPortal();
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityDreadPortal) {
            int i = 3;
            for (int j = 0; j < i; ++j) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.25;
                double d4 = (double)rand.nextFloat() * -0.25;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.25;
                int k = rand.nextInt(2) * 2 - 1;
                IceAndFire.PROXY.spawnParticle("dread_portal", d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityDreadPortal();
    }
}

