/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockJar
extends ContainerBlock
implements ICustomRendered {
    protected static final VoxelShape AABB = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public Item itemBlock;
    private boolean empty;
    private int pixieType;

    public BlockJar(int pixieType) {
        super(pixieType != -1 ? AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_208770_d().func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(p_235454_0_ -> pixieType == -1 ? 0 : 10).func_222379_b(IafBlockRegistry.JAR_EMPTY) : AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_208770_d().func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185853_f));
        this.empty = pixieType == -1;
        this.pixieType = pixieType;
        if (this.empty) {
            this.setRegistryName("iceandfire:pixie_jar_empty");
        } else {
            this.setRegistryName("iceandfire:pixie_jar_" + pixieType);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void dropPixie(World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityJar && ((TileEntityJar)world.func_175625_s((BlockPos)pos)).hasPixie) {
            ((TileEntityJar)world.func_175625_s(pos)).releasePixie();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult resultIn) {
        if (!this.empty && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityJar && ((TileEntityJar)world.func_175625_s((BlockPos)pos)).hasPixie && ((TileEntityJar)world.func_175625_s((BlockPos)pos)).hasProduced) {
            ((TileEntityJar)world.func_175625_s((BlockPos)pos)).hasProduced = false;
            ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)IafItemRegistry.PIXIE_DUST));
            if (!world.field_72995_K) {
                world.func_217376_c((Entity)item);
            }
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, IafSoundRegistry.PIXIE_HURT, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityJar) {
            if (!this.empty) {
                ((TileEntityJar)world.func_175625_s((BlockPos)pos)).hasPixie = true;
                ((TileEntityJar)world.func_175625_s((BlockPos)pos)).pixieType = this.pixieType;
            } else {
                ((TileEntityJar)world.func_175625_s((BlockPos)pos)).hasPixie = false;
            }
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityJar(this.empty);
    }
}

