/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.StatCollector;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.inventory.ContainerDragon;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiDragon
extends ContainerScreen<ContainerDragon> {
    private static final ResourceLocation texture = new ResourceLocation("iceandfire:textures/gui/dragon.png");
    private PlayerInventory playerInventory;
    private ContainerDragon dragonInv;
    private float mousePosx;
    private float mousePosY;

    public GuiDragon(ContainerDragon dragonInv, PlayerInventory playerInv, ITextComponent name) {
        super((Container)dragonInv, playerInv, name);
        this.playerInventory = playerInv;
        this.dragonInv = dragonInv;
        this.field_147000_g = 214;
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_238422_b_(p_230451_1_, this.field_230704_d_.func_241878_f(), (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public static void drawEntityOnScreen(int posX, int posY, float scale, float mouseX, float mouseY, LivingEntity p_228187_5_) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = p_228187_5_.field_70761_aq;
        float f3 = p_228187_5_.field_70177_z;
        float f4 = p_228187_5_.field_70125_A;
        float f5 = p_228187_5_.field_70758_at;
        float f6 = p_228187_5_.field_70759_as;
        p_228187_5_.field_70761_aq = 180.0f + f * 20.0f;
        p_228187_5_.field_70177_z = 180.0f + f * 40.0f;
        p_228187_5_.field_70125_A = -f1 * 20.0f;
        p_228187_5_.field_70759_as = p_228187_5_.field_70177_z;
        p_228187_5_.field_70758_at = p_228187_5_.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)p_228187_5_, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        p_228187_5_.field_70761_aq = f2;
        p_228187_5_.field_70177_z = f3;
        p_228187_5_.field_70125_A = f4;
        p_228187_5_.field_70758_at = f5;
        p_228187_5_.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    protected void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        Entity entity = IceAndFire.PROXY.getReferencedMob();
        if (entity instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)entity;
            String s1 = dragon.func_200200_C_().getString();
            int k = (this.field_230708_k_ - this.field_146999_f) / 2;
            int l = (this.field_230709_l_ - this.field_147000_g) / 2;
            FontRenderer font = this.getMinecraft().field_71466_p;
            String s3 = dragon.func_200201_e() == null ? StatCollector.translateToLocal("dragon.unnamed") : StatCollector.translateToLocal("dragon.name") + " " + dragon.func_200201_e().getString();
            font.func_238421_b_(matrixStack, s3, (float)(k + this.field_146999_f / 2 - font.func_78256_a(s3) / 2), (float)(l + 75), 0xFFFFFF);
            String s2 = StatCollector.translateToLocal("dragon.health") + " " + Math.floor(Math.min(dragon.func_110143_aJ(), dragon.func_110138_aP())) + " / " + dragon.func_110138_aP();
            font.func_238421_b_(matrixStack, s2, (float)(k + this.field_146999_f / 2 - font.func_78256_a(s2) / 2), (float)(l + 84), 0xFFFFFF);
            String s5 = StatCollector.translateToLocal("dragon.gender") + StatCollector.translateToLocal(dragon.isMale() ? "dragon.gender.male" : "dragon.gender.female");
            font.func_238421_b_(matrixStack, s5, (float)(k + this.field_146999_f / 2 - font.func_78256_a(s5) / 2), (float)(l + 93), 0xFFFFFF);
            String s6 = StatCollector.translateToLocal("dragon.hunger") + dragon.getHunger() + "/100";
            font.func_238421_b_(matrixStack, s6, (float)(k + this.field_146999_f / 2 - font.func_78256_a(s6) / 2), (float)(l + 102), 0xFFFFFF);
            String s4 = StatCollector.translateToLocal("dragon.stage") + " " + dragon.getDragonStage() + " " + StatCollector.translateToLocal("dragon.days.front") + dragon.getAgeInDays() + " " + StatCollector.translateToLocal("dragon.days.back");
            font.func_238421_b_(matrixStack, s4, (float)(k + this.field_146999_f / 2 - font.func_78256_a(s4) / 2), (float)(l + 111), 0xFFFFFF);
            String s7 = dragon.func_70902_q() != null ? StatCollector.translateToLocal("dragon.owner") + dragon.func_70902_q().func_200200_C_().getString() : StatCollector.translateToLocal("dragon.untamed");
            font.func_238421_b_(matrixStack, s7, (float)(k + this.field_146999_f / 2 - font.func_78256_a(s7) / 2), (float)(l + 120), 0xFFFFFF);
        }
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        this.mousePosx = p_230430_2_;
        this.mousePosY = p_230430_3_;
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.func_230459_a_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        int k = (this.field_230708_k_ - this.field_146999_f) / 2;
        int l = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        Entity entity = IceAndFire.PROXY.getReferencedMob();
        if (entity instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)entity;
            float dragonScale = 1.0f / Math.max(1.0E-4f, dragon.func_213355_cm());
            GuiDragon.drawEntityOnScreen(k + 88, l + (int)(0.5f * dragon.flyProgress) + 55, dragonScale * 23.0f, (float)(k + 51) - this.mousePosx, (float)(l + 75 - 50) - this.mousePosY, (LivingEntity)dragon);
        }
        this.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
    }
}

