/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.iceandfire.client.model.ModelDragonBase;
import com.github.alexthe666.iceandfire.client.model.util.EntityModelPartBuilder;
import com.github.alexthe666.iceandfire.client.model.util.HideableModelRenderer;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class ModelDreadQueen
extends ModelDragonBase<EntityDreadQueen> {
    public HideableModelRenderer body;
    public HideableModelRenderer chestplate;
    public HideableModelRenderer head;
    public HideableModelRenderer armRight;
    public HideableModelRenderer legRight;
    public HideableModelRenderer armLeft;
    public HideableModelRenderer legLeft;
    public HideableModelRenderer cloak;
    public HideableModelRenderer necklace;
    public HideableModelRenderer crown;
    public HideableModelRenderer sleeveRight;
    public HideableModelRenderer robeLowerRight;
    public HideableModelRenderer sleeveLeft;
    public HideableModelRenderer robeLowerLeft;
    public BipedModel.ArmPose leftArmPose;
    public BipedModel.ArmPose rightArmPose;
    public boolean isSneak;
    private ModelAnimator animator;
    private boolean armor = false;

    public ModelDreadQueen(float modelSize, boolean armorArms) {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.armor = armorArms;
        this.leftArmPose = BipedModel.ArmPose.EMPTY;
        this.rightArmPose = BipedModel.ArmPose.EMPTY;
        this.body = new HideableModelRenderer(this, 16, 16);
        this.body.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 0.0f);
        this.crown = new HideableModelRenderer(this, 58, 0);
        this.crown.func_78793_a(0.0f, 1.0f, 0.0f);
        this.crown.func_228301_a_(-4.5f, -12.5f, -4.5f, 9.0f, 13.0f, 9.0f, 0.0f);
        this.legRight = new HideableModelRenderer(this, 0, 16);
        this.legRight.func_78793_a(-1.9f, 12.0f, 0.1f);
        this.legRight.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f);
        this.sleeveLeft = new HideableModelRenderer(this, 36, 33);
        this.sleeveLeft.field_78809_i = true;
        this.sleeveLeft.func_78793_a(-0.5f, -0.1f, 0.0f);
        this.sleeveLeft.func_228301_a_(-0.5f, -2.1f, -2.4f, 5.0f, 6.0f, 5.0f, 0.0f);
        this.robeLowerLeft = new HideableModelRenderer(this, 58, 33);
        this.robeLowerLeft.func_78793_a(0.0f, -0.2f, 0.0f);
        this.robeLowerLeft.func_228301_a_(-1.9f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, 0.0f);
        this.chestplate = new HideableModelRenderer(this, 1, 32);
        this.chestplate.func_78793_a(0.0f, 0.1f, 0.0f);
        this.chestplate.func_228301_a_(-4.5f, -0.3f, -2.5f, 9.0f, 12.0f, 5.0f, 0.0f);
        this.robeLowerRight = new HideableModelRenderer(this, 58, 33);
        this.robeLowerRight.field_78809_i = true;
        this.robeLowerRight.func_78793_a(0.0f, -0.2f, 0.0f);
        this.robeLowerRight.func_228301_a_(-2.1f, 0.0f, -2.5f, 4.0f, 7.0f, 5.0f, 0.0f);
        this.sleeveRight = new HideableModelRenderer(this, 36, 33);
        this.sleeveRight.func_78793_a(0.5f, -0.1f, 0.0f);
        this.sleeveRight.func_228301_a_(-4.5f, -2.1f, -2.4f, 5.0f, 6.0f, 5.0f, 0.0f);
        this.cloak = new HideableModelRenderer(this, 81, 37);
        this.cloak.func_78793_a(0.0f, 0.1f, 0.0f);
        this.cloak.func_228301_a_(-4.5f, 0.0f, 2.3f, 9.0f, 21.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.cloak, 0.045553092f, 0.0f, 0.0f);
        this.armRight = new HideableModelRenderer(this, 40, 16);
        this.armRight.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.armRight.func_228301_a_(-2.5f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.armRight, 0.0f, 0.0f, 0.10000736f);
        this.necklace = new HideableModelRenderer(this, 1, 52);
        this.necklace.func_78793_a(0.0f, 0.1f, 0.0f);
        this.necklace.func_228301_a_(-4.5f, -0.3f, -2.8f, 9.0f, 7.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.necklace, 0.03211406f, 0.0f, 0.0f);
        this.armLeft = new HideableModelRenderer(this, 40, 16);
        this.armLeft.field_78809_i = true;
        this.armLeft.func_78793_a(5.0f, 2.0f, -0.0f);
        this.armLeft.func_228301_a_(-0.5f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.armLeft, -0.0f, 0.0f, -0.10000736f);
        this.head = new HideableModelRenderer(this, 0, 0);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f);
        this.legLeft = new HideableModelRenderer(this, 0, 16);
        this.legLeft.field_78809_i = true;
        this.legLeft.func_78793_a(1.9f, 12.0f, 0.1f);
        this.legLeft.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.0f);
        this.head.func_78792_a((ModelRenderer)this.crown);
        this.body.func_78792_a((ModelRenderer)this.legRight);
        this.armLeft.func_78792_a((ModelRenderer)this.sleeveLeft);
        this.legLeft.func_78792_a((ModelRenderer)this.robeLowerLeft);
        this.body.func_78792_a((ModelRenderer)this.chestplate);
        this.legRight.func_78792_a((ModelRenderer)this.robeLowerRight);
        this.armRight.func_78792_a((ModelRenderer)this.sleeveRight);
        this.body.func_78792_a((ModelRenderer)this.cloak);
        this.body.func_78792_a((ModelRenderer)this.armRight);
        this.chestplate.func_78792_a((ModelRenderer)this.necklace);
        this.body.func_78792_a((ModelRenderer)this.armLeft);
        this.body.func_78792_a((ModelRenderer)this.head);
        this.body.func_78792_a((ModelRenderer)this.legLeft);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public void setLivingAnimations(EntityDreadQueen LivingEntityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.rightArmPose = BipedModel.ArmPose.EMPTY;
        this.leftArmPose = BipedModel.ArmPose.EMPTY;
        ItemStack itemstack = LivingEntityIn.func_184586_b(Hand.MAIN_HAND);
        super.func_212843_a_((Entity)LivingEntityIn, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void setRotationAngles(EntityDreadQueen entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, 1.0f);
        ItemStack itemstack = entityIn.func_184614_ca();
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
        float f = 1.0f;
        this.armRight.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.armLeft.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
        this.legRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f;
        this.legLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f;
        this.legRight.field_78796_g = 0.0f;
        this.legLeft.field_78796_g = 0.0f;
        this.legRight.field_78808_h = 0.0f;
        this.legLeft.field_78808_h = 0.0f;
        if (entityIn.func_184218_aH()) {
            this.armRight.field_78795_f += -0.62831855f;
            this.armLeft.field_78795_f += -0.62831855f;
            this.legRight.field_78795_f = -1.4137167f;
            this.legRight.field_78796_g = 0.31415927f;
            this.legRight.field_78808_h = 0.07853982f;
            this.legLeft.field_78795_f = -1.4137167f;
            this.legLeft.field_78796_g = -0.31415927f;
            this.legLeft.field_78808_h = -0.07853982f;
        }
        if (this.field_217112_c > 0.0f) {
            HandSide Handside = this.getMainHand((Entity)entityIn);
            ModelRenderer modelrenderer = this.getArmForSide(Handside);
            float f1 = this.field_217112_c;
            this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (Handside == HandSide.LEFT) {
                this.body.field_78796_g *= -1.0f;
            }
            this.armRight.field_78798_e = MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.armRight.field_78800_c = -MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.armLeft.field_78798_e = -MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.armLeft.field_78800_c = MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.armRight.field_78796_g += this.body.field_78796_g;
            this.armLeft.field_78796_g += this.body.field_78796_g;
            this.armLeft.field_78795_f += this.body.field_78796_g;
            f1 = 1.0f - this.field_217112_c;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
            float f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f2 * 1.2 + (double)f3));
            modelrenderer.field_78796_g += this.body.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.body.field_78795_f = 0.5f;
            this.armRight.field_78795_f += 0.4f;
            this.armLeft.field_78795_f += 0.4f;
            this.legRight.field_78798_e = 4.0f;
            this.legLeft.field_78798_e = 4.0f;
            this.legRight.field_78797_d = 9.0f;
            this.legLeft.field_78797_d = 9.0f;
            this.head.field_78797_d = 1.0f;
        } else {
            this.body.field_78795_f = 0.0f;
            this.legRight.field_78798_e = 0.1f;
            this.legLeft.field_78798_e = 0.1f;
            this.legRight.field_78797_d = 12.0f;
            this.legLeft.field_78797_d = 12.0f;
            this.head.field_78797_d = 0.0f;
        }
        this.armRight.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeft.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armRight.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        this.armLeft.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
        float speed_walk = 0.6f;
        float speed_idle = 0.05f;
        float degree_walk = 1.0f;
        float degree_idle = 0.5f;
        if (entityIn.getAnimation() == EntityDreadQueen.ANIMATION_SPAWN && entityIn.getAnimationTick() < 30) {
            this.flap(this.armRight, 0.5f, 0.5f, false, 2.0f, -0.7f, entityIn.field_70173_aa, 1.0f);
            this.flap(this.armLeft, 0.5f, 0.5f, true, 2.0f, -0.7f, entityIn.field_70173_aa, 1.0f);
            this.walk(this.armRight, 0.5f, 0.5f, true, 1.0f, 0.0f, entityIn.field_70173_aa, 1.0f);
            this.walk(this.armLeft, 0.5f, 0.5f, true, 1.0f, 0.0f, entityIn.field_70173_aa, 1.0f);
        }
    }

    public void animate(IAnimatedEntity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        this.animator.update(entity);
        this.animator.setAnimation(EntityDreadQueen.ANIMATION_SPAWN);
        this.animator.startKeyframe(0);
        this.animator.move((AdvancedModelBox)this.body, 0.0f, 35.0f, 0.0f);
        this.rotate(this.animator, this.armLeft, -180.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.armRight, -180.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(30);
        this.animator.move((AdvancedModelBox)this.body, 0.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.armLeft, -180.0f, 0.0f, 0.0f);
        this.rotate(this.animator, this.armRight, -180.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.armLeft : this.armRight;
    }

    protected HandSide getMainHand(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entityIn;
            HandSide Handside = LivingEntity2.func_184591_cq();
            return LivingEntity2.field_184622_au == Hand.MAIN_HAND ? Handside : Handside.func_188468_a();
        }
        return HandSide.RIGHT;
    }

    public void setVisible(boolean visible) {
        this.head.invisible = !visible;
        this.body.invisible = !visible;
        this.armRight.invisible = !visible;
        this.armLeft.invisible = !visible;
        this.legRight.invisible = !visible;
        this.legLeft.invisible = !visible;
    }

    @Override
    public void renderStatue(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, Entity living) {
        this.resetToDefaultPose();
        this.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.resetToDefaultPose();
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)((Object)this.body));
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return EntityModelPartBuilder.getAllPartsFromClass(this.getClass(), this.getClass().getName());
    }
}

