/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.client.model.ModelAmphithere;
import com.github.alexthe666.iceandfire.client.model.ModelCockatrice;
import com.github.alexthe666.iceandfire.client.model.ModelCyclops;
import com.github.alexthe666.iceandfire.client.model.ModelHippogryph;
import com.github.alexthe666.iceandfire.client.model.ModelHydraHead;
import com.github.alexthe666.iceandfire.client.model.ModelStymphalianBird;
import com.github.alexthe666.iceandfire.client.model.ModelTroll;
import com.github.alexthe666.iceandfire.entity.EntityMobSkull;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderMobSkull
extends EntityRenderer<EntityMobSkull> {
    private static final Map<String, ResourceLocation> SKULL_TEXTURE_CACHE = Maps.newHashMap();
    private ModelHippogryph hippogryphModel = new ModelHippogryph();
    private ModelCyclops cyclopsModel = new ModelCyclops();
    private ModelCockatrice cockatriceModel = new ModelCockatrice();
    private ModelStymphalianBird stymphalianBirdModel = new ModelStymphalianBird();
    private ModelTroll trollModel = new ModelTroll();
    private ModelAmphithere amphithereModel = new ModelAmphithere();
    private ModelHydraHead hydraModel;
    private TabulaModel seaSerpentModel;

    public RenderMobSkull(EntityRendererManager renderManager, SegmentedModel seaSerpentModel) {
        super(renderManager);
        this.seaSerpentModel = (TabulaModel)seaSerpentModel;
        this.hydraModel = new ModelHydraHead(0);
    }

    private static void setRotationAngles(ModelRenderer cube, float rotX, float rotY, float rotZ) {
        cube.field_78795_f = rotX;
        cube.field_78796_g = rotY;
        cube.field_78808_h = rotZ;
    }

    public void render(EntityMobSkull entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -180.0f, true));
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, 180.0f - entity.getYaw(), true));
        float f = 0.0625f;
        float size = 1.0f;
        matrixStackIn.func_227862_a_(size, size, size);
        matrixStackIn.func_227861_a_(0.0, entity.isOnWall() ? (double)-0.24f : (double)-0.12f, 0.5);
        this.renderForEnum(entity.getSkullType(), entity.isOnWall(), matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227865_b_();
    }

    private void renderForEnum(EnumSkullType skull, boolean onWall, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getSkullTexture(skull)));
        switch (skull) {
            case HIPPOGRYPH: {
                matrixStackIn.func_227861_a_(0.0, -0.0, (double)-0.2f);
                matrixStackIn.func_227862_a_(1.2f, 1.2f, 1.2f);
                this.hippogryphModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.hippogryphModel.Head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-5.0), 0.0f, 0.0f);
                this.hippogryphModel.Head.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case CYCLOPS: {
                matrixStackIn.func_227861_a_(0.0, (double)1.8f, -0.5);
                matrixStackIn.func_227862_a_(2.25f, 2.25f, 2.25f);
                this.cyclopsModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.cyclopsModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.cyclopsModel.Head.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case COCKATRICE: {
                if (onWall) {
                    matrixStackIn.func_227861_a_(0.0, 0.0, (double)0.35f);
                }
                this.cockatriceModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.cockatriceModel.head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.cockatriceModel.head.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case STYMPHALIAN: {
                if (!onWall) {
                    matrixStackIn.func_227861_a_(0.0, 0.0, (double)-0.35f);
                }
                this.stymphalianBirdModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.stymphalianBirdModel.HeadBase, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.stymphalianBirdModel.HeadBase.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case TROLL: {
                matrixStackIn.func_227861_a_(0.0, 1.0, (double)-0.35f);
                if (onWall) {
                    matrixStackIn.func_227861_a_(0.0, 0.0, (double)0.35f);
                }
                this.trollModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.trollModel.head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-20.0), 0.0f, 0.0f);
                this.trollModel.head.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case AMPHITHERE: {
                matrixStackIn.func_227861_a_(0.0, (double)-0.2f, (double)0.7f);
                matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
                this.amphithereModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.amphithereModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.amphithereModel.Head.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SEASERPENT: {
                matrixStackIn.func_227861_a_(0.0, (double)-0.35f, (double)0.8f);
                matrixStackIn.func_227862_a_(2.5f, 2.5f, 2.5f);
                this.seaSerpentModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.seaSerpentModel.getCube("Head"), onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.seaSerpentModel.getCube("Head").func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case HYDRA: {
                matrixStackIn.func_227861_a_(0.0, (double)-0.2f, (double)-0.1f);
                matrixStackIn.func_227862_a_(2.0f, 2.0f, 2.0f);
                this.hydraModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((ModelRenderer)this.hydraModel.Head1, onWall ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
                this.hydraModel.Head1.func_228309_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public ResourceLocation getEntityTexture(EntityMobSkull entity) {
        return this.getSkullTexture(entity.getSkullType());
    }

    public ResourceLocation getSkullTexture(EnumSkullType skull) {
        String s = "iceandfire:textures/models/skulls/skull_" + skull.name().toLowerCase() + ".png";
        ResourceLocation resourcelocation = SKULL_TEXTURE_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            SKULL_TEXTURE_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

