/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.entity.tile.TileEntityGhostChest;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class RenderGhostChest
extends TileEntityRenderer<TileEntityGhostChest> {
    private static final ResourceLocation GHOST_CHEST = new ResourceLocation("iceandfire:textures/models/ghost/ghost_chest.png");
    private static final ResourceLocation GHOST_CHEST_LEFT = new ResourceLocation("iceandfire:textures/models/ghost/ghost_chest_left.png");
    private static final ResourceLocation GHOST_CHEST_RIGHT = new ResourceLocation("iceandfire:textures/models/ghost/ghost_chest_right.png");
    private final ModelRenderer singleLid;
    private final ModelRenderer singleBottom = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer singleLatch;
    private final ModelRenderer rightLid;
    private final ModelRenderer rightBottom;
    private final ModelRenderer rightLatch;
    private final ModelRenderer leftLid;
    private final ModelRenderer leftBottom;
    private final ModelRenderer leftLatch;

    public RenderGhostChest(TileEntityRendererDispatcher p_i226008_1_) {
        super(p_i226008_1_);
        this.singleBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.singleLid = new ModelRenderer(64, 64, 0, 0);
        this.singleLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.singleLid.field_78797_d = 9.0f;
        this.singleLid.field_78798_e = 1.0f;
        this.singleLatch = new ModelRenderer(64, 64, 0, 0);
        this.singleLatch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.singleLatch.field_78797_d = 8.0f;
        this.rightBottom = new ModelRenderer(64, 64, 0, 19);
        this.rightBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.rightLid = new ModelRenderer(64, 64, 0, 0);
        this.rightLid.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.rightLid.field_78797_d = 9.0f;
        this.rightLid.field_78798_e = 1.0f;
        this.rightLatch = new ModelRenderer(64, 64, 0, 0);
        this.rightLatch.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.rightLatch.field_78797_d = 8.0f;
        this.leftBottom = new ModelRenderer(64, 64, 0, 19);
        this.leftBottom.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.leftLid = new ModelRenderer(64, 64, 0, 0);
        this.leftLid.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.leftLid.field_78797_d = 9.0f;
        this.leftLid.field_78798_e = 1.0f;
        this.leftLatch = new ModelRenderer(64, 64, 0, 0);
        this.leftLatch.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.leftLatch.field_78797_d = 8.0f;
    }

    protected ResourceLocation getMaterial(TileEntityGhostChest tileEntity, ChestType chestType) {
        return RenderGhostChest.getChestMaterial(chestType, GHOST_CHEST, GHOST_CHEST_LEFT, GHOST_CHEST_RIGHT);
    }

    public void render(TileEntityGhostChest tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntityIn.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.func_235901_b_((Property)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((Property)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            matrixStackIn.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper icallbackwrapper = flag ? abstractchestblock.func_225536_a_(blockstate, world, tileEntityIn.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.func_226917_a_((IChestLid)tileEntityIn))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLightIn);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getMaterial(tileEntityIn, chesttype)));
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.renderModels(matrixStackIn, ivertexbuilder, this.leftLid, this.leftLatch, this.leftBottom, f1, i, combinedOverlayIn);
                } else {
                    this.renderModels(matrixStackIn, ivertexbuilder, this.rightLid, this.rightLatch, this.rightBottom, f1, i, combinedOverlayIn);
                }
            } else {
                this.renderModels(matrixStackIn, ivertexbuilder, this.singleLid, this.singleLatch, this.singleBottom, f1, i, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderModels(MatrixStack matrixStackIn, IVertexBuilder bufferIn, ModelRenderer chestLid, ModelRenderer chestLatch, ModelRenderer chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.field_78795_f = chestLid.field_78795_f = -(lidAngle * 1.5707964f);
        chestLid.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestLatch.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        chestBottom.func_228308_a_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    private static ResourceLocation getChestMaterial(ChestType p_228772_0_, ResourceLocation p_228772_1_, ResourceLocation p_228772_2_, ResourceLocation p_228772_3_) {
        switch (p_228772_0_) {
            case LEFT: {
                return p_228772_2_;
            }
            case RIGHT: {
                return p_228772_3_;
            }
        }
        return p_228772_1_;
    }
}

