/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.config;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.config.DefaultBiomes;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class BiomeConfig {
    public static List<? extends String> overworldSpawnBiomes = Lists.newArrayList((Object[])DefaultBiomes.OVERWORLD_BIOMES);
    public static List<? extends String> oreGenBiomes = Lists.newArrayList((Object[])DefaultBiomes.OVERWORLD_BIOMES);
    public static List<? extends String> sapphireBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_SNOWY);
    public static List<? extends String> amethystBiomes = Lists.newArrayList((Object[])DefaultBiomes.SAVANNAS);
    public static List<? extends String> fireLilyBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_HOT);
    public static List<? extends String> iceLilyBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_SNOWY);
    public static List<? extends String> lightningLilyBiomes = Lists.newArrayList((Object[])DefaultBiomes.SAVANNAS);
    public static List<? extends String> fireDragonBiomes = Lists.newArrayList((Object[])DefaultBiomes.FIREDRAGON_ROOST);
    public static List<? extends String> iceDragonBiomes = Lists.newArrayList((Object[])DefaultBiomes.ICEDRAGON_ROOST);
    public static List<? extends String> lightningDragonBiomes = Lists.newArrayList((Object[])DefaultBiomes.LIGHTNING_ROOSTS);
    public static List<? extends String> gorgonTempleBiomes = Lists.newArrayList((Object[])DefaultBiomes.BEACHES);
    public static List<? extends String> cyclopsCaveBiomes = Lists.newArrayList((Object[])DefaultBiomes.BEACHES);
    public static List<? extends String> hippogryphBiomes = Lists.newArrayList((Object[])DefaultBiomes.HILLS);
    public static List<? extends String> pixieBiomes = Lists.newArrayList((Object[])DefaultBiomes.PIXIES);
    public static List<? extends String> hippocampusBiomes = Lists.newArrayList((Object[])DefaultBiomes.OCEANS);
    public static List<? extends String> seaSerpentBiomes = Lists.newArrayList((Object[])DefaultBiomes.OCEANS);
    public static List<? extends String> sirenBiomes = Lists.newArrayList((Object[])DefaultBiomes.OCEANS);
    public static List<? extends String> amphithereBiomes = Lists.newArrayList((Object[])DefaultBiomes.JUNGLE);
    public static List<? extends String> desertMyrmexBiomes = Lists.newArrayList((Object[])DefaultBiomes.DESERT);
    public static List<? extends String> jungleMyrmexBiomes = Lists.newArrayList((Object[])DefaultBiomes.JUNGLE);
    public static List<? extends String> snowyTrollBiomes = Lists.newArrayList((Object[])DefaultBiomes.SNOWY);
    public static List<? extends String> forestTrollBiomes = Lists.newArrayList((Object[])DefaultBiomes.WOODLAND);
    public static List<? extends String> mountainTrollBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_HILLY);
    public static List<? extends String> stymphalianBiomes = Lists.newArrayList((Object[])DefaultBiomes.SWAMPS);
    public static List<? extends String> hydraBiomes = Lists.newArrayList((Object[])DefaultBiomes.SWAMPS);
    public static List<? extends String> mausoleumBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_SNOWY);
    public static List<? extends String> graveyardBiomes = Lists.newArrayList((Object[])DefaultBiomes.GRAVEYARD_BIOMES);
    public static List<? extends String> cockatriceBiomes = Lists.newArrayList((Object[])DefaultBiomes.SAVANNAS);
    public static List<? extends String> deathwormBiomes = Lists.newArrayList((Object[])DefaultBiomes.DESERT);
    public static List<? extends String> wanderingCyclopsBiomes = Lists.newArrayList((Object[])DefaultBiomes.PLAINS);
    public static List<? extends String> lightningDragonSkeletonBiomes = Lists.newArrayList((Object[])DefaultBiomes.SAVANNAS);
    public static List<? extends String> fireDragonSkeletonBiomes = Lists.newArrayList((Object[])DefaultBiomes.DESERT);
    public static List<? extends String> iceDragonSkeletonBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_SNOWY);
    public static List<? extends String> blackHippogryphBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:desert_hills"});
    public static List<? extends String> brownHippogryphBiomes = Lists.newArrayList((Object[])DefaultBiomes.VERY_HILLY);
    public static List<? extends String> grayHippogryphBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:dark_forest_hills"});
    public static List<? extends String> chestnutHippogryphBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:wooded_mountains"});
    public static List<? extends String> creamyHippogryphBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:savanna_plateau"});
    public static List<? extends String> darkBrownHippogryphBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:taiga_mountains", "minecraft:taiga_hills"});
    public static List<? extends String> whiteHippogryphBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:snowy_mountains", "minecraft:snowy_taiga_mountains", "minecraft:snowy_taiga_hills"});
    public static Map<String, ForgeConfigSpec.ConfigValue<List<? extends String>>> biomeConfigValues = new HashMap<String, ForgeConfigSpec.ConfigValue<List<? extends String>>>();

    public BiomeConfig(ForgeConfigSpec.Builder builder) {
        builder.push("biome_configs");
        try {
            for (Field f : BiomeConfig.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof List)) continue;
                biomeConfigValues.putIfAbsent(f.getName(), (ForgeConfigSpec.ConfigValue<List<? extends String>>)builder.comment("biome list").defineList(f.getName(), (List)obj, o -> o instanceof String));
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Encountered error building iceandfire-biomes.toml");
            e.printStackTrace();
        }
    }

    public static void bake(ModConfig config) {
        try {
            for (Field f : BiomeConfig.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof List)) continue;
                ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = biomeConfigValues.get(f.getName());
                if (config == null) continue;
                f.set(null, configValue.get());
            }
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Encountered error building iceandfire-biomes.toml");
            e.printStackTrace();
        }
    }
}

