/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public final ForgeConfigSpec.BooleanValue generateSilverOre;
    public final ForgeConfigSpec.BooleanValue generateCopperOre;
    public final ForgeConfigSpec.BooleanValue generateSapphireOre;
    public final ForgeConfigSpec.BooleanValue generateAmythestOre;
    public final ForgeConfigSpec.BooleanValue generateDragonSkeletons;
    public final ForgeConfigSpec.IntValue generateDragonSkeletonChance;
    public final ForgeConfigSpec.BooleanValue generateDragonDens;
    public final ForgeConfigSpec.IntValue generateDragonDenChance;
    public final ForgeConfigSpec.BooleanValue generateDragonRoosts;
    public final ForgeConfigSpec.IntValue generateDragonRoostChance;
    public final ForgeConfigSpec.IntValue dragonDenGoldAmount;
    public final ForgeConfigSpec.BooleanValue spawnGlaciers;
    public final ForgeConfigSpec.IntValue glacierSpawnChance;
    public final ForgeConfigSpec.IntValue oreToStoneRatioForDragonCaves;
    public final ForgeConfigSpec.IntValue dragonEggTime;
    public final ForgeConfigSpec.IntValue dragonGriefing;
    public final ForgeConfigSpec.BooleanValue tamedDragonGriefing;
    public final ForgeConfigSpec.IntValue dragonFlapNoiseDistance;
    public final ForgeConfigSpec.IntValue dragonFluteDistance;
    public final ForgeConfigSpec.DoubleValue dragonHealth;
    public final ForgeConfigSpec.IntValue dragonAttackDamage;
    public final ForgeConfigSpec.DoubleValue dragonAttackDamageFire;
    public final ForgeConfigSpec.DoubleValue dragonAttackDamageIce;
    public final ForgeConfigSpec.DoubleValue dragonAttackDamageLightning;
    public final ForgeConfigSpec.IntValue maxDragonFlight;
    public final ForgeConfigSpec.IntValue dragonGoldSearchLength;
    public final ForgeConfigSpec.BooleanValue canDragonsDespawn;
    public final ForgeConfigSpec.BooleanValue doDragonsSleep;
    public final ForgeConfigSpec.BooleanValue dragonDigWhenStuck;
    public final ForgeConfigSpec.IntValue dragonBreakBlockCooldown;
    public final ForgeConfigSpec.BooleanValue dragonDropSkull;
    public final ForgeConfigSpec.BooleanValue dragonDropHeart;
    public final ForgeConfigSpec.BooleanValue dragonDropBlood;
    public final ForgeConfigSpec.IntValue dragonTargetSearchLength;
    public final ForgeConfigSpec.IntValue dragonWanderFromHomeDistance;
    public final ForgeConfigSpec.IntValue dragonHungerTickRate;
    public final ForgeConfigSpec.BooleanValue spawnHippogryphs;
    public final ForgeConfigSpec.IntValue hippogryphSpawnRate;
    public final ForgeConfigSpec.BooleanValue spawnGorgons;
    public final ForgeConfigSpec.IntValue spawnGorgonsChance;
    public final ForgeConfigSpec.DoubleValue gorgonMaxHealth;
    public final ForgeConfigSpec.BooleanValue spawnPixies;
    public final ForgeConfigSpec.IntValue spawnPixiesChance;
    public final ForgeConfigSpec.IntValue pixieVillageSize;
    public final ForgeConfigSpec.BooleanValue pixiesStealItems;
    public final ForgeConfigSpec.BooleanValue generateCyclopsCaves;
    public final ForgeConfigSpec.BooleanValue generateWanderingCyclops;
    public final ForgeConfigSpec.IntValue spawnWanderingCyclopsChance;
    public final ForgeConfigSpec.IntValue spawnCyclopsCaveChance;
    public final ForgeConfigSpec.IntValue cyclopesSheepSearchLength;
    public final ForgeConfigSpec.DoubleValue cyclopsMaxHealth;
    public final ForgeConfigSpec.DoubleValue cyclopsAttackStrength;
    public final ForgeConfigSpec.DoubleValue cyclopsBiteStrength;
    public final ForgeConfigSpec.BooleanValue cyclopsGriefing;
    public final ForgeConfigSpec.DoubleValue sirenMaxHealth;
    public final ForgeConfigSpec.BooleanValue generateSirenIslands;
    public final ForgeConfigSpec.BooleanValue sirenShader;
    public final ForgeConfigSpec.IntValue sirenMaxSingTime;
    public final ForgeConfigSpec.IntValue sirenTimeBetweenSongs;
    public final ForgeConfigSpec.IntValue generateSirenChance;
    public final ForgeConfigSpec.BooleanValue spawnHippocampus;
    public final ForgeConfigSpec.IntValue hippocampusSpawnChance;
    public final ForgeConfigSpec.IntValue deathWormTargetSearchLength;
    public final ForgeConfigSpec.DoubleValue deathWormMaxHealth;
    public final ForgeConfigSpec.DoubleValue deathWormAttackStrength;
    public final ForgeConfigSpec.BooleanValue spawnDeathWorm;
    public final ForgeConfigSpec.BooleanValue deathWormAttackMonsters;
    public final ForgeConfigSpec.IntValue deathWormSpawnRate;
    public final ForgeConfigSpec.IntValue deathWormSpawnCheckChance;
    public final ForgeConfigSpec.IntValue cockatriceChickenSearchLength;
    public final ForgeConfigSpec.IntValue cockatriceEggChance;
    public final ForgeConfigSpec.DoubleValue cockatriceMaxHealth;
    public final ForgeConfigSpec.BooleanValue chickensLayRottenEggs;
    public final ForgeConfigSpec.BooleanValue spawnCockatrices;
    public final ForgeConfigSpec.IntValue cockatriceSpawnRate;
    public final ForgeConfigSpec.IntValue cockatriceSpawnCheckChance;
    public final ForgeConfigSpec.IntValue stymphalianBirdTargetSearchLength;
    public final ForgeConfigSpec.IntValue stymphalianBirdFeatherDropChance;
    public final ForgeConfigSpec.DoubleValue stymphalianBirdFeatherAttackStength;
    public final ForgeConfigSpec.IntValue stymphalianBirdFlockLength;
    public final ForgeConfigSpec.IntValue stymphalianBirdFlightHeight;
    public final ForgeConfigSpec.BooleanValue spawnStymphalianBirds;
    public final ForgeConfigSpec.BooleanValue stymphalianBirdsDataTagDrops;
    public final ForgeConfigSpec.BooleanValue stympahlianBirdAttackAnimals;
    public final ForgeConfigSpec.IntValue stymphalianBirdSpawnChance;
    public final ForgeConfigSpec.BooleanValue spawnTrolls;
    public final ForgeConfigSpec.IntValue trollSpawnRate;
    public final ForgeConfigSpec.IntValue trollSpawnCheckChance;
    public final ForgeConfigSpec.BooleanValue trollsDropWeapon;
    public final ForgeConfigSpec.DoubleValue trollMaxHealth;
    public final ForgeConfigSpec.DoubleValue trollAttackStrength;
    public final ForgeConfigSpec.BooleanValue villagersFearDragons;
    public final ForgeConfigSpec.BooleanValue animalsFearDragons;
    public final ForgeConfigSpec.BooleanValue generateMyrmexColonies;
    public final ForgeConfigSpec.IntValue myrmexPregnantTicks;
    public final ForgeConfigSpec.IntValue myrmexEggTicks;
    public final ForgeConfigSpec.IntValue myrmexLarvaTicks;
    public final ForgeConfigSpec.IntValue myrmexColonyGenChance;
    public final ForgeConfigSpec.IntValue myrmexColonySize;
    public final ForgeConfigSpec.DoubleValue myrmexBaseAttackStrength;
    public final ForgeConfigSpec.BooleanValue experimentalPathFinder;
    public final ForgeConfigSpec.BooleanValue spawnAmphitheres;
    public final ForgeConfigSpec.IntValue amphithereSpawnRate;
    public final ForgeConfigSpec.IntValue amphithereVillagerSearchLength;
    public final ForgeConfigSpec.IntValue amphithereTameTime;
    public final ForgeConfigSpec.DoubleValue amphithereFlightSpeed;
    public final ForgeConfigSpec.DoubleValue amphithereMaxHealth;
    public final ForgeConfigSpec.DoubleValue amphithereAttackStrength;
    public final ForgeConfigSpec.BooleanValue spawnSeaSerpents;
    public final ForgeConfigSpec.IntValue seaSerpentSpawnChance;
    public final ForgeConfigSpec.BooleanValue seaSerpentGriefing;
    public final ForgeConfigSpec.DoubleValue seaSerpentBaseHealth;
    public final ForgeConfigSpec.DoubleValue seaSerpentAttackStrength;
    public final ForgeConfigSpec.DoubleValue dragonsteelBaseDamage;
    public final ForgeConfigSpec.IntValue dragonsteelBaseArmor;
    public final ForgeConfigSpec.IntValue dragonsteelBaseDurability;
    public final ForgeConfigSpec.BooleanValue dragonMovedWronglyFix;
    public final ForgeConfigSpec.BooleanValue weezerTinkers;
    public final ForgeConfigSpec.DoubleValue dragonBlockBreakingDropChance;
    public final ForgeConfigSpec.BooleanValue completeDragonPathfinding;
    public final ForgeConfigSpec.BooleanValue generateMausoleums;
    public final ForgeConfigSpec.IntValue generateMausoleumChance;
    public final ForgeConfigSpec.BooleanValue spawnLiches;
    public final ForgeConfigSpec.IntValue lichSpawnRate;
    public final ForgeConfigSpec.DoubleValue hydraMaxHealth;
    public final ForgeConfigSpec.BooleanValue generateHydraCaves;
    public final ForgeConfigSpec.IntValue generateHydraChance;
    public final ForgeConfigSpec.BooleanValue explosiveDragonBreath;
    public final ForgeConfigSpec.DoubleValue weezerTinkersDisarmChance;
    public final ForgeConfigSpec.BooleanValue chunkLoadSummonCrystal;
    public ForgeConfigSpec.IntValue dangerousWorldGenDistanceLimit;
    public ForgeConfigSpec.IntValue dangerousWorldGenSeparationLimit;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedBreakBlocks;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> noDropBreakBlocks;
    public final ForgeConfigSpec.BooleanValue useDimensionBlackList;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistDimensions;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> whitelistDimensions;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> dragonBlacklistDimensions;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> dragonWhitelistDimensions;
    public final ForgeConfigSpec.DoubleValue dragonFlightSpeedMod;
    public final ForgeConfigSpec.DoubleValue ghostMaxHealth;
    public final ForgeConfigSpec.DoubleValue ghostAttackStrength;
    public final ForgeConfigSpec.BooleanValue generateGraveyards;
    public final ForgeConfigSpec.IntValue generateGraveyardChance;
    public final ForgeConfigSpec.BooleanValue ghostSpawnFromPlayerDeaths;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.blacklistedBreakBlocks = builder.comment("Blocks that a dragon cannot break. Use the format like \"minecraft:chest\" or \"rats:block_of_cheese\" ").defineList("blacklistedBreakBlocks", (List)Lists.newArrayList(), o -> o instanceof String);
        this.noDropBreakBlocks = builder.comment("Blocks that a dragon can break, but won't spawn drops for. Use the format like \"minecraft:stone\" or \"rats:block_of_cheese\" ").defineList("noDropBreakBlocks", (List)Lists.newArrayList((Object[])new String[]{"minecraft:stone", "minecraft:dirt", "minecraft:grass_block"}), o -> o instanceof String);
        this.generateSilverOre = ServerConfig.buildBoolean(builder, "Generate Silver Ore", "all", true, "Whether to generate silver ore or not");
        this.useDimensionBlackList = ServerConfig.buildBoolean(builder, "Use Dimension Blacklist", "all", false, "True if using blacklists, false if using whitelists for dragons and structure gen.");
        this.blacklistDimensions = builder.comment("Blacklisted structure gen dimensions. Use the format like \"minecraft:the_nether\" or \"rats:ratlantis\" ").defineList("blacklistDimensions", (List)Lists.newArrayList((Object[])new String[]{"minecraft:the_nether", "minecraft:the_end"}), o -> o instanceof String);
        this.whitelistDimensions = builder.comment("Whitelist structure gen dimensions. Use the format like \"minecraft:the_nether\" or \"rats:ratlantis\" ").defineList("blacklistDimensions", (List)Lists.newArrayList((Object[])new String[]{"minecraft:overworld"}), o -> o instanceof String);
        this.dragonBlacklistDimensions = builder.comment("Blacklisted structure gen dimensions. Use the format like \"minecraft:the_nether\" or \"rats:ratlantis\" ").defineList("blacklistDimensions", (List)Lists.newArrayList((Object[])new String[]{"minecraft:the_nether", "minecraft:the_end"}), o -> o instanceof String);
        this.dragonWhitelistDimensions = builder.comment("Whitelist structure gen dimensions. Use the format like \"minecraft:the_nether\" or \"rats:ratlantis\" ").defineList("blacklistDimensions", (List)Lists.newArrayList((Object[])new String[]{"minecraft:overworld"}), o -> o instanceof String);
        this.generateCopperOre = ServerConfig.buildBoolean(builder, "Generate Copper Ore", "all", true, "Whether to generate copper ore or not");
        this.generateSapphireOre = ServerConfig.buildBoolean(builder, "Generate Sapphire Ore", "all", true, "Whether to generate sapphire ore or not");
        this.generateAmythestOre = ServerConfig.buildBoolean(builder, "Generate Amethyst Ore", "all", true, "Whether to generate amethyst ore or not");
        this.generateDragonSkeletons = ServerConfig.buildBoolean(builder, "Generate Dragon Skeletons", "all", true, "Whether to generate dragon skeletons or not");
        this.generateDragonSkeletonChance = ServerConfig.buildInt(builder, "Generate Dragon Skeleton Chance", "all", 300, 1, 10000, "1 out of this number chance per chunk for generation");
        this.generateDragonDens = ServerConfig.buildBoolean(builder, "Generate Dragon Caves", "all", true, "Whether to generate dragon caves or not");
        this.generateDragonDenChance = ServerConfig.buildInt(builder, "Generate Dragon Cave Chance", "all", 180, 1, 10000, "1 out of this number chance per chunk for generation");
        this.generateDragonRoosts = ServerConfig.buildBoolean(builder, "Generate Dragon Roosts", "all", true, "Whether to generate dragon roosts or not");
        this.generateDragonRoostChance = ServerConfig.buildInt(builder, "Generate Dragon Roost Chance", "all", 360, 1, 10000, "1 out of this number chance per chunk for generation");
        this.dragonDenGoldAmount = ServerConfig.buildInt(builder, "Dragon Den Gold Amount", "all", 4, 1, 10000, "1 out of this number chance per block that gold will generate in dragon lairs.");
        this.spawnGlaciers = ServerConfig.buildBoolean(builder, "Generate Glaciers", "all", true, "Whether to generate glacier biomes or not");
        this.glacierSpawnChance = ServerConfig.buildInt(builder, "Glacier Spawn Weight", "all", 4, 1, 10000, "Glacier Spawn Weight. Higher number = more common");
        this.oreToStoneRatioForDragonCaves = ServerConfig.buildInt(builder, "Dragon Cave Ore Ratio", "all", 45, 1, 10000, "Ratio of Stone(this number) to Ores in Dragon Caves");
        this.dragonBlockBreakingDropChance = ServerConfig.buildDouble(builder, "Dragon Block Breaking Drop Chance", "all", 0.1f, 0.0, 1.0, "The percentage chance for a block to drop as an item when a dragon breaks it.");
        this.dragonEggTime = ServerConfig.buildInt(builder, "Dragon Egg Hatch Time", "all", 7200, 1, Integer.MAX_VALUE, "How long it takes(in ticks) for a dragon egg to hatch");
        this.dragonGriefing = ServerConfig.buildInt(builder, "Dragon Griefing", "all", 0, 0, 2, "Dragon griefing - 2 is no griefing, 1 is breaking weak blocks, 0 is default");
        this.tamedDragonGriefing = ServerConfig.buildBoolean(builder, "Tamed Dragon Griefing", "all", true, "True if tamed dragons can follow the griefing rules.");
        this.dragonFlapNoiseDistance = ServerConfig.buildInt(builder, "Dragon Flap Noise Distance", "all", 4, 0, 10000, "Dragon Flap Noise Distance - Larger number, further away you can hear it");
        this.dragonFluteDistance = ServerConfig.buildInt(builder, "Dragon Flute Distance", "all", 4, 0, 10000, "Dragon Flute Distance - how many chunks away is the dragon flute effective?");
        this.dragonHealth = ServerConfig.buildDouble(builder, "Dragon Health", "all", 500.0, 1.0, 100000.0, "Max dragon health. Health is scaled to this");
        this.dragonAttackDamage = ServerConfig.buildInt(builder, "Dragon Attack Damage", "all", 17, 1, 10000, "Max dragon attack damage. Attack Damage is scaled to this");
        this.dragonAttackDamageFire = ServerConfig.buildDouble(builder, "Dragon Attack Damage(Fire breath)", "all", 2.0, 0.0, 10000.0, "Damage dealt from a successful fire breath attack. Attack Damage is scaled to by age, so a stage 5 dragon will deal 5x as much as this number");
        this.dragonAttackDamageIce = ServerConfig.buildDouble(builder, "Dragon Attack Damage(Ice breath)", "all", 2.5, 0.0, 10000.0, "Damage dealt from a successful ice breath attack. Attack Damage is scaled to by age, so a stage 5 dragon will deal 5x as much as this number");
        this.dragonAttackDamageLightning = ServerConfig.buildDouble(builder, "Dragon Attack Damage(Lightning breath)", "all", 3.5, 0.0, 10000.0, "Damage dealt from a successful lightning breath attack. Attack Damage is scaled to by age, so a stage 5 dragon will deal 5x as much as this number");
        this.maxDragonFlight = ServerConfig.buildInt(builder, "Max Dragon Flight Height", "all", 128, 100, Integer.MAX_VALUE, "How high dragons can fly, in Y height.");
        this.dragonGoldSearchLength = ServerConfig.buildInt(builder, "Dragon Gold Search Length", "all", 30, 0, 10000, "How far away dragons will detect gold blocks being destroyed or chests being opened");
        this.canDragonsDespawn = ServerConfig.buildBoolean(builder, "Dragons Despawn", "all", true, "True if dragons can despawn. Note that if this is false there may be SERIOUS lag issues.");
        this.doDragonsSleep = ServerConfig.buildBoolean(builder, "Tamed Dragons Sleep", "all", true, "True if tamed dragons go to sleep at night.");
        this.dragonDigWhenStuck = ServerConfig.buildBoolean(builder, "Dragons Dig When Stuck", "all", true, "True if dragons can break blocks if they get stuck. Turn this off if your dragons randomly explode.");
        this.dragonDropSkull = ServerConfig.buildBoolean(builder, "Dragons Drop Skull", "all", true, "True if dragons can drop their skull on death.");
        this.dragonDropHeart = ServerConfig.buildBoolean(builder, "Dragons Drop Heart", "all", true, "True if dragons can drop their heart on death.");
        this.dragonDropBlood = ServerConfig.buildBoolean(builder, "Dragons Drop Blood", "all", true, "True if dragons can drop their blood on death.");
        this.explosiveDragonBreath = ServerConfig.buildBoolean(builder, "Explosive Dragon Breath", "all", false, "True if dragons fire/ice charges create secondary explosions that launch blocks everywhere. Turn this to true if you like unfair explosions. Or lag.");
        this.dragonTargetSearchLength = ServerConfig.buildInt(builder, "Dragon Target Search Length", "all", 128, 1, 10000, "How many blocks away can dragons spot potential prey. Note that increasing this could cause lag.");
        this.dragonWanderFromHomeDistance = ServerConfig.buildInt(builder, "Dragon Wander From Home Distance", "all", 40, 1, 10000, "How many blocks away can dragons wander from their defined \"home\" position.");
        this.dragonHungerTickRate = ServerConfig.buildInt(builder, "Dragon Hunger Tick Rate", "all", 3000, 1, 10000, "Every interval of this number in ticks, dragon hunger decreases.");
        this.dragonBreakBlockCooldown = ServerConfig.buildInt(builder, "Dragon Block Break Cooldown", "all", 5, 0, 10000, "Every interval of this number in ticks, dragon allowed to break blocks.");
        this.villagersFearDragons = ServerConfig.buildBoolean(builder, "Villagers Fear Dragons", "all", true, "True if villagers should run away and hide from dragons and other hostile Ice and Fire mobs.");
        this.animalsFearDragons = ServerConfig.buildBoolean(builder, "Animals Fear Dragons", "all", true, "True if animals should run away and hide from dragons and other hostile Ice and Fire mobs.");
        this.completeDragonPathfinding = ServerConfig.buildBoolean(builder, "Intelligent Dragon Pathfinding", "all", false, "A more intelligent dragon pathfinding system, but is also laggier. Turn this on if you think dragons are too stupid.");
        this.spawnHippogryphs = ServerConfig.buildBoolean(builder, "Spawn Hippogryphs", "all", true, "True if hippogryphs are allowed to spawn");
        this.hippogryphSpawnRate = ServerConfig.buildInt(builder, "Hippogryph Spawn Weight", "all", 2, 1, 10000, "Hippogryph spawn weight. Lower = lower chance to spawn.");
        this.spawnGorgons = ServerConfig.buildBoolean(builder, "Spawn Gorgons", "all", true, "True if gorgon temples are allowed to spawn");
        this.spawnGorgonsChance = ServerConfig.buildInt(builder, "Spawn Gorgon Chance", "all", 75, 1, 10000, "1 out of this number chance per chunk for generation");
        this.gorgonMaxHealth = ServerConfig.buildDouble(builder, "Gorgon Max Health", "all", 100.0, 1.0, 10000.0, "Maximum gorgon health");
        this.spawnPixies = ServerConfig.buildBoolean(builder, "Spawn Pixies", "all", true, "True if pixie villages are allowed to spawn");
        this.spawnPixiesChance = ServerConfig.buildInt(builder, "Spawn Pixies Chance", "all", 60, 1, 10000, "1 out of this number chance per chunk for generation");
        this.pixieVillageSize = ServerConfig.buildInt(builder, "Pixie Village Size", "all", 5, 1, 10000, "size of pixie villages");
        this.pixiesStealItems = ServerConfig.buildBoolean(builder, "Pixies Steal Items", "all", true, "True if pixies are allowed to steal from players");
        this.generateCyclopsCaves = ServerConfig.buildBoolean(builder, "Spawn Cyclopes Caves", "all", true, "True if cyclops caves are allowed to spawn");
        this.spawnCyclopsCaveChance = ServerConfig.buildInt(builder, "Spawn Cyclops Cave Chance", "all", 170, 1, 10000, "1 out of this number chance per chunk for generation");
        this.generateWanderingCyclops = ServerConfig.buildBoolean(builder, "Spawn Wandering Cyclopes", "all", true, "True if wandering cyclopes are allowed to spawn");
        this.spawnWanderingCyclopsChance = ServerConfig.buildInt(builder, "Spawn Wandering Cyclops Chance", "all", 900, 1, 10000, "1 out of this number chance per chunk for generation");
        this.cyclopsMaxHealth = ServerConfig.buildDouble(builder, "Cyclops Max Health", "all", 150.0, 1.0, 10000.0, "Maximum cyclops health");
        this.cyclopesSheepSearchLength = ServerConfig.buildInt(builder, "Cyclopes Sheep Search Length", "all", 17, 1, 10000, "How many blocks away can cyclopes detect sheep. Note that increasing this could cause lag.");
        this.cyclopsAttackStrength = ServerConfig.buildDouble(builder, "Cyclops Attack Strength", "all", 15.0, 1.0, 10000.0, "Cyclops attack strength");
        this.cyclopsBiteStrength = ServerConfig.buildDouble(builder, "Cyclops Bite Strength", "all", 40.0, 1.0, 10000.0, "Amount of damage done with cyclops bite attack.");
        this.cyclopsGriefing = ServerConfig.buildBoolean(builder, "Cyclops Griefing", "all", true, "Whether or not cyclops can break logs or leaves in their way");
        this.sirenMaxHealth = ServerConfig.buildDouble(builder, "Siren Max Health", "all", 50.0, 1.0, 10000.0, "Maximum siren health");
        this.generateSirenIslands = ServerConfig.buildBoolean(builder, "Spawn Sirens", "all", true, "True if siren islands are allowed to spawn");
        this.sirenShader = ServerConfig.buildBoolean(builder, "Use Siren Shader", "all", true, "True to make the screen pink when sirens attract players");
        this.generateSirenChance = ServerConfig.buildInt(builder, "Spawn Sirens Chance", "all", 400, 1, 10000, "1 out of this number chance per chunk for generation");
        this.sirenMaxSingTime = ServerConfig.buildInt(builder, "Siren Max Sing Time", "all", 12000, 100, 24000, "how long(in ticks) can a siren use its sing effect on a player, without a cooldown.");
        this.sirenTimeBetweenSongs = ServerConfig.buildInt(builder, "Siren Time Between Songs", "all", 2000, 100, 24000, "how long(in ticks) a siren has to wait after failing to lure in a player");
        this.spawnHippocampus = ServerConfig.buildBoolean(builder, "Spawn Hippocampus", "all", true, "True if hippocampi are allowed to spawn");
        this.hippocampusSpawnChance = ServerConfig.buildInt(builder, "Spawn Hippocampus Chance", "all", 40, 1, 10000, "1 out of this number chance per chunk for generation");
        this.deathWormTargetSearchLength = ServerConfig.buildInt(builder, "Death Worm Target Search Length", "all", 64, 1, 10000, "How many blocks away can death worms spot potential prey. Note that increasing this could cause lag");
        this.deathWormMaxHealth = ServerConfig.buildDouble(builder, "Death Worm Base Health", "all", 10.0, 1.0, 10000.0, "Default deathworm health, this is scaled to the worm's particular size");
        this.deathWormAttackStrength = ServerConfig.buildDouble(builder, "Death Worm Base Attack Strength", "all", 3.0, 1.0, 10000.0, "Default deathworm attack strength, this is scaled to the worm's particular size");
        this.spawnDeathWorm = ServerConfig.buildBoolean(builder, "Spawn Death Worms", "all", true, "True if deathworms are allowed to spawn");
        this.deathWormAttackMonsters = ServerConfig.buildBoolean(builder, "Death Worms Target Monsters", "all", true, "True if wild deathworms are allowed to target and attack monsters");
        this.deathWormSpawnRate = ServerConfig.buildInt(builder, "Death Worm Spawn Weight", "all", 30, 1, 10000, "Deathworm spawn weight. Lower = lower chance to spawn");
        this.deathWormSpawnCheckChance = ServerConfig.buildInt(builder, "Death Worm Spawn Check Chance", "all", 3, 0, 10000, "A double check to see if the game can spawn death worms. Higher number = lower chance to spawn.");
        this.cockatriceMaxHealth = ServerConfig.buildDouble(builder, "Cockatrice Health", "all", 40.0, 1.0, 10000.0, "Maximum cockatrice health");
        this.cockatriceChickenSearchLength = ServerConfig.buildInt(builder, "Cockatrice chicken Search Length", "all", 32, 1, 10000, "How many blocks away can cockatrices detect chickens. Note that increasing this could cause lag.");
        this.cockatriceEggChance = ServerConfig.buildInt(builder, "Cockatrice chicken Search Length", "all", 30, 1, Integer.MAX_VALUE, "1 out of this number chance per 6000 ticks for a chicken to lay a cockatrice egg.");
        this.chickensLayRottenEggs = ServerConfig.buildBoolean(builder, "Chickens Lay Rotten Eggs", "all", true, "True if chickens lay rotten eggs.");
        this.spawnCockatrices = ServerConfig.buildBoolean(builder, "Spawn Cockatrices", "all", true, "True if cockatrices are allowed to spawn");
        this.cockatriceSpawnRate = ServerConfig.buildInt(builder, "Cockatrice Spawn Weight", "all", 4, 1, 10000, "Cockatrice spawn weight. Lower = lower chance to spawn");
        this.cockatriceSpawnCheckChance = ServerConfig.buildInt(builder, "Cockatrice Spawn Check Chance", "all", 0, 0, 10000, "A double check to see if the game can spawn cockatrices. Higher number = lower chance to spawn.");
        this.stymphalianBirdTargetSearchLength = ServerConfig.buildInt(builder, "Stymphalian Bird Target Search Length", "all", 64, 1, 10000, "How many blocks away can stymphalian birds spot potential prey. Note that increasing this could cause lag.");
        this.stymphalianBirdFeatherDropChance = ServerConfig.buildInt(builder, "Stymphalian Bird Feather Drop Chance", "all", 25, 0, 10000, "1/this number chance for a stymphalian feather to turn into an item before despawning. Zero means never.");
        this.stymphalianBirdFeatherAttackStength = ServerConfig.buildDouble(builder, "Stymphalian Bird Feather Attack Strength", "all", 1.0, 0.0, 10000.0, "Stymphalian bird feather attack strength.");
        this.stymphalianBirdFlockLength = ServerConfig.buildInt(builder, "Stymphalian Bird Flock Length", "all", 40, 1, 10000, "How far away stymphalian birds will consider other birds to be in the same flock.");
        this.stymphalianBirdFlightHeight = ServerConfig.buildInt(builder, "Max Stymphalian Bird Flight Height", "all", 80, 10, Integer.MAX_VALUE, "How high stymphalian birds can fly, in Y height.");
        this.spawnStymphalianBirds = ServerConfig.buildBoolean(builder, "Spawn Stymphalian Birds", "all", true, "True if stymphalian birds are allowed to spawn");
        this.stymphalianBirdsDataTagDrops = ServerConfig.buildBoolean(builder, "Stymphalian Birds drop ore dict items", "all", true, "True if stymphalian birds can drop items registered in the ore dictionary to ingotCopper, ingotBronze, nuggetCopper, nuggetBronze.");
        this.stympahlianBirdAttackAnimals = ServerConfig.buildBoolean(builder, "Stymphalian Birds Target Animals", "all", false, "True if stymphalian birds are allowed to target and attack animals");
        this.stymphalianBirdSpawnChance = ServerConfig.buildInt(builder, "Spawn Stymhphalian Bird Chance", "all", 80, 1, 10000, "1 out of this number chance per chunk for generation");
        this.spawnTrolls = ServerConfig.buildBoolean(builder, "Spawn Trolls", "all", true, "True if trolls are allowed to spawn");
        this.trollsDropWeapon = ServerConfig.buildBoolean(builder, "Trolls Drop Weapon", "all", true, "True if trolls are allowed to drop their weapon on death.");
        this.trollSpawnRate = ServerConfig.buildInt(builder, "Troll Spawn Weight", "all", 60, 1, 10000, "Troll spawn weight. Lower = lower chance to spawn");
        this.trollSpawnCheckChance = ServerConfig.buildInt(builder, "Troll Spawn Check Chance", "all", 30, 1, 10000, "A double check to see if the game can spawn trolls. Higher number = lower chance to spawn.");
        this.trollMaxHealth = ServerConfig.buildDouble(builder, "Troll Max Health", "all", 50.0, 1.0, 10000.0, "Maximum troll health");
        this.trollAttackStrength = ServerConfig.buildDouble(builder, "Troll Attack Strength", "all", 10.0, 1.0, 10000.0, "Troll attack strength");
        this.generateMyrmexColonies = ServerConfig.buildBoolean(builder, "Spawn Myrmex", "all", true, "True if myrmex colonies are allowed to spawn");
        this.myrmexPregnantTicks = ServerConfig.buildInt(builder, "Myrmex Gestation Length", "all", 2500, 1, 10000, "How many ticks it takes for a Myrmex Queen to produce an egg.");
        this.myrmexEggTicks = ServerConfig.buildInt(builder, "Myrmex Hatch Length", "all", 3000, 1, 10000, "How many ticks it takes for a Myrmex Egg to hatch.");
        this.myrmexLarvaTicks = ServerConfig.buildInt(builder, "Myrmex Hatch Length", "all", 35000, 1, 100000, "How many ticks it takes for a Myrmex to move from a larva to a pupa, and from a pupa to an adult.");
        this.myrmexColonyGenChance = ServerConfig.buildInt(builder, "Myrmex Colony Gen Chance", "all", 150, 1, 10000, "One out of this number chance per chunk to generate a myrmex hive.");
        this.myrmexColonySize = ServerConfig.buildInt(builder, "Myrmex Colony Max Size", "all", 80, 10, 10000, "How many maximum individuals a myrmex colony can have.");
        this.myrmexBaseAttackStrength = ServerConfig.buildDouble(builder, "Myrmex Base Attack Strength", "all", 3.0, 1.0, 10000.0, "Base Myrmex(worker) attack strength");
        this.experimentalPathFinder = ServerConfig.buildBoolean(builder, "Experimental Dragon path Finder", "all", false, "Turning this to true simplifies the dragon's pathfinding process, making them dumber when finding a path, but better for servers with many loaded dragons.");
        this.spawnAmphitheres = ServerConfig.buildBoolean(builder, "Spawn Amphitheres", "all", true, "True if amphitheres are allowed to spawn");
        this.amphithereSpawnRate = ServerConfig.buildInt(builder, "Amphithere Spawn Weight", "all", 50, 1, 10000, "Amphithere spawn weight. Lower = lower chance to spawn");
        this.amphithereVillagerSearchLength = ServerConfig.buildInt(builder, "Amphithere Villager Search Length", "all", 64, 1, 10000, "How many blocks away can ampitheres detect villagers being hurt. Note that increasing this could cause lag.");
        this.amphithereTameTime = ServerConfig.buildInt(builder, "Amphithere Tame Time", "all", 400, 1, 10000, "How many ticks it takes while riding an untamed amphithere to tame it.");
        this.amphithereFlightSpeed = ServerConfig.buildDouble(builder, "Amphithere Flight Speed", "all", 1.75, 0.0, 3.0, "How fast amphitheres fly.");
        this.amphithereMaxHealth = ServerConfig.buildDouble(builder, "Amphithere Max Health", "all", 50.0, 1.0, 10000.0, "Maximum amphithere health");
        this.amphithereAttackStrength = ServerConfig.buildDouble(builder, "Amphithere Attack Strength", "all", 7.0, 1.0, 10000.0, "Amphithere attack strength");
        this.spawnSeaSerpents = ServerConfig.buildBoolean(builder, "Spawn Sea Serpents", "all", true, "True if sea serpents are allowed to spawn");
        this.seaSerpentSpawnChance = ServerConfig.buildInt(builder, "Spawn Sea Serpent Chance", "all", 250, 1, 10000, "1 out of this number chance per chunk for generation");
        this.seaSerpentGriefing = ServerConfig.buildBoolean(builder, "Sea Serpent Griefing", "all", true, "Whether or not sea serpents can break weak blocks in their way");
        this.seaSerpentBaseHealth = ServerConfig.buildDouble(builder, "Sea Serpent Base Health", "all", 20.0, 1.0, 10000.0, "Default sea serpent health, this is scaled to the sea serpent's particular size");
        this.seaSerpentAttackStrength = ServerConfig.buildDouble(builder, "Sea Serpent Base Attack Strength", "all", 4.0, 1.0, 10000.0, "Default sea serpent attack strength, this is scaled to the sea serpent's particular size");
        this.dragonsteelBaseDamage = ServerConfig.buildDouble(builder, "Dragonsteel Sword Base Attack Strength", "all", 25.0, 5.0, 2.147483647E9, "Default attack strength of a dragonsteel sword.");
        this.dragonsteelBaseArmor = ServerConfig.buildInt(builder, "Dragonsteel Base Armor", "all", 12, 7, Integer.MAX_VALUE, "Default armor value of dragonsteel chestplate.");
        this.dragonsteelBaseDurability = ServerConfig.buildInt(builder, "Dragonsteel Base Durability", "all", 8000, 1, Integer.MAX_VALUE, "Default durability value of dragonsteel sword.");
        this.dragonMovedWronglyFix = ServerConfig.buildBoolean(builder, "Dragon Moved Wrongly Error Fix", "all", false, "Enable this if your server is being bombarded with moved wrongly or moved too fast console messages. REQUIRES RESTART!");
        this.weezerTinkers = ServerConfig.buildBoolean(builder, "Weezer", "all", true, "Disable this to remove easter egg with tinkers installed.");
        this.weezerTinkersDisarmChance = ServerConfig.buildDouble(builder, "Easter Egg Tinkers Tool Disarm chance", "all", 0.2f, 0.0, 1.0, "Percentage of critical strike that will disarm with easter egg tinkers material.");
        this.generateMausoleums = ServerConfig.buildBoolean(builder, "Generate Mausoleums", "all", true, "True if mausoleums are allowed to generate");
        this.generateMausoleumChance = ServerConfig.buildInt(builder, "Mausoleum Gen Chance", "all", 1800, 1, 10000, "One out of this number chance per chunk to generate a mausoleum.");
        this.spawnLiches = ServerConfig.buildBoolean(builder, "Spawn Liches", "all", true, "True if dread liches are allowed to spawn");
        this.lichSpawnRate = ServerConfig.buildInt(builder, "Lich Spawn Weight", "all", 2, 1, 10000, "Dread Lich spawn weight. Lower = lower chance to spawn");
        this.hydraMaxHealth = ServerConfig.buildDouble(builder, "Hydra Max Health", "all", 250.0, 1.0, 10000.0, "Maximum hydra health");
        this.generateHydraCaves = ServerConfig.buildBoolean(builder, "Generate Hydra Caves", "all", true, "True if hydra caves are allowed to generate");
        this.generateHydraChance = ServerConfig.buildInt(builder, "Hydra Caves Gen Chance", "all", 120, 1, 10000, "One out of this number chance per chunk to generate a hydra cave.");
        this.chunkLoadSummonCrystal = ServerConfig.buildBoolean(builder, "Chunk Load Summon Crystal", "all", true, "True if the summon crystal can load chunks to find dragons.");
        this.dangerousWorldGenDistanceLimit = ServerConfig.buildInt(builder, "Dangerous World Gen Dist From Spawn", "all", 1000, 1, 10000, "How far away dangerous structures(dragon roosts, cyclops caves, etc.) must be from spawn(0, 0).");
        this.dangerousWorldGenSeparationLimit = ServerConfig.buildInt(builder, "Dangerous World Gen Dist Seperation", "all", 300, 1, 10000, "How far away dangerous structures(dragon roosts, cyclops caves, etc.) must be from the last generated structure.");
        this.dragonFlightSpeedMod = ServerConfig.buildDouble(builder, "Dragon Flight Speed Modifier", "all", 1.0, 0.0, 2.0, "Change this to slow down or speed up dragon or amphithere flight.");
        this.generateGraveyards = ServerConfig.buildBoolean(builder, "Generate Graveyards", "all", true, "Whether to generate graveyards or not");
        this.generateGraveyardChance = ServerConfig.buildInt(builder, "Ghost Max Health", "all", 16, 2, 10000, "Graveyard rarity.");
        this.ghostMaxHealth = ServerConfig.buildDouble(builder, "Ghost Max Health", "all", 30.0, 1.0, 10000.0, "Maximum ghost health.");
        this.ghostAttackStrength = ServerConfig.buildDouble(builder, "Ghost Attack Strength", "all", 3.0, 0.0, 10000.0, "Maximum ghost attack strength.");
        this.ghostSpawnFromPlayerDeaths = ServerConfig.buildBoolean(builder, "Ghost Spawn from PvP deaths", "all", true, "True if ghosts can rarely spawn from brutal PvP deaths.");
    }

    private static ForgeConfigSpec.BooleanValue buildBoolean(ForgeConfigSpec.Builder builder, String name, String catagory, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ForgeConfigSpec.IntValue buildInt(ForgeConfigSpec.Builder builder, String name, String catagory, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ForgeConfigSpec.DoubleValue buildDouble(ForgeConfigSpec.Builder builder, String name, String catagory, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }
}

