/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDeathwormPart;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIFindSandTarget;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIGetInSand;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DeathwormAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.EntityGroundAIRide;
import com.github.alexthe666.iceandfire.entity.ai.IAFLookHelper;
import com.github.alexthe666.iceandfire.entity.util.BlockLaunchExplosion;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IGroundMount;
import com.github.alexthe666.iceandfire.entity.util.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.message.MessageDeathWormHitbox;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDeathWormLand;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDeathWormSand;
import com.google.common.base.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityDeathWorm
extends TameableEntity
implements ISyncMount,
IBlacklistedFromStatues,
IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IPhasesThroughBlock,
IGroundMount {
    public static final ResourceLocation TAN_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_tan");
    public static final ResourceLocation WHITE_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_white");
    public static final ResourceLocation RED_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_red");
    public static final ResourceLocation TAN_GIANT_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_tan_giant");
    public static final ResourceLocation WHITE_GIANT_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_white_giant");
    public static final ResourceLocation RED_GIANT_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_red_giant");
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> WORM_AGE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> HOME = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static Animation ANIMATION_BITE = Animation.create((int)10);
    @OnlyIn(value=Dist.CLIENT)
    public ChainBuffer tail_buffer;
    private int animationTick;
    private boolean willExplode = false;
    private int ticksTillExplosion = 60;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[6];
    private boolean isSandNavigator;
    private float prevScale = 0.0f;
    private LookController lookHelper = new IAFLookHelper((MobEntity)this);
    private int growthCounter = 0;
    private float nextStepDistance;

    public EntityDeathWorm(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70158_ak = true;
        this.field_70138_W = 1.0f;
        if (worldIn.field_72995_K) {
            this.tail_buffer = new ChainBuffer();
        }
        this.switchNavigator(false);
        this.field_70714_bg.func_75776_a(0, new EntityGroundAIRide<EntityDeathWorm>(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new DeathWormAIFindSandTarget(this, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new DeathWormAIGetInSand(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new DeathWormAIWander(this, 1.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DeathwormAITargetItems(this, false, false));
        this.field_70715_bh.func_75776_a(1, new DeathWormAITarget<LivingEntity>(this, LivingEntity.class, false, new Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity input) {
                if (EntityDeathWorm.this.func_70909_n()) {
                    return input instanceof MonsterEntity;
                }
                return (IafConfig.deathWormAttackMonsters ? input instanceof LivingEntity : input instanceof AnimalEntity || input instanceof PlayerEntity) && DragonUtils.isAlive(input) && (!(input instanceof EntityDragonBase) || !((EntityDragonBase)input).isModelDead()) && !EntityDeathWorm.this.func_152114_e(input);
            }
        }));
    }

    public LookController func_70671_ap() {
        return this.lookHelper;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean getCanSpawnHere() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        return BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c()) && this.func_70681_au().nextInt(1 + IafConfig.deathWormSpawnCheckChance) == 0 && this.field_70170_p.func_201696_r(blockpos) > 8;
    }

    public void onUpdateParts() {
        this.addSegmentsToWorld();
        if (this.isSandBelow()) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 1.0));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState BlockState2 = this.field_70170_p.func_180495_p(blockpos);
            if (this.field_70170_p.field_72995_K) {
                // empty if block
            }
        }
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.func_213355_cm() > 3.0f ? 20 : 10;
    }

    public void initSegments(float scale) {
        this.segments = new EntityMutlipartPart[7];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new EntityDeathwormPart((LivingEntity)this, (-0.8f - (float)i * 0.8f) * scale, 0.0f, 0.0f, 0.7f * scale, 0.7f * scale, 1.0f);
            this.segments[i].func_82149_j((Entity)this);
            this.segments[i].setParent((LivingEntity)this);
        }
    }

    private void addSegmentsToWorld() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            if (!entity.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)entity);
            }
            entity.setParent((LivingEntity)this);
        }
    }

    private void clearSegments() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_174812_G();
            entity.func_70106_y();
        }
    }

    public void setExplosive(boolean explosive) {
        this.willExplode = true;
        this.ticksTillExplosion = 60;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.func_184185_a(this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_ATTACK : IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
        }
        if (this.func_70681_au().nextInt(3) == 0 && this.func_213355_cm() > 1.0f && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && !MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_()))) {
            BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.field_70170_p, (MobEntity)this, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), this.func_213355_cm());
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        this.clearSegments();
        super.func_70645_a(cause);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getVariant()) {
            case 0: {
                return this.func_213355_cm() > 3.0f ? TAN_GIANT_LOOT : TAN_LOOT;
            }
            case 1: {
                return this.func_213355_cm() > 3.0f ? RED_GIANT_LOOT : RED_LOOT;
            }
            case 2: {
                return this.func_213355_cm() > 3.0f ? WHITE_GIANT_LOOT : WHITE_LOOT;
            }
        }
        return null;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WORM_AGE, (Object)10);
        this.field_70180_af.func_187214_a(HOME, (Object)BlockPos.field_177992_a);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("GrowthCounter", this.growthCounter);
        compound.func_74776_a("Scale", this.getScale());
        compound.func_74768_a("WormAge", this.getWormAge());
        compound.func_74772_a("WormHome", this.getWormHome().func_218275_a());
        compound.func_74757_a("WillExplode", this.willExplode);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.growthCounter = compound.func_74762_e("GrowthCounter");
        this.setDeathWormScale(compound.func_74760_g("Scale"));
        this.setWormAge(compound.func_74762_e("WormAge"));
        this.setWormHome(BlockPos.func_218283_e((long)compound.func_74763_f("WormHome")));
        this.willExplode = compound.func_74767_n("WillExplode");
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public BlockPos getWormHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME);
    }

    public void setWormHome(BlockPos home) {
        if (home instanceof BlockPos) {
            this.field_70180_af.func_187227_b(HOME, (Object)home);
        }
    }

    public int getWormAge() {
        return Math.max(1, (Integer)this.field_70180_af.func_187225_a(WORM_AGE));
    }

    public void setWormAge(int age) {
        this.field_70180_af.func_187227_b(WORM_AGE, (Object)age);
    }

    public float getScale() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue()).floatValue();
    }

    public float func_213355_cm() {
        return Math.min(this.getScale() * ((float)this.getWormAge() / 5.0f), 7.0f);
    }

    public void setDeathWormScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
        this.clearSegments();
        if (!this.field_70170_p.field_72995_K) {
            this.initSegments(scale * ((float)this.getWormAge() / 5.0f));
            IceAndFire.sendMSGToAll(new MessageDeathWormHitbox(this.func_145782_y(), scale * ((float)this.getWormAge() / 5.0f)));
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(3));
        float size = 0.25f + (float)(Math.random() * (double)0.35f);
        this.setDeathWormScale(this.func_70681_au().nextInt(20) == 0 ? size * 4.0f : size);
        return spawnDataIn;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.deathWormMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, IafConfig.deathWormAttackStrength).func_233815_a_(Attributes.field_233819_b_, (double)IafConfig.deathWormTargetSearchLength).func_233815_a_(Attributes.field_233826_i_, 3.0);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
            float radius = -0.5f * this.func_213355_cm();
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)this.func_70047_e() - (double)0.55f, this.func_226281_cx_() + extraZ);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.getWormAge() > 4 && player.func_184187_bx() == null && player.func_184614_ca().func_77973_b() == Items.field_151112_aM && player.func_184592_cb().func_77973_b() == Items.field_151112_aM && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private void switchNavigator(boolean inSand) {
        if (inSand) {
            this.field_70765_h = new SandMoveHelper();
            this.field_70699_by = new PathNavigateDeathWormSand(this, this.field_70170_p);
            this.isSandNavigator = true;
        } else {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new PathNavigateDeathWormLand(this, this.field_70170_p);
            this.isSandNavigator = false;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_82729_p) {
            return false;
        }
        if (this.func_184207_aI() && source.func_76346_g() != null && this.func_184179_bs() != null && source.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
    }

    private Vector3d getAllowedMovement(Vector3d vec) {
        boolean flag3;
        boolean flag2;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
        VoxelShape voxelshape = this.field_70170_p.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        Stream stream1 = this.field_70170_p.func_230318_c_((Entity)this, axisalignedbb.func_216361_a(vec), p_233561_0_ -> true);
        ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(stream1, stream));
        Vector3d Vector3d2 = vec.func_189985_c() == 0.0 ? vec : EntityDeathWorm.func_223307_a((Entity)this, (Vector3d)vec, (AxisAlignedBB)axisalignedbb, (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
        boolean flag = vec.field_72450_a != Vector3d2.field_72450_a;
        boolean flag1 = vec.field_72448_b != Vector3d2.field_72448_b;
        boolean bl = flag2 = vec.field_72449_c != Vector3d2.field_72449_c;
        if (this.isInSand() || this.isSandBelow()) {
            return Vector3d2;
        }
        boolean bl2 = flag3 = this.func_233570_aj_() || flag1 && vec.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vector3d Vector3d3;
            Vector3d Vector3d1 = EntityDeathWorm.func_223307_a((Entity)this, (Vector3d)new Vector3d(vec.field_72450_a, (double)this.field_70138_W, vec.field_72449_c), (AxisAlignedBB)axisalignedbb, (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
            Vector3d Vector3d22 = EntityDeathWorm.func_223307_a((Entity)this, (Vector3d)new Vector3d(0.0, (double)this.field_70138_W, 0.0), (AxisAlignedBB)axisalignedbb.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
            if (Vector3d22.field_72448_b < (double)this.field_70138_W && EntityDeathWorm.func_213296_b((Vector3d)(Vector3d3 = EntityDeathWorm.func_223307_a((Entity)this, (Vector3d)new Vector3d(vec.field_72450_a, 0.0, vec.field_72449_c), (AxisAlignedBB)axisalignedbb.func_191194_a(Vector3d22), (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream).func_178787_e(Vector3d22))) > EntityDeathWorm.func_213296_b((Vector3d)Vector3d1)) {
                Vector3d1 = Vector3d3;
            }
            if (EntityDeathWorm.func_213296_b((Vector3d)Vector3d1) > EntityDeathWorm.func_213296_b((Vector3d)Vector3d2)) {
                return Vector3d1.func_178787_e(EntityDeathWorm.func_223307_a((Entity)this, (Vector3d)new Vector3d(0.0, -Vector3d1.field_72448_b + vec.field_72448_b, 0.0), (AxisAlignedBB)axisalignedbb.func_191194_a(Vector3d1), (World)this.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream));
            }
        }
        return Vector3d2;
    }

    public boolean checkBlockCollision(AxisAlignedBB bb) {
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.Mutable blockpos$pooledmutableblockpos = new BlockPos.Mutable();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    BlockState BlockState1 = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(l3, i4, j4));
                    if (BlockState1.func_185904_a() == Material.field_151579_a || BlockState1.func_185904_a() == Material.field_151595_p) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_70094_T() {
        BlockPos.Mutable blockpos$pooledmutableblockpos = new BlockPos.Mutable();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * this.func_213311_cf() * 0.8f)));
            int l = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * this.func_213311_cf() * 0.8f)));
            if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
            blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
            if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_229980_m_((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos) || this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a() == Material.field_151595_p) continue;
            return true;
        }
        return false;
    }

    protected void func_213282_i(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vector3d vector3d = new Vector3d(x - (double)blockpos.func_177958_n(), y - (double)blockpos.func_177956_o(), z - (double)blockpos.func_177952_p());
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, direction1);
            if (this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_235785_r_((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable) && !BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_177230_c())) continue;
            double d1 = vector3d.func_216370_a(direction1.func_176740_k());
            double d = d2 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.func_176743_c().func_179524_a();
        Vector3d vector3d1 = this.func_213322_ci().func_186678_a(0.75);
        if (direction.func_176740_k() == Direction.Axis.X) {
            this.func_213293_j(f1 * f, vector3d1.field_72448_b, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Y) {
            this.func_213293_j(vector3d1.field_72450_a, f1 * f, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Z) {
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, f1 * f);
        }
    }

    private boolean isBlockFullCube(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151595_p && this.field_70170_p.func_180495_p(pos).func_200132_m();
    }

    private void updateAttributes() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(Math.min(0.2, 0.15 * (double)this.func_213355_cm()));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(Math.max(1.0, IafConfig.deathWormAttackStrength * (double)this.func_213355_cm()));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(Math.max(6.0, IafConfig.deathWormMaxHealth * (double)this.func_213355_cm()));
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)IafConfig.deathWormTargetSearchLength);
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111125_b());
    }

    public void onKillEntity(LivingEntity LivingEntityIn) {
        if (this.func_70909_n()) {
            this.func_70691_i(14.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.willExplode) {
            if (this.ticksTillExplosion == 0) {
                boolean b;
                boolean bl = b = !MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
                if (b) {
                    this.field_70170_p.func_217398_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.5f * this.func_213355_cm(), false, Explosion.Mode.DESTROY);
                }
            } else {
                --this.ticksTillExplosion;
            }
        }
        if (this.field_70173_aa == 1) {
            this.initSegments(this.func_213355_cm());
        }
        this.field_70145_X = this.isInSand();
        this.func_189654_d(this.isInSandStrict());
        if (!this.isInSand() && this.func_70094_T()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
        }
        if (this.growthCounter > 1000 && this.getWormAge() < 5) {
            this.growthCounter = 0;
            this.setWormAge(Math.min(5, this.getWormAge() + 1));
            this.clearSegments();
            this.func_70691_i(15.0f);
            this.setDeathWormScale(this.getScale());
            if (this.field_70170_p.field_72995_K) {
                int i = 0;
                while ((float)i < 10.0f * this.func_213355_cm()) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), (double)((float)this.getSurface((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226278_cu_()), (int)Math.floor(this.func_226281_cx_())) + 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
                    ++i;
                }
            }
        }
        if (this.getWormAge() < 5) {
            ++this.growthCounter;
        }
        if (this.func_184179_bs() != null) {
            if (this.func_70094_T()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 2.0, 0.0));
                this.field_70145_X = true;
            } else {
                this.field_70145_X = false;
            }
        }
        if (this.func_184179_bs() != null && this.func_70638_az() != null) {
            this.func_70661_as().func_75499_g();
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null) {
            this.field_70125_A = 0.0f;
        } else {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 10.0f);
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist >= 4.0 * (double)this.func_213355_cm() && dist <= 16.0 * (double)this.func_213355_cm() && (this.isInSand() || this.field_70122_E)) {
                double d1;
                double d0 = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
                float leap = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_()) * d1));
                if ((double)leap >= 1.0E-4) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(d0 / (double)leap * 0.5, (double)0.15f, d1 / (double)leap * 0.5));
                }
                this.setAnimation(ANIMATION_BITE);
            }
            if (dist < Math.min(4.0, 4.0 * (double)this.func_213355_cm()) && this.getAnimation() == ANIMATION_BITE) {
                float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.4f, 0.0));
            }
        }
    }

    public int getWormBrightness(float partialTicks) {
        BlockPos eyePos = new BlockPos(this.func_174824_e(1.0f));
        while (eyePos.func_177956_o() < 256 && BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p(eyePos).func_177230_c())) {
            eyePos = eyePos.func_177984_a();
        }
        int light = this.field_70170_p.func_226658_a_(LightType.BLOCK, eyePos);
        return light;
    }

    public int getSurface(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        while (!this.field_70170_p.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        return pos.func_177956_o();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_IDLE : IafSoundRegistry.DEATHWORM_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_HURT : IafSoundRegistry.DEATHWORM_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_DIE : IafSoundRegistry.DEATHWORM_DIE;
    }

    public void func_70071_h_() {
        boolean inSand;
        super.func_70071_h_();
        this.func_213323_x_();
        this.onUpdateParts();
        if (this.attack() && this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity) {
            LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((PlayerEntity)this.func_184179_bs()), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
                this.func_184185_a(this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_ATTACK : IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
                if (this.func_70681_au().nextInt(3) == 0 && this.func_213355_cm() > 1.0f) {
                    float radius = 1.5f * this.func_213355_cm();
                    float angle = (float)Math.PI / 180 * this.field_70761_aq;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.field_70170_p, (MobEntity)this, this.func_226277_ct_() + extraX, this.func_226278_cu_() - (double)this.func_70047_e(), this.func_226281_cx_() + extraZ, this.func_213355_cm() * 0.75f);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
            }
            if (target != null) {
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            }
        }
        if (this.isInSand()) {
            BlockPos pos = new BlockPos(this.func_226277_ct_(), (double)this.getSurface((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226278_cu_()), (int)Math.floor(this.func_226281_cx_())), this.func_226281_cx_()).func_177977_b();
            BlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_200015_d((IBlockReader)this.field_70170_p, pos) && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), (double)((float)this.getSurface((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226278_cu_()), (int)Math.floor(this.func_226281_cx_())) + 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
            }
            if (this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_187747_eB, 1.0f, 0.5f);
            }
            if (this.func_70638_az() != null) {
                this.func_70605_aq().func_75642_a(this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_(), this.func_70638_az().func_226281_cx_(), 1.0);
            }
        }
        if (this.up() && this.field_70122_E) {
            this.func_70664_aZ();
        }
        if ((inSand = this.isInSand()) && !this.isSandNavigator) {
            this.switchNavigator(true);
        }
        if (!inSand && this.isSandNavigator) {
            this.switchNavigator(false);
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (LivingEntity)this);
        }
        if (this.func_184179_bs() != null) {
            this.field_70145_X = false;
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((PlayerEntity)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            this.attack(IafKeybindRegistry.dragon_strike.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void dismount(boolean dismount) {
        this.setStateField(1, dismount);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public boolean isSandBelow() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 1.0)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        BlockState BlockState2 = this.field_70170_p.func_180495_p(blockpos);
        return BlockState2.func_185904_a() == Material.field_151595_p;
    }

    public boolean isInSand() {
        return this.func_184179_bs() == null && (BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177984_a()).func_177230_c()) || BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_177230_c()) || BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_177230_c()));
    }

    public boolean isInSandStrict() {
        return this.isInSand();
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public Entity[] getWormParts() {
        return this.segments;
    }

    public int func_184649_cE() {
        return 10;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_213352_e(Vector3d vec) {
        super.func_213352_e(vec);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    @Override
    public boolean canPhaseThroughBlock(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151595_p;
    }

    public boolean canExplosionDestroyBlock(Explosion explosionIn, World worldIn, BlockPos pos, BlockState blockStateIn, float p_174816_5_) {
        float hardness = blockStateIn.func_185887_b((IBlockReader)worldIn, pos);
        return hardness != -1.0f && hardness < 1.5f;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRidingPlayer(PlayerEntity player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    @Override
    public double getRideSpeedModifier() {
        return 1.0;
    }

    public class SandMoveHelper
    extends MovementController {
        private EntityDeathWorm worm;

        public SandMoveHelper() {
            super((MobEntity)EntityDeathWorm.this);
            this.worm = EntityDeathWorm.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d Vector3d2 = new Vector3d(this.field_75646_b - EntityDeathWorm.this.func_226277_ct_(), this.field_75647_c - EntityDeathWorm.this.func_226278_cu_(), this.field_75644_d - EntityDeathWorm.this.func_226281_cx_());
                double d0 = Vector3d2.func_72433_c();
                if (d0 < EntityDeathWorm.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityDeathWorm.this.func_213317_d(EntityDeathWorm.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    this.field_75645_e = 1.0;
                    EntityDeathWorm.this.func_213317_d(EntityDeathWorm.this.func_213322_ci().func_178787_e(Vector3d2.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    if (EntityDeathWorm.this.func_70638_az() == null) {
                        Vector3d Vector3d1 = EntityDeathWorm.this.func_213322_ci();
                        EntityDeathWorm.this.field_70761_aq = EntityDeathWorm.this.field_70177_z = -((float)MathHelper.func_181159_b((double)Vector3d1.field_72450_a, (double)Vector3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d2 = EntityDeathWorm.this.func_70638_az().func_226277_ct_() - EntityDeathWorm.this.func_226277_ct_();
                        double d1 = EntityDeathWorm.this.func_70638_az().func_226281_cx_() - EntityDeathWorm.this.func_226281_cx_();
                        EntityDeathWorm.this.field_70761_aq = EntityDeathWorm.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d2, (double)d1)) * 57.295776f;
                    }
                }
            }
        }
    }
}

