/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDreadLichSkull
extends AbstractArrowEntity {
    public EntityDreadLichSkull(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_70239_b(6.0);
    }

    public EntityDreadLichSkull(EntityType type, World worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.func_70239_b(6.0);
    }

    public EntityDreadLichSkull(EntityType type, World worldIn, LivingEntity shooter, double x, double y, double z) {
        super(type, shooter, worldIn);
        this.func_70239_b(6.0);
    }

    public EntityDreadLichSkull(EntityType type, World worldIn, LivingEntity shooter, double dmg) {
        super(type, shooter, worldIn);
        this.func_70239_b(dmg);
    }

    public EntityDreadLichSkull(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(IafEntityRegistry.DREAD_LICH_SKULL, worldIn);
    }

    public boolean func_70090_H() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        double speed;
        double minusZ;
        double minusY;
        double minusX;
        LivingEntity target;
        float sqrt = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
        boolean flag = true;
        Entity shootingEntity = this.func_234616_v_();
        if (shootingEntity != null && shootingEntity instanceof MobEntity && ((MobEntity)shootingEntity).func_70638_az() != null) {
            target = ((MobEntity)shootingEntity).func_70638_az();
            minusX = target.func_226277_ct_() - this.func_226277_ct_();
            minusY = target.func_226278_cu_() - this.func_226278_cu_();
            minusZ = target.func_226281_cx_() - this.func_226281_cx_();
            speed = 0.15;
            this.func_213317_d(this.func_213322_ci().func_72441_c(minusX * speed * 0.1, minusY * speed * 0.1, minusZ * speed * 0.1));
        }
        if (shootingEntity instanceof PlayerEntity) {
            target = ((PlayerEntity)shootingEntity).func_94060_bK();
            if (target == null || !target.func_70089_S()) {
                double d0 = 10.0;
                List list = this.field_70170_p.func_175674_a(shootingEntity, new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_() + 1.0, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + 1.0).func_72314_b(d0, 10.0, d0), EntityPredicates.field_94557_a);
                if (!list.isEmpty()) {
                    for (Entity e : list) {
                        if (!(e instanceof LivingEntity) || e.func_110124_au().equals(shootingEntity.func_110124_au())) continue;
                        target = (LivingEntity)e;
                    }
                }
            }
            if (target != null && target.func_70089_S()) {
                minusX = target.func_226277_ct_() - this.func_226277_ct_();
                minusY = target.func_226278_cu_() + (double)target.func_70047_e() - this.func_226278_cu_();
                minusZ = target.func_226281_cx_() - this.func_226281_cx_();
                speed = 0.25 * Math.min((double)this.func_70032_d((Entity)target), 10.0) / 10.0;
                this.func_213317_d(this.func_213322_ci().func_72441_c((Math.signum(minusX) * 0.5 - this.func_213322_ci().field_72450_a) * (double)0.1f, (Math.signum(minusY) * 0.5 - this.func_213322_ci().field_72448_b) * (double)0.1f, (Math.signum(minusZ) * 0.5 - this.func_213322_ci().field_72449_c) * (double)0.1f));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72450_a, (double)this.func_213322_ci().field_72449_c) * 57.29577951308232);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72448_b, (double)sqrt) * 57.29577951308232);
                flag = false;
            }
        }
        if ((sqrt < 0.1f || this.field_70123_F || this.field_70124_G || this.field_70254_i) && this.field_70173_aa > 5 && flag) {
            this.func_70106_y();
        }
        double d0 = 0.0;
        double d1 = 0.01;
        double d2 = 0.0;
        double x = this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
        double y = this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - (double)this.func_213302_cg();
        double z = this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
        float f = (this.func_213311_cf() + this.func_213302_cg() + this.func_213311_cf()) * 0.333f + 0.5f;
        if (this.particleDistSq(x, y, z) < (double)(f * f)) {
            IceAndFire.PROXY.spawnParticle("dread_torch", x, y + 0.5, z, d0, d1, d2);
        }
        super.func_70071_h_();
    }

    public double particleDistSq(double toX, double toY, double toZ) {
        double d0 = this.func_226277_ct_() - toX;
        double d1 = this.func_226278_cu_() - toY;
        double d2 = this.func_226281_cx_() - toZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R() && soundIn != SoundEvents.field_187731_t && soundIn != SoundEvents.field_187734_u) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = raytraceResultIn.func_216348_a();
            Entity shootingEntity = this.func_234616_v_();
            if (entity != null && shootingEntity != null && entity.func_184191_r(shootingEntity)) {
                return;
            }
        }
        super.func_213868_a(raytraceResultIn);
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        Entity shootingEntity = this.func_234616_v_();
        if (living != null && (shootingEntity == null || !living.func_70028_i(shootingEntity)) && living instanceof PlayerEntity) {
            this.damageShield((PlayerEntity)living, (float)this.func_70242_d());
        }
    }

    protected void damageShield(PlayerEntity player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b().isShield(player.func_184607_cu(), (LivingEntity)player)) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_222118_a(i, (LivingEntity)player, p_220009_1_ -> p_220009_1_.func_213334_d(player.func_184600_cs()));
            if (player.func_184607_cu().func_190926_b()) {
                Hand Hand2 = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copyBeforeUse, (Hand)Hand2);
                if (Hand2 == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

