/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIFindWaterTarget;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.HippocampusAIRide;
import com.github.alexthe666.iceandfire.entity.ai.HippocampusAIWander;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.IDropArmor;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.inventory.ContainerHippocampus;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageHippogryphArmor;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateAmphibious;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityHippocampus
extends TameableEntity
implements ISyncMount,
IAnimatedEntity,
IDropArmor {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHippocampus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityHippocampus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMOR = EntityDataManager.func_187226_a(EntityHippocampus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(EntityHippocampus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityHippocampus.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static Animation ANIMATION_SPEAK;
    public float onLandProgress;
    @OnlyIn(value=Dist.CLIENT)
    public ChainBuffer tail_buffer;
    public Inventory hippocampusInventory;
    public float sitProgress;
    public int airBorneCounter;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isLandNavigator;
    private boolean isSitting;
    private boolean hasChestVarChanged = false;

    public EntityHippocampus(EntityType t, World worldIn) {
        super(t, worldIn);
        this.field_70138_W = 1.0f;
        ANIMATION_SPEAK = Animation.create((int)15);
        this.switchNavigator(true);
        if (worldIn.field_72995_K) {
            this.tail_buffer = new ChainBuffer();
        }
        this.initHippocampusInv();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new HippocampusAIRide(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new AquaticAITempt((MobEntity)this, 1.0, Items.field_222066_kO, false));
        this.field_70714_bg.func_75776_a(0, (Goal)new AquaticAITempt((MobEntity)this, 1.0, Items.field_179563_cD, false));
        this.field_70714_bg.func_75776_a(1, (Goal)new AquaticAIFindWaterTarget((MobEntity)this, 10, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new AquaticAIGetInWater((MobEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new HippocampusAIWander((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
    }

    protected int func_70693_a(PlayerEntity player) {
        return 2;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h ? 10.0f : (float)this.field_70170_p.func_201696_r(pos) - 0.5f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new PathNavigateAmphibious((CreatureEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper();
            this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
    }

    private void initHippocampusInv() {
        Inventory animalchest = this.hippocampusInventory;
        this.hippocampusInventory = new Inventory(18);
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.hippocampusInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.hippocampusInventory.func_70299_a(j, itemstack.func_77946_l());
            }
            if (this.field_70170_p.field_72995_K) {
                ItemStack saddle = animalchest.func_70301_a(0);
                ItemStack chest = animalchest.func_70301_a(1);
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 2, EntityHippocampus.getIntFromArmor(animalchest.func_70301_a(2))));
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity) || this.func_70638_az() == passenger) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    public static int getIntFromArmor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == Items.field_151138_bX) {
            return 1;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == Items.field_151136_bY) {
            return 2;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == Items.field_151125_bZ) {
            return 3;
        }
        return 0;
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.hippocampusInventory.func_70302_i_()) {
            this.hippocampusInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.hippocampusInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippocampusInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippocampusInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        double ymod1 = (double)this.onLandProgress * -0.02;
        passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.6f + ymod1, this.func_226281_cx_());
    }

    public void func_70636_d() {
        boolean inWater;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof LivingEntity && this.field_70173_aa % 20 == 0) {
            ((LivingEntity)this.func_184179_bs()).func_195064_c(new EffectInstance(Effects.field_76427_o, 30, 0, true, false));
        }
        this.airBorneCounter = !this.field_70122_E ? ++this.airBorneCounter : 0;
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 1.0f, (LivingEntity)this);
        }
        if (this.up()) {
            if (!this.func_70090_H() && this.airBorneCounter == 0 && this.field_70122_E) {
                this.func_70664_aZ();
            } else if (this.func_70090_H()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
            }
        }
        if (this.down()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.4, 0.0));
        }
        if (this.func_70090_H() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.func_70090_H() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        boolean bl = inWater = !this.func_70090_H();
        if (inWater && this.onLandProgress < 20.0f) {
            this.onLandProgress += 1.0f;
        } else if (!inWater && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        boolean sitting = this.isSitting();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.hasChestVarChanged && this.hippocampusInventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.hippocampusInventory.func_70301_a(i).func_190926_b()) continue;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.hippocampusInventory.func_70301_a(i), 1.0f);
                }
                this.hippocampusInventory.func_70304_b(i);
            }
            this.hasChestVarChanged = false;
        }
    }

    public boolean up() {
        return (Byte.valueOf((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE)) & 1) == 1;
    }

    public boolean down() {
        return (Byte.valueOf((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE)) >> 1 & 1) == 1;
    }

    public boolean dismount() {
        return (Byte.valueOf((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE)) >> 2 & 1) == 1;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean getCanSpawnHere() {
        return this.func_226278_cu_() > 30.0 && this.func_226278_cu_() < (double)this.field_70170_p.func_181545_F();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Chested", this.isChested());
        compound.func_74757_a("Saddled", this.isSaddled());
        compound.func_74768_a("Armor", this.getArmor());
        if (this.hippocampusInventory != null) {
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.hippocampusInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippocampusInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                CompoundNBT2.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(CompoundNBT2);
                nbttaglist.add((Object)CompoundNBT2);
            }
            compound.func_218657_a("Items", (INBT)nbttaglist);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setChested(compound.func_74767_n("Chested"));
        this.setSaddled(compound.func_74767_n("Saddled"));
        this.setArmor(compound.func_74762_e("Armor"));
        if (this.hippocampusInventory != null) {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippocampusInv();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT2.func_74771_c("Slot") & 0xFF;
                this.hippocampusInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
            }
        } else {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippocampusInv();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT3 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT3.func_74771_c("Slot") & 0xFF;
                this.initHippocampusInv();
                this.hippocampusInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT3));
                ItemStack saddle = this.hippocampusInventory.func_70301_a(0);
                ItemStack chest = this.hippocampusInventory.func_70301_a(1);
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 2, EntityHippocampus.getIntFromArmor(this.hippocampusInventory.func_70301_a(2))));
            }
        }
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean isSitting() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void setSitting(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public int getArmor() {
        return (Integer)this.field_70180_af.func_187225_a(ARMOR);
    }

    public void setArmor(int armorType) {
        this.field_70180_af.func_187227_b(ARMOR, (Object)armorType);
        double armorValue = 0.0;
        switch (armorType) {
            case 1: {
                armorValue = 10.0;
                break;
            }
            case 2: {
                armorValue = 20.0;
                break;
            }
            case 3: {
                armorValue = 30.0;
            }
        }
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a(armorValue);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(6));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_SPEAK};
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        if (ageable instanceof EntityHippocampus) {
            EntityHippocampus hippo = new EntityHippocampus(IafEntityRegistry.HIPPOCAMPUS, this.field_70170_p);
            hippo.setVariant(this.func_70681_au().nextBoolean() ? this.getVariant() : ((EntityHippocampus)ageable).getVariant());
            return hippo;
        }
        return null;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70090_H() {
        return super.func_70090_H();
    }

    public void func_213352_e(Vector3d vec) {
        if (this.isSitting()) {
            super.func_213352_e(Vector3d.field_186680_a);
            return;
        }
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_213309_a(0.1f, vec);
                float f4 = 0.6f;
                float d0 = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)f4 * 0.9, (double)f4 * 0.9, (double)f4 * 0.9));
            } else {
                super.func_213352_e(vec);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.func_226277_ct_() - this.field_70169_q;
        double deltaZ = this.func_226281_cx_() - this.field_70166_s;
        double deltaY = this.func_226278_cu_() - this.field_70167_r;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179563_cD;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack != null && itemstack.func_77973_b() == Items.field_179563_cD && this.func_70874_b() == 0 && !this.func_70880_s()) {
            this.setSitting(false);
            this.func_146082_f(player);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_222066_kO) {
            int i;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(5.0f);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (i = 0; i < 3; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
            }
            if (!this.func_70909_n() && this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                for (i = 0; i < 6; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_152114_e((LivingEntity)player) && itemstack != null && itemstack.func_77973_b() == Items.field_179563_cD && this.func_70874_b() == 0 && !this.func_70880_s()) {
            this.setSitting(false);
            this.func_146082_f(player);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_152114_e((LivingEntity)player) && itemstack != null && itemstack.func_77973_b() == Items.field_151055_y) {
            this.setSitting(!this.isSitting());
            return ActionResultType.SUCCESS;
        }
        if (this.func_152114_e((LivingEntity)player) && itemstack.func_190926_b()) {
            if (player.func_225608_bj_()) {
                this.openGUI(player);
                return ActionResultType.SUCCESS;
            }
            if (this.isSaddled() && !this.func_70631_g_() && !player.func_184218_aH()) {
                player.func_184205_a((Entity)this, true);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    return new ContainerHippocampus(p_createMenu_1_, (IInventory)EntityHippocampus.this.hippocampusInventory, p_createMenu_2_, EntityHippocampus.this);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("entity.iceandfire.hippocampus");
                }
            });
        }
        IceAndFire.PROXY.setReferencedMob((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((PlayerEntity)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            this.down(IafKeybindRegistry.dragon_down.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            this.down(IafKeybindRegistry.dragon_down.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void dismount(boolean dismount) {
        this.setStateField(2, dismount);
    }

    public void refreshInventory() {
        ItemStack saddle = this.hippocampusInventory.func_70301_a(0);
        ItemStack chest = this.hippocampusInventory.func_70301_a(1);
        this.setSaddled(saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b());
        this.setChested(chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b());
        this.setArmor(EntityHippocampus.getIntFromArmor(this.hippocampusInventory.func_70301_a(2)));
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 2, EntityHippocampus.getIntFromArmor(this.hippocampusInventory.func_70301_a(2))));
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.HIPPOCAMPUS_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return IafSoundRegistry.HIPPOCAMPUS_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.HIPPOCAMPUS_DIE;
    }

    @Override
    public void dropArmor() {
        if (this.hippocampusInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippocampusInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippocampusInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean isRidingPlayer(PlayerEntity player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Nullable
    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    public double getRideSpeedModifier() {
        return this.func_70090_H() ? (double)1.2f * IafConfig.dragonFlightSpeedMod : (double)0.55f;
    }

    class SwimmingMoveHelper
    extends MovementController {
        private EntityHippocampus hippo;

        public SwimmingMoveHelper() {
            super((MobEntity)EntityHippocampus.this);
            this.hippo = EntityHippocampus.this;
        }

        public void func_75641_c() {
            if (this.hippo.func_184207_aI()) {
                double flySpeed = (double)0.8f * this.hippo.getRideSpeedModifier();
                Vector3d dragonVec = this.hippo.func_213303_ch();
                Vector3d moveVec = new Vector3d(this.field_75646_b, this.field_75647_c, this.field_75644_d);
                Vector3d normalized = moveVec.func_178788_d(dragonVec).func_72432_b();
                double dist = dragonVec.func_72438_d(moveVec);
                this.hippo.func_213293_j(normalized.field_72450_a * flySpeed, normalized.field_72448_b * flySpeed, normalized.field_72449_c * flySpeed);
                if (dist > 2.5E-7) {
                    float yaw = (float)Math.toDegrees(Math.PI * 2 - Math.atan2(normalized.field_72450_a, normalized.field_72448_b));
                    this.hippo.field_70177_z = this.func_75639_a(this.hippo.field_70177_z, yaw, 5.0f);
                    this.hippo.func_70659_e((float)this.field_75645_e);
                }
                this.hippo.func_213315_a(MoverType.SELF, this.hippo.func_213322_ci());
            } else if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.hippo.func_70661_as().func_75500_f()) {
                double distanceX = this.field_75646_b - this.hippo.func_226277_ct_();
                double distanceY = this.field_75647_c - this.hippo.func_226278_cu_();
                double distanceZ = this.field_75644_d - this.hippo.func_226281_cx_();
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ));
                distanceY /= distanceWithY;
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.hippo.field_70177_z = this.func_75639_a(this.hippo.field_70177_z, angle, 30.0f);
                this.hippo.func_70659_e(1.0f);
                float f1 = 0.0f;
                float f2 = 0.0f;
                if (distance < (double)Math.max(1.0f, this.hippo.func_213311_cf())) {
                    float f = this.hippo.field_70177_z * ((float)Math.PI / 180);
                    f1 = (float)((double)f1 - (double)(MathHelper.func_76126_a((float)f) * 0.35f));
                    f2 = (float)((double)f2 + (double)(MathHelper.func_76134_b((float)f) * 0.35f));
                }
                this.hippo.func_213317_d(this.hippo.func_213322_ci().func_72441_c((double)f1, (double)this.hippo.func_70689_ay() * distanceY * 0.1, (double)f2));
            } else if (this.field_188491_h == MovementController.Action.JUMPING) {
                this.hippo.func_70659_e((float)(this.field_75645_e * this.hippo.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                if (this.hippo.field_70122_E) {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            } else {
                this.hippo.func_70659_e(0.0f);
            }
        }
    }
}

