/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.DragonFireEvent;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonIceCharge;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonSyncFire;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityIceDragon
extends EntityDragonBase {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final ResourceLocation FEMALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/ice_dragon_female");
    public static final ResourceLocation MALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/ice_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = new ResourceLocation("iceandfire", "entities/dragon/ice_dragon_skeleton");
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntityIceDragon.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_FIRECHARGE;
    public boolean isSwimming;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;

    public EntityIceDragon(World worldIn) {
        this(IafEntityRegistry.ICE_DRAGON, worldIn);
    }

    public EntityIceDragon(EntityType t, World worldIn) {
        super(t, worldIn, DragonType.ICE, 1.0, 1 + IafConfig.dragonAttackDamage, IafConfig.dragonHealth * 0.04, IafConfig.dragonHealth, 0.15f, 0.4f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)25);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.func_70909_n()) {
            return entity.func_200600_R() != this.func_200600_R() && this.func_213311_cf() >= entity.func_213311_cf() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof PlayerEntity || DragonUtils.isDragonTargetable(entity) || entity instanceof WaterMobEntity || !this.func_70909_n() && DragonUtils.isVillager(entity);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "blue_";
            }
            case 1: {
                return "white_";
            }
            case 2: {
                return "sapphire_";
            }
            case 3: 
        }
        return "silver_";
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return IafItemRegistry.DRAGONSCALES_BLUE;
            }
            case 1: {
                return IafItemRegistry.DRAGONSCALES_WHITE;
            }
            case 2: {
                return IafItemRegistry.DRAGONSCALES_SAPPHIRE;
            }
            case 3: 
        }
        return IafItemRegistry.DRAGONSCALES_SILVER;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return IafItemRegistry.DRAGONEGG_BLUE;
            }
            case 1: {
                return IafItemRegistry.DRAGONEGG_WHITE;
            }
            case 2: {
                return IafItemRegistry.DRAGONEGG_SAPPHIRE;
            }
            case 3: 
        }
        return IafItemRegistry.DRAGONEGG_SILVER;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Swimming", this.func_203007_ba());
        compound.func_74768_a("SwimmingTicks", this.ticksSwiming);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_204711_a(compound.func_74767_n("Swimming"));
        this.ticksSwiming = compound.func_74762_e("SwimmingTicks");
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.func_70671_ap().func_75651_a(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.func_213303_ch().func_72441_c(0.0, (double)(this.func_213302_cg() / 2.0f), 0.0), entityIn.func_213303_ch().func_72441_c(0.0, (double)(entityIn.func_213302_cg() / 2.0f), 0.0)) && entityIn.func_213311_cf() < this.func_213311_cf() * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.func_184220_m((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        boolean swimming;
        super.func_70636_d();
        if (!this.isFlying() && !this.isHovering() && this.func_203007_ba() && !this.field_70170_p.field_72995_K) {
            this.flightManager.update();
        }
        if (!this.field_70170_p.field_72995_K && this.func_180799_ab() && this.isAllowedToTriggerFlight() && !this.isModelDead()) {
            this.setHovering(true);
            this.setSleeping(false);
            this.setSitting(false);
            this.flyHovering = 0;
            this.flyTicks = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            float growSize;
            float f = growSize = this.isInMaterialWater() ? 1.0f : 0.5f;
            if (this.func_174813_aQ().func_72314_b((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70652_k((Entity)this.func_70638_az());
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.field_70122_E)) {
                this.shootIceAtMob(this.func_70638_az());
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.func_70068_e((Entity)this.func_70638_az()) < 100.0) {
                double difX = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
                double difY = this.func_70638_az().func_226278_cu_() + (double)this.func_70638_az().func_213302_cg() - this.func_226278_cu_();
                double difZ = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
                this.func_213317_d(this.func_213322_ci().func_72441_c(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.func_174813_aQ().func_72314_b((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                    this.func_70652_k((Entity)this.func_70638_az());
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        if ((swimming = this.isInMaterialWater()) && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (this.isInMaterialWater() && !this.func_203007_ba() && (!this.isFlying() && !this.isHovering() || this.flyTicks > 100)) {
            this.func_204711_a(true);
            this.setHovering(false);
            this.setFlying(false);
            this.flyTicks = 0;
            this.ticksSwiming = 0;
        }
        if ((!this.isInMaterialWater() || this.isHovering() || this.isFlying()) && this.func_203007_ba()) {
            this.func_204711_a(false);
            this.ticksSwiming = 0;
        }
        if (this.func_203007_ba() && !this.isModelDead()) {
            ++this.ticksSwiming;
            if (!(!this.isInMaterialWater() && !this.isOverWater() || this.ticksSwiming <= 4000 && (this.func_70638_az() == null || this.func_70090_H() == this.func_70638_az().func_70090_H()) || this.func_70631_g_() || this.isHovering() || this.isFlying())) {
                this.setHovering(true);
                this.func_70664_aZ();
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.8, 0.0));
                this.func_204711_a(false);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isHovering() && !this.isFlying() && (this.isInMaterialWater() || this.isOverWater())) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.2, 0.0));
        }
        this.swimCycle = this.swimCycle < 48 ? (this.swimCycle += 2) : 0;
        if (this.isModelDead() && this.swimCycle != 0) {
            this.swimCycle = 0;
        }
    }

    private boolean isOverWater() {
        return this.isInMaterialWater();
    }

    public boolean isInsideWaterBlock() {
        return this.isInMaterialWater();
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.field_70177_z = this.field_70761_aq;
                Vector3d headVec = this.getHeadPosition();
                this.func_184185_a(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                float inaccuracy = 1.0f;
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(IafEntityRegistry.ICE_DRAGON_CHARGE, this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                RayTraceResult mop;
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    public boolean isInMaterialWater() {
        return this.func_70090_H();
    }

    private void shootIceAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.func_70681_au().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.field_70177_z = this.field_70761_aq;
                    Vector3d headVec = this.getHeadPosition();
                    double d2 = entity.func_226277_ct_() - headVec.field_72450_a;
                    double d3 = entity.func_226278_cu_() - headVec.field_72448_b;
                    double d4 = entity.func_226281_cx_() - headVec.field_72449_c;
                    float inaccuracy = 1.0f;
                    this.func_184185_a(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(IafEntityRegistry.ICE_DRAGON_CHARGE, this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                    }
                    if (!entity.func_70089_S() || entity == null) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.field_70177_z = this.field_70761_aq;
                    if (this.field_70173_aa % 5 == 0) {
                        this.func_184185_a(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 1);
                    if (!entity.func_70089_S() || entity == null) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireEvent(this, burnX, burnY, burnZ))) {
            return;
        }
        if (syncType == 1 && !this.field_70170_p.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 2 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 3 && !this.field_70170_p.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType == 4 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.field_70177_z = this.field_70761_aq;
                Vector3d headVec = this.getHeadPosition();
                double d2 = burnX - headVec.field_72450_a;
                double d3 = burnY - headVec.field_72448_b;
                double d4 = burnZ - headVec.field_72449_c;
                float inaccuracy = 1.0f;
                this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(IafEntityRegistry.ICE_DRAGON_CHARGE, this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                }
            }
            return;
        }
        this.func_70661_as().func_75499_g();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vector3d headPos = this.getHeadPosition();
        double d2 = burnX - headPos.field_72450_a;
        double d3 = burnY - headPos.field_72448_b;
        double d4 = burnZ - headPos.field_72449_c;
        float particleScale = MathHelper.func_76131_a((float)(this.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f);
        double distance = Math.max(2.5 * this.func_70092_e(burnX, burnY, burnZ), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int particleCount = this.getDragonStage() <= 3 ? 6 : 3;
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.field_72450_a + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.field_72448_b + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.field_72449_c + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(particleCount) == 0) {
                    IceAndFire.PROXY.spawnDragonParticle("dragonice", headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, 0.0, 0.0, 0.0, this);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_()), new Vector3d(progressX, progressY, progressZ), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                BlockPos pos = new BlockPos(result.func_216347_e());
                IafDragonDestructionManager.destroyAreaIce(this.field_70170_p, pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            if (!this.field_70170_p.field_72995_K) {
                IafDragonDestructionManager.destroyAreaIce(this.field_70170_p, new BlockPos(spawnX, spawnY, spawnZ), this);
            }
        }
    }

    public boolean func_203007_ba() {
        if (this.field_70170_p.field_72995_K) {
            boolean swimming;
            this.isSwimming = swimming = ((Boolean)this.field_70180_af.func_187225_a(SWIMMING)).booleanValue();
            return swimming;
        }
        return this.isSwimming;
    }

    public void func_204711_a(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_IDLE : (this.isAdult() ? IafSoundRegistry.ICEDRAGON_ADULT_IDLE : IafSoundRegistry.ICEDRAGON_CHILD_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_HURT : (this.isAdult() ? IafSoundRegistry.ICEDRAGON_ADULT_HURT : IafSoundRegistry.ICEDRAGON_CHILD_HURT);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_DEATH : (this.isAdult() ? IafSoundRegistry.ICEDRAGON_ADULT_DEATH : IafSoundRegistry.ICEDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_ROAR : (this.isAdult() ? IafSoundRegistry.ICEDRAGON_ADULT_ROAR : IafSoundRegistry.ICEDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR};
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == IafItemRegistry.FROST_STEW;
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.func_177958_n() + 0.5f, (float)burningTarget.func_177956_o() + 0.5f, (float)burningTarget.func_177952_p() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public double getFlightSpeedModifier() {
        return super.getFlightSpeedModifier() * (double)(this.isInMaterialWater() ? 0.3f : 1.0f);
    }

    @Override
    public boolean isAllowedToTriggerFlight() {
        return super.isAllowedToTriggerFlight() && !this.func_70090_H();
    }

    @Override
    protected void spawnDeathParticles() {
        if (this.field_70170_p.field_72995_K) {
            for (int k = 0; k < 10; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                IceAndFire.PROXY.spawnParticle("snowflake", this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    @Override
    protected void spawnBabyParticles() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                float radiusAdd = (float)i * 0.15f;
                float headPosX = (float)(this.func_226277_ct_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.func_226281_cx_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.func_226278_cu_() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                IceAndFire.PROXY.spawnParticle("dragonice", headPosX, headPosY, headPosZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getStartMetaForType() {
        return 4;
    }

    @Override
    public SoundEvent getBabyFireSound() {
        return SoundEvents.field_187618_I;
    }

    @Override
    protected ItemStack getSkull() {
        return new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_ICE);
    }

    @Override
    public boolean useFlyingPathFinder() {
        return this.isFlying() || this.isInMaterialWater();
    }

    @Override
    public Item getSummoningCrystal() {
        return IafItemRegistry.SUMMONING_CRYSTAL_ICE;
    }

    @Override
    protected Item getBloodItem() {
        return IafItemRegistry.ICE_DRAGON_BLOOD;
    }

    @Override
    protected IItemProvider getHeartItem() {
        return IafItemRegistry.ICE_DRAGON_HEART;
    }
}

