/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.message.MessageMultipartInteract;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityMutlipartPart
extends Entity {
    private static final DataParameter<Integer> PARENT_ID = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE_WIDTH = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SCALE_HEIGHT = EntityDataManager.func_187226_a(EntityMutlipartPart.class, (IDataSerializer)DataSerializers.field_187193_c);
    public EntitySize multipartSize;
    protected float radius;
    protected float angleYaw;
    protected float offsetY;
    protected float damageMultiplier;

    public EntityMutlipartPart(EntityType t, World world) {
        super(t, world);
        this.multipartSize = t.func_220334_j();
    }

    public Entity getEntity() {
        return this;
    }

    public EntityMutlipartPart(EntityType t, LivingEntity parent, float radius, float angleYaw, float offsetY, float sizeX, float sizeY, float damageMultiplier) {
        super(t, parent.field_70170_p);
        this.setParent(parent);
        this.setScaleX(sizeX);
        this.setScaleY(sizeY);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
        this.damageMultiplier = damageMultiplier;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(this.getScaleX(), this.getScaleY(), false);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PARENT_ID, (Object)0);
        this.field_70180_af.func_187214_a(SCALE_WIDTH, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(SCALE_HEIGHT, (Object)Float.valueOf(0.5f));
    }

    private int getParentId() {
        return (Integer)this.field_70180_af.func_187225_a(PARENT_ID);
    }

    private void setParentId(int parentId) {
        this.field_70180_af.func_187227_b(PARENT_ID, (Object)parentId);
    }

    private float getScaleX() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE_WIDTH)).floatValue();
    }

    private void setScaleX(float scale) {
        this.field_70180_af.func_187227_b(SCALE_WIDTH, (Object)Float.valueOf(scale));
    }

    private float getScaleY() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE_HEIGHT)).floatValue();
    }

    private void setScaleY(float scale) {
        this.field_70180_af.func_187227_b(SCALE_HEIGHT, (Object)Float.valueOf(scale));
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > 10) {
            LivingEntity parent = this.getParent();
            this.func_213323_x_();
            if (parent != null && !this.field_70170_p.field_72995_K) {
                this.func_70107_b(parent.func_226277_ct_() + (double)this.radius * Math.cos((double)parent.field_70761_aq * (Math.PI / 180) + (double)this.angleYaw), parent.func_226278_cu_() + (double)this.offsetY, parent.func_226281_cx_() + (double)this.radius * Math.sin((double)parent.field_70761_aq * (Math.PI / 180) + (double)this.angleYaw));
                this.func_70018_K();
                if (!this.field_70170_p.field_72995_K) {
                    this.collideWithNearbyEntities();
                }
                if (parent.field_70128_L && !this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else if (this.field_70173_aa > 20 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    public void func_70106_y() {
        this.remove(false);
    }

    public LivingEntity getParent() {
        int id = this.getParentId();
        Entity rawEntity = this.field_70170_p.func_73045_a(id);
        return rawEntity instanceof LivingEntity ? (LivingEntity)rawEntity : null;
    }

    public void setParent(LivingEntity entity) {
        this.setParentId(entity.func_145782_y());
    }

    public boolean func_70028_i(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void collideWithNearbyEntities() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        LivingEntity parent = this.getParent();
        if (parent != null) {
            entities.stream().filter(arg_0 -> EntityMutlipartPart.lambda$collideWithNearbyEntities$0((Entity)parent, arg_0)).forEach(arg_0 -> EntityMutlipartPart.lambda$collideWithNearbyEntities$1((Entity)parent, arg_0));
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        LivingEntity parent = this.getParent();
        if (this.field_70170_p.field_72995_K && parent != null) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageMultipartInteract(parent.func_145782_y(), 0.0f));
        }
        return parent != null ? parent.func_184230_a(player, hand) : ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        LivingEntity parent = this.getParent();
        if (this.field_70170_p.field_72995_K && source.func_76346_g() instanceof PlayerEntity && parent != null) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageMultipartInteract(parent.func_145782_y(), damage * this.damageMultiplier));
        }
        return parent != null && parent.func_70097_a(source, damage * this.damageMultiplier);
    }

    public boolean shouldNotExist() {
        LivingEntity parent = this.getParent();
        return !parent.func_70089_S();
    }

    public boolean shouldContinuePersisting() {
        return this.isAddedToWorld() || this.field_70128_L;
    }

    private static /* synthetic */ void lambda$collideWithNearbyEntities$1(Entity parent, Entity entity) {
        entity.func_70108_f(parent);
    }

    private static /* synthetic */ boolean lambda$collideWithNearbyEntities$0(Entity parent, Entity entity) {
        return entity != parent && !(entity instanceof EntityMutlipartPart) && entity.func_70104_M();
    }
}

