/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityMyrmexEgg
extends LivingEntity
implements IBlacklistedFromStatues,
IDeadMob {
    private static final DataParameter<Boolean> MYRMEX_TYPE = EntityDataManager.func_187226_a(EntityMyrmexEgg.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MYRMEX_AGE = EntityDataManager.func_187226_a(EntityMyrmexEgg.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MYRMEX_CASTE = EntityDataManager.func_187226_a(EntityMyrmexEgg.class, (IDataSerializer)DataSerializers.field_187192_b);
    public UUID hiveUUID;

    public EntityMyrmexEgg(EntityType t, World worldIn) {
        super(t, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.0);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("Jungle", this.isJungle());
        tag.func_74768_a("MyrmexAge", this.getMyrmexAge());
        tag.func_74768_a("MyrmexCaste", this.getMyrmexCaste());
        tag.func_186854_a("HiveUUID", this.hiveUUID == null ? (this.hiveUUID = UUID.randomUUID()) : this.hiveUUID);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setJungle(tag.func_74767_n("Jungle"));
        this.setMyrmexAge(tag.func_74762_e("MyrmexAge"));
        this.setMyrmexCaste(tag.func_74762_e("MyrmexCaste"));
        this.hiveUUID = tag.func_186857_a("hiveUUID");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(MYRMEX_TYPE, (Object)false);
        this.func_184212_Q().func_187214_a(MYRMEX_AGE, (Object)0);
        this.func_184212_Q().func_187214_a(MYRMEX_CASTE, (Object)0);
    }

    public boolean isJungle() {
        return (Boolean)this.func_184212_Q().func_187225_a(MYRMEX_TYPE);
    }

    public void setJungle(boolean jungle) {
        this.func_184212_Q().func_187227_b(MYRMEX_TYPE, (Object)jungle);
    }

    public int getMyrmexAge() {
        return (Integer)this.func_184212_Q().func_187225_a(MYRMEX_AGE);
    }

    public void setMyrmexAge(int i) {
        this.func_184212_Q().func_187227_b(MYRMEX_AGE, (Object)i);
    }

    public int getMyrmexCaste() {
        return (Integer)this.func_184212_Q().func_187225_a(MYRMEX_CASTE);
    }

    public void setMyrmexCaste(int i) {
        this.func_184212_Q().func_187227_b(MYRMEX_CASTE, (Object)i);
    }

    public boolean canSeeSky() {
        return this.field_70170_p.func_175710_j(this.func_233580_cy_());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.canSeeSky()) {
            this.setMyrmexAge(this.getMyrmexAge() + 1);
        }
        if (this.getMyrmexAge() > IafConfig.myrmexEggTicks) {
            EntityMyrmexBase myrmex;
            this.func_70106_y();
            switch (this.getMyrmexCaste()) {
                default: {
                    myrmex = new EntityMyrmexWorker(IafEntityRegistry.MYRMEX_WORKER, this.field_70170_p);
                    break;
                }
                case 1: {
                    myrmex = new EntityMyrmexSoldier(IafEntityRegistry.MYRMEX_SOLDIER, this.field_70170_p);
                    break;
                }
                case 2: {
                    myrmex = new EntityMyrmexRoyal(IafEntityRegistry.MYRMEX_ROYAL, this.field_70170_p);
                    break;
                }
                case 3: {
                    myrmex = new EntityMyrmexSentinel(IafEntityRegistry.MYRMEX_SENTINEL, this.field_70170_p);
                    break;
                }
                case 4: {
                    myrmex = new EntityMyrmexQueen(IafEntityRegistry.MYRMEX_QUEEN, this.field_70170_p);
                }
            }
            myrmex.setJungleVariant(this.isJungle());
            myrmex.setGrowthStage(0);
            myrmex.func_70080_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            if (myrmex instanceof EntityMyrmexQueen) {
                MyrmexHive hive = new MyrmexHive(this.field_70170_p, this.func_233580_cy_(), 100);
                PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 30.0);
                if (player != null) {
                    hive.hasOwner = true;
                    hive.ownerUUID = player.func_110124_au();
                    if (!this.field_70170_p.field_72995_K) {
                        hive.modifyPlayerReputation(player.func_110124_au(), 100);
                    }
                }
                MyrmexWorldData.addHive(this.field_70170_p, hive);
                myrmex.setHive(hive);
            } else if (MyrmexWorldData.get(this.field_70170_p) != null) {
                MyrmexHive hive = this.hiveUUID == null ? MyrmexWorldData.get(this.field_70170_p).getNearestHive(this.func_233580_cy_(), 400) : MyrmexWorldData.get(this.field_70170_p).getHiveFromUUID(this.hiveUUID);
                if (!this.field_70170_p.field_72995_K && hive != null && Math.sqrt(this.func_70092_e(hive.getCenter().func_177958_n(), hive.getCenter().func_177956_o(), hive.getCenter().func_177952_p())) < 2000.0) {
                    myrmex.setHive(hive);
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)myrmex);
            }
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_(), IafSoundRegistry.DRAGON_HATCH, this.func_184176_by(), 2.5f, 1.0f, false);
        }
    }

    public SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return null;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return ImmutableList.of();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public boolean func_70097_a(DamageSource dmg, float var2) {
        if (dmg == DamageSource.field_76368_d || dmg == DamageSource.field_76379_h) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !dmg.func_76357_e()) {
            this.func_70099_a(this.getItem(), 0.0f);
        }
        this.func_70106_y();
        return super.func_70097_a(dmg, var2);
    }

    private ItemStack getItem() {
        ItemStack egg = new ItemStack((IItemProvider)(this.isJungle() ? IafItemRegistry.MYRMEX_JUNGLE_EGG : IafItemRegistry.MYRMEX_DESERT_EGG), 1);
        CompoundNBT newTag = new CompoundNBT();
        newTag.func_74768_a("EggOrdinal", this.getMyrmexCaste());
        egg.func_77982_d(newTag);
        return egg;
    }

    public boolean func_70104_M() {
        return false;
    }

    public HandSide func_184591_cq() {
        return null;
    }

    protected void func_82167_n(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(PlayerEntity player) {
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public boolean isInNursery() {
        MyrmexHive hive = MyrmexWorldData.get(this.field_70170_p).getNearestHive(this.func_233580_cy_(), 100);
        if (hive != null && hive.getRooms(WorldGenMyrmexHive.RoomType.NURSERY).isEmpty() && hive.getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_233580_cy_()) != null) {
            return false;
        }
        if (hive != null) {
            BlockPos nursery = hive.getRandomRoom(WorldGenMyrmexHive.RoomType.NURSERY, this.func_70681_au(), this.func_233580_cy_());
            return this.func_70092_e(nursery.func_177958_n(), nursery.func_177956_o(), nursery.func_177952_p()) < 2025.0;
        }
        return false;
    }
}

