/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFindHidingSpot;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.MyrmexTrades;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMyrmexSentinel
extends EntityMyrmexBase {
    public static final Animation ANIMATION_GRAB = Animation.create((int)15);
    public static final Animation ANIMATION_NIBBLE = Animation.create((int)10);
    public static final Animation ANIMATION_STING = Animation.create((int)25);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final ResourceLocation DESERT_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_sentinel_desert");
    public static final ResourceLocation JUNGLE_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_sentinel_jungle");
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_sentinel.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_sentinel.png");
    private static final ResourceLocation TEXTURE_DESERT_HIDDEN = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_sentinel_hidden.png");
    private static final ResourceLocation TEXTURE_JUNGLE_HIDDEN = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_sentinel_hidden.png");
    private static final DataParameter<Boolean> HIDING = EntityDataManager.func_187226_a(EntityMyrmexSentinel.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float holdingProgress;
    public float hidingProgress;
    public int visibleTicks = 0;
    public int daylightTicks = 0;

    public EntityMyrmexSentinel(EntityType t, World worldIn) {
        super(t, worldIn);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_SENTINEL.get(1) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_SENTINEL.get(1);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_SENTINEL.get(2) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_SENTINEL.get(2);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 8;
    }

    public Entity getHeldEntity() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_70636_d() {
        double dist;
        boolean hiding;
        super.func_70636_d();
        this.visibleTicks = this.visibleTicks > 0 ? --this.visibleTicks : 0;
        if (this.func_70638_az() != null) {
            this.visibleTicks = 100;
        }
        this.daylightTicks = this.canSeeSky() ? ++this.daylightTicks : 0;
        boolean holding = this.getHeldEntity() != null;
        boolean bl = hiding = this.isHiding() && !this.hasCustomer();
        if (holding || this.isOnResin() || this.func_70638_az() != null || this.visibleTicks > 0) {
            this.setHiding(false);
        }
        if (holding && this.holdingProgress < 20.0f) {
            this.holdingProgress += 1.0f;
        } else if (!holding && this.holdingProgress > 0.0f) {
            this.holdingProgress -= 1.0f;
        }
        if (hiding) {
            this.field_70177_z = this.field_70126_B;
        }
        if (hiding && this.hidingProgress < 20.0f) {
            this.hidingProgress += 1.0f;
        } else if (!hiding && this.hidingProgress > 0.0f) {
            this.hidingProgress -= 1.0f;
        }
        if (this.getHeldEntity() != null) {
            this.setAnimation(ANIMATION_NIBBLE);
            if (this.getAnimationTick() == 5) {
                this.playBiteSound();
                this.getHeldEntity().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() / 6));
            }
        }
        if (this.getAnimation() == ANIMATION_GRAB && this.func_70638_az() != null && this.getAnimationTick() == 7) {
            this.playStingSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() / 2));
                this.func_70638_az().func_184220_m((Entity)this);
            }
        }
        if (this.getAnimation() == ANIMATION_SLASH && this.func_70638_az() != null && this.getAnimationTick() % 5 == 0 && this.getAnimationTick() <= 20) {
            this.playBiteSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() / 4));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && (this.getAnimationTick() == 0 || this.getAnimationTick() == 10)) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && (this.getAnimationTick() == 6 || this.getAnimationTick() == 16) && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 18.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 3));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAIFindHidingSpot(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new MyrmexAILeaveHive(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 4, true, true, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return entity != null && !EntityMyrmexBase.haveSameHive(EntityMyrmexSentinel.this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof IMob);
            }
        }));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIDING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, IafConfig.myrmexBaseAttackStrength * 3.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 12.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        if (this.isHiding()) {
            return this.isJungle() ? TEXTURE_JUNGLE_HIDDEN : TEXTURE_DESERT_HIDDEN;
        }
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.8f;
    }

    @Override
    public int getCasteImportance() {
        return 2;
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("Hiding", this.isHiding());
        tag.func_74768_a("DaylightTicks", this.daylightTicks);
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setHiding(tag.func_74767_n("Hiding"));
        this.daylightTicks = tag.func_74762_e("DaylightTicks");
    }

    @Override
    public boolean shouldLeaveHive() {
        return true;
    }

    @Override
    public boolean shouldEnterHive() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            float radius = 1.25f;
            float extraY = 0.35f;
            if (this.getAnimation() == ANIMATION_GRAB) {
                int modTick = MathHelper.func_76125_a((int)this.getAnimationTick(), (int)0, (int)10);
                radius = 3.25f - (float)modTick * 0.2f;
                extraY = (float)modTick * 0.035f;
            }
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            if (passenger.func_213302_cg() >= 1.75f) {
                extraY = passenger.func_213302_cg() - 2.0f;
            }
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)extraY, this.func_226281_cx_() + extraZ);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if ((double)amount >= 1.0 && !this.func_184188_bt().isEmpty() && this.field_70146_Z.nextInt(2) == 0) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_184210_p();
            }
        }
        this.visibleTicks = 300;
        this.setHiding(false);
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_SLASH && this.getAnimation() != ANIMATION_GRAB && this.getHeldEntity() == null) {
            if (this.func_70681_au().nextInt(2) == 0 && entityIn.func_213311_cf() < 2.0f) {
                this.setAnimation(ANIMATION_GRAB);
            } else {
                this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_SLASH);
            }
            this.visibleTicks = 300;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsGaurding() {
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_SLASH, ANIMATION_STING, ANIMATION_GRAB, ANIMATION_NIBBLE};
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.getHeldEntity() == null && !this.isHiding();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean isHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(HIDING);
    }

    public void setHiding(boolean hiding) {
        this.field_70180_af.func_187227_b(HIDING, (Object)hiding);
    }

    public int func_213708_dV() {
        return 0;
    }

    public boolean func_213705_dZ() {
        return false;
    }
}

