/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.entity.EntityDeathwormPart;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentBubbles;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIWatchClosestIgnoreRider;
import com.github.alexthe666.iceandfire.entity.ai.FlyingAITarget;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIGetInWater;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntitySeaSerpent
extends AnimalEntity
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)40);
    public static final int TIME_BETWEEN_JUMPS = 170;
    public static final int TIME_BETWEEN_ROARS = 300;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> JUMPING = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BREATHING = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANCIENT = EntityDataManager.func_187226_a(EntitySeaSerpent.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final com.google.common.base.Predicate NOT_SEA_SERPENT = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof LivingEntity && !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive((LivingEntity)entity);
        }
    };
    public int swimCycle;
    public float orbitRadius = 0.0f;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer roll_buffer;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer tail_buffer;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer head_buffer;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer pitch_buffer;
    @Nullable
    public BlockPos orbitPos = null;
    public float jumpProgress = 0.0f;
    public float wantJumpProgress = 0.0f;
    public float jumpRot = 0.0f;
    public float breathProgress = 0.0f;
    public boolean attackDecision = false;
    private int animationTick;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[9];
    private float lastScale;
    private boolean isLandNavigator;
    private SwimBehavior swimBehavior = SwimBehavior.WANDER;
    private boolean changedSwimBehavior = false;
    private int ticksCircling;
    private boolean isArcing = false;
    private float arcingYAdditive = 0.0f;
    private int ticksSinceJump = 1000;
    private int ticksSinceRoar = 0;
    private int ticksJumping = 0;
    private boolean isBreathing;

    public EntitySeaSerpent(EntityType t, World worldIn) {
        super(t, worldIn);
        this.switchNavigator(true);
        this.field_70158_ak = true;
        this.resetParts(1.0f);
        if (worldIn.field_72995_K) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.tail_buffer = new IFChainBuffer();
            this.head_buffer = new IFChainBuffer();
        }
    }

    public static BlockPos getPositionRelativeToSeafloor(EntitySeaSerpent entity, World world, double x, double z, Random rand) {
        BlockPos topY = new BlockPos(x, entity.func_226278_cu_(), z);
        BlockPos bottomY = new BlockPos(x, entity.func_226278_cu_(), z);
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.func_177956_o() < world.func_217301_I()) {
            topY = topY.func_177984_a();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        if (entity.ticksSinceJump > 170) {
            return topY.func_177981_b((int)Math.ceil(3.0f * entity.getSeaSerpentScale()));
        }
        if (entity.ticksSinceRoar > 300 || entity.getAnimation() == ANIMATION_ROAR) {
            return topY.func_177977_b();
        }
        for (int tries = 0; tries < 5; ++tries) {
            BlockPos pos = new BlockPos(x, (double)(bottomY.func_177956_o() + 1 + rand.nextInt(Math.max(1, topY.func_177956_o() - bottomY.func_177956_o() - 2))), z);
            if (!EntitySeaSerpent.isWaterBlock(world, pos)) continue;
            return pos;
        }
        return entity.func_233580_cy_();
    }

    public static BlockPos getPositionInOrbit(EntitySeaSerpent entity, World world, BlockPos orbit, Random rand) {
        float possibleOrbitRadius = entity.orbitRadius + 10.0f;
        float radius = 5.0f * entity.getSeaSerpentScale();
        float angle = (float)Math.PI / 180 * possibleOrbitRadius;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos((double)orbit.func_177958_n() + extraX, (double)orbit.func_177956_o(), (double)orbit.func_177952_p() + extraZ);
        entity.orbitRadius = possibleOrbitRadius;
        return radialPos;
    }

    public static BlockPos getPositionPreyArc(EntitySeaSerpent entity, BlockPos target, World world) {
        float radius = 10.0f * entity.getSeaSerpentScale();
        entity.field_70761_aq = entity.field_70177_z;
        float angle = (float)Math.PI / 180 * entity.field_70761_aq;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double signum = Math.signum((double)((float)target.func_177956_o() + 0.5f) - entity.func_226278_cu_());
        BlockPos pos = new BlockPos((double)target.func_177958_n() + extraX, (double)target.func_177956_o() + (double)entity.field_70146_Z.nextInt(5) * signum, (double)target.func_177952_p() + extraZ);
        entity.isArcing = true;
        return EntitySeaSerpent.clampBlockPosToWater((Entity)entity, world, pos);
    }

    private static BlockPos clampBlockPosToWater(Entity entity, World world, BlockPos pos) {
        BlockPos topY = new BlockPos((double)pos.func_177958_n(), entity.func_226278_cu_(), (double)pos.func_177952_p());
        BlockPos bottomY = new BlockPos((double)pos.func_177958_n(), entity.func_226278_cu_(), (double)pos.func_177952_p());
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.func_177956_o() < world.func_217301_I()) {
            topY = topY.func_177984_a();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        return new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)(bottomY.func_177956_o() + 1), (int)(topY.func_177956_o() - 1)), pos.func_177952_p());
    }

    public static boolean isWaterBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SeaSerpentAIGetInWater(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new AISwimWander());
        this.field_70714_bg.func_75776_a(1, (Goal)new AISwimBite());
        this.field_70714_bg.func_75776_a(1, (Goal)new AISwimCircle());
        this.field_70714_bg.func_75776_a(2, (Goal)new SeaSerpentAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new EntityAIWatchClosestIgnoreRider((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new FlyingAITarget((MobEntity)this, LivingEntity.class, 150, true, false, NOT_SEA_SERPENT));
        this.field_70715_bh.func_75776_a(3, (Goal)new FlyingAITarget((MobEntity)this, PlayerEntity.class, 0, true, false, NOT_SEA_SERPENT));
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.isAncient() ? 30 : 15;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.field_70699_by.func_212239_d(true);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper(this);
            this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean isDirectPathBetweenPoints(BlockPos pos) {
        Vector3d bector3d1;
        Vector3d vector3d = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, bector3d1 = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.hydraMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, (double)Math.min(2048, IafConfig.dragonTargetSearchLength)).func_233815_a_(Attributes.field_233826_i_, 3.0);
    }

    public void resetParts(float scale) {
        this.clearParts();
        this.segments = new EntityMutlipartPart[9];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = i > 3 ? new EntityDeathwormPart((LivingEntity)this, (2.0f - (float)(i + 1) * 0.55f) * scale, 0.0f, 0.0f, 0.5f * scale, 0.5f * scale, 1.0f) : new EntityDeathwormPart((LivingEntity)this, (1.8f - (float)i * 0.5f) * scale, 0.0f, 0.0f, 0.45f * scale, 0.4f * scale, 1.0f);
        }
    }

    public void onUpdateParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.setParent((LivingEntity)this);
            if (entity.shouldContinuePersisting()) continue;
            this.field_70170_p.func_217376_c((Entity)entity);
        }
    }

    private void clearParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_70106_y();
        }
    }

    public void func_70106_y() {
        this.clearParts();
        super.func_70106_y();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
    }

    public float func_213355_cm() {
        return this.getSeaSerpentScale();
    }

    public void func_213323_x_() {
        super.func_213323_x_();
        float scale = this.getSeaSerpentScale();
        double prevX = this.func_226277_ct_();
        double prevY = this.func_226278_cu_();
        double prevZ = this.func_226281_cx_();
        float localWidth = this.func_213311_cf();
        if (!(this.func_213311_cf() > localWidth) || this.field_70148_d || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
        if (scale != this.lastScale) {
            this.resetParts(this.getSeaSerpentScale());
        }
        this.lastScale = scale;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213323_x_();
        this.onUpdateParts();
        if (this.func_70090_H()) {
            this.spawnParticlesAroundEntity((IParticleData)ParticleTypes.field_197612_e, (Entity)this, (int)this.getSeaSerpentScale());
            for (EntityMutlipartPart entity : this.segments) {
                this.spawnParticlesAroundEntity((IParticleData)ParticleTypes.field_197612_e, entity, (int)this.getSeaSerpentScale());
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private void spawnParticlesAroundEntity(IParticleData type, Entity entity, int count) {
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            double x = entity.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf();
            if (this.field_70170_p.func_180495_p(new BlockPos(x, y = entity.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * entity.func_213302_cg()), z = entity.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf())).func_185904_a() != Material.field_151586_h) continue;
            this.field_70170_p.func_195594_a(type, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void spawnSlamParticles(IParticleData type) {
        int i = 0;
        while ((float)i < this.getSeaSerpentScale() * 3.0f) {
            for (int i1 = 0; i1 < 20; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = 1.25f * this.getSeaSerpentScale();
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                if (!this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195590_a(type, true, this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(JUMPING, (Object)false);
        this.field_70180_af.func_187214_a(BREATHING, (Object)false);
        this.field_70180_af.func_187214_a(ANCIENT, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("TicksSinceRoar", this.ticksSinceRoar);
        compound.func_74776_a("Scale", this.getSeaSerpentScale());
        compound.func_74757_a("JumpingOutOfWater", this.isJumpingOutOfWater());
        compound.func_74757_a("AttackDecision", this.attackDecision);
        compound.func_74757_a("Breathing", this.isBreathing());
        compound.func_74757_a("Ancient", this.isAncient());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.ticksSinceRoar = compound.func_74762_e("TicksSinceRoar");
        this.setSeaSerpentScale(compound.func_74760_g("Scale"));
        this.setJumpingOutOfWater(compound.func_74767_n("JumpingOutOfWater"));
        this.attackDecision = compound.func_74767_n("AttackDecision");
        this.setBreathing(compound.func_74767_n("Breathing"));
        this.setAncient(compound.func_74767_n("Ancient"));
    }

    private void updateAttributes() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(Math.min(0.25, 0.15 * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(Math.max(4.0, IafConfig.seaSerpentAttackStrength * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(Math.max(10.0, IafConfig.seaSerpentBaseHealth * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)Math.min(2048, IafConfig.dragonTargetSearchLength));
        this.func_70691_i(30.0f * this.getSeaSerpentScale());
    }

    private float getAncientModifier() {
        return this.isAncient() ? 1.5f : 1.0f;
    }

    public float getSeaSerpentScale() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue()).floatValue();
    }

    private void setSeaSerpentScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean isJumpingOutOfWater() {
        return (Boolean)this.field_70180_af.func_187225_a(JUMPING);
    }

    public void setJumpingOutOfWater(boolean jump) {
        this.field_70180_af.func_187227_b(JUMPING, (Object)jump);
    }

    public boolean isAncient() {
        return (Boolean)this.field_70180_af.func_187225_a(ANCIENT);
    }

    public void setAncient(boolean ancient) {
        this.field_70180_af.func_187227_b(ANCIENT, (Object)ancient);
    }

    public boolean isBreathing() {
        if (this.field_70170_p.field_72995_K) {
            boolean breathing;
            this.isBreathing = breathing = ((Boolean)this.field_70180_af.func_187225_a(BREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathing;
    }

    public void setBreathing(boolean breathing) {
        this.field_70180_af.func_187227_b(BREATHING, (Object)breathing);
        if (!this.field_70170_p.field_72995_K) {
            this.isBreathing = breathing;
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.isJumpingOutOfWater() && !this.shouldStopJumping()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.08, 0.0));
            }
            if (this.isJumpingOutOfWater() && this.swimBehavior == SwimBehavior.WANDER && this.shouldStopJumping() && this.func_70090_H()) {
                this.setJumpingOutOfWater(false);
                this.ticksSinceJump = 0;
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
                this.func_70624_b(null);
            }
        }
        boolean breathing = this.isBreathing() && this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_ROAR;
        boolean jumping = !this.func_70090_H() && !this.func_233570_aj_() && this.func_213322_ci().field_72448_b >= 0.0;
        boolean wantJumping = false;
        boolean ground = !this.func_70090_H() && this.field_70122_E;
        boolean prevJumping = this.isJumpingOutOfWater();
        ++this.ticksSinceRoar;
        ++this.ticksSinceJump;
        if (this.ticksSinceRoar > 300 && this.isAtSurface() && this.getAnimation() != ANIMATION_BITE && this.jumpProgress == 0.0f && !this.isJumpingOutOfWater()) {
            this.setAnimation(ANIMATION_ROAR);
            this.ticksSinceRoar = 0;
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 1) {
            this.func_184185_a(IafSoundRegistry.SEA_SERPENT_ROAR, this.func_70599_aP() + 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.SEA_SERPENT_BITE, this.func_70599_aP(), 1.0f);
        }
        this.ticksJumping = this.isJumpingOutOfWater() ? ++this.ticksJumping : 0;
        if (this.isJumpingOutOfWater() && EntitySeaSerpent.isWaterBlock(this.field_70170_p, this.func_233580_cy_().func_177981_b(2))) {
            this.setJumpingOutOfWater(false);
        }
        if (!(this.isJumpingOutOfWater() || EntitySeaSerpent.isWaterBlock(this.field_70170_p, this.func_233580_cy_().func_177984_a()) || this.ticksSinceJump <= 170 && this.func_70638_az() == null)) {
            this.ticksSinceJump = 0;
            this.setJumpingOutOfWater(true);
        }
        this.swimCycle = this.swimCycle < 38 ? (this.swimCycle += 2) : 0;
        if (breathing && this.breathProgress < 20.0f) {
            this.breathProgress += 0.5f;
        } else if (!breathing && this.breathProgress > 0.0f) {
            this.breathProgress -= 0.5f;
        }
        if (jumping && this.jumpProgress < 10.0f) {
            this.jumpProgress += 0.5f;
        } else if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 0.5f;
        }
        if (wantJumping && this.wantJumpProgress < 10.0f) {
            this.wantJumpProgress += 2.0f;
        } else if (!wantJumping && this.wantJumpProgress > 0.0f) {
            this.wantJumpProgress -= 2.0f;
        }
        if (this.isJumpingOutOfWater() && this.jumpRot < 1.0f) {
            this.jumpRot += 0.1f;
        } else if (!this.isJumpingOutOfWater() && this.jumpRot > 0.0f) {
            this.jumpRot -= 0.1f;
        }
        if (prevJumping != this.isJumpingOutOfWater() && !this.isJumpingOutOfWater()) {
            this.func_184185_a(IafSoundRegistry.SEA_SERPENT_SPLASH, 5.0f, 0.75f);
            this.func_184185_a(SoundEvents.field_187539_bB, 5.0f, 0.75f);
            this.spawnSlamParticles((IParticleData)ParticleTypes.field_197612_e);
            this.spawnSlamParticles((IParticleData)ParticleTypes.field_197612_e);
            this.spawnSlamParticles((IParticleData)ParticleTypes.field_197612_e);
            this.spawnSlamParticles((IParticleData)ParticleTypes.field_197612_e);
            this.doSplashDamage();
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.field_70761_aq = this.field_70177_z;
        this.field_70125_A = MathHelper.func_76131_a((float)((float)this.func_213322_ci().field_72448_b * 20.0f), (float)-90.0f, (float)90.0f);
        if (this.field_70170_p.field_72995_K) {
            this.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 10.0f, 0.5f, (LivingEntity)this);
            if (!jumping) {
                this.tail_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (LivingEntity)this);
                this.head_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (LivingEntity)this);
            }
        }
        if (this.changedSwimBehavior) {
            this.changedSwimBehavior = false;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackDecision) {
                this.setBreathing(false);
            }
            if (this.func_70638_az() != null && this.getAnimation() != ANIMATION_ROAR) {
                if (!this.attackDecision) {
                    if (!this.func_70638_az().func_70090_H() || !this.func_70685_l((Entity)this.func_70638_az()) || this.func_70068_e((Entity)this.func_70638_az()) < (double)(30.0f * this.getSeaSerpentScale())) {
                        this.attackDecision = true;
                    }
                    if (!this.attackDecision) {
                        this.shoot(this.func_70638_az());
                    }
                } else if (this.func_70068_e((Entity)this.func_70638_az()) > (double)(200.0f * this.getSeaSerpentScale())) {
                    this.attackDecision = false;
                }
            } else {
                this.setBreathing(false);
            }
            this.ticksCircling = this.swimBehavior == SwimBehavior.CIRCLE ? ++this.ticksCircling : 0;
            if (this.func_70638_az() != null) {
                this.swimBehavior = this.func_70090_H() ? (this.attackDecision ? (this.isPreyAtSurface() && this.func_70068_e((Entity)this.func_70638_az()) < (double)(200.0f * this.getSeaSerpentScale()) && this.ticksSinceJump > 170 ? SwimBehavior.JUMP : SwimBehavior.ATTACK) : SwimBehavior.ATTACK) : (this.field_70122_E ? SwimBehavior.ATTACK : SwimBehavior.WANDER);
            } else if (this.swimBehavior == SwimBehavior.JUMP && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > (double)(200.0f * this.getSeaSerpentScale())) {
                this.swimBehavior = SwimBehavior.WANDER;
                this.ticksSinceJump = 0;
                this.setJumpingOutOfWater(false);
            }
            if (this.swimBehavior != SwimBehavior.JUMP && this.swimBehavior != SwimBehavior.ATTACK && this.ticksSinceJump > 170) {
                this.swimBehavior = SwimBehavior.JUMP;
            }
            if (this.swimBehavior != SwimBehavior.ATTACK) {
                this.arcingYAdditive = 0.0f;
            }
            if (this.swimBehavior == SwimBehavior.JUMP && this.func_213322_ci().field_72448_b < 0.0 && !this.func_70090_H()) {
                this.swimBehavior = SwimBehavior.WANDER;
                this.ticksSinceJump = 0;
                this.setJumpingOutOfWater(false);
            }
            if (this.swimBehavior == SwimBehavior.ATTACK && this.func_70638_az() != null && !this.func_70638_az().func_70090_H()) {
                this.swimBehavior = SwimBehavior.WANDER;
                this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 360.0f);
            }
            if (!(this.swimBehavior != SwimBehavior.ATTACK || this.func_70638_az() != null && this.isDirectPathBetweenPoints(this.func_70638_az().func_233580_cy_()))) {
                this.swimBehavior = SwimBehavior.WANDER;
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && (this.isTouchingMob((Entity)this.func_70638_az()) || this.func_70068_e((Entity)this.func_70638_az()) < 50.0)) {
            this.hurtMob(this.func_70638_az());
        }
        this.breakBlock();
        if (!this.field_70170_p.field_72995_K && this.func_184218_aH() && this.func_184208_bv() instanceof BoatEntity) {
            BoatEntity boat = (BoatEntity)this.func_184208_bv();
            boat.func_70106_y();
            this.func_184210_p();
        }
    }

    private void doSplashDamage() {
        double getWidth = 2.0 * (double)this.getSeaSerpentScale();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(getWidth, getWidth * 0.5, getWidth), (Predicate)NOT_SEA_SERPENT);
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            this.destroyBoat(entity);
            double xRatio = this.func_226277_ct_() - entity.func_226277_ct_();
            double zRatio = this.func_226281_cx_() - entity.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            float strength = 0.3f * this.getSeaSerpentScale();
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(xRatio / (double)f * (double)strength, (double)strength, zRatio / (double)f * (double)strength));
        }
    }

    public void destroyBoat(Entity sailor) {
        if (sailor.func_184187_bx() != null && sailor.func_184187_bx() instanceof BoatEntity && !this.field_70170_p.field_72995_K) {
            BoatEntity boat = (BoatEntity)sailor.func_184187_bx();
            boat.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                for (int i = 0; i < 3; ++i) {
                    boat.func_70099_a(new ItemStack((IItemProvider)Item.func_150898_a((Block)boat.func_184453_r().func_195933_b())), 0.0f);
                }
                for (int j = 0; j < 2; ++j) {
                    boat.func_199701_a_(new ItemStack((IItemProvider)Items.field_151055_y));
                }
            }
        }
    }

    private boolean isPreyAtSurface() {
        if (this.func_70638_az() != null) {
            BlockPos pos = this.func_70638_az().func_233580_cy_();
            return !EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177981_b((int)Math.ceil(this.func_70638_az().func_213302_cg())));
        }
        return false;
    }

    private void hurtMob(LivingEntity entity) {
        if (this.getAnimation() == ANIMATION_BITE && entity != null && this.getAnimationTick() > 6) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            this.attackDecision = this.func_70681_au().nextBoolean();
        }
    }

    public void moveJumping() {
        float velocity = 0.5f;
        double x = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        double z = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180)));
        float f = MathHelper.func_76133_a((double)(x * x + z * z));
        x /= (double)f;
        z /= (double)f;
        this.func_213293_j(x *= (double)velocity, this.func_213322_ci().field_72448_b, z *= (double)velocity);
    }

    private boolean isTouchingMob(Entity entity) {
        if (this.func_174813_aQ().func_72321_a((double)(this.getSeaSerpentScale() * 3.0f), (double)(this.getSeaSerpentScale() * 3.0f), (double)(this.getSeaSerpentScale() * 3.0f)).func_72326_a(entity.func_174813_aQ())) {
            return true;
        }
        for (EntityMutlipartPart segment : this.segments) {
            if (!segment.func_174813_aQ().func_72321_a((double)(this.getSeaSerpentScale() * 2.0f), (double)(this.getSeaSerpentScale() * 2.0f), (double)(this.getSeaSerpentScale() * 2.0f)).func_72326_a(entity.func_174813_aQ())) continue;
            return true;
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void breakBlock() {
        if (IafConfig.seaSerpentGriefing) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 2; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 2; ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) - 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 2; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 2; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        FluidState fluidState = this.field_70170_p.func_204610_c(pos);
                        Block block = state.func_177230_c();
                        if (state.func_196958_f() || state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() || state.func_185904_a() != Material.field_151585_k && state.func_185904_a() != Material.field_151584_j || !fluidState.func_206888_e() || block == Blocks.field_150350_a || this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        boolean ancient;
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(7));
        boolean bl = ancient = this.func_70681_au().nextInt(16) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + this.func_70681_au().nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + this.func_70681_au().nextFloat() * 4.0f);
        }
        return spawnDataIn;
    }

    public void onWorldSpawn(Random random) {
        boolean ancient;
        this.setVariant(random.nextInt(6));
        boolean bl = ancient = random.nextInt(15) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + random.nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + random.nextFloat() * 4.0f);
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_ROAR, ANIMATION_SPEAK};
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.SEA_SERPENT_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.SEA_SERPENT_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.SEA_SERPENT_DIE;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    private boolean canMove() {
        return true;
    }

    public boolean wantsToJump() {
        return this.ticksSinceJump > 170 && this.swimBehavior == SwimBehavior.JUMP;
    }

    private boolean shouldStopJumping() {
        return this.ticksJumping > 30 || !EntitySeaSerpent.isWaterBlock(this.field_70170_p, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_233580_cy_()).func_177979_c(1));
    }

    public boolean isAtSurface() {
        BlockPos pos = this.func_233580_cy_();
        return EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177977_b()) && !EntitySeaSerpent.isWaterBlock(this.field_70170_p, pos.func_177984_a());
    }

    private void shoot(LivingEntity entity) {
        if (!this.attackDecision) {
            if (!this.func_70090_H()) {
                this.setBreathing(false);
                this.attackDecision = true;
            }
            if (this.isBreathing()) {
                if (this.field_70173_aa % 40 == 0) {
                    this.func_184185_a(IafSoundRegistry.SEA_SERPENT_BREATH, 4.0f, 1.0f);
                }
                if (this.field_70173_aa % 5 == 0) {
                    this.field_70177_z = this.field_70761_aq;
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float headPosX = f1 + (float)(this.segments[0].func_226277_ct_() + (double)(0.3f * this.getSeaSerpentScale()) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = f2 + (float)(this.segments[0].func_226281_cx_() + (double)(0.3f * this.getSeaSerpentScale()) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = f3 + (float)(this.segments[0].func_226278_cu_() + (double)(0.2f * this.getSeaSerpentScale()));
                    double d2 = entity.func_226277_ct_() - (double)headPosX;
                    double d3 = entity.func_226278_cu_() - (double)headPosY;
                    double d4 = entity.func_226281_cx_() - (double)headPosZ;
                    float inaccuracy = 1.0f;
                    EntitySeaSerpentBubbles entitylargefireball = new EntitySeaSerpentBubbles(IafEntityRegistry.SEA_SERPENT_BUBBLES, this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    float size = 0.8f;
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                    }
                    if (!entity.func_70089_S() || entity == null) {
                        this.setBreathing(false);
                        this.attackDecision = this.func_70681_au().nextBoolean();
                    }
                }
            } else {
                this.setBreathing(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    public EnumSeaSerpent getEnum() {
        switch (this.getVariant()) {
            default: {
                return EnumSeaSerpent.BLUE;
            }
            case 1: {
                return EnumSeaSerpent.BRONZE;
            }
            case 2: {
                return EnumSeaSerpent.DEEPBLUE;
            }
            case 3: {
                return EnumSeaSerpent.GREEN;
            }
            case 4: {
                return EnumSeaSerpent.PURPLE;
            }
            case 5: {
                return EnumSeaSerpent.RED;
            }
            case 6: 
        }
        return EnumSeaSerpent.TEAL;
    }

    public void func_213352_e(Vector3d vec) {
        if (this.swimBehavior == SwimBehavior.JUMP && this.isJumpingOutOfWater() && this.func_70638_az() == null) {
            this.moveJumping();
        }
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_213309_a(0.1f, vec);
                float f4 = 0.6f;
                float d0 = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)f4 * 0.9, (double)f4 * 0.9, (double)f4 * 0.9));
            } else {
                super.func_213352_e(vec);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.func_226277_ct_() - this.field_70169_q;
        double deltaZ = this.func_226281_cx_() - this.field_70166_s;
        double deltaY = this.func_226278_cu_() - this.field_70167_r;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        this.attackDecision = this.func_70681_au().nextBoolean();
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public int func_82143_as() {
        return 1000;
    }

    class AISwimBite
    extends Goal {
        public int max_distance = 1000;
        BlockPos target;
        boolean secondPhase = false;
        boolean isOver = false;

        public void func_75251_c() {
            this.target = null;
            this.secondPhase = false;
            this.isOver = false;
            EntitySeaSerpent.this.isArcing = false;
            EntitySeaSerpent.this.arcingYAdditive = 0.0f;
        }

        public boolean func_75250_a() {
            if (!EntitySeaSerpent.this.attackDecision && EntitySeaSerpent.this.func_70638_az() != null && EntitySeaSerpent.this.func_70068_e((Entity)EntitySeaSerpent.this.func_70638_az()) < 300.0) {
                return false;
            }
            if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.ATTACK && EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP || !EntitySeaSerpent.this.canMove() || EntitySeaSerpent.this.func_70638_az() == null) {
                return false;
            }
            if (EntitySeaSerpent.this.func_70090_H() && EntitySeaSerpent.this.func_70638_az() != null) {
                this.target = EntitySeaSerpent.this.func_70638_az().func_233580_cy_();
                EntitySeaSerpent.this.orbitPos = null;
                this.secondPhase = false;
                EntitySeaSerpent.this.isArcing = false;
                return true;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            return true;
        }

        public boolean func_75253_b() {
            if (this.isOver) {
                return false;
            }
            if (!EntitySeaSerpent.this.attackDecision && EntitySeaSerpent.this.func_70638_az() != null && EntitySeaSerpent.this.func_70068_e((Entity)EntitySeaSerpent.this.func_70638_az()) < 300.0) {
                this.func_75251_c();
                return false;
            }
            if (this.secondPhase) {
                if (EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.func_70092_e(this.target.func_177958_n(), this.target.func_177956_o(), this.target.func_177952_p()) > (double)this.max_distance || this.isOver) {
                    EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                    this.func_75251_c();
                    return false;
                }
                return true;
            }
            return EntitySeaSerpent.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) {
                if (EntitySeaSerpent.this.func_70638_az() != null && EntitySeaSerpent.this.func_70090_H()) {
                    this.target = EntitySeaSerpent.this.func_70638_az().func_233580_cy_().func_177981_b((int)Math.ceil(3.0f * EntitySeaSerpent.this.getSeaSerpentScale()));
                }
            } else {
                if (EntitySeaSerpent.this.func_70638_az() == null || !EntitySeaSerpent.this.func_70638_az().func_70089_S()) {
                    this.secondPhase = true;
                } else {
                    double d0 = EntitySeaSerpent.this.func_70638_az().func_226277_ct_() - EntitySeaSerpent.this.func_226277_ct_();
                    double d1 = EntitySeaSerpent.this.func_70638_az().func_226281_cx_() - EntitySeaSerpent.this.func_226281_cx_();
                    double d2 = d0 * d0 + d1 * d1;
                    d2 = MathHelper.func_76133_a((double)d2);
                    EntitySeaSerpent.this.arcingYAdditive = (float)(this.secondPhase ? 1 : -1) * (float)d2;
                }
                if (!this.secondPhase) {
                    this.target = EntitySeaSerpent.this.func_70638_az().func_233580_cy_();
                    if (!EntitySeaSerpent.this.attackDecision) {
                        if (EntitySeaSerpent.this.func_70638_az() != null) {
                            if (EntitySeaSerpent.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) > (double)(10.0f * EntitySeaSerpent.this.getSeaSerpentScale())) {
                                EntitySeaSerpent.this.setBreathing(true);
                            } else {
                                EntitySeaSerpent.this.attackDecision = true;
                            }
                        }
                    } else {
                        if (EntitySeaSerpent.this.func_70638_az() != null && (EntitySeaSerpent.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < (double)(30.0f * EntitySeaSerpent.this.getSeaSerpentScale()) || EntitySeaSerpent.this.isTouchingMob((Entity)EntitySeaSerpent.this.func_70638_az()))) {
                            EntitySeaSerpent.this.setAnimation(ANIMATION_BITE);
                        }
                        if (EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < (double)(30.0f * EntitySeaSerpent.this.getSeaSerpentScale())) {
                            this.target = null;
                            this.secondPhase = true;
                        }
                    }
                }
                if (this.secondPhase && EntitySeaSerpent.this.func_70638_az() != null) {
                    if (EntitySeaSerpent.this.func_70068_e((Entity)EntitySeaSerpent.this.func_70638_az()) > (double)this.max_distance || this.target != null && EntitySeaSerpent.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 5.0) {
                        this.func_75251_c();
                        this.isOver = true;
                    } else {
                        this.target = EntitySeaSerpent.getPositionPreyArc(EntitySeaSerpent.this, EntitySeaSerpent.this.func_70638_az().func_233580_cy_(), EntitySeaSerpent.this.field_70170_p);
                    }
                }
            }
            if (this.target != null && (EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, this.target) || EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP)) {
                EntitySeaSerpent.this.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.5);
                if (EntitySeaSerpent.this.func_70638_az() == null) {
                    EntitySeaSerpent.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AISwimCircle
    extends Goal {
        BlockPos target;

        public boolean func_75250_a() {
            if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.CIRCLE || !EntitySeaSerpent.this.canMove()) {
                return false;
            }
            if (!EntitySeaSerpent.this.func_70605_aq().func_75640_a()) {
                EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                return false;
            }
            if (EntitySeaSerpent.this.func_70090_H() && !EntitySeaSerpent.this.isJumpingOutOfWater()) {
                BlockPos gen = this.generateTarget();
                if (gen != null) {
                    EntitySeaSerpent.this.orbitPos = gen;
                    this.target = EntitySeaSerpent.getPositionInOrbit(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.orbitPos, EntitySeaSerpent.this.field_70146_Z);
                    return EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target);
                }
                EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
            }
            return false;
        }

        protected BlockPos generateTarget() {
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = EntitySeaSerpent.getPositionRelativeToSeafloor(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.func_226277_ct_() + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.func_226281_cx_() + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.field_70146_Z);
                if (!EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, pos) || !EntitySeaSerpent.this.isDirectPathBetweenPoints(pos)) continue;
                return pos;
            }
            return null;
        }

        public boolean func_75253_b() {
            if (this.target != null && !EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target)) {
                return false;
            }
            return EntitySeaSerpent.this.func_70638_az() == null && EntitySeaSerpent.this.swimBehavior == SwimBehavior.CIRCLE;
        }

        public void func_75246_d() {
            if (EntitySeaSerpent.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 25.0) {
                this.target = EntitySeaSerpent.getPositionInOrbit(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.orbitPos, EntitySeaSerpent.this.field_70146_Z);
            }
            if (EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, this.target) && EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target)) {
                EntitySeaSerpent.this.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntitySeaSerpent.this.func_70638_az() == null) {
                    EntitySeaSerpent.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    public class AISwimWander
    extends Goal {
        BlockPos target;

        public boolean func_75250_a() {
            BlockPos gen;
            if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.WANDER && EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP || !EntitySeaSerpent.this.canMove() || EntitySeaSerpent.this.func_70638_az() != null) {
                return false;
            }
            if (EntitySeaSerpent.this.func_70090_H() && (gen = this.generateTarget()) != null) {
                this.target = gen;
                EntitySeaSerpent.this.orbitPos = null;
                return EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP || !EntitySeaSerpent.this.func_70605_aq().func_75640_a();
            }
            return false;
        }

        protected BlockPos generateTarget() {
            if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) {
                BlockPos pos = EntitySeaSerpent.getPositionRelativeToSeafloor(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.func_226277_ct_(), EntitySeaSerpent.this.func_226281_cx_(), EntitySeaSerpent.this.field_70146_Z);
                return pos.func_177981_b(3 * (int)Math.ceil(EntitySeaSerpent.this.getSeaSerpentScale()));
            }
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = EntitySeaSerpent.getPositionRelativeToSeafloor(EntitySeaSerpent.this, EntitySeaSerpent.this.field_70170_p, EntitySeaSerpent.this.func_226277_ct_() + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.func_226281_cx_() + (double)EntitySeaSerpent.this.field_70146_Z.nextInt(30) - 15.0, EntitySeaSerpent.this.field_70146_Z);
                if ((!EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, pos) || !EntitySeaSerpent.this.isDirectPathBetweenPoints(pos)) && EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP) continue;
                return pos;
            }
            return null;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            return true;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            if (this.target == null) {
                this.target = this.generateTarget();
            }
            if (this.target != null && (EntitySeaSerpent.isWaterBlock(EntitySeaSerpent.this.field_70170_p, this.target) || EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) && EntitySeaSerpent.this.isDirectPathBetweenPoints(this.target)) {
                EntitySeaSerpent.this.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntitySeaSerpent.this.func_70638_az() == null) {
                    EntitySeaSerpent.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    public class SwimmingMoveHelper
    extends MovementController {
        private final EntitySeaSerpent dolphin;

        public SwimmingMoveHelper(EntitySeaSerpent dolphinIn) {
            super((MobEntity)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                int dist;
                double d0 = this.field_75646_b - EntitySeaSerpent.this.func_226277_ct_();
                double d1 = this.field_75647_c - EntitySeaSerpent.this.func_226278_cu_();
                double d2 = this.field_75644_d - EntitySeaSerpent.this.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < 6.0 && EntitySeaSerpent.this.func_70638_az() == null) {
                    if (!EntitySeaSerpent.this.changedSwimBehavior && EntitySeaSerpent.this.swimBehavior == SwimBehavior.WANDER && EntitySeaSerpent.this.field_70146_Z.nextInt(20) == 0) {
                        EntitySeaSerpent.this.swimBehavior = SwimBehavior.CIRCLE;
                        EntitySeaSerpent.this.changedSwimBehavior = true;
                    }
                    if (!EntitySeaSerpent.this.changedSwimBehavior && EntitySeaSerpent.this.swimBehavior == SwimBehavior.CIRCLE && EntitySeaSerpent.this.field_70146_Z.nextInt(5) == 0 && EntitySeaSerpent.this.ticksCircling > 150) {
                        EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                        EntitySeaSerpent.this.changedSwimBehavior = true;
                    }
                }
                if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP && !EntitySeaSerpent.this.func_70090_H() && !EntitySeaSerpent.this.field_70122_E) {
                    EntitySeaSerpent.this.ticksSinceJump = 0;
                }
                int n = dist = EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP ? 10 : 3;
                if (d3 < (double)dist && EntitySeaSerpent.this.func_70638_az() == null || EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP && EntitySeaSerpent.this.shouldStopJumping() && EntitySeaSerpent.this.func_70638_az() == null) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntitySeaSerpent.this.func_213317_d(EntitySeaSerpent.this.func_213322_ci().func_216372_d(0.5, 1.0, 0.5).func_72441_c(0.0, (double)-0.08f, 0.0));
                    if (EntitySeaSerpent.this.swimBehavior == SwimBehavior.JUMP) {
                        EntitySeaSerpent.this.swimBehavior = SwimBehavior.WANDER;
                        EntitySeaSerpent.this.ticksSinceJump = 0;
                        EntitySeaSerpent.this.setJumpingOutOfWater(false);
                    }
                } else {
                    float f1;
                    EntitySeaSerpent.this.func_213317_d(EntitySeaSerpent.this.func_213322_ci().func_72441_c(d0 / d3 * 0.5 * this.field_75645_e, d1 / d3 * 0.5 * this.field_75645_e, d2 / d3 * 0.5 * this.field_75645_e));
                    EntitySeaSerpent.this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    if (!EntitySeaSerpent.this.isArcing) {
                        if (EntitySeaSerpent.this.func_70638_az() == null) {
                            float f = (float)(MathHelper.func_181159_b((double)d3, (double)d1) * 57.2957763671875) - 90.0f;
                            EntitySeaSerpent.this.field_70761_aq = EntitySeaSerpent.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntitySeaSerpent.this.func_213322_ci().field_72450_a, (double)EntitySeaSerpent.this.func_213322_ci().field_72449_c)) * 57.295776f;
                        } else if (EntitySeaSerpent.this.swimBehavior != SwimBehavior.JUMP) {
                            double d4 = EntitySeaSerpent.this.func_70638_az().func_226277_ct_() - EntitySeaSerpent.this.func_226277_ct_();
                            double d5 = EntitySeaSerpent.this.func_70638_az().func_226281_cx_() - EntitySeaSerpent.this.func_226281_cx_();
                            EntitySeaSerpent.this.field_70761_aq = EntitySeaSerpent.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                        }
                    }
                }
            }
        }
    }

    static enum SwimBehavior {
        CIRCLE,
        WANDER,
        ATTACK,
        JUMP,
        NONE;

    }
}

