/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianFeather;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAIFlee;
import com.github.alexthe666.iceandfire.entity.ai.StymphalianBirdAITarget;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.util.StymphalianBirdFlock;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Predicate;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityStymphalianBird
extends MonsterEntity
implements IAnimatedEntity,
IMob,
IVillagerFear,
IAnimalFear {
    public static final Predicate<Entity> STYMPHALIAN_PREDICATE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityStymphalianBird;
        }
    };
    private static final int FLIGHT_CHANCE_PER_TICK = 100;
    private static final DataParameter<Optional<UUID>> VICTOR_ENTITY = EntityDataManager.func_187226_a(EntityStymphalianBird.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityStymphalianBird.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_PECK = Animation.create((int)20);
    public static Animation ANIMATION_SHOOT_ARROWS = Animation.create((int)30);
    public static Animation ANIMATION_SPEAK = Animation.create((int)10);
    public float flyProgress;
    public BlockPos airTarget;
    public StymphalianBirdFlock flock;
    private int animationTick;
    private Animation currentAnimation;
    private LivingEntity victorEntity;
    private boolean isFlying;
    private int flyTicks;
    private int launchTicks;
    private boolean aiFlightLaunch = false;
    private int airBorneCounter;

    public EntityStymphalianBird(EntityType t, World worldIn) {
        super(t, worldIn);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new StymphalianBirdAIFlee(this, 10.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new StymphalianBirdAIAirTarget(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new StymphalianBirdAITarget(this, LivingEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, IafConfig.myrmexBaseAttackStrength * 2.0).func_233815_a_(Attributes.field_233819_b_, (double)Math.min(2048, IafConfig.stymphalianBirdTargetSearchLength)).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VICTOR_ENTITY, Optional.empty());
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.getVictorId() != null) {
            tag.func_186854_a("VictorUUID", this.getVictorId());
        }
        tag.func_74757_a("Flying", this.isFlying());
    }

    public void func_70037_a(CompoundNBT tag) {
        UUID s;
        super.func_70037_a(tag);
        if (tag.func_186855_b("VictorUUID")) {
            s = tag.func_186857_a("VictorUUID");
        } else {
            String s1 = tag.func_74779_i("VictorUUID");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (s != null) {
            try {
                this.setVictorId(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setFlying(tag.func_74767_n("Flying"));
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (cause.func_76346_g() != null && cause.func_76346_g() instanceof LivingEntity && !this.field_70170_p.field_72995_K) {
            this.setVictorId(cause.func_76346_g().func_110124_au());
            if (this.flock != null) {
                this.flock.setFearTarget((LivingEntity)cause.func_76346_g());
            }
        }
        super.func_70645_a(cause);
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
    }

    @Nullable
    public UUID getVictorId() {
        return ((Optional)this.field_70180_af.func_187225_a(VICTOR_ENTITY)).orElse(null);
    }

    public void setVictorId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(VICTOR_ENTITY, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getVictor() {
        try {
            UUID uuid = this.getVictorId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void setVictor(LivingEntity player) {
        this.setVictorId(player.func_110124_au());
    }

    public boolean isVictor(LivingEntity entityIn) {
        return entityIn == this.getVictor();
    }

    public boolean isTargetBlocked(Vector3d target) {
        return this.field_70170_p.func_217299_a(new RayTraceContext(target, this.func_174824_e(1.0f), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_PECK);
        }
        return true;
    }

    public void func_70636_d() {
        boolean flying;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && (this.func_70638_az() instanceof PlayerEntity && ((PlayerEntity)this.func_70638_az()).func_184812_l_() || this.getVictor() != null && this.isVictor(this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        if (this.flock == null) {
            StymphalianBirdFlock otherFlock = StymphalianBirdFlock.getNearbyFlock(this);
            if (otherFlock == null) {
                this.flock = StymphalianBirdFlock.createFlock(this);
            } else {
                this.flock = otherFlock;
                this.flock.addToFlock(this);
            }
        } else {
            if (!this.flock.isLeader(this)) {
                double dist = this.func_70068_e((Entity)this.flock.getLeader());
                if (dist > 360.0) {
                    this.setFlying(true);
                    this.field_70699_by.func_75499_g();
                    this.airTarget = StymphalianBirdAIAirTarget.getNearbyAirTarget(this.flock.getLeader());
                    this.aiFlightLaunch = false;
                } else if (!this.flock.getLeader().isFlying()) {
                    this.setFlying(false);
                    this.airTarget = null;
                    this.aiFlightLaunch = false;
                }
                if (this.func_233570_aj_() && dist < 40.0 && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
                    this.setFlying(false);
                }
            }
            this.flock.update();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (this.getAnimation() == ANIMATION_PECK && this.getAnimationTick() == 7) {
                if (dist < 1.5) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
                }
                if (this.field_70122_E) {
                    this.setFlying(false);
                }
            }
            if (this.getAnimation() != ANIMATION_PECK && this.getAnimation() != ANIMATION_SHOOT_ARROWS && dist > 3.0 && dist < 225.0) {
                this.setAnimation(ANIMATION_SHOOT_ARROWS);
            }
            if (this.getAnimation() == ANIMATION_SHOOT_ARROWS) {
                LivingEntity target = this.func_70638_az();
                this.func_70625_a((Entity)target, 360.0f, 360.0f);
                if (this.isFlying()) {
                    this.field_70177_z = this.field_70761_aq;
                    if ((this.getAnimationTick() == 7 || this.getAnimationTick() == 14) && this.isDirectPathBetweenPoints((Entity)this, this.func_213303_ch(), target.func_213303_ch())) {
                        this.func_184185_a(IafSoundRegistry.STYMPHALIAN_BIRD_ATTACK, 1.0f, 1.0f);
                        for (int i = 0; i < 4; ++i) {
                            float wingX = (float)(this.func_226277_ct_() + (double)0.9f * Math.cos((double)(this.field_70177_z + (float)(180 * (i % 2))) * Math.PI / 180.0));
                            float wingZ = (float)(this.func_226281_cx_() + (double)0.9f * Math.sin((double)(this.field_70177_z + (float)(180 * (i % 2))) * Math.PI / 180.0));
                            float wingY = (float)(this.func_226278_cu_() + 1.0);
                            double d0 = target.func_226277_ct_() - (double)wingX;
                            double d1 = target.func_174813_aQ().field_72338_b - (double)wingY;
                            double d2 = target.func_226281_cx_() - (double)wingZ;
                            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                            EntityStymphalianFeather entityarrow = new EntityStymphalianFeather(IafEntityRegistry.STYMPHALIAN_FEATHER, this.field_70170_p, (LivingEntity)this);
                            entityarrow.func_70107_b(wingX, wingY, wingZ);
                            entityarrow.func_70186_c(d0, d1 + d3 * 0.10000000298023223, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                            this.field_70170_p.func_217376_c((Entity)entityarrow);
                        }
                    }
                } else {
                    this.setFlying(true);
                }
            }
        }
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        boolean bl = flying = this.isFlying() && !this.func_233570_aj_() || this.airBorneCounter > 10 || this.getAnimation() == ANIMATION_SHOOT_ARROWS;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.isFlying() && this.airTarget != null && this.func_233570_aj_() && !this.field_70170_p.field_72995_K) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.func_70638_az() == null) {
            this.flyAround();
        } else if (this.func_70638_az() != null) {
            this.flyTowardsTarget();
        }
        if (!this.field_70170_p.field_72995_K && this.doesWantToLand() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70038_c(0.0, 0.0, 0.0) && !this.isFlying()) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.field_70170_p.field_72995_K && this.func_233570_aj_() && this.isFlying() && !this.aiFlightLaunch && this.getAnimation() != ANIMATION_SHOOT_ARROWS) {
            this.setFlying(false);
            this.airTarget = null;
        }
        if ((properties == null || properties != null && !properties.isStone()) && !this.field_70170_p.field_72995_K && (this.flock == null || this.flock != null && this.flock.isLeader(this)) && this.func_70681_au().nextInt(100) == 0 && !this.isFlying() && this.func_184188_bt().isEmpty() && !this.func_70631_g_() && this.field_70122_E) {
            this.setFlying(true);
            this.launchTicks = 0;
            this.flyTicks = 0;
            this.aiFlightLaunch = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.aiFlightLaunch && this.launchTicks < 40) {
                ++this.launchTicks;
            } else {
                this.launchTicks = 0;
                this.aiFlightLaunch = false;
            }
            this.flyTicks = this.isFlying() ? ++this.flyTicks : 0;
        }
        this.airBorneCounter = !this.field_70122_E ? ++this.airBorneCounter : 0;
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !this.isFlying() && !this.field_70170_p.field_72995_K) {
            this.setFlying(true);
            this.aiFlightLaunch = true;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.func_226278_cu_() > (double)IafConfig.stymphalianBirdFlightHeight) {
            this.func_70107_b(this.func_226277_ct_(), IafConfig.stymphalianBirdFlightHeight, this.func_226281_cx_());
        }
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vector3d vec1, Vector3d vec2) {
        return this.field_70170_p.func_217299_a(new RayTraceContext(vec1, vec2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    private boolean isLeaderNotFlying() {
        return this.flock != null && this.flock.getLeader() != null && !this.flock.getLeader().isFlying();
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new Vector3d((double)this.airTarget.func_177958_n(), this.func_226278_cu_(), (double)this.airTarget.func_177952_p());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.func_226277_ct_();
            targetY = (double)Math.min(this.airTarget.func_177956_o(), 256) + 1.0 - this.func_226278_cu_();
            targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.func_226281_cx_();
            motionX = (Math.signum(targetX) * 0.5 - this.func_213322_ci().field_72450_a) * 0.100000000372529 * (double)this.getFlySpeed(false);
            motionY = (Math.signum(targetY) * 0.5 - this.func_213322_ci().field_72448_b) * 0.100000000372529 * (double)this.getFlySpeed(true);
            motionZ = (Math.signum(targetZ) * 0.5 - this.func_213322_ci().field_72449_c) * 0.100000000372529 * (double)this.getFlySpeed(false);
            this.func_213317_d(this.func_213322_ci().func_72441_c(motionX, motionY, motionZ));
            angle = (float)(Math.atan2(this.func_213322_ci().field_72449_c, this.func_213322_ci().field_72450_a) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70126_B = this.field_70177_z;
            this.field_70177_z += rotation;
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isTargetInAir() && this.isFlying()) {
            v1 = new Vector3d((double)this.airTarget.func_177958_n(), this.func_226278_cu_(), (double)this.airTarget.func_177952_p());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
            }
        }
    }

    private float getFlySpeed(boolean y) {
        float speed = 2.0f;
        if (this.flock != null && !this.flock.isLeader(this) && this.func_70068_e((Entity)this.flock.getLeader()) > 10.0) {
            speed = 4.0f;
        }
        if (this.getAnimation() == ANIMATION_SHOOT_ARROWS && !y) {
            speed = (float)((double)speed * 0.05);
        }
        return speed;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.STYMPHALIAN_BIRD_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.STYMPHALIAN_BIRD_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.STYMPHALIAN_BIRD_DIE;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)IafConfig.stymphalianBirdTargetSearchLength);
        return spawnDataIn;
    }

    public void func_70624_b(LivingEntity entity) {
        if (this.isVictor(entity) && entity != null) {
            return;
        }
        super.func_70624_b(entity);
        if (this.flock != null && this.flock.isLeader(this) && entity != null) {
            this.flock.onLeaderAttack(entity);
        }
    }

    public float getDistanceSquared(Vector3d Vector3d2) {
        float f = (float)(this.func_226277_ct_() - Vector3d2.field_72450_a);
        float f1 = (float)(this.func_226278_cu_() - Vector3d2.field_72448_b);
        float f2 = (float)(this.func_226281_cx_() - Vector3d2.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a);
    }

    public boolean doesWantToLand() {
        if (this.flock != null && !this.flock.isLeader(this) && this.flock.getLeader() != null) {
            return this.flock.getLeader().doesWantToLand();
        }
        return this.flyTicks > 500 || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_PECK, ANIMATION_SHOOT_ARROWS, ANIMATION_SPEAK};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return IafConfig.stympahlianBirdAttackAnimals;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

