/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.util.IAFMath;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class IafDragonFlightManager {
    private EntityDragonBase dragon;
    private Vector3d target;
    private IafDragonAttacks.Air prevAirAttack;
    private Vector3d startAttackVec;
    private Vector3d startPreyVec;
    private boolean hasStartedToScorch = false;
    private LivingEntity prevAttackTarget = null;

    public IafDragonFlightManager(EntityDragonBase dragon) {
        this.dragon = dragon;
    }

    public static float approach(float number, float max, float min) {
        min = Math.abs(min);
        return number < max ? MathHelper.func_76131_a((float)(number + min), (float)number, (float)max) : MathHelper.func_76131_a((float)(number - min), (float)max, (float)number);
    }

    public static float approachDegrees(float number, float max, float min) {
        float add = MathHelper.func_76142_g((float)(max - number));
        return IafDragonFlightManager.approach(number, number + add, min);
    }

    public static float degreesDifferenceAbs(float f1, float f2) {
        return Math.abs(MathHelper.func_76142_g((float)(f2 - f1)));
    }

    public void update() {
        if (this.dragon.func_70638_az() != null && this.dragon.func_70638_az().func_70089_S()) {
            if (this.dragon instanceof EntityIceDragon && this.dragon.func_70090_H()) {
                this.dragon.airAttack = this.dragon.func_70638_az() == null ? IafDragonAttacks.Air.SCORCH_STREAM : IafDragonAttacks.Air.TACKLE;
            }
            LivingEntity entity = this.dragon.func_70638_az();
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE) {
                this.target = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_213302_cg(), entity.func_226281_cx_());
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                float distY = 5 + this.dragon.getDragonStage() * 2;
                int randomDist = 20;
                if (this.dragon.func_70092_e(entity.func_226277_ct_(), this.dragon.func_226278_cu_(), entity.func_226281_cx_()) < 16.0 || this.dragon.func_70092_e(entity.func_226277_ct_(), this.dragon.func_226278_cu_(), entity.func_226281_cx_()) > 900.0) {
                    this.target = new Vector3d(entity.func_226277_ct_() + (double)this.dragon.func_70681_au().nextInt(randomDist) - (double)(randomDist / 2), entity.func_226278_cu_() + (double)distY, entity.func_226281_cx_() + (double)this.dragon.func_70681_au().nextInt(randomDist) - (double)(randomDist / 2));
                }
                this.dragon.stimulateFire(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 3);
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.SCORCH_STREAM && this.startPreyVec != null && this.startAttackVec != null) {
                float distX = (float)(this.startPreyVec.field_72450_a - this.startAttackVec.field_72450_a);
                float distY = 5 + this.dragon.getDragonStage() * 2;
                float distZ = (float)(this.startPreyVec.field_72449_c - this.startAttackVec.field_72449_c);
                this.target = new Vector3d(entity.func_226277_ct_() + (double)distX, entity.func_226278_cu_() + (double)distY, entity.func_226281_cx_() + (double)distZ);
                this.dragon.tryScorchTarget();
                this.hasStartedToScorch = true;
                if (this.target != null && this.dragon.func_70092_e(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) < 100.0) {
                    this.target = new Vector3d(entity.func_226277_ct_() - (double)distX, entity.func_226278_cu_() + (double)distY, entity.func_226281_cx_() - (double)distZ);
                }
            }
        } else if (this.target == null || this.dragon.func_70092_e(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) < 4.0 || !this.dragon.field_70170_p.func_175623_d(new BlockPos(this.target)) && (this.dragon.isHovering() || this.dragon.isFlying()) || this.dragon.getCommand() == 2 && this.dragon.shouldTPtoOwner()) {
            BlockPos viewBlock = DragonUtils.getBlockInView(this.dragon);
            if (this.dragon instanceof EntityIceDragon && !this.dragon.isHovering() && !this.dragon.isFlying()) {
                viewBlock = DragonUtils.getWaterBlockInView(this.dragon);
            }
            if (this.dragon.getCommand() == 2 && this.dragon.isFlying()) {
                viewBlock = DragonUtils.getBlockInViewEscort(this.dragon);
            }
            if (viewBlock != null) {
                this.target = new Vector3d((double)viewBlock.func_177958_n() + 0.5, (double)viewBlock.func_177956_o() + 0.5, (double)viewBlock.func_177952_p() + 0.5);
            }
        }
        if (this.target != null) {
            if (this.target.field_72448_b > (double)IafConfig.maxDragonFlight) {
                this.target = new Vector3d(this.target.field_72450_a, (double)IafConfig.maxDragonFlight, this.target.field_72449_c);
            }
            if (this.target.field_72448_b >= this.dragon.func_226278_cu_() && !this.dragon.isModelDead()) {
                this.dragon.func_213317_d(this.dragon.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
            }
        }
        this.prevAirAttack = this.dragon.airAttack;
    }

    public Vector3d getFlightTarget() {
        return this.target == null ? Vector3d.field_186680_a : this.target;
    }

    private float getDistanceXZ(double x, double z) {
        float f = (float)(this.dragon.func_226277_ct_() - x);
        float f2 = (float)(this.dragon.func_226281_cx_() - z);
        return f * f + f2 * f2;
    }

    public void onSetAttackTarget(@Nullable LivingEntity LivingEntityIn) {
        if (this.prevAttackTarget != LivingEntityIn) {
            this.startPreyVec = LivingEntityIn != null ? new Vector3d(LivingEntityIn.func_226277_ct_(), LivingEntityIn.func_226278_cu_(), LivingEntityIn.func_226281_cx_()) : new Vector3d(this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_());
            this.startAttackVec = new Vector3d(this.dragon.func_226277_ct_(), this.dragon.func_226278_cu_(), this.dragon.func_226281_cx_());
        }
        this.prevAttackTarget = LivingEntityIn;
    }

    protected static class PlayerFlightMoveHelper<T extends MobEntity>
    extends MovementController {
        private T dragon;

        public PlayerFlightMoveHelper(T dragon) {
            super(dragon);
            this.dragon = dragon;
        }

        public void func_75641_c() {
            double flySpeed = this.field_75645_e * this.speedMod();
            Vector3d dragonVec = this.dragon.func_213303_ch();
            Vector3d moveVec = new Vector3d(this.field_75646_b, this.field_75647_c, this.field_75644_d);
            Vector3d normalized = moveVec.func_178788_d(dragonVec).func_72432_b();
            double dist = dragonVec.func_72438_d(moveVec);
            this.dragon.func_213293_j(normalized.field_72450_a * flySpeed, normalized.field_72448_b * flySpeed, normalized.field_72449_c * flySpeed);
            if (dist > 2.5E-7) {
                float yaw = (float)Math.toDegrees(Math.PI * 2 - Math.atan2(normalized.field_72450_a, normalized.field_72448_b));
                ((MobEntity)this.dragon).field_70177_z = this.func_75639_a(((MobEntity)this.dragon).field_70177_z, yaw, 5.0f);
                this.dragon.func_70659_e((float)this.field_75645_e);
            }
            this.dragon.func_213315_a(MoverType.SELF, this.dragon.func_213322_ci());
        }

        public double speedMod() {
            return (this.dragon instanceof EntityAmphithere ? 0.75 : 0.5) * IafConfig.dragonFlightSpeedMod;
        }
    }

    protected static class FlightMoveHelper
    extends MovementController {
        private EntityDragonBase dragon;

        protected FlightMoveHelper(EntityDragonBase dragonBase) {
            super((MobEntity)dragonBase);
            this.dragon = dragonBase;
        }

        public void func_75641_c() {
            if (this.dragon.field_70123_F) {
                this.dragon.field_70177_z += 180.0f;
                this.field_75645_e = 0.1f;
                this.dragon.flightManager.target = null;
                return;
            }
            float distX = (float)(this.dragon.flightManager.getFlightTarget().field_72450_a - this.dragon.func_226277_ct_());
            float distY = (float)(this.dragon.flightManager.getFlightTarget().field_72448_b - this.dragon.func_226278_cu_());
            float distZ = (float)(this.dragon.flightManager.getFlightTarget().field_72449_c - this.dragon.func_226281_cx_());
            double planeDist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ));
            double yDistMod = 1.0 - (double)MathHelper.func_76135_e((float)(distY * 0.7f)) / planeDist;
            distX = (float)((double)distX * yDistMod);
            distZ = (float)((double)distZ * yDistMod);
            planeDist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ));
            double dist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ + distY * distY));
            if (dist > 1.0) {
                float finPitch;
                float yawCopy = this.dragon.field_70177_z;
                float atan = (float)MathHelper.func_181159_b((double)distZ, (double)distX);
                float yawTurn = MathHelper.func_76142_g((float)(this.dragon.field_70177_z + 90.0f));
                float yawTurnAtan = MathHelper.func_76142_g((float)(atan * 57.295776f));
                this.dragon.field_70761_aq = this.dragon.field_70177_z = IafDragonFlightManager.approachDegrees(yawTurn, yawTurnAtan, this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && this.dragon.func_70638_az() != null ? 10.0f : 4.0f) - 90.0f;
                if (IafDragonFlightManager.degreesDifferenceAbs(yawCopy, this.dragon.field_70177_z) < 3.0f) {
                    this.field_75645_e = IafDragonFlightManager.approach((float)this.field_75645_e, 1.8f, 0.005f * (1.8f / (float)this.field_75645_e));
                } else {
                    this.field_75645_e = IafDragonFlightManager.approach((float)this.field_75645_e, 0.2f, 0.025f);
                    if (dist < 100.0 && this.dragon.func_70638_az() != null) {
                        this.field_75645_e *= dist / 100.0;
                    }
                }
                this.dragon.field_70125_A = finPitch = (float)(-(MathHelper.func_181159_b((double)(-distY), (double)planeDist) * 57.2957763671875));
                float yawTurnHead = this.dragon.field_70177_z + 90.0f;
                this.field_75645_e *= this.dragon.getFlightSpeedModifier();
                double lvt_16_1_ = this.field_75645_e * (double)MathHelper.func_76134_b((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distX / dist);
                double lvt_18_1_ = this.field_75645_e * (double)MathHelper.func_76126_a((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distZ / dist);
                double lvt_20_1_ = this.field_75645_e * (double)MathHelper.func_76126_a((float)(finPitch * ((float)Math.PI / 180))) * Math.abs((double)distY / dist);
                double motionCap = 0.2;
                this.dragon.func_213317_d(this.dragon.func_213322_ci().func_72441_c(Math.min(lvt_16_1_ * 0.2, motionCap), Math.min(lvt_20_1_ * 0.2, motionCap), Math.min(lvt_18_1_ * 0.2, motionCap)));
            }
        }
    }

    protected static class GroundMoveHelper
    extends MovementController {
        public GroundMoveHelper(MobEntity LivingEntityIn) {
            super(LivingEntityIn);
        }

        public float distance(float rotateAngleFrom, float rotateAngleTo) {
            return (float)IAFMath.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.STRAFE) {
                NodeProcessor nodeprocessor;
                float f = (float)this.field_75648_a.func_110148_a(Attributes.field_233821_d_).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigator pathnavigate = this.field_75648_a.func_70661_as();
                if (pathnavigate != null && (nodeprocessor = pathnavigate.func_189566_q()) != null && nodeprocessor.func_186330_a((IBlockReader)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.func_226277_ct_() + (double)f7)), MathHelper.func_76128_c((double)this.field_75648_a.func_226278_cu_()), MathHelper.func_76128_c((double)(this.field_75648_a.func_226281_cx_() + (double)f8))) != PathNodeType.WALKABLE) {
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = MovementController.Action.WAIT;
            } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                EntityDragonBase dragonBase = (EntityDragonBase)this.field_75648_a;
                double d0 = this.func_179917_d() - this.field_75648_a.func_226277_ct_();
                double d1 = this.func_179918_f() - this.field_75648_a.func_226281_cx_();
                double d2 = this.func_179919_e() - this.field_75648_a.func_226278_cu_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float targetDegree = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                float changeRange = 70.0f;
                if (dragonBase.func_213311_cf() > 2.0f) {
                    float ageMod = 1.0f - (float)Math.min(dragonBase.getAgeInDays(), 125) / 125.0f;
                    changeRange = 5.0f + ageMod * 10.0f;
                }
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, targetDegree, changeRange);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.func_213311_cf())) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = MovementController.Action.JUMPING;
                }
            } else if (this.field_188491_h == MovementController.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

