/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class HippogryphAIAirTarget
extends Goal {
    private EntityHippogryph hippogryph;

    public HippogryphAIAirTarget(EntityHippogryph dragon) {
        this.hippogryph = dragon;
    }

    public boolean func_75250_a() {
        if (this.hippogryph != null) {
            if (!this.hippogryph.isFlying() && !this.hippogryph.isHovering()) {
                return false;
            }
            if (this.hippogryph.func_233684_eK_()) {
                return false;
            }
            if (this.hippogryph.func_70631_g_()) {
                return false;
            }
            if (this.hippogryph.func_70902_q() != null && this.hippogryph.func_184188_bt().contains(this.hippogryph.func_70902_q())) {
                return false;
            }
            if (this.hippogryph.airTarget != null) {
                Vector3d vector3d = new Vector3d((double)this.hippogryph.airTarget.func_177958_n(), this.hippogryph.func_226278_cu_(), (double)this.hippogryph.airTarget.func_177952_p());
                if (this.hippogryph.getDistanceSquared(vector3d) > 3.0f) {
                    this.hippogryph.airTarget = null;
                }
            }
            if (this.hippogryph.airTarget != null) {
                return false;
            }
            Vector3d vec = this.findAirTarget();
            if (vec == null) {
                return false;
            }
            this.hippogryph.airTarget = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            return true;
        }
        return false;
    }

    public boolean continueExecuting() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this.hippogryph, StoneEntityProperties.class);
        if (!this.hippogryph.isFlying() && !this.hippogryph.isHovering()) {
            return false;
        }
        if (this.hippogryph.func_233684_eK_()) {
            return false;
        }
        if (this.hippogryph.func_70631_g_()) {
            return false;
        }
        if (this.hippogryph.func_70631_g_()) {
            return false;
        }
        if (properties != null && properties.isStone()) {
            return false;
        }
        return this.hippogryph.airTarget != null;
    }

    public Vector3d findAirTarget() {
        return Vector3d.func_237489_a_((Vector3i)this.getNearbyAirTarget());
    }

    public BlockPos getNearbyAirTarget() {
        Random random = this.hippogryph.func_70681_au();
        if (this.hippogryph.func_70638_az() == null) {
            for (int i = 0; i < 10; ++i) {
                BlockPos pos = DragonUtils.getBlockInViewHippogryph(this.hippogryph);
                if (pos == null || this.hippogryph.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151579_a) continue;
                return pos;
            }
        } else {
            BlockPos pos = new BlockPos((int)this.hippogryph.func_70638_az().func_226277_ct_(), (int)this.hippogryph.func_70638_az().func_226278_cu_(), (int)this.hippogryph.func_70638_az().func_226281_cx_());
            if (this.hippogryph.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
                return pos;
            }
        }
        return this.hippogryph.func_233580_cy_();
    }
}

