/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.Heightmap;

public class MyrmexAIFindHidingSpot
extends Goal {
    private static final int RADIUS = 32;
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super Entity> targetEntitySelector;
    private final EntityMyrmexSentinel myrmex;
    private BlockPos targetBlock = null;
    private int wanderRadius = 32;

    public MyrmexAIFindHidingSpot(EntityMyrmexSentinel myrmex) {
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)myrmex);
        this.targetEntitySelector = new Predicate<Entity>(){

            public boolean apply(@Nullable Entity myrmex) {
                return myrmex != null && myrmex instanceof EntityMyrmexSentinel;
            }
        };
        this.myrmex = myrmex;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.targetBlock = this.getTargetPosition(this.wanderRadius);
        return this.myrmex.canMove() && this.myrmex.func_70638_az() == null && this.myrmex.canSeeSky() && !this.myrmex.isHiding();
    }

    public boolean func_75253_b() {
        return !this.myrmex.shouldEnterHive() && this.myrmex.func_70661_as().func_75500_f() && this.myrmex.func_70638_az() == null && !this.myrmex.isHiding();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            if (this.areMyrmexNear(5.0) || this.myrmex.isOnResin()) {
                this.myrmex.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
                if (this.myrmex.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.targetBlock)) < 20.0) {
                    this.wanderRadius += 32;
                    this.targetBlock = this.getTargetPosition(this.wanderRadius);
                }
            } else if (this.myrmex.func_70638_az() == null && this.myrmex.func_70931_l_() == null && this.myrmex.visibleTicks == 0) {
                this.myrmex.setHiding(true);
            }
        }
    }

    public void func_75251_c() {
        this.targetBlock = null;
        this.wanderRadius = 32;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.myrmex.func_174813_aQ().func_72314_b(targetDistance, 14.0, targetDistance);
    }

    public BlockPos getTargetPosition(int radius) {
        int x = (int)this.myrmex.func_226277_ct_() + this.myrmex.func_70681_au().nextInt(radius * 2) - radius;
        int z = (int)this.myrmex.func_226281_cx_() + this.myrmex.func_70681_au().nextInt(radius * 2) - radius;
        return this.myrmex.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x, 0, z));
    }

    private boolean areMyrmexNear(double distance) {
        List sentinels = this.myrmex.field_70170_p.func_175674_a((Entity)this.myrmex, this.getTargetableArea(distance), this.targetEntitySelector);
        ArrayList<Entity> hiddenSentinels = new ArrayList<Entity>();
        for (Entity sentinel : sentinels) {
            if (!(sentinel instanceof EntityMyrmexSentinel) || !((EntityMyrmexSentinel)sentinel).isHiding()) continue;
            hiddenSentinels.add(sentinel);
        }
        return !hiddenSentinels.isEmpty();
    }
}

