/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockDragonforgeBricks;
import com.github.alexthe666.iceandfire.block.BlockDragonforgeCore;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.IafTileEntityRegistry;
import com.github.alexthe666.iceandfire.inventory.ContainerDragonForge;
import com.github.alexthe666.iceandfire.message.MessageUpdateDragonforge;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityDragonforge
extends LockableTileEntity
implements ITickableTileEntity,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0, 1};
    private static final int[] SLOTS_BOTTOM = new int[]{2};
    private static final int[] SLOTS_SIDES = new int[]{0, 1};
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public int isFire;
    public int cookTime;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, Direction.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, Direction.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, Direction.WEST);
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private NonNullList<ItemStack> forgeItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int lastDragonFlameTimer = 0;
    private boolean prevAssembled;
    private boolean canAddFlameAgain = true;

    public TileEntityDragonforge() {
        super(IafTileEntityRegistry.DRAGONFORGE_CORE);
    }

    public TileEntityDragonforge(int isFire) {
        super(IafTileEntityRegistry.DRAGONFORGE_CORE);
        this.isFire = isFire;
    }

    public int func_70302_i_() {
        return this.forgeItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.forgeItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void updateGrills(boolean grill) {
        for (Direction facing : HORIZONTALS) {
            BlockPos grillPos = this.func_174877_v().func_177972_a(facing);
            if (!this.grillMatches(this.field_145850_b.func_180495_p(grillPos).func_177230_c())) continue;
            BlockState grillState = (BlockState)this.getGrillBlock().func_176223_P().func_206870_a((Property)BlockDragonforgeBricks.GRILL, (Comparable)Boolean.valueOf(grill));
            if (this.field_145850_b.func_180495_p(grillPos) == grillState) continue;
            this.field_145850_b.func_175656_a(grillPos, grillState);
        }
    }

    public Block getGrillBlock() {
        if (this.isFire == 0) {
            return IafBlockRegistry.DRAGONFORGE_FIRE_BRICK;
        }
        if (this.isFire == 1) {
            return IafBlockRegistry.DRAGONFORGE_ICE_BRICK;
        }
        if (this.isFire == 2) {
            return IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK;
        }
        return IafBlockRegistry.DRAGONFORGE_FIRE_BRICK;
    }

    public boolean grillMatches(Block block) {
        if (this.isFire == 0 && block == IafBlockRegistry.DRAGONFORGE_FIRE_BRICK) {
            return true;
        }
        if (this.isFire == 1 && block == IafBlockRegistry.DRAGONFORGE_ICE_BRICK) {
            return true;
        }
        return this.isFire == 2 && block == IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.forgeItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.forgeItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.forgeItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.forgeItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.forgeItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag || this.cookTime > this.getMaxCookTime((ItemStack)this.forgeItemStacks.get(0), (ItemStack)this.forgeItemStacks.get(1))) {
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.forgeItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.forgeItemStacks);
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.forgeItemStacks);
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public int getFireType(Block block) {
        if (block == IafBlockRegistry.DRAGONFORGE_FIRE_CORE || block == IafBlockRegistry.DRAGONFORGE_FIRE_CORE_DISABLED) {
            return 0;
        }
        if (block == IafBlockRegistry.DRAGONFORGE_ICE_CORE || block == IafBlockRegistry.DRAGONFORGE_ICE_CORE_DISABLED) {
            return 1;
        }
        if (block == IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE || block == IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE_DISABLED) {
            return 2;
        }
        return 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        this.isFire = this.getFireType(this.func_195044_w().func_177230_c());
        if (this.lastDragonFlameTimer > 0) {
            --this.lastDragonFlameTimer;
        }
        this.updateGrills(this.assembled());
        if (!this.field_145850_b.field_72995_K) {
            if (this.prevAssembled != this.assembled()) {
                BlockDragonforgeCore.setState(this.isFire, this.prevAssembled, this.field_145850_b, this.field_174879_c);
            }
            this.prevAssembled = this.assembled();
            if (!this.assembled()) {
                return;
            }
        }
        if (this.cookTime > 0 && this.canSmelt() && this.lastDragonFlameTimer == 0) {
            --this.cookTime;
        }
        if (this.func_70301_a(0).func_190926_b() && !this.field_145850_b.field_72995_K) {
            this.cookTime = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isBurning()) {
                if (this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime >= this.getMaxCookTime((ItemStack)this.forgeItemStacks.get(0), (ItemStack)this.forgeItemStacks.get(1))) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else if (this.cookTime > 0) {
                    IceAndFire.sendMSGToAll(new MessageUpdateDragonforge(this.field_174879_c.func_218275_a(), this.cookTime));
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.getMaxCookTime((ItemStack)this.forgeItemStacks.get(0), (ItemStack)this.forgeItemStacks.get(1)));
            }
            if (flag != this.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (!this.canAddFlameAgain) {
            this.canAddFlameAgain = true;
        }
    }

    public int getMaxCookTime(ItemStack cookStack, ItemStack bloodStack) {
        ItemStack stack = this.getCurrentResult(cookStack, bloodStack);
        if (stack.func_77973_b() == Item.func_150898_a((Block)IafBlockRegistry.ASH) || stack.func_77973_b() == Item.func_150898_a((Block)IafBlockRegistry.DRAGON_ICE)) {
            return 100;
        }
        return 1000;
    }

    private ItemStack getCurrentResult(ItemStack cookStack, ItemStack bloodStack) {
        DragonForgeRecipe forgeRecipe = null;
        forgeRecipe = this.isFire == 0 ? IafRecipeRegistry.getFireForgeRecipe(cookStack) : (this.isFire == 1 ? IafRecipeRegistry.getIceForgeRecipe(cookStack) : IafRecipeRegistry.getLightningForgeRecipe(cookStack));
        ItemStack itemstack = ItemStack.field_190927_a;
        if (forgeRecipe != null && bloodStack.func_77969_a(forgeRecipe.getBlood())) {
            itemstack = forgeRecipe.getOutput();
        }
        if (itemstack.func_190926_b()) {
            if (this.isFire == 0) {
                itemstack = new ItemStack((IItemProvider)IafBlockRegistry.ASH);
            } else if (this.isFire == 1) {
                itemstack = new ItemStack((IItemProvider)IafBlockRegistry.DRAGON_ICE);
            } else if (this.isFire == 2) {
                itemstack = new ItemStack((IItemProvider)IafBlockRegistry.ASH);
            }
        }
        return itemstack;
    }

    public boolean canSmelt() {
        if (((ItemStack)this.forgeItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = this.getCurrentResult((ItemStack)this.forgeItemStacks.get(0), (ItemStack)this.forgeItemStacks.get(1));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.forgeItemStacks.get(2);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.forgeItemStacks.get(0);
            ItemStack bloodStack = (ItemStack)this.forgeItemStacks.get(1);
            ItemStack itemstack1 = this.getCurrentResult((ItemStack)this.forgeItemStacks.get(0), (ItemStack)this.forgeItemStacks.get(1));
            ItemStack itemstack2 = (ItemStack)this.forgeItemStacks.get(2);
            if (itemstack2.func_190926_b()) {
                this.forgeItemStacks.set(2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (!bloodStack.func_190926_b() && this.cookTime == 0) {
                bloodStack.func_190918_g(1);
            }
            itemstack.func_190918_g(1);
        }
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index == 1) {
            DragonForgeRecipe forgeRecipe = null;
            forgeRecipe = this.isFire == 0 ? IafRecipeRegistry.getFireForgeRecipeForBlood((ItemStack)this.forgeItemStacks.get(0)) : (this.isFire == 1 ? IafRecipeRegistry.getIceForgeRecipeForBlood((ItemStack)this.forgeItemStacks.get(0)) : IafRecipeRegistry.getLightningForgeRecipe((ItemStack)this.forgeItemStacks.get(0)));
            if (forgeRecipe != null) {
                return true;
            }
        }
        return index == 0;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == Direction.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public int getField(int id) {
        return this.cookTime;
    }

    public void setField(int id, int value) {
        this.cookTime = value;
    }

    public int getFieldCount() {
        return 1;
    }

    public void func_174888_l() {
        this.forgeItemStacks.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.dragonforge_fire" + DragonType.getNameFromInt(this.isFire));
    }

    public void transferPower(int i) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canSmelt()) {
                if (this.canAddFlameAgain) {
                    this.cookTime = Math.min(this.getMaxCookTime((ItemStack)this.forgeItemStacks.get(0), (ItemStack)this.forgeItemStacks.get(1)) + 1, this.cookTime + i);
                    this.canAddFlameAgain = false;
                }
            } else {
                this.cookTime = 0;
            }
            IceAndFire.sendMSGToAll(new MessageUpdateDragonforge(this.field_174879_c.func_218275_a(), this.cookTime));
        }
        this.lastDragonFlameTimer = 40;
    }

    private boolean checkBoneCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177978_c().func_177974_f(), IafBlockRegistry.DRAGON_BONE_BLOCK) && this.doesBlockEqual(pos.func_177978_c().func_177976_e(), IafBlockRegistry.DRAGON_BONE_BLOCK) && this.doesBlockEqual(pos.func_177968_d().func_177974_f(), IafBlockRegistry.DRAGON_BONE_BLOCK) && this.doesBlockEqual(pos.func_177968_d().func_177976_e(), IafBlockRegistry.DRAGON_BONE_BLOCK);
    }

    private boolean checkBrickCorners(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177978_c().func_177974_f(), this.getBrick()) && this.doesBlockEqual(pos.func_177978_c().func_177976_e(), this.getBrick()) && this.doesBlockEqual(pos.func_177968_d().func_177974_f(), this.getBrick()) && this.doesBlockEqual(pos.func_177968_d().func_177976_e(), this.getBrick());
    }

    private boolean checkBrickSlots(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177978_c(), this.getBrick()) && this.doesBlockEqual(pos.func_177974_f(), this.getBrick()) && this.doesBlockEqual(pos.func_177976_e(), this.getBrick()) && this.doesBlockEqual(pos.func_177968_d(), this.getBrick());
    }

    private boolean checkY(BlockPos pos) {
        return this.doesBlockEqual(pos.func_177984_a(), this.getBrick()) && this.doesBlockEqual(pos.func_177977_b(), this.getBrick());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean assembled() {
        return this.checkBoneCorners(this.field_174879_c.func_177977_b()) && this.checkBrickSlots(this.field_174879_c.func_177977_b()) && this.checkBrickCorners(this.field_174879_c) && this.atleastThreeAreBricks(this.field_174879_c) && this.checkY(this.field_174879_c) && this.checkBoneCorners(this.field_174879_c.func_177984_a()) && this.checkBrickSlots(this.field_174879_c.func_177984_a());
    }

    private Block getBrick() {
        if (this.isFire == 0) {
            return IafBlockRegistry.DRAGONFORGE_FIRE_BRICK;
        }
        if (this.isFire == 1) {
            return IafBlockRegistry.DRAGONFORGE_ICE_BRICK;
        }
        return IafBlockRegistry.DRAGONFORGE_LIGHTNING_BRICK;
    }

    private boolean doesBlockEqual(BlockPos pos, Block block) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == block;
    }

    private boolean atleastThreeAreBricks(BlockPos pos) {
        int count = 0;
        for (Direction facing : HORIZONTALS) {
            if (this.field_145850_b.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this.getBrick()) continue;
            ++count;
        }
        return count > 2;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerDragonForge(id, (IInventory)this, playerInventory, (IIntArray)new IntArray(0));
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new ContainerDragonForge(id, (IInventory)this, player, (IIntArray)new IntArray(0));
    }
}

