/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.gen.Heightmap;

public class DragonUtils {
    public static BlockPos getBlockInViewEscort(EntityDragonBase dragon) {
        float radius = 12.0f * (0.7f * dragon.getRenderSize() / 3.0f);
        float neg = dragon.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.field_70761_aq;
        BlockPos escortPos = dragon.getEscortPosition();
        BlockPos ground = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, escortPos);
        int distFromGround = escortPos.func_177956_o() - ground.func_177956_o();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = new BlockPos(escortPos.func_177958_n() + dragon.func_70681_au().nextInt(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance / 2, distFromGround > 16 ? escortPos.func_177956_o() : escortPos.func_177956_o() + 8 + dragon.func_70681_au().nextInt(16), escortPos.func_177952_p() + dragon.func_70681_au().nextInt(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance / 2);
            if (dragon.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)pos)) || !(dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)pos)) > 6.0f)) continue;
            return pos;
        }
        return null;
    }

    public static BlockPos getBlockInView(EntityDragonBase dragon) {
        BlockPos pos;
        float radius = 12.0f * (0.7f * dragon.getRenderSize() / 3.0f);
        float neg = dragon.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.field_70761_aq;
        if (dragon.hasHomePosition && dragon.homePos != null) {
            BlockPos dragonPos = dragon.func_233580_cy_();
            BlockPos ground = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            int distFromGround = (int)dragon.func_226278_cu_() - ground.func_177956_o();
            for (int i = 0; i < 10; ++i) {
                BlockPos pos2 = new BlockPos(dragon.homePos.func_177958_n() + dragon.func_70681_au().nextInt(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance, distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.func_226278_cu_() + (double)dragon.func_70681_au().nextInt(16) - 8.0) : (int)dragon.func_226278_cu_() + dragon.func_70681_au().nextInt(16) + 1, dragon.homePos.func_177952_p() + dragon.func_70681_au().nextInt(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance);
                if (dragon.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)pos2)) || !(dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)pos2)) > 6.0f)) continue;
                return pos2;
            }
        }
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + dragon.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(dragon.func_226277_ct_() + extraX, 0.0, dragon.func_226281_cx_() + extraZ);
        BlockPos ground = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.func_226278_cu_() - ground.func_177956_o();
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.func_226278_cu_() + (double)dragon.func_70681_au().nextInt(16) - 8.0) : (int)dragon.func_226278_cu_() + dragon.func_70681_au().nextInt(16) + 1);
        BlockPos blockPos = pos = dragon.doesWantToLand() ? ground : newPos;
        if (!dragon.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0f) {
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInView(EntityDragonBase dragon) {
        BlockPos surface;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.func_70681_au().nextInt(dragon.getDragonStage() * 6);
        float neg = dragon.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dragon.field_70761_aq + 3.15f + dragon.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(dragon.func_226277_ct_() + extraX, 0.0, dragon.func_226281_cx_() + extraZ);
        BlockPos ground = dragon.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.func_226278_cu_() - ground.func_177956_o();
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.func_226278_cu_() + (double)dragon.func_70681_au().nextInt(16) - 8.0) : (int)dragon.func_226278_cu_() + dragon.func_70681_au().nextInt(16) + 1);
        BlockPos pos = dragon.doesWantToLand() ? ground : newPos;
        BlockPos blockPos = surface = dragon.field_70170_p.func_180495_p(newPos.func_177979_c(2)).func_185904_a() != Material.field_151586_h ? newPos.func_177979_c(dragon.func_70681_au().nextInt(10) + 1) : newPos;
        if (dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)surface)) > 6.0f && dragon.field_70170_p.func_180495_p(surface).func_185904_a() == Material.field_151586_h) {
            return surface;
        }
        return null;
    }

    public static LivingEntity riderLookingAtEntity(final LivingEntity dragon, LivingEntity rider, double dist) {
        Vector3d Vector3d2 = rider.func_174824_e(1.0f);
        Vector3d Vector3d1 = rider.func_70676_i(1.0f);
        Vector3d Vector3d22 = Vector3d2.func_72441_c(Vector3d1.field_72450_a * dist, Vector3d1.field_72448_b * dist, Vector3d1.field_72449_c * dist);
        double d1 = dist;
        Entity pointedEntity = null;
        List list = rider.field_70170_p.func_175674_a((Entity)rider, rider.func_174813_aQ().func_72321_a(Vector3d1.field_72450_a * dist, Vector3d1.field_72448_b * dist, Vector3d1.field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0), (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (DragonUtils.onSameTeam((Entity)dragon, entity)) {
                    return false;
                }
                return entity != null && entity.func_70067_L() && entity instanceof LivingEntity && !entity.func_70028_i((Entity)dragon) && !entity.func_184191_r((Entity)dragon) && (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead());
            }
        });
        double d2 = d1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y() + 2.0);
            Vector3d raytraceresult = axisalignedbb.func_216365_b(Vector3d2, Vector3d22).orElse(Vector3d.field_186680_a);
            if (axisalignedbb.func_72318_a(Vector3d2)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = Vector3d2.func_72438_d(raytraceresult)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == rider.func_184208_bv() && !rider.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        return (LivingEntity)pointedEntity;
    }

    public static BlockPos getBlockInViewHippogryph(EntityHippogryph hippo) {
        BlockPos pos;
        int distFromGround;
        BlockPos ground;
        float radius = -12.599999f - (float)hippo.func_70681_au().nextInt(48);
        float neg = hippo.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * hippo.field_70761_aq + 3.15f + hippo.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        if (hippo.hasHomePosition && hippo.homePos != null) {
            BlockPos dragonPos = hippo.func_233580_cy_();
            ground = hippo.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            distFromGround = (int)hippo.func_226278_cu_() - ground.func_177956_o();
            for (int i = 0; i < 10; ++i) {
                pos = new BlockPos(hippo.homePos.func_177958_n() + hippo.func_70681_au().nextInt(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance, distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, hippo.func_226278_cu_() + (double)hippo.func_70681_au().nextInt(16) - 8.0) : (int)hippo.func_226278_cu_() + hippo.func_70681_au().nextInt(16) + 1, hippo.homePos.func_177952_p() + hippo.func_70681_au().nextInt(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance);
                if (hippo.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)pos)) || !(hippo.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)pos)) > 6.0f)) continue;
                return pos;
            }
        }
        BlockPos radialPos = new BlockPos(hippo.func_226277_ct_() + extraX, 0.0, hippo.func_226281_cx_() + extraZ);
        ground = hippo.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        distFromGround = (int)hippo.func_226278_cu_() - ground.func_177956_o();
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, hippo.func_226278_cu_() + (double)hippo.func_70681_au().nextInt(16) - 8.0) : (int)hippo.func_226278_cu_() + hippo.func_70681_au().nextInt(16) + 1);
        BlockPos blockPos = pos = hippo.doesWantToLand() ? ground : newPos;
        if (!hippo.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && hippo.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0f) {
            return newPos;
        }
        return null;
    }

    public static BlockPos getBlockInViewStymphalian(EntityStymphalianBird bird) {
        BlockPos pos;
        float radius = -9.45f - (float)bird.func_70681_au().nextInt(24);
        float neg = bird.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = bird.flock != null && !bird.flock.isLeader(bird) ? DragonUtils.getStymphalianFlockDirection(bird) : bird.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + bird.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = DragonUtils.getStymphalianFearPos(bird, new BlockPos(bird.func_226277_ct_() + extraX, 0.0, bird.func_226281_cx_() + extraZ));
        BlockPos ground = bird.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)bird.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = Math.min(IafConfig.stymphalianBirdFlightHeight, bird.flock != null && !bird.flock.isLeader(bird) ? ground.func_177956_o() + bird.func_70681_au().nextInt(16) : ground.func_177956_o() + bird.func_70681_au().nextInt(16));
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? flightHeight : (int)bird.func_226278_cu_() + bird.func_70681_au().nextInt(16) + 1);
        BlockPos blockPos = pos = bird.doesWantToLand() ? ground : newPos;
        if (!bird.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && bird.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0f) {
            return newPos;
        }
        return null;
    }

    private static BlockPos getStymphalianFearPos(EntityStymphalianBird bird, BlockPos fallback) {
        Vector3d Vector3d2;
        if (bird.getVictor() != null && bird.getVictor() instanceof CreatureEntity && (Vector3d2 = RandomPositionGenerator.func_75461_b((CreatureEntity)((CreatureEntity)bird.getVictor()), (int)16, (int)IafConfig.stymphalianBirdFlightHeight, (Vector3d)new Vector3d(bird.getVictor().func_226277_ct_(), bird.getVictor().func_226278_cu_(), bird.getVictor().func_226281_cx_()))) != null) {
            BlockPos pos = new BlockPos(Vector3d2);
            return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        return fallback;
    }

    private static float getStymphalianFlockDirection(EntityStymphalianBird bird) {
        EntityStymphalianBird leader = bird.flock.getLeader();
        if (bird.func_70068_e((Entity)leader) > 2.0) {
            double d0 = leader.func_226277_ct_() - bird.func_226277_ct_();
            double d2 = leader.func_226281_cx_() - bird.func_226281_cx_();
            double d1 = leader.func_226278_cu_() + (double)leader.func_70047_e() - (bird.func_226278_cu_() + (double)bird.func_70047_e());
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float degrees = MathHelper.func_76142_g((float)(f - bird.field_70177_z));
            return bird.field_70177_z + degrees;
        }
        return leader.field_70761_aq;
    }

    public static BlockPos getBlockInTargetsViewCockatrice(EntityCockatrice cockatrice, LivingEntity target) {
        float radius = 10 + cockatrice.func_70681_au().nextInt(10);
        float neg = cockatrice.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * target.field_70759_as;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(target.func_226277_ct_() + extraX, 0.0, target.func_226281_cx_() + extraZ);
        BlockPos ground = target.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (!cockatrice.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground)) && cockatrice.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 30.0) {
            return ground;
        }
        return target.func_233580_cy_();
    }

    public static BlockPos getBlockInTargetsViewGhost(EntityGhost ghost, LivingEntity target) {
        float radius = 4 + ghost.func_70681_au().nextInt(5);
        float neg = ghost.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * (target.field_70759_as + 90.0f + (float)ghost.func_70681_au().nextInt(180));
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(target.func_226277_ct_() + extraX, target.func_226278_cu_(), target.func_226281_cx_() + extraZ);
        BlockPos ground = radialPos;
        if (ghost.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 30.0) {
            return ground;
        }
        return ghost.func_233580_cy_();
    }

    public static BlockPos getBlockInTargetsViewGorgon(EntityGorgon cockatrice, LivingEntity target) {
        float radius = 6.0f;
        float neg = cockatrice.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * target.field_70759_as;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(target.func_226277_ct_() + extraX, target.func_226278_cu_(), target.func_226281_cx_() + extraZ);
        if (!cockatrice.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)radialPos).func_72441_c(0.0, 0.75, 0.0)) && cockatrice.func_195048_a(Vector3d.func_237489_a_((Vector3i)radialPos)) < 300.0) {
            return radialPos;
        }
        return target.func_233580_cy_();
    }

    public static BlockPos getBlockInTargetsViewSeaSerpent(EntitySeaSerpent serpent, LivingEntity target) {
        float radius = 10.0f * serpent.getSeaSerpentScale() + (float)serpent.func_70681_au().nextInt(10);
        float neg = serpent.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * target.field_70759_as;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(target.func_226277_ct_() + extraX, 0.0, target.func_226281_cx_() + extraZ);
        BlockPos ground = target.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (serpent.func_195048_a(Vector3d.func_237489_a_((Vector3i)ground)) > 30.0) {
            return ground;
        }
        return target.func_233580_cy_();
    }

    public static boolean canTameDragonAttack(TameableEntity dragon, Entity entity) {
        if (EntityTypeTags.func_219762_a().func_241834_b(IafTagRegistry.VILLAGERS).func_230235_a_((Object)entity.func_200600_R())) {
            return false;
        }
        if (entity instanceof AbstractVillagerEntity || entity instanceof GolemEntity || entity instanceof PlayerEntity) {
            return false;
        }
        if (entity instanceof TameableEntity) {
            return !((TameableEntity)entity).func_70909_n();
        }
        return true;
    }

    public static boolean isVillager(Entity entity) {
        return EntityTypeTags.func_219762_a().func_241834_b(IafTagRegistry.VILLAGERS).func_230235_a_((Object)entity.func_200600_R());
    }

    public static boolean isAnimaniaMob(Entity entity) {
        return false;
    }

    public static boolean isDragonTargetable(Entity entity) {
        return EntityTypeTags.func_219762_a().func_241834_b(IafTagRegistry.DRAGON_TARGETS).func_230235_a_((Object)entity.func_200600_R());
    }

    public static boolean canDragonBreak(Block block) {
        return block != Blocks.field_180401_cv && block != Blocks.field_150343_Z && block != Blocks.field_150377_bs && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db && !DragonUtils.isBlacklistedBlock(block);
    }

    public static boolean hasSameOwner(TameableEntity cockatrice, Entity entity) {
        if (entity instanceof TameableEntity) {
            TameableEntity tameable = (TameableEntity)entity;
            return tameable.func_184753_b() != null && cockatrice.func_184753_b() != null && tameable.func_184753_b().equals(cockatrice.func_184753_b());
        }
        return false;
    }

    public static boolean isAlive(LivingEntity entity) {
        boolean alive = (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead()) && !EntityGorgon.isStoneMob(entity);
        return alive;
    }

    public static boolean canGrief(boolean weak) {
        if (weak) {
            return IafConfig.dragonGriefing == 0;
        }
        return IafConfig.dragonGriefing < 2;
    }

    public static boolean isBlacklistedBlock(Block block) {
        if (IafConfig.blacklistBreakBlocksIsWhiteList) {
            for (String string : IafConfig.blacklistedBreakBlocks) {
                if (!string.equalsIgnoreCase(block.getRegistryName().toString())) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.blacklistedBreakBlocks) {
            if (!string.equalsIgnoreCase(block.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean canHostilesTarget(Entity entity) {
        if (entity instanceof PlayerEntity && entity.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity);
    }

    public static boolean onSameTeam(Entity entity1, Entity entity2) {
        LivingEntity multipart;
        LivingEntity owner1 = null;
        LivingEntity owner2 = null;
        boolean def = entity1.func_184191_r(entity2);
        if (entity1 instanceof TameableEntity) {
            owner1 = ((TameableEntity)entity1).func_70902_q();
        }
        if (entity2 instanceof TameableEntity) {
            owner2 = ((TameableEntity)entity2).func_70902_q();
        }
        if (entity1 instanceof EntityMutlipartPart && (multipart = ((EntityMutlipartPart)entity1).getParent()) != null && multipart instanceof TameableEntity) {
            owner1 = ((TameableEntity)multipart).func_70902_q();
        }
        if (entity2 instanceof EntityMutlipartPart && (multipart = ((EntityMutlipartPart)entity2).getParent()) != null && multipart instanceof TameableEntity) {
            owner2 = ((TameableEntity)multipart).func_70902_q();
        }
        if (owner1 != null && owner2 != null) {
            return owner1.func_70028_i((Entity)owner2);
        }
        return def;
    }

    public static boolean canDropFromDragonBlockBreak(BlockState state) {
        for (String string : IafConfig.noDropBreakBlocks) {
            if (!string.equalsIgnoreCase(state.func_177230_c().getRegistryName().toString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isDreadBlock(BlockState state) {
        Block block = state.func_177230_c();
        return block == IafBlockRegistry.DREAD_STONE || block == IafBlockRegistry.DREAD_STONE_BRICKS || block == IafBlockRegistry.DREAD_STONE_BRICKS_CHISELED || block == IafBlockRegistry.DREAD_STONE_BRICKS_CRACKED || block == IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY || block == IafBlockRegistry.DREAD_STONE_TILE || block == IafBlockRegistry.DREAD_STONE_FACE || block == IafBlockRegistry.DREAD_TORCH || block == IafBlockRegistry.DREAD_STONE_BRICKS_STAIRS || block == IafBlockRegistry.DREAD_STONE_BRICKS_SLAB || block == IafBlockRegistry.DREADWOOD_LOG || block == IafBlockRegistry.DREADWOOD_PLANKS || block == IafBlockRegistry.DREADWOOD_PLANKS_LOCK || block == IafBlockRegistry.DREAD_PORTAL || block == IafBlockRegistry.DREAD_SPAWNER;
    }
}

