/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityChainTie;
import com.github.alexthe666.iceandfire.entity.props.ChainEntityProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.WallBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemChain
extends Item {
    private boolean sticky;

    public ItemChain(boolean sticky) {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS));
        this.sticky = sticky;
        this.setRegistryName("iceandfire", sticky ? "chain_sticky" : "chain");
    }

    public static boolean attachToFence(PlayerEntity player, World worldIn, BlockPos fence) {
        EntityChainTie entityleashknot = EntityChainTie.getKnotForPosition(worldIn, fence);
        boolean flag = false;
        double d0 = 30.0;
        int i = fence.func_177958_n();
        int j = fence.func_177956_o();
        int k = fence.func_177952_p();
        for (LivingEntity LivingEntity2 : worldIn.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0))) {
            ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity2, ChainEntityProperties.class);
            if (chainProperties == null || !chainProperties.isChained() || !chainProperties.isConnectedToEntity((Entity)LivingEntity2, (Entity)player)) continue;
            if (entityleashknot == null) {
                entityleashknot = EntityChainTie.createKnot(worldIn, fence);
            }
            chainProperties.addChain((Entity)LivingEntity2, (Entity)entityleashknot);
            chainProperties.removeChain((Entity)LivingEntity2, (Entity)player);
            flag = true;
        }
        return flag;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.chain.desc_0").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.chain.desc_1").func_240699_a_(TextFormatting.GRAY));
        if (this.sticky) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.chain_sticky.desc_2").func_240699_a_(TextFormatting.GREEN));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.chain_sticky.desc_3").func_240699_a_(TextFormatting.GREEN));
        }
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ChainEntityProperties chainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)target, ChainEntityProperties.class);
        if (chainProperties != null) {
            if (chainProperties.isConnectedToEntity((Entity)target, (Entity)playerIn) || chainProperties.wasJustDisconnected) {
                chainProperties.wasJustDisconnected = false;
                return ActionResultType.SUCCESS;
            }
            if (!this.sticky) {
                double d0 = 60.0;
                double i = playerIn.func_226277_ct_();
                double j = playerIn.func_226278_cu_();
                double k = playerIn.func_226281_cx_();
                boolean flag = false;
                for (LivingEntity LivingEntity2 : playerIn.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(i - d0, j - d0, k - d0, i + d0, j + d0, k + d0))) {
                    ChainEntityProperties otherChainProperties = (ChainEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity2, ChainEntityProperties.class);
                    if (otherChainProperties == null || !otherChainProperties.isChained() || !otherChainProperties.isConnectedToEntity((Entity)LivingEntity2, (Entity)playerIn)) continue;
                    chainProperties.addChain((Entity)target, (Entity)LivingEntity2);
                    chainProperties.removeChain((Entity)target, (Entity)playerIn);
                    otherChainProperties.removeChain((Entity)target, (Entity)playerIn);
                    flag = true;
                }
                if (!flag) {
                    chainProperties.addChain((Entity)target, (Entity)playerIn);
                }
            } else {
                chainProperties.addChain((Entity)target, (Entity)playerIn);
            }
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            chainProperties.updateConnectedEntities((Entity)target);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Block block = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c();
        if (!(block instanceof WallBlock)) {
            return ActionResultType.PASS;
        }
        if (!context.func_195991_k().field_72995_K) {
            ItemChain.attachToFence(context.func_195999_j(), context.func_195991_k(), context.func_195995_a());
        }
        return ActionResultType.SUCCESS;
    }
}

