/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.props.MiscEntityProperties;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemDeathwormGauntlet
extends Item
implements ICustomRendered {
    public ItemDeathwormGauntlet(String color) {
        super(IceAndFire.PROXY.setupISTER(new Item.Properties().func_200918_c(500).func_200916_a(IceAndFire.TAB_ITEMS)));
        this.setRegistryName("iceandfire", "deathworm_gauntlet_" + color);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MiscEntityProperties.class);
        if (stack.func_77978_p() != null && properties != null) {
            if (properties.deathwormReceded || properties.deathwormLaunched) {
                return;
            }
            if (player instanceof PlayerEntity) {
                if (stack.func_77978_p().func_74762_e("HolderID") != player.func_145782_y()) {
                    stack.func_77978_p().func_74768_a("HolderID", player.func_145782_y());
                }
                if (((PlayerEntity)player).func_184811_cZ().func_185143_a((Item)this, 0.0f) == 0.0f) {
                    ((PlayerEntity)player).func_184811_cZ().func_185145_a((Item)this, 10);
                    player.func_184185_a(IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
                    properties.deathwormReceded = false;
                    properties.deathwormLaunched = true;
                }
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity LivingEntity2, int timeLeft) {
        MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity2, MiscEntityProperties.class);
        if (properties != null && properties.specialWeaponDmg > 0) {
            stack.func_222118_a(properties.specialWeaponDmg, LivingEntity2, p_219999_1_ -> p_219999_1_.func_213334_d(LivingEntity2.func_184600_cs()));
            properties.specialWeaponDmg = 0;
        }
        if (stack.func_77978_p().func_74762_e("HolderID") != -1) {
            stack.func_77978_p().func_74768_a("HolderID", -1);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        boolean hitMob = false;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        } else {
            MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(entity, MiscEntityProperties.class);
            if (properties != null) {
                if (properties.deathwormReceded) {
                    if (properties.deathwormLungeTicks > 0) {
                        properties.deathwormLungeTicks -= 4;
                    }
                    if (properties.deathwormLungeTicks <= 0) {
                        properties.deathwormLungeTicks = 0;
                        properties.deathwormReceded = false;
                        properties.deathwormLaunched = false;
                    }
                } else if (properties.deathwormLaunched) {
                    properties.deathwormLungeTicks = 4 + properties.deathwormLungeTicks;
                    if (properties.deathwormLungeTicks > 20 && !properties.deathwormReceded) {
                        properties.deathwormReceded = true;
                    }
                }
                if (properties.prevDeathwormLungeTicks == 20 && entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    Vector3d Vector3d2 = player.func_70676_i(1.0f).func_72432_b();
                    double range = 5.0;
                    for (MobEntity LivingEntity2 : world.func_217357_a(MobEntity.class, new AxisAlignedBB(player.func_226277_ct_() - range, player.func_226278_cu_() - range, player.func_226281_cx_() - range, player.func_226277_ct_() + range, player.func_226278_cu_() + range, player.func_226281_cx_() + range))) {
                        Vector3d Vector3d1 = new Vector3d(LivingEntity2.func_226277_ct_() - player.func_226277_ct_(), LivingEntity2.func_226278_cu_() - player.func_226278_cu_(), LivingEntity2.func_226281_cx_() - player.func_226281_cx_());
                        double d0 = Vector3d1.func_72433_c();
                        double d1 = Vector3d2.func_72430_b(Vector3d1 = Vector3d1.func_72432_b());
                        boolean canSee = d1 > 1.0 - 0.5 / d0 && player.func_70685_l((Entity)LivingEntity2);
                        if (!canSee) continue;
                        ++properties.specialWeaponDmg;
                        LivingEntity2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entity)), 3.0f);
                        LivingEntity2.func_233627_a_(0.5f, LivingEntity2.func_226277_ct_() - player.func_226277_ct_(), LivingEntity2.func_226281_cx_() - player.func_226281_cx_());
                    }
                }
                properties.prevDeathwormLungeTicks = properties.deathwormLungeTicks;
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.legendary_weapon.desc").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.deathworm_gauntlet.desc_0").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.deathworm_gauntlet.desc_1").func_240699_a_(TextFormatting.GRAY));
    }
}

