/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMobSpawn;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenPixieVillage;
import com.github.alexthe666.iceandfire.world.gen.WorldGenSirenIsland;
import com.github.alexthe666.iceandfire.world.structure.DreadMausoleumStructure;
import com.github.alexthe666.iceandfire.world.structure.GorgonTemplePiece;
import com.github.alexthe666.iceandfire.world.structure.GorgonTempleStructure;
import com.github.alexthe666.iceandfire.world.structure.GraveyardPiece;
import com.github.alexthe666.iceandfire.world.structure.GraveyardStructure;
import com.github.alexthe666.iceandfire.world.structure.MausoleumPiece;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IafWorldRegistry {
    public static Feature<NoFeatureConfig> FIRE_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> ICE_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> LIGHTNING_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> FIRE_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> ICE_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> LIGHTNING_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> CYCLOPS_CAVE;
    public static Feature<NoFeatureConfig> PIXIE_VILLAGE;
    public static Feature<NoFeatureConfig> SIREN_ISLAND;
    public static Feature<NoFeatureConfig> HYDRA_CAVE;
    public static Feature<NoFeatureConfig> MYRMEX_HIVE_DESERT;
    public static Feature<NoFeatureConfig> MYRMEX_HIVE_JUNGLE;
    public static Feature<NoFeatureConfig> MOB_SPAWNS;
    public static IStructurePieceType MAUSOLEUM_PIECE;
    public static Structure<NoFeatureConfig> MAUSOLEUM;
    public static final Structure<NoFeatureConfig> MAUSOLEUM_SF;
    public static IStructurePieceType GORGON_PIECE;
    public static Structure<NoFeatureConfig> GORGON_TEMPLE;
    public static final Structure<NoFeatureConfig> GORGON_TEMPLE_SF;
    public static IStructurePieceType GRAVEYARD_PIECE;
    public static Structure<NoFeatureConfig> GRAVEYARD;
    public static final Structure<NoFeatureConfig> GRAVEYARD_SF;
    public static ConfiguredFeature FIRE_LILY_CF;
    public static ConfiguredFeature FROST_LILY_CF;
    public static ConfiguredFeature LIGHTNING_LILY_CF;
    public static ConfiguredFeature COPPER_ORE_CF;
    public static ConfiguredFeature SILVER_ORE_CF;
    public static ConfiguredFeature SAPPHIRE_ORE_CF;
    public static ConfiguredFeature AMETHYST_ORE_CF;
    public static ConfiguredFeature FIRE_DRAGON_ROOST_CF;
    public static ConfiguredFeature ICE_DRAGON_ROOST_CF;
    public static ConfiguredFeature LIGHTNING_DRAGON_ROOST_CF;
    public static ConfiguredFeature FIRE_DRAGON_CAVE_CF;
    public static ConfiguredFeature ICE_DRAGON_CAVE_CF;
    public static ConfiguredFeature LIGHTNING_DRAGON_CAVE_CF;
    public static ConfiguredFeature CYCLOPS_CAVE_CF;
    public static ConfiguredFeature PIXIE_VILLAGE_CF;
    public static ConfiguredFeature SIREN_ISLAND_CF;
    public static ConfiguredFeature HYDRA_CAVE_CF;
    public static ConfiguredFeature MYRMEX_HIVE_DESERT_CF;
    public static ConfiguredFeature MYRMEX_HIVE_JUNGLE_CF;
    public static ConfiguredFeature MOB_SPAWNS_CF;
    public static StructureFeature GORGON_TEMPLE_CF;
    public static StructureFeature MAUSOLEUM_CF;
    public static StructureFeature GRAVEYARD_CF;

    public static void register() {
        FIRE_DRAGON_ROOST = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:fire_dragon_roost", (Object)((Object)new WorldGenFireDragonRoosts((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        ICE_DRAGON_ROOST = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:ice_dragon_roost", (Object)((Object)new WorldGenIceDragonRoosts((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        LIGHTNING_DRAGON_ROOST = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:lightning_dragon_roost", (Object)((Object)new WorldGenLightningDragonRoosts((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        FIRE_DRAGON_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:fire_dragon_cave", (Object)((Object)new WorldGenFireDragonCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        ICE_DRAGON_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:ice_dragon_cave", (Object)((Object)new WorldGenIceDragonCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        LIGHTNING_DRAGON_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:lightning_dragon_cave", (Object)((Object)new WorldGenLightningDragonCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        CYCLOPS_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:cyclops_cave", (Object)((Object)new WorldGenCyclopsCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        PIXIE_VILLAGE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:pixie_village", (Object)((Object)new WorldGenPixieVillage((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        SIREN_ISLAND = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:siren_island", (Object)((Object)new WorldGenSirenIsland((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        HYDRA_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:hydra_cave", (Object)((Object)new WorldGenHydraCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        MYRMEX_HIVE_DESERT = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:myrmex_hive_desert", (Object)((Object)new WorldGenMyrmexHive(false, false, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        MYRMEX_HIVE_JUNGLE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:myrmex_hive_jungle", (Object)((Object)new WorldGenMyrmexHive(false, true, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        MOB_SPAWNS = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:mob_spawns", (Object)((Object)new WorldGenMobSpawn((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_)));
        MAUSOLEUM_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:mausoleum_piece", MausoleumPiece.Piece::new);
        MAUSOLEUM = (Structure)Registry.func_218325_a((Registry)Registry.field_218361_B, (String)"iceandfire:mausoleum", MAUSOLEUM);
        IafWorldRegistry.putStructureOnAList("iceandfire:mausoleum", MAUSOLEUM);
        GORGON_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:gorgon_piece", GorgonTemplePiece.Piece::new);
        GORGON_TEMPLE = (Structure)Registry.func_218325_a((Registry)Registry.field_218361_B, (String)"iceandfire:gorgon_temple", GORGON_TEMPLE);
        IafWorldRegistry.putStructureOnAList("iceandfire:gorgon_temple", GORGON_TEMPLE);
        GRAVEYARD_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:graveyard_piece", GraveyardPiece.Piece::new);
        GRAVEYARD = (Structure)Registry.func_218325_a((Registry)Registry.field_218361_B, (String)"iceandfire:graveyard", GRAVEYARD);
        IafWorldRegistry.putStructureOnAList("iceandfire:graveyard", GRAVEYARD);
        IafWorldRegistry.addStructureSeperation((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, GORGON_TEMPLE, new StructureSeparationSettings(Math.max(IafConfig.spawnGorgonsChance, 2), Math.max(IafConfig.spawnGorgonsChance / 2, 1), 34222645));
        IafWorldRegistry.addStructureSeperation((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, MAUSOLEUM, new StructureSeparationSettings(Math.max(IafConfig.generateMausoleumChance, 2), Math.max(IafConfig.generateMausoleumChance / 2, 1), 34222645));
        IafWorldRegistry.addStructureSeperation((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, GRAVEYARD, new StructureSeparationSettings(Math.max(IafConfig.generateGraveyardChance, 2), Math.max(IafConfig.generateGraveyardChance / 2, 1), 34222644));
        GORGON_TEMPLE_CF = (StructureFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)"iceandfire:gorgon_temple", (Object)GORGON_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MAUSOLEUM_CF = (StructureFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)"iceandfire:mausoleum", (Object)MAUSOLEUM.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        GRAVEYARD_CF = (StructureFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)"iceandfire:graveyard", (Object)GRAVEYARD.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        COPPER_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:copper_ore", (Object)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, IafBlockRegistry.COPPER_ORE.func_176223_P(), 5)).func_242733_d(128)).func_242728_a()).func_242731_b(5));
        SILVER_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:silver_ore", (Object)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, IafBlockRegistry.SILVER_ORE.func_176223_P(), 8)).func_242733_d(32)).func_242728_a()).func_242731_b(2));
        SAPPHIRE_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:sapphire_ore", (Object)Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), IafBlockRegistry.SAPPHIRE_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        AMETHYST_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:amythest_ore", (Object)Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), IafBlockRegistry.AMYTHEST_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        FIRE_LILY_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:fire_lily", (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.FIRE_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l));
        FROST_LILY_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:frost_lily", (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.FROST_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l));
        LIGHTNING_LILY_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:lightning_lily", (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.LIGHTNING_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l));
        FIRE_DRAGON_ROOST_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:fire_dragon_roost", (Object)FIRE_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        ICE_DRAGON_ROOST_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:ice_dragon_roost", (Object)ICE_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        LIGHTNING_DRAGON_ROOST_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:lightning_dragon_roost", (Object)LIGHTNING_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        FIRE_DRAGON_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:fire_dragon_cave", (Object)FIRE_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        ICE_DRAGON_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:ice_dragon_cave", (Object)ICE_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        LIGHTNING_DRAGON_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:lightning_dragon_cave", (Object)LIGHTNING_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        CYCLOPS_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:cyclops_cave", (Object)CYCLOPS_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        PIXIE_VILLAGE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:pixie_village", (Object)PIXIE_VILLAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SIREN_ISLAND_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:siren_island", (Object)SIREN_ISLAND.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        HYDRA_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:hydra_cave", (Object)HYDRA_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MYRMEX_HIVE_DESERT_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:myrmex_hive_desert", (Object)MYRMEX_HIVE_DESERT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MYRMEX_HIVE_JUNGLE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:myrmex_hive_jungle", (Object)MYRMEX_HIVE_JUNGLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MOB_SPAWNS_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:misc_mob_spawns", (Object)MOB_SPAWNS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addStructureSeperation(RegistryKey<DimensionSettings> preset, Structure structure, StructureSeparationSettings settings) {
        ((DimensionSettings)WorldGenRegistries.field_243658_j.func_230516_a_(preset)).func_236108_a_().func_236195_a_().put(structure, settings);
    }

    public static <F extends Structure<?>> void putStructureOnAList(String nameForList, F structure) {
        Structure.field_236365_a_.put((Object)nameForList.toLowerCase(Locale.ROOT), structure);
    }

    private static <F extends Structure<?>> F func_236394_a_(String p_236394_0_, F p_236394_1_, GenerationStage.Decoration p_236394_2_) {
        return (F)((Structure)Registry.func_218325_a((Registry)Registry.field_218361_B, (String)p_236394_0_.toLowerCase(Locale.ROOT), p_236394_1_));
    }

    public static void setup() {
    }

    public static boolean isFarEnoughFromSpawn(IWorld world, BlockPos pos) {
        BlockPos spawnRelative = new BlockPos(0, pos.func_177956_o(), 0);
        boolean spawnCheck = !spawnRelative.func_218141_a((Vector3i)pos, IafConfig.dangerousWorldGenDistanceLimit);
        return spawnCheck;
    }

    public static boolean isDimensionListed(IServerWorld world) {
        ResourceLocation name = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.blacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.whitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDimensionListedForDragons(IServerWorld world) {
        ResourceLocation name = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.dragonBlacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.dragonWhitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFarEnoughFromDangerousGen(IWorld world, BlockPos pos) {
        return true;
    }

    public static void onBiomesLoad(BiomeLoadingEvent event) {
        if (BiomeConfig.fireLilyBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FIRE_LILY_CF);
        }
        if (BiomeConfig.lightningLilyBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LIGHTNING_LILY_CF);
        }
        if (BiomeConfig.iceLilyBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FROST_LILY_CF);
        }
        if (BiomeConfig.oreGenBiomes.contains(event.getName().toString())) {
            if (IafConfig.generateSilverOre) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, SILVER_ORE_CF);
            }
            if (IafConfig.generateCopperOre) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, COPPER_ORE_CF);
            }
        }
        if (IafConfig.generateSapphireOre && BiomeConfig.sapphireBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, SAPPHIRE_ORE_CF);
        }
        if (IafConfig.generateAmythestOre && BiomeConfig.amethystBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AMETHYST_ORE_CF);
        }
        if (IafConfig.generateDragonRoosts) {
            if (BiomeConfig.fireDragonBiomes.contains(event.getName().toString())) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FIRE_DRAGON_ROOST_CF);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, FIRE_DRAGON_CAVE_CF);
            }
            if (BiomeConfig.lightningDragonBiomes.contains(event.getName().toString())) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, LIGHTNING_DRAGON_ROOST_CF);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, LIGHTNING_DRAGON_CAVE_CF);
            }
            if (BiomeConfig.iceDragonBiomes.contains(event.getName().toString())) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ICE_DRAGON_ROOST_CF);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ICE_DRAGON_CAVE_CF);
            }
        }
        if (IafConfig.generateCyclopsCaves && BiomeConfig.cyclopsCaveBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, CYCLOPS_CAVE_CF);
        }
        if (IafConfig.spawnGorgons && BiomeConfig.gorgonTempleBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242516_a(GORGON_TEMPLE_CF);
        }
        if (IafConfig.spawnPixies && BiomeConfig.pixieBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PIXIE_VILLAGE_CF);
        }
        if (IafConfig.generateHydraCaves && BiomeConfig.hydraBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, HYDRA_CAVE_CF);
        }
        if (IafConfig.generateMausoleums && BiomeConfig.mausoleumBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242516_a(MAUSOLEUM_CF);
        }
        if (IafConfig.generateGraveyards && BiomeConfig.graveyardBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242516_a(GRAVEYARD_CF);
        }
        if (IafConfig.generateMyrmexColonies && BiomeConfig.desertMyrmexBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MYRMEX_HIVE_DESERT_CF);
        }
        if (IafConfig.generateMyrmexColonies && BiomeConfig.jungleMyrmexBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MYRMEX_HIVE_JUNGLE_CF);
        }
        if (IafConfig.generateMyrmexColonies && BiomeConfig.sirenBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SIREN_ISLAND_CF);
        }
        if (BiomeConfig.overworldSpawnBiomes.contains(event.getName().toString())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MOB_SPAWNS_CF);
        }
    }

    public static String getBiomeName(Biome biome) {
        ResourceLocation loc = ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome);
        return loc == null ? "" : loc.toString();
    }

    static {
        MAUSOLEUM = new DreadMausoleumStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        MAUSOLEUM_SF = IafWorldRegistry.func_236394_a_("iceandfire:mausoleum", MAUSOLEUM, GenerationStage.Decoration.SURFACE_STRUCTURES);
        GORGON_TEMPLE = new GorgonTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        GORGON_TEMPLE_SF = IafWorldRegistry.func_236394_a_("iceandfire:gorgon_temple", GORGON_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES);
        GRAVEYARD = new GraveyardStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        GRAVEYARD_SF = IafWorldRegistry.func_236394_a_("iceandfire:graveyard", GRAVEYARD, GenerationStage.Decoration.SURFACE_STRUCTURES);
    }
}

