/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class MyrmexWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "iceandfire_myrmex";
    private final List<BlockPos> villagerPositionsList = Lists.newArrayList();
    private final List<MyrmexHive> hiveList = Lists.newArrayList();
    private World world;
    private int tickCounter;

    public MyrmexWorldData() {
        super(IDENTIFIER);
    }

    public MyrmexWorldData(World world) {
        super(IDENTIFIER);
        this.world = world;
        this.func_76185_a();
    }

    public static MyrmexWorldData get(World world) {
        if (world instanceof ServerWorld) {
            ServerWorld overworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            DimensionSavedDataManager storage = overworld.func_217481_x();
            MyrmexWorldData data = (MyrmexWorldData)storage.func_215752_a(MyrmexWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.func_76185_a();
            }
            return data;
        }
        return null;
    }

    public static void addHive(World world, MyrmexHive hive) {
        MyrmexWorldData.get((World)world).hiveList.add(hive);
    }

    public void setWorldsForAll(World worldIn) {
        this.world = worldIn;
        for (MyrmexHive village : this.hiveList) {
            village.setWorld(worldIn);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (MyrmexHive hive : this.hiveList) {
            hive.tick(this.tickCounter, this.world);
        }
    }

    private void removeAnnihilatedHives() {
        Iterator<MyrmexHive> iterator = this.hiveList.iterator();
        while (iterator.hasNext()) {
            MyrmexHive village = iterator.next();
            if (!village.isAnnihilated()) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public List<MyrmexHive> getHivelist() {
        return this.hiveList;
    }

    public MyrmexHive getNearestHive(BlockPos doorBlock, int radius) {
        MyrmexHive village = null;
        double d0 = 3.4028234663852886E38;
        for (MyrmexHive village1 : this.hiveList) {
            float f;
            double d1 = village1.getCenter().func_177951_i((Vector3i)doorBlock);
            if (!(d1 < d0) || !(d1 <= (double)((f = (float)(radius + village1.getVillageRadius())) * f))) continue;
            village = village1;
            d0 = d1;
        }
        return village;
    }

    private boolean positionInList(BlockPos pos) {
        for (BlockPos blockpos : this.villagerPositionsList) {
            if (!blockpos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public void debug() {
        for (MyrmexHive hive : this.hiveList) {
            IceAndFire.LOGGER.warn(hive.toString());
        }
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        ListNBT nbttaglist = nbt.func_150295_c("Hives", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
            MyrmexHive village = new MyrmexHive();
            village.readVillageDataFromNBT(CompoundNBT2);
            this.hiveList.add(village);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        ListNBT nbttaglist = new ListNBT();
        for (MyrmexHive village : this.hiveList) {
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            village.writeVillageDataToNBT(CompoundNBT2);
            nbttaglist.add((Object)CompoundNBT2);
        }
        compound.func_218657_a("Hives", (INBT)nbttaglist);
        return compound;
    }

    public MyrmexHive getHiveFromUUID(UUID id) {
        for (MyrmexHive hive : this.hiveList) {
            if (hive.hiveUUID == null || !hive.hiveUUID.equals(id)) continue;
            return hive;
        }
        return null;
    }
}

