/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenMobSpawn
extends Feature<NoFeatureConfig> {
    public WorldGenMobSpawn(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean func_241855_a(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        BlockPos pos;
        if (!IafWorldRegistry.isDimensionListed((IServerWorld)worldIn)) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position.func_177982_a(8, 0, 8));
        BlockPos oceanPos = worldIn.func_205770_a(Heightmap.Type.OCEAN_FLOOR_WG, position.func_177982_a(8, 0, 8));
        Biome biome = worldIn.func_226691_t_(position);
        if (IafConfig.spawnDeathWorm && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && BiomeConfig.deathwormBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.deathWormSpawnRate + 1) == 0) {
            EntityDeathWorm deathWorm = (EntityDeathWorm)IafEntityRegistry.DEATH_WORM.func_200721_a((World)worldIn.func_201672_e());
            deathWorm.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
            deathWorm.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(position), SpawnReason.CHUNK_GENERATION, null, null);
            worldIn.func_217376_c((Entity)deathWorm);
        }
        if (IafConfig.generateWanderingCyclops && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && BiomeConfig.wanderingCyclopsBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.spawnWanderingCyclopsChance + 1) == 0) {
            EntityCyclops cyclops = (EntityCyclops)IafEntityRegistry.CYCLOPS.func_200721_a((World)worldIn.func_201672_e());
            cyclops.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
            cyclops.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(position), SpawnReason.SPAWNER, null, null);
            cyclops.setVariant(rand.nextInt(3));
            for (int i = 0; i < 3 + rand.nextInt(3); ++i) {
                SheepEntity sheep = (SheepEntity)EntityType.field_200737_ac.func_200721_a((World)worldIn.func_201672_e());
                sheep.func_70107_b((double)((float)position.func_177958_n() + 0.5f), (double)(position.func_177956_o() + 1), (double)((float)position.func_177952_p() + 0.5f));
                sheep.func_175512_b(SheepEntity.func_175510_a((Random)rand));
                worldIn.func_217376_c((Entity)sheep);
            }
        }
        if (IafConfig.generateDragonSkeletons) {
            int dragonage;
            EntityDragonBase firedragon;
            if (BiomeConfig.lightningDragonSkeletonBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.generateDragonSkeletonChance + 1) == 0) {
                firedragon = (EntityLightningDragon)IafEntityRegistry.LIGHTNING_DRAGON.func_200721_a((World)worldIn.func_201672_e());
                firedragon.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
                dragonage = 10 + rand.nextInt(100);
                firedragon.growDragon(dragonage);
                ((EntityLightningDragon)firedragon).modelDeadProgress = 20.0f;
                firedragon.setModelDead(true);
                firedragon.setDeathStage(dragonage / 5 / 2);
                ((EntityLightningDragon)firedragon).field_70177_z = rand.nextInt(360);
                worldIn.func_217376_c((Entity)firedragon);
            } else if (BiomeConfig.fireDragonSkeletonBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.generateDragonSkeletonChance + 1) == 0) {
                firedragon = (EntityFireDragon)IafEntityRegistry.FIRE_DRAGON.func_200721_a((World)worldIn.func_201672_e());
                firedragon.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
                dragonage = 10 + rand.nextInt(100);
                firedragon.growDragon(dragonage);
                ((EntityFireDragon)firedragon).modelDeadProgress = 20.0f;
                firedragon.setModelDead(true);
                firedragon.setDeathStage(dragonage / 5 / 2);
                ((EntityFireDragon)firedragon).field_70177_z = rand.nextInt(360);
                worldIn.func_217376_c((Entity)firedragon);
            }
            if (BiomeConfig.iceDragonSkeletonBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.generateDragonSkeletonChance + 1) == 0) {
                EntityIceDragon icedragon = (EntityIceDragon)IafEntityRegistry.ICE_DRAGON.func_200721_a((World)worldIn.func_201672_e());
                icedragon.func_70107_b((float)position.func_177958_n() + 0.5f, position.func_177956_o() + 1, (float)position.func_177952_p() + 0.5f);
                dragonage = 10 + rand.nextInt(100);
                icedragon.growDragon(dragonage);
                icedragon.modelDeadProgress = 20.0f;
                icedragon.setModelDead(true);
                icedragon.setDeathStage(dragonage / 5 / 2);
                icedragon.field_70177_z = rand.nextInt(360);
                worldIn.func_217376_c((Entity)icedragon);
            }
        }
        if (IafConfig.spawnHippocampus && BiomeConfig.hippocampusBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.hippocampusSpawnChance + 1) == 0) {
            for (int i = 0; i < rand.nextInt(5); ++i) {
                BlockPos pos2 = oceanPos.func_177982_a(rand.nextInt(10) - 5, rand.nextInt(30), rand.nextInt(10) - 5);
                if (worldIn.func_204610_c(pos2).func_206886_c() != Fluids.field_204546_a) continue;
                EntityHippocampus campus = (EntityHippocampus)IafEntityRegistry.HIPPOCAMPUS.func_200721_a((World)worldIn.func_201672_e());
                campus.setVariant(rand.nextInt(5));
                campus.func_70012_b((float)pos2.func_177958_n() + 0.5f, (float)pos2.func_177956_o() + 0.5f, (float)pos2.func_177952_p() + 0.5f, 0.0f, 0.0f);
                worldIn.func_217376_c((Entity)campus);
            }
        }
        if (IafConfig.spawnSeaSerpents && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && BiomeConfig.seaSerpentBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.seaSerpentSpawnChance + 1) == 0 && worldIn.func_204610_c(pos = oceanPos.func_177982_a(rand.nextInt(10) - 5, rand.nextInt(30), rand.nextInt(10) - 5)).func_206886_c() == Fluids.field_204546_a) {
            EntitySeaSerpent serpent = (EntitySeaSerpent)IafEntityRegistry.SEA_SERPENT.func_200721_a((World)worldIn.func_201672_e());
            serpent.onWorldSpawn(rand);
            serpent.func_70012_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
            worldIn.func_217376_c((Entity)serpent);
        }
        if (IafConfig.spawnStymphalianBirds && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && BiomeConfig.stymphalianBiomes.contains(IafWorldRegistry.getBiomeName(biome)) && rand.nextInt(IafConfig.stymphalianBirdSpawnChance + 1) == 0) {
            for (int i = 0; i < 4 + rand.nextInt(4); ++i) {
                BlockPos pos3 = position.func_177982_a(rand.nextInt(10) - 5, 0, rand.nextInt(10) - 5);
                if (!worldIn.func_180495_p((pos3 = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos3)).func_177977_b()).func_200132_m()) continue;
                EntityStymphalianBird bird = (EntityStymphalianBird)IafEntityRegistry.STYMPHALIAN_BIRD.func_200721_a((World)worldIn.func_201672_e());
                bird.func_70012_b((float)pos3.func_177958_n() + 0.5f, (float)pos3.func_177956_o() + 1.5f, (float)pos3.func_177952_p() + 0.5f, 0.0f, 0.0f);
                worldIn.func_217376_c((Entity)bird);
            }
        }
        return false;
    }
}

