/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.telepathicgrunt.repurposedstructures.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.RSStructureFilterMaps;
import com.telepathicgrunt.repurposedstructures.RSStructures;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;

public class RSAddFeaturesAndStructures {
    public static void addDimensionalSpacing(WorldEvent.Load event) {
        List dimensionBlacklist = Arrays.stream(RepurposedStructures.RSMainConfig.blacklistedDimensions.get().split(",")).map(String::trim).collect(Collectors.toList());
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            if (dimensionBlacklist.stream().anyMatch(blacklist -> blacklist.equals(serverWorld.func_234923_W_().func_240901_a_().toString()))) {
                tempMap.keySet().removeAll(RSStructures.RS_STRUCTURES.keySet());
            } else {
                tempMap.putAll(RSStructures.RS_STRUCTURES);
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            for (ResourceLocation identifier : RSStructures.RS_STRUCTURE_START_PIECES) {
                JigsawPattern structurePool = (JigsawPattern)serverWorld.func_241828_r().func_243612_b(Registry.field_243555_ax).func_82594_a(identifier);
                if (structurePool == null) continue;
                List elements = structurePool.func_214943_b(new Random());
                for (JigsawPiece element : elements) {
                    element.func_214852_a(serverWorld.func_184163_y(), new BlockPos(0, 0, 0), Rotation.NONE);
                }
            }
        }
    }

    public static void addMineshafts(BiomeLoadingEvent event) {
        for (Map.Entry<StructureFeature<?, ?>, Predicate<BiomeLoadingEvent>> mineshaftTypeAndCondition : RSStructureFilterMaps.MINESHAFT_TYPE_AND_CONDITIONS.entrySet()) {
            if (RSAddFeaturesAndStructures.attemptToAddMineshaft(event, mineshaftTypeAndCondition.getKey(), mineshaftTypeAndCondition.getValue())) break;
        }
    }

    private static boolean attemptToAddMineshaft(BiomeLoadingEvent event, StructureFeature<?, ?> configuredStructureFeature, Predicate<BiomeLoadingEvent> predicate) {
        if (predicate.test(event) && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.yungsBetterMineshaftIsNotOn) {
                event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == Structure.field_236367_c_);
            }
            event.getGeneration().getStructures().add(() -> configuredStructureFeature);
            return true;
        }
        return false;
    }

    public static void addDungeons(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSDungeonsConfig.jungleDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.JUNGLE && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.JUNGLE_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.badlandsDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.MESA && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.BADLANDS_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.darkForestDungeonSpawnrate.get() != 0 && event.getName().func_110623_a().contains("dark_forest") && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.DARK_FOREST_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.desertDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.DESERT && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.DESERT_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.mushroomDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.MUSHROOM && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.MUSHROOM_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.swampDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.SWAMP && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.SWAMP_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.snowDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.ICY && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(true, event, RSConfiguredFeatures.SNOW_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.netherDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.NETHER && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(false, event, RSConfiguredFeatures.NETHER_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.endDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.THEEND && !event.getName().equals((Object)new ResourceLocation("minecraft:the_end")) && !event.getName().equals((Object)new ResourceLocation("minecraft:small_end_islands")) && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfigUA(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(false, event, RSConfiguredFeatures.END_DUNGEONS);
        } else if (RepurposedStructures.RSDungeonsConfig.oceanDungeonSpawnrate.get() != 0 && event.getCategory() == Biome.Category.OCEAN && RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfig(event.getName())) {
            RSAddFeaturesAndStructures.replaceOrAddDungeon(false, event, RSConfiguredFeatures.OCEAN_DUNGEONS);
        }
    }

    private static void replaceOrAddDungeon(boolean replacing, BiomeLoadingEvent event, ConfiguredFeature<?, ?> rsDungeon) {
        if (replacing) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).removeIf(supplier -> ((ConfiguredFeature)supplier.get()).field_222737_a.equals(Features.field_243797_W.field_222737_a));
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_STRUCTURES).add(() -> rsDungeon);
    }

    private static boolean dungeonAllowedByNamespaceAndConfigUA(ResourceLocation biomeID) {
        if (!biomeID.func_110624_b().equals("ultra_amplified_dimension")) {
            return RSAddFeaturesAndStructures.dungeonAllowedByNamespaceAndConfig(biomeID);
        }
        return false;
    }

    private static boolean dungeonAllowedByNamespaceAndConfig(ResourceLocation biomeID) {
        return biomeID.func_110624_b().equals("minecraft") || RepurposedStructures.RSDungeonsConfig.addDungeonsToModdedBiomes.get() != false;
    }

    public static void addWells(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSWellsConfig.badlandsWellSpawnrate.get() != 10000 && event.getCategory() == Biome.Category.MESA && RSAddFeaturesAndStructures.wellAllowedByNamespaceAndConfig(event.getName())) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.BADLANDS_WELL);
        } else if (RepurposedStructures.RSWellsConfig.netherWellSpawnrate.get() != 10000 && event.getCategory() == Biome.Category.NETHER && RSAddFeaturesAndStructures.wellAllowedByNamespaceAndConfig(event.getName())) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.NETHER_WELL);
        } else if (RepurposedStructures.RSWellsConfig.snowWellSpawnrate.get() != 10000 && (event.getCategory() == Biome.Category.ICY || event.getName().func_110623_a().contains("snow")) && RSAddFeaturesAndStructures.wellAllowedByNamespaceAndConfig(event.getName())) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.SNOW_WELL);
        } else if (RepurposedStructures.RSWellsConfig.mossyStoneWellSpawnrate.get() != 10000 && (event.getCategory() == Biome.Category.SWAMP || event.getCategory() == Biome.Category.JUNGLE || event.getName().func_110623_a().contains("dark_forest") || event.getName().func_110623_a().contains("dark_oak")) && RSAddFeaturesAndStructures.wellAllowedByNamespaceAndConfig(event.getName())) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.MOSSY_STONE_WELL);
        } else if (RepurposedStructures.RSWellsConfig.forestWellSpawnrate.get() != 10000 && event.getCategory() == Biome.Category.FOREST && !event.getName().func_110623_a().contains("dark_forest") && !event.getName().func_110623_a().contains("dark_oak") && RSAddFeaturesAndStructures.wellAllowedByNamespaceAndConfig(event.getName())) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> RSConfiguredFeatures.FOREST_WELL);
        }
    }

    private static boolean wellAllowedByNamespaceAndConfig(ResourceLocation biomeID) {
        return biomeID.func_110624_b().equals("minecraft") || RepurposedStructures.RSWellsConfig.addWellsToModdedBiomes.get() != false;
    }

    public static void addSwampTreeFeatures(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSMainConfig.hornedSwampTree.get().booleanValue() && (event.getName().equals((Object)new ResourceLocation("minecraft:swamp")) || RepurposedStructures.RSMainConfig.addLargeSwampTreeModdedBiomes.get().booleanValue() && event.getCategory() == Biome.Category.SWAMP && !event.getName().func_110624_b().equals("ultra_amplified_dimension") && !event.getName().func_110624_b().equals("minecraft"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.HORNED_SWAMP_TREE_UNCOMMON);
        } else if (RepurposedStructures.RSMainConfig.hornedSwampTree.get().booleanValue() && event.getName().equals((Object)new ResourceLocation("minecraft:swamp_hills"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).removeIf(configuredFeature -> ((ConfiguredFeature)configuredFeature.get()).field_222738_b instanceof DecoratedFeatureConfig && RSAddFeaturesAndStructures.serializeAndCompareFeature((ConfiguredFeature)configuredFeature.get(), Features.field_243875_bU));
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.HORNED_SWAMP_TREE_COMMON);
        }
    }

    public static void addBoulderFeatures(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSMainConfig.boulderGiant.get().booleanValue() && !event.getName().func_110624_b().equals("ultra_amplified_dimension") && (event.getName().equals((Object)new ResourceLocation("minecraft:giant_spruce_taiga_hills")) || event.getName().equals((Object)new ResourceLocation("minecraft:giant_tree_taiga_hills")) || RepurposedStructures.RSMainConfig.addGiantBouldersModdedBiomes.get().booleanValue() && !event.getName().func_110624_b().equals("minecraft") && (event.getName().func_110623_a().contains("giant") && event.getName().func_110623_a().contains("taiga") || event.getName().func_110623_a().contains("redwood")))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).removeIf(configuredFeature -> ((ConfiguredFeature)configuredFeature.get()).field_222738_b instanceof DecoratedFeatureConfig && RSAddFeaturesAndStructures.serializeAndCompareFeature((ConfiguredFeature)configuredFeature.get(), Features.field_243779_E));
            event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).add(() -> RSConfiguredFeatures.BOULDER_GIANT);
        } else if (RepurposedStructures.RSMainConfig.boulderTiny.get().booleanValue() && !event.getName().func_110624_b().equals("ultra_amplified_dimension") && (event.getName().equals((Object)new ResourceLocation("minecraft:snowy_taiga_mountains")) || event.getName().equals((Object)new ResourceLocation("minecraft:taiga_mountains")) || RepurposedStructures.RSMainConfig.addTinyBouldersModdedBiomes.get().booleanValue() && !event.getName().func_110624_b().equals("minecraft") && event.getName().func_110623_a().contains("taiga") && (event.getName().func_110623_a().contains("mountain") || event.getName().func_110623_a().contains("hill")))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.LOCAL_MODIFICATIONS).add(() -> RSConfiguredFeatures.BOULDER_TINY);
        }
    }

    public static void addStrongholds(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSStrongholdsConfig.allowStonebrickStronghold.get().booleanValue() && RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdSpawnrate.get() != 1001 && event.getCategory() != Biome.Category.NETHER && (event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_.equals(Structure.field_236375_k_)) || !event.getName().func_110624_b().equals("minecraft") && RepurposedStructures.RSStrongholdsConfig.addStonebrickStrongholdToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.STONEBRICK_STRONGHOLD);
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> RSConfiguredFeatures.STONEBRICK_STRONGHOLD_CHAINS);
        } else if (RepurposedStructures.RSStrongholdsConfig.netherStrongholdSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSStrongholdsConfig.addNetherStrongholdToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_STRONGHOLD);
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_DECORATION).add(() -> RSConfiguredFeatures.NETHER_STRONGHOLD_CHAINS);
        }
    }

    public static void addOutposts(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            if (RepurposedStructures.RSOutpostsConfig.crimsonOutpostSpawnrate.get() != 1001 && event.getName().func_110623_a().contains("crimson") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSOutpostsConfig.addCrimsonOutpostToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.CRIMSON_OUTPOST);
            } else if (RepurposedStructures.RSOutpostsConfig.warpedOutpostSpawnrate.get() != 1001 && event.getName().func_110623_a().contains("warped") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSOutpostsConfig.addWarpedOutpostToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.WARPED_OUTPOST);
            } else if (RepurposedStructures.RSOutpostsConfig.netherBrickOutpostSpawnrate.get() != 1001 && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSOutpostsConfig.addNetherBrickOutpostToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_BRICK_OUTPOST);
            }
        }
    }

    public static void addShipwrecks(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSShipwrecksConfig.endShipwreckSpawnrate.get() != 1001 && (event.getName().equals((Object)new ResourceLocation("minecraft:end_highlands")) || !event.getName().func_110624_b().equals("minecraft") && event.getCategory() == Biome.Category.THEEND && RepurposedStructures.RSShipwrecksConfig.addEndShipwreckToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.END_SHIPWRECK);
        }
        if (event.getCategory() == Biome.Category.NETHER) {
            if (RepurposedStructures.RSShipwrecksConfig.crimsonShipwreckSpawnrate.get() != 1001 && event.getName().func_110623_a().contains("crimson") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSShipwrecksConfig.addCrimsonShipwreckToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.CRIMSON_SHIPWRECK);
            } else if (RepurposedStructures.RSShipwrecksConfig.warpedShipwreckSpawnrate.get() != 1001 && event.getName().func_110623_a().contains("warped") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSShipwrecksConfig.addCrimsonShipwreckToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.WARPED_SHIPWRECK);
            } else if (RepurposedStructures.RSShipwrecksConfig.netherBricksShipwreckSpawnrate.get() != 1001 && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSShipwrecksConfig.addNetherBricksShipwreckToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_BRICKS_SHIPWRECK);
            }
        }
    }

    public static void addJungleFortress(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSMainConfig.jungleFortressSpawnrate.get() != 1001) {
            if (event.getCategory() == Biome.Category.JUNGLE && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSMainConfig.addJungleFortressToModdedBiomes.get().booleanValue())) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.JUNGLE_FORTRESS);
            }
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.JUNGLE_FORTRESS_VINES);
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> RSConfiguredFeatures.FORTRESS_BREAKAGE);
        }
    }

    public static void addTemples(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSTemplesConfig.netherBasaltTempleSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && (event.getName().func_110623_a().contains("basalt") || event.getName().func_110623_a().contains("blackstone")) && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherBasaltTempleToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_BASALT_TEMPLE);
        } else if (RepurposedStructures.RSTemplesConfig.netherCrimsonTempleSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && event.getName().func_110623_a().contains("crimson") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherCrimsonTempleToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_CRIMSON_TEMPLE);
        } else if (RepurposedStructures.RSTemplesConfig.netherWarpedTempleSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && event.getName().func_110623_a().contains("warped") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherWarpedTempleToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_WARPED_TEMPLE);
        } else if (RepurposedStructures.RSTemplesConfig.netherSoulTempleSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && event.getName().func_110623_a().contains("soul") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherSoulTempleToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_SOUL_TEMPLE);
        } else if (RepurposedStructures.RSTemplesConfig.netherWastelandTempleSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherWastelandTempleToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_WASTELAND_TEMPLE);
        }
    }

    public static void addPyramids(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSTemplesConfig.netherPyramidSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addNetherPyramidToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.NETHER_PYRAMID);
        }
        if (RepurposedStructures.RSTemplesConfig.badlandsPyramidSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.MESA && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSTemplesConfig.addBadlandsPyramidToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.BADLANDS_TEMPLE);
        }
    }

    public static void addIgloos(BiomeLoadingEvent event) {
        if (RepurposedStructures.RSMainConfig.grassyIglooSpawnrate.get() != 1001 && (event.getCategory() == Biome.Category.FOREST || event.getCategory() == Biome.Category.PLAINS) && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSMainConfig.addGrassyIglooToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.GRASSY_IGLOO);
        }
        if (RepurposedStructures.RSMainConfig.stoneIglooSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.TAIGA && event.getName().func_110623_a().contains("giant") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSMainConfig.addStoneIglooToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.STONE_IGLOO);
        }
    }

    public static void addVillages(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.MESA && !event.getName().func_110623_a().contains("plateau") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.badlandsVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.BADLANDS_VILLAGE);
            }
        } else if (event.getName().func_110623_a().contains("birch") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.birchVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.BIRCH_VILLAGE);
            }
        } else if (event.getName().func_110623_a().contains("dark_forest") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.darkForestVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.DARK_FOREST_VILLAGE);
            }
        } else if (event.getCategory() == Biome.Category.JUNGLE && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.jungleVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.JUNGLE_VILLAGE);
                event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.JUNGLE_VILLAGE_VINES);
            }
        } else if (event.getCategory() == Biome.Category.SWAMP && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.swampVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.SWAMP_VILLAGE);
                event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> RSConfiguredFeatures.SWAMP_VILLAGE_VINES);
            }
        } else if (event.getCategory() == Biome.Category.EXTREME_HILLS && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.RSVillagesConfig.mountainsVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MOUNTAINS_VILLAGE);
            }
        } else if (event.getName().equals((Object)new ResourceLocation("minecraft:giant_spruce_taiga")) || event.getName().equals((Object)new ResourceLocation("minecraft:giant_tree_taiga")) || !event.getName().func_110624_b().equals("minecraft") && RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue() && (event.getName().func_110623_a().contains("giant") && event.getName().func_110623_a().contains("taiga") || event.getName().func_110623_a().contains("redwood"))) {
            if (RepurposedStructures.RSVillagesConfig.giantTaigaVillageSpawnrate.get() != 1001) {
                event.getGeneration().getStructures().add(() -> RSConfiguredStructures.GIANT_TAIGA_VILLAGE);
            }
        } else if (RepurposedStructures.RSVillagesConfig.crimsonVillageSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && event.getName().func_110623_a().contains("crimson") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.CRIMSON_VILLAGE);
        } else if (RepurposedStructures.RSVillagesConfig.warpedVillageSpawnrate.get() != 1001 && event.getCategory() == Biome.Category.NETHER && event.getName().func_110623_a().contains("warped") && (event.getName().func_110624_b().equals("minecraft") || RepurposedStructures.RSVillagesConfig.addVillagesToModdedBiomes.get().booleanValue())) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.WARPED_VILLAGE);
        }
    }

    private static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> configuredFeature1, ConfiguredFeature<?, ?> configuredFeature2) {
        Optional configuredFeatureJSON1 = ConfiguredFeature.field_236264_b_.encode(() -> configuredFeature1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional configuredFeatureJSON2 = ConfiguredFeature.field_236264_b_.encode(() -> configuredFeature2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if ((!configuredFeatureJSON1.isPresent() || !configuredFeatureJSON2.isPresent()) && configuredFeature1.field_222738_b instanceof DecoratedFeatureConfig && configuredFeature2.field_222738_b instanceof DecoratedFeatureConfig && ((ConfiguredFeature)((DecoratedFeatureConfig)configuredFeature1.field_222738_b).field_214689_a.get()).field_222737_a == ((ConfiguredFeature)((DecoratedFeatureConfig)configuredFeature2.field_222738_b).field_214689_a.get()).field_222737_a) {
            return true;
        }
        return configuredFeatureJSON1.equals(configuredFeatureJSON2);
    }
}

