/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.FortressJungleStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.OutpostNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.PyramidBadlandsStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.PyramidNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSMineshaftEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSMineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSNetherStrongholdStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.RSStonebrickStrongholdStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.ShipwreckEndStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.ShipwreckNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.TempleNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.VillageBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.VillageNetherStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.VillageSwampStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.RSMineshaftPieces;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePieces;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class RSStructures {
    public static final Map<Structure<?>, StructureSeparationSettings> RS_STRUCTURES = new HashMap();
    public static final Set<ResourceLocation> RS_STRUCTURE_START_PIECES = new HashSet<ResourceLocation>();
    public static Structure<NoFeatureConfig> BIRCH_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.BIRCH, RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.birchMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.birchMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> DESERT_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.DESERT, RepurposedStructures.RSMineshaftsConfig.desertMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.desertMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.desertMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> END_MINESHAFT = new RSMineshaftEndStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.END, RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.endMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.endMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> NETHER_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.NETHER, RepurposedStructures.RSMineshaftsConfig.netherMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.netherMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.netherMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> ICY_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.ICY, RepurposedStructures.RSMineshaftsConfig.icyMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.icyMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.icyMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> JUNGLE_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.JUNGLE, RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.jungleMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.jungleMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> OCEAN_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.OCEAN, RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.oceanMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.oceanMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> SAVANNA_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.SAVANNA, RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.savannaMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.savannaMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> STONE_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.STONE, RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.stoneMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.stoneMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> SWAMP_OR_DARK_FOREST_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.SWAMPORDARKFOREST, RepurposedStructures.RSMineshaftsConfig.swampAndDarkForestMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.swampAndDarkForestMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.swampAndDarkForestMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> TAIGA_MINESHAFT = new RSMineshaftStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, RSMineshaftPieces.Type.TAIGA, RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSpawnrate.get().intValue(), RepurposedStructures.RSMineshaftsConfig.taigaMineshaftMaxHeight.get(), RepurposedStructures.RSMineshaftsConfig.taigaMineshaftMinHeight.get());
    public static Structure<NoFeatureConfig> STONEBRICK_STRONGHOLD = new RSStonebrickStrongholdStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static Structure<NoFeatureConfig> NETHER_STRONGHOLD = new RSNetherStrongholdStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static Structure<NoFeatureConfig> JUNGLE_FORTRESS = new FortressJungleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static Structure<NoFeatureConfig> GRASSY_IGLOO = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:igloos/grassy_top"), 3);
    public static Structure<NoFeatureConfig> STONE_IGLOO = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:igloos/stone_top"), 3);
    public static Structure<NoFeatureConfig> NETHER_WASTELAND_TEMPLE = new TempleNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "temples/temple_nether_wasteland"));
    public static Structure<NoFeatureConfig> NETHER_BASALT_TEMPLE = new TempleNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "temples/temple_nether_basalt"));
    public static Structure<NoFeatureConfig> NETHER_WARPED_TEMPLE = new TempleNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "temples/temple_nether_warped"));
    public static Structure<NoFeatureConfig> NETHER_CRIMSON_TEMPLE = new TempleNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "temples/temple_nether_crimson"));
    public static Structure<NoFeatureConfig> NETHER_SOUL_TEMPLE = new TempleNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "temples/temple_nether_soul"));
    public static Structure<NoFeatureConfig> NETHER_BRICK_OUTPOST = new OutpostNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "outposts/nether_brick/base_plates"));
    public static Structure<NoFeatureConfig> WARPED_OUTPOST = new OutpostNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "outposts/warped/base_plates"));
    public static Structure<NoFeatureConfig> CRIMSON_OUTPOST = new OutpostNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures", "outposts/crimson/base_plates"));
    public static Structure<NoFeatureConfig> NETHER_PYRAMID = new PyramidNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static Structure<NoFeatureConfig> BADLANDS_TEMPLE = new PyramidBadlandsStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static Structure<NoFeatureConfig> END_SHIPWRECK = new ShipwreckEndStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static Structure<NoFeatureConfig> NETHER_BRICKS_SHIPWRECK = new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/nether_bricks"), false);
    public static Structure<NoFeatureConfig> CRIMSON_SHIPWRECK = new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/crimson"), true);
    public static Structure<NoFeatureConfig> WARPED_SHIPWRECK = new ShipwreckNetherStructure(new ResourceLocation("repurposed_structures", "shipwrecks/warped"), true);
    public static Structure<NoFeatureConfig> BADLANDS_VILLAGE = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/badlands/town_centers"), 10);
    public static Structure<NoFeatureConfig> BIRCH_VILLAGE = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/birch/town_centers"), 6);
    public static Structure<NoFeatureConfig> DARK_FOREST_VILLAGE = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/dark_forest/town_centers"), 6);
    public static Structure<NoFeatureConfig> JUNGLE_VILLAGE = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/jungle/town_centers"), 8);
    public static Structure<NoFeatureConfig> SWAMP_VILLAGE = new VillageSwampStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/swamp/town_centers"), 6);
    public static Structure<NoFeatureConfig> MOUNTAINS_VILLAGE = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/mountains/town_centers"), 6);
    public static Structure<NoFeatureConfig> GIANT_TAIGA_VILLAGE = new VillageBaseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/giant_taiga/town_centers"), 6);
    public static Structure<NoFeatureConfig> CRIMSON_VILLAGE = new VillageNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/crimson/town_centers"), 6);
    public static Structure<NoFeatureConfig> WARPED_VILLAGE = new VillageNetherStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, new ResourceLocation("repurposed_structures:village/warped/town_centers"), 6);
    public static List<Structure<?>> OVERWORLD_VILLAGE_LIST = Arrays.asList(BADLANDS_VILLAGE, BIRCH_VILLAGE, DARK_FOREST_VILLAGE, JUNGLE_VILLAGE, SWAMP_VILLAGE, MOUNTAINS_VILLAGE, GIANT_TAIGA_VILLAGE);
    public static List<Structure<?>> NETHER_VILLAGE_LIST = Arrays.asList(CRIMSON_VILLAGE, WARPED_VILLAGE);
    public static List<Structure<?>> NETHER_OUTPOSTS_LIST = Arrays.asList(NETHER_BRICK_OUTPOST, WARPED_OUTPOST, CRIMSON_OUTPOST);
    public static List<Structure<?>> NETHER_TEMPLE_LIST = Arrays.asList(NETHER_WASTELAND_TEMPLE, NETHER_BASALT_TEMPLE, NETHER_WARPED_TEMPLE, NETHER_CRIMSON_TEMPLE, NETHER_SOUL_TEMPLE, NETHER_PYRAMID);
    public static List<Structure<?>> NETHER_SHIPWRECKS_LIST = Arrays.asList(NETHER_BRICKS_SHIPWRECK, WARPED_SHIPWRECK, CRIMSON_SHIPWRECK);
    public static List<Structure<?>> LARGE_VANILLA_NETHER_STRUCTURE_LIST = Arrays.asList(Structure.field_236378_n_, Structure.field_236383_s_);

    public static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_birch"), BIRCH_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 399117345));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_desert"), DESERT_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1990612785));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_end"), END_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2057488602));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_nether"), NETHER_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1220811654));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_icy"), ICY_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1451015246));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_jungle"), JUNGLE_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1434412876));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_ocean"), OCEAN_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1774808662));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_savanna"), SAVANNA_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1960212212));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_stone"), STONE_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1436736620));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_swamp_or_dark_forest"), SWAMP_OR_DARK_FOREST_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 2037177700));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "mineshaft_taiga"), TAIGA_MINESHAFT, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(1, 0, 1383003172));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "stronghold_stonebrick"), STONEBRICK_STRONGHOLD, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSStrongholdsConfig.stonebrickStrongholdSpawnrate.get().intValue() * 0.5f), 1098192663));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "stronghold_nether"), NETHER_STRONGHOLD, GenerationStage.Decoration.UNDERGROUND_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSStrongholdsConfig.netherStrongholdSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSStrongholdsConfig.netherStrongholdSpawnrate.get().intValue() * 0.5f), 1731422513));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "fortress_jungle"), JUNGLE_FORTRESS, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.jungleFortressSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.jungleFortressSpawnrate.get().intValue() * 0.5f), 1464189157));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "igloo_grassy"), GRASSY_IGLOO, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.grassyIglooSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.grassyIglooSpawnrate.get().intValue() * 0.5f), 1460835582));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "igloo_stone"), STONE_IGLOO, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSMainConfig.stoneIglooSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSMainConfig.stoneIglooSpawnrate.get().intValue() * 0.5f), 1327429039));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "temple_nether_wasteland"), NETHER_WASTELAND_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherWastelandTempleSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherWastelandTempleSpawnrate.get().intValue() * 0.5f), 1435489909));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "temple_nether_soul"), NETHER_SOUL_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherSoulTempleSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherSoulTempleSpawnrate.get().intValue() * 0.5f), 1799485937));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "temple_nether_basalt"), NETHER_BASALT_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherBasaltTempleSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherBasaltTempleSpawnrate.get().intValue() * 0.5f), 1063117750));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "temple_nether_crimson"), NETHER_CRIMSON_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherCrimsonTempleSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherCrimsonTempleSpawnrate.get().intValue() * 0.5f), 1898896156));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "temple_nether_warped"), NETHER_WARPED_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherWarpedTempleSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherWarpedTempleSpawnrate.get().intValue() * 0.5f), 1635542708));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "outpost_nether_brick"), NETHER_BRICK_OUTPOST, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.netherBrickOutpostSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.netherBrickOutpostSpawnrate.get().intValue() * 0.5f), 1305971394));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "outpost_warped"), WARPED_OUTPOST, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.warpedOutpostSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.warpedOutpostSpawnrate.get().intValue() * 0.5f), 1928816918));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "outpost_crimson"), CRIMSON_OUTPOST, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSOutpostsConfig.crimsonOutpostSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSOutpostsConfig.crimsonOutpostSpawnrate.get().intValue() * 0.5f), 1951425662));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "pyramid_badlands"), BADLANDS_TEMPLE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.badlandsPyramidSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.badlandsPyramidSpawnrate.get().intValue() * 0.5f), 1718729448));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "pyramid_nether"), NETHER_PYRAMID, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSTemplesConfig.netherPyramidSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSTemplesConfig.netherPyramidSpawnrate.get().intValue() * 0.5f), 2054372964));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "shipwreck_end"), END_SHIPWRECK, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.endShipwreckSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.endShipwreckSpawnrate.get().intValue() * 0.5f), 1605500075));
        RSStructures.registerStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "shipwreck_nether_bricks"), NETHER_BRICKS_SHIPWRECK, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.netherBricksShipwreckSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.netherBricksShipwreckSpawnrate.get().intValue() * 0.5f), 2073308006));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "shipwreck_crimson"), CRIMSON_SHIPWRECK, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.crimsonShipwreckSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.crimsonShipwreckSpawnrate.get().intValue() * 0.5f), 1019716871));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "shipwreck_warped"), WARPED_SHIPWRECK, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSShipwrecksConfig.warpedShipwreckSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSShipwrecksConfig.warpedShipwreckSpawnrate.get().intValue() * 0.5f), 2072979641));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_badlands"), BADLANDS_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.badlandsVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.badlandsVillageSpawnrate.get().intValue() * 0.5f), 1319707555));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_birch"), BIRCH_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.birchVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.birchVillageSpawnrate.get().intValue() * 0.5f), 1102567365));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_dark_oak"), DARK_FOREST_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.darkForestVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.darkForestVillageSpawnrate.get().intValue() * 0.5f), 1921339358));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_jungle"), JUNGLE_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.jungleVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.jungleVillageSpawnrate.get().intValue() * 0.5f), 1229975218));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_swamp"), SWAMP_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.swampVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.swampVillageSpawnrate.get().intValue() * 0.5f), 1559650945));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_mountains"), MOUNTAINS_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.mountainsVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.mountainsVillageSpawnrate.get().intValue() * 0.5f), 2010875989));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_giant_taiga"), GIANT_TAIGA_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.giantTaigaVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.giantTaigaVillageSpawnrate.get().intValue() * 0.5f), 1559528842));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_crimson"), CRIMSON_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.crimsonVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.crimsonVillageSpawnrate.get().intValue() * 0.5f), 1854750198));
        RSStructures.registerLandscapeTransformingStructure(event.getRegistry(), new ResourceLocation("repurposed_structures", "village_warped"), WARPED_VILLAGE, GenerationStage.Decoration.SURFACE_STRUCTURES, new StructureSeparationSettings(RepurposedStructures.RSVillagesConfig.warpedVillageSpawnrate.get().intValue(), (int)((float)RepurposedStructures.RSVillagesConfig.warpedVillageSpawnrate.get().intValue() * 0.5f), 1298332136));
        StructurePieces.registerStructurePieces();
    }

    public static <F extends Structure<NoFeatureConfig>> void registerLandscapeTransformingStructure(IForgeRegistry<Structure<?>> registry, ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings StructureSeparationSettings2) {
        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        RSStructures.registerStructure(registry, resourceLocation, structure, stage, StructureSeparationSettings2);
    }

    public static <F extends Structure<NoFeatureConfig>> void registerStructure(IForgeRegistry<Structure<?>> registry, ResourceLocation resourceLocation, F structure, GenerationStage.Decoration stage, StructureSeparationSettings structureSeparationSettings) {
        structure.setRegistryName(resourceLocation);
        Structure.func_236394_a_((String)resourceLocation.toString(), structure, (GenerationStage.Decoration)stage);
        FlatGenerationSettings.field_202247_j.put(structure, structure.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        RS_STRUCTURES.put(structure, structureSeparationSettings);
    }
}

