/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.telepathicgrunt.repurposedstructures.RSAddFeaturesAndStructures;
import com.telepathicgrunt.repurposedstructures.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.RSFeatures;
import com.telepathicgrunt.repurposedstructures.RSStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMainConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSOutpostsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSShipwrecksConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSStrongholdsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSTemplesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSVillagesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.misc.VillagerTradesModification;
import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import com.telepathicgrunt.repurposedstructures.utils.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.world.placements.RSPlacements;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="repurposed_structures")
public class RepurposedStructures {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static RSMainConfig.RSConfigValues RSMainConfig = null;
    public static RSDungeonsConfig.RSDungeonsConfigValues RSDungeonsConfig = null;
    public static RSMineshaftsConfig.RSMineshaftsConfigValues RSMineshaftsConfig = null;
    public static RSStrongholdsConfig.RSStrongholdsConfigValues RSStrongholdsConfig = null;
    public static RSWellsConfig.RSWellsConfigValues RSWellsConfig = null;
    public static RSOutpostsConfig.RSOutpostsConfigValues RSOutpostsConfig = null;
    public static RSVillagesConfig.RSVillagesConfigValues RSVillagesConfig = null;
    public static RSTemplesConfig.RSTemplesConfigValues RSTemplesConfig = null;
    public static RSShipwrecksConfig.RSShipwrecksConfigValues RSShipwrecksConfig = null;
    public static MobSpawnerManager mobSpawnerManager = null;
    public static boolean yungsBetterMineshaftIsNotOn = true;

    public RepurposedStructures() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(this::biomeModification);
        forgeBus.addListener(RSAddFeaturesAndStructures::addDimensionalSpacing);
        forgeBus.addListener(this::registerDatapackListener);
        modEventBus.addListener(this::setup);
        modEventBus.addGenericListener(Feature.class, this::onRegisterFeatures);
        modEventBus.addGenericListener(Structure.class, this::onRegisterStructures);
        modEventBus.addGenericListener(Placement.class, this::onRegisterPlacements);
        RSMainConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMainConfig.RSConfigValues::new, "repurposed_structures-common.toml");
        RSDungeonsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSDungeonsConfig.RSDungeonsConfigValues::new, "repurposed_structures-dungeons.toml");
        RSMineshaftsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMineshaftsConfig.RSMineshaftsConfigValues::new, "repurposed_structures-mineshafts.toml");
        RSStrongholdsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSStrongholdsConfig.RSStrongholdsConfigValues::new, "repurposed_structures-strongholds.toml");
        RSWellsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSWellsConfig.RSWellsConfigValues::new, "repurposed_structures-wells.toml");
        RSShipwrecksConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSShipwrecksConfig.RSShipwrecksConfigValues::new, "repurposed_structures-shipwrecks.toml");
        RSOutpostsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSOutpostsConfig.RSOutpostsConfigValues::new, "repurposed_structures-outposts.toml");
        RSTemplesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSTemplesConfig.RSTemplesConfigValues::new, "repurposed_structures-temples.toml");
        RSVillagesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSVillagesConfig.RSVillagesConfigValues::new, "repurposed_structures-villages.toml");
        yungsBetterMineshaftIsNotOn = !ModList.get().isLoaded("bettermineshafts");
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(VillagerTradesModification::addMapTrades);
    }

    public void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
        RSFeatures.registerFeatures(event);
        RSConfiguredFeatures.registerConfiguredFeatures();
    }

    public void onRegisterStructures(RegistryEvent.Register<Structure<?>> event) {
        RepurposedStructures.loadRSConfigs();
        RSStructures.registerStructures(event);
        RSConfiguredStructures.registerStructureFeatures();
    }

    public void onRegisterPlacements(RegistryEvent.Register<Placement<?>> event) {
        RepurposedStructures.loadRSConfigs();
        RSPlacements.registerPlacements();
    }

    public void registerDatapackListener(AddReloadListenerEvent event) {
        mobSpawnerManager = new MobSpawnerManager();
        event.addListener((IFutureReloadListener)mobSpawnerManager);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        Map<String, List<String>> allBiomeBlacklists = RepurposedStructures.getBiomeBlacklists();
        RepurposedStructures.addFeaturesAndStructuresToBiomes(event, allBiomeBlacklists);
    }

    public static void addFeaturesAndStructuresToBiomes(BiomeLoadingEvent event, Map<String, List<String>> allBiomeBlacklists) {
        if (RepurposedStructures.isBiomeAllowed("mineshaft", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addMineshafts(event);
        }
        if (RepurposedStructures.isBiomeAllowed("fortress", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addJungleFortress(event);
        }
        if (RepurposedStructures.isBiomeAllowed("dungeon", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addDungeons(event);
        }
        if (RepurposedStructures.isBiomeAllowed("well", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addWells(event);
        }
        if (RepurposedStructures.isBiomeAllowed("swamp_tree", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addSwampTreeFeatures(event);
        }
        if (RepurposedStructures.isBiomeAllowed("boulder", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addBoulderFeatures(event);
        }
        if (RepurposedStructures.isBiomeAllowed("temple", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addTemples(event);
        }
        if (RepurposedStructures.isBiomeAllowed("pyramid", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addPyramids(event);
        }
        if (RepurposedStructures.isBiomeAllowed("igloo", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addIgloos(event);
        }
        if (RepurposedStructures.isBiomeAllowed("outpost", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addOutposts(event);
        }
        if (RepurposedStructures.isBiomeAllowed("shipwreck", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addShipwrecks(event);
        }
        if (RepurposedStructures.isBiomeAllowed("village", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addVillages(event);
        }
        if (RepurposedStructures.isBiomeAllowed("stronghold", event.getName(), allBiomeBlacklists)) {
            RSAddFeaturesAndStructures.addStrongholds(event);
        }
    }

    private static boolean isBiomeAllowed(String structureType, ResourceLocation biomeID, Map<String, List<String>> allBiomeBlacklists) {
        return allBiomeBlacklists.get(structureType).stream().noneMatch(blacklistedBiome -> blacklistedBiome.equals(biomeID.toString()));
    }

    private static void loadRSConfigs() {
        try {
            Field fld = ConfigTracker.class.getDeclaredField("configSets");
            fld.setAccessible(true);
            Class[] partypes = new Class[]{ModConfig.class, Path.class};
            Method method = ConfigTracker.class.getDeclaredMethod("openConfig", partypes);
            method.setAccessible(true);
            for (ModConfig modConfig : (Set)((EnumMap)fld.get(ConfigTracker.INSTANCE)).get(ModConfig.Type.COMMON)) {
                if (!modConfig.getModId().equals(MODID)) continue;
                Object[] arglist = new Object[]{modConfig, FMLPaths.CONFIGDIR.get()};
                method.invoke((Object)ConfigTracker.INSTANCE, arglist);
            }
            fld.setAccessible(false);
            method.setAccessible(false);
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public static Map<String, List<String>> getBiomeBlacklists() {
        HashMap<String, List<String>> allBiomeBlacklists = new HashMap<String, List<String>>();
        allBiomeBlacklists.put("dungeon", Arrays.asList(RepurposedStructures.RSDungeonsConfig.blacklistedDungeonBiomes.get().split(",")));
        allBiomeBlacklists.put("boulder", Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedBoulderBiomes.get().split(",")));
        allBiomeBlacklists.put("swamp_tree", Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedSwampTreeBiomes.get().split(",")));
        allBiomeBlacklists.put("fortress", Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedFortressBiomes.get().split(",")));
        allBiomeBlacklists.put("igloo", Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedIglooBiomes.get().split(",")));
        allBiomeBlacklists.put("mineshaft", Arrays.asList(RepurposedStructures.RSMineshaftsConfig.blacklistedMineshaftBiomes.get().split(",")));
        allBiomeBlacklists.put("outpost", Arrays.asList(RepurposedStructures.RSOutpostsConfig.blacklistedOutpostBiomes.get().split(",")));
        allBiomeBlacklists.put("shipwreck", Arrays.asList(RepurposedStructures.RSShipwrecksConfig.blacklistedShipwreckBiomes.get().split(",")));
        allBiomeBlacklists.put("stronghold", Arrays.asList(RepurposedStructures.RSStrongholdsConfig.blacklistedStrongholdBiomes.get().split(",")));
        allBiomeBlacklists.put("temple", Arrays.asList(RepurposedStructures.RSTemplesConfig.blacklistedTempleBiomes.get().split(",")));
        allBiomeBlacklists.put("pyramid", Arrays.asList(RepurposedStructures.RSTemplesConfig.blacklistedPyramidBiomes.get().split(",")));
        allBiomeBlacklists.put("village", Arrays.asList(RepurposedStructures.RSVillagesConfig.blacklistedVillageBiomes.get().split(",")));
        allBiomeBlacklists.put("well", Arrays.asList(RepurposedStructures.RSWellsConfig.blacklistedWellBiomes.get().split(",")));
        return allBiomeBlacklists;
    }
}

