/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.mixin;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RSStructures;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NoiseChunkGenerator.class})
public class StructureMobSpawningMixin {
    @Inject(method={"getEntitySpawnList(Lnet/minecraft/world/biome/Biome;Lnet/minecraft/world/gen/feature/structure/StructureManager;Lnet/minecraft/entity/EntityClassification;Lnet/minecraft/util/math/BlockPos;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private void structureMobs(Biome biome, StructureManager accessor, EntityClassification group, BlockPos pos, CallbackInfoReturnable<List<MobSpawnInfo.Spawners>> cir) {
        List<MobSpawnInfo.Spawners> list = StructureMobSpawningMixin.getStructureSpawns(biome, accessor, group, pos);
        if (list != null) {
            cir.setReturnValue(list);
        }
    }

    private static List<MobSpawnInfo.Spawners> getStructureSpawns(Biome biome, StructureManager accessor, EntityClassification group, BlockPos pos) {
        if (group == EntityClassification.MONSTER) {
            for (Structure<?> outpost : RSStructures.NETHER_OUTPOSTS_LIST) {
                if (!accessor.func_235010_a_(pos, true, outpost).func_75069_d()) continue;
                return outpost.func_202279_e();
            }
            for (Structure<?> shipwreck : RSStructures.NETHER_SHIPWRECKS_LIST) {
                if (!accessor.func_235010_a_(pos, true, shipwreck).func_75069_d()) continue;
                return Lists.newArrayList((Iterator)Iterators.concat(biome.func_242433_b().func_242559_a(EntityClassification.MONSTER).iterator(), shipwreck.func_202279_e().iterator()));
            }
            if (accessor.func_235010_a_(pos, true, RSStructures.NETHER_STRONGHOLD).func_75069_d()) {
                return RSStructures.NETHER_STRONGHOLD.func_202279_e();
            }
            if (accessor.func_235010_a_(pos, true, RSStructures.JUNGLE_FORTRESS).func_75069_d()) {
                return Lists.newArrayList((Iterator)Iterators.concat(biome.func_242433_b().func_242559_a(EntityClassification.MONSTER).iterator(), RSStructures.JUNGLE_FORTRESS.func_202279_e().iterator()));
            }
            if (accessor.func_235010_a_(pos, true, RSStructures.END_MINESHAFT).func_75069_d()) {
                return Lists.newArrayList((Iterator)Iterators.concat(biome.func_242433_b().func_242559_a(EntityClassification.MONSTER).iterator(), RSStructures.END_MINESHAFT.func_202279_e().iterator()));
            }
        }
        return null;
    }
}

